/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import it.cnr.imaa.essi.lablib.gui.checkboxtree.CheckboxTree;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.adempiere.core.domains.models.X_PP_Product_BOM;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.apps.form.VBOMDrop;
import org.compiere.grid.ed.VNumber;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.MRole;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.eevolution.form.bom.RadioButtonTreeCellRenderer;
import org.eevolution.form.bom.nodeUserObject;
import org.eevolution.manufacturing.model.MPPProductBOM;
import org.eevolution.manufacturing.model.MPPProductBOMLine;

public class VProductConfigurationBOM
extends CPanel
implements FormPanel,
ActionListener {
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private CheckboxTree m_tree;
    private MProduct m_product = null;
    private BigDecimal m_qty = Env.ONE;
    private int m_bomLine = 0;
    private static CLogger log = CLogger.getCLogger(VBOMDrop.class);
    private ArrayList<JToggleButton> m_selectionList = new ArrayList();
    private ArrayList<VNumber> m_qtyList = new ArrayList();
    private ArrayList<Integer> m_productList = new ArrayList();
    private ArrayList<Integer> m_bomLineIDList = new ArrayList();
    private HashMap<String, ButtonGroup> m_buttonGroups = new HashMap();
    private static final int WINDOW_WIDTH = 600;
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private CPanel selectionPanel = new CPanel(new ALayout());
    private CComboBox productField;
    private VNumber productQty = new VNumber("Qty", true, false, true, 29, Msg.translate(Env.getCtx(), "Qty"));
    private CComboBox orderField;
    private CComboBox invoiceField;
    private CComboBox projectField;
    private RadioButtonTreeCellRenderer m_RadioButtonTreeCellRenderer = null;

    @Override
    public void init(int WindowNo, FormFrame frame) {
        log.info("");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        try {
            this.createSelectionPanel(true, true, true);
            this.m_frame.getContentPane().add((Component)this.selectionPanel, "North");
            this.createMainPanel();
            CScrollPane scroll = new CScrollPane(this);
            this.m_frame.getContentPane().add((Component)scroll, "Center");
            this.confirmPanel.addActionListener(this);
            this.m_frame.getContentPane().add((Component)this.confirmPanel, "South");
            DefaultMutableTreeNode parent = new DefaultMutableTreeNode(Msg.translate(Env.getCtx(), "No Product Chosen"));
            this.m_RadioButtonTreeCellRenderer = new RadioButtonTreeCellRenderer();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
        this.sizeIt();
    }

    private void sizeIt() {
        this.m_frame.pack();
        Dimension size = this.m_frame.getPreferredSize();
        size.width = 600;
        this.m_frame.setSize(size);
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
        this.removeAll();
        if (this.selectionPanel != null) {
            this.selectionPanel.removeAll();
        }
        this.selectionPanel = null;
        if (this.m_selectionList != null) {
            this.m_selectionList.clear();
        }
        this.m_selectionList = null;
        if (this.m_productList != null) {
            this.m_productList.clear();
        }
        this.m_productList = null;
        if (this.m_qtyList != null) {
            this.m_qtyList.clear();
        }
        this.m_qtyList = null;
        if (this.m_buttonGroups != null) {
            this.m_buttonGroups.clear();
        }
        this.m_buttonGroups = null;
    }

    private void createSelectionPanel(boolean order, boolean invoice, boolean project) {
        int row = 0;
        this.selectionPanel.setBorder(new TitledBorder(Msg.translate(Env.getCtx(), "Selection")));
        this.productField = new CComboBox(this.getProducts());
        CLabel label = new CLabel(Msg.translate(Env.getCtx(), "M_Product_ID"));
        label.setLabelFor(this.productField);
        this.selectionPanel.add((Component)label, new ALayoutConstraint(row++, 0));
        this.selectionPanel.add(this.productField);
        this.productField.addActionListener(this);
        label = new CLabel(this.productQty.getTitle());
        label.setLabelFor(this.productQty);
        this.selectionPanel.add(label);
        this.selectionPanel.add(this.productQty);
        this.productQty.setValue(Env.ONE);
        this.productQty.addActionListener(this);
        if (order) {
            this.orderField = new CComboBox(this.getOrders());
            label = new CLabel(Msg.translate(Env.getCtx(), "C_Order_ID"));
            label.setLabelFor(this.orderField);
            this.selectionPanel.add((Component)label, new ALayoutConstraint(row++, 0));
            this.selectionPanel.add(this.orderField);
            this.orderField.addActionListener(this);
        }
        if (invoice) {
            this.invoiceField = new CComboBox(this.getInvoices());
            label = new CLabel(Msg.translate(Env.getCtx(), "C_Invoice_ID"));
            label.setLabelFor(this.invoiceField);
            this.selectionPanel.add((Component)label, new ALayoutConstraint(row++, 0));
            this.selectionPanel.add(this.invoiceField);
            this.invoiceField.addActionListener(this);
        }
        if (project) {
            this.projectField = new CComboBox(this.getProjects());
            label = new CLabel(Msg.translate(Env.getCtx(), "C_Project_ID"));
            label.setLabelFor(this.projectField);
            this.selectionPanel.add((Component)label, new ALayoutConstraint(row++, 0));
            this.selectionPanel.add(this.projectField);
            this.projectField.addActionListener(this);
        }
        this.confirmPanel.getOKButton().setEnabled(false);
        Dimension size = this.selectionPanel.getPreferredSize();
        size.width = 600;
        this.selectionPanel.setPreferredSize(size);
    }

    private KeyNamePair[] getProducts() {
        String sql = "SELECT M_Product_ID, Name FROM M_Product WHERE IsBOM='Y' AND IsVerified='Y' AND IsActive='Y' and M_Product_ID in (SELECT M_Product_ID FROM PP_Product_bom WHERE bomtype = 'C' AND bomuse = 'A') ORDER BY Name";
        return DB.getKeyNamePairs(MRole.getDefault().addAccessSQL(sql, "M_Product", false, false), true);
    }

    private KeyNamePair[] getOrders() {
        String sql = "SELECT C_Order_ID, DocumentNo || '_' || GrandTotal FROM C_Order WHERE Processed='N' AND DocStatus='DR' ORDER BY DocumentNo";
        return DB.getKeyNamePairs(MRole.getDefault().addAccessSQL(sql, "C_Order", false, false), true);
    }

    private KeyNamePair[] getProjects() {
        String sql = "SELECT C_Project_ID, Name FROM C_Project WHERE Processed='N' AND IsSummary='N' AND IsActive='Y' AND ProjectCategory<>'S' ORDER BY Name";
        return DB.getKeyNamePairs(MRole.getDefault().addAccessSQL(sql, "C_Project", false, false), true);
    }

    private KeyNamePair[] getInvoices() {
        String sql = "SELECT C_Invoice_ID, DocumentNo || '_' || GrandTotal FROM C_Invoice WHERE Processed='N' AND DocStatus='DR' ORDER BY DocumentNo";
        return DB.getKeyNamePairs(MRole.getDefault().addAccessSQL(sql, "C_Invoice", false, false), true);
    }

    private void createMainPanel() {
        log.config(": " + this.m_product);
        this.removeAll();
        this.setPreferredSize(null);
        this.invalidate();
        this.setBorder(null);
        this.m_selectionList.clear();
        this.m_productList.clear();
        this.m_bomLineIDList.clear();
        this.m_qtyList.clear();
        this.m_buttonGroups.clear();
        this.setLayout(new ALayout());
        String title = Msg.getMsg(Env.getCtx(), "SelectProduct");
        if (this.m_product != null && this.m_product.get_ID() > 0) {
            title = this.m_product.getName();
            if (this.m_product.getDescription() != null && this.m_product.getDescription().length() > 0) {
                this.setToolTipText(this.m_product.getDescription());
            }
            this.m_bomLine = 0;
            this.m_tree = new CheckboxTree(this.m_RadioButtonTreeCellRenderer.action_loadBOM(this.m_product, true));
            this.m_tree.getCheckingModel().setCheckingMode(TreeCheckingModel.CheckingMode.SIMPLE);
            this.m_tree.getCheckingModel().clearChecking();
            this.m_tree.setCellRenderer(this.m_RadioButtonTreeCellRenderer);
            this.m_tree.setScrollsOnExpand(true);
            JScrollPane treeView = new JScrollPane(this.m_tree);
            this.add(treeView);
        } else {
            DefaultMutableTreeNode nodeHolder = new DefaultMutableTreeNode(Msg.translate(Env.getCtx(), "No Product Chosen"));
            this.m_tree = new CheckboxTree(nodeHolder);
            JScrollPane treeView = new JScrollPane(this.m_tree);
            this.add(treeView);
        }
        this.setBorder(new TitledBorder(title));
    }

    private MProduct getProductFromMPPProductBOM(int PP_Product_BOM_ID) {
        MProduct m_product = null;
        try {
            StringBuffer sql1 = new StringBuffer("select m_product_id from pp_product_bom where pp_product_bom_id = ?");
            CPreparedStatement pstmt = DB.prepareStatement(sql1.toString(), null);
            pstmt.setInt(1, PP_Product_BOM_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                int m_product_id = rs.getInt(1);
                m_product = new MProduct(Env.getCtx(), m_product_id, null);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException s) {
            log.log(Level.SEVERE, "ERROR:", s);
        }
        return m_product;
    }

    private MProduct getProductFromMPPProductBOMLine(MPPProductBOMLine bomLine) {
        MProduct m_product = null;
        try {
            StringBuffer sql1 = new StringBuffer("select m_product_id from pp_product_bomline where pp_product_bomline_id = ?");
            CPreparedStatement pstmt = DB.prepareStatement(sql1.toString(), null);
            pstmt.setInt(1, bomLine.getPP_Product_BOMLine_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                int m_product_id = rs.getInt(1);
                m_product = new MProduct(Env.getCtx(), m_product_id, null);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException s) {
            log.log(Level.SEVERE, "ERROR:", s);
        }
        return m_product;
    }

    private MPPProductBOMLine[] getBOMLines(MProduct m_product) {
        ArrayList col = new ArrayList();
        try {
            StringBuffer sql1 = new StringBuffer("select pp_product_bom_id from pp_product_bom where m_product_id = ?");
            CPreparedStatement pstmt = DB.prepareStatement(sql1.toString(), null);
            pstmt.setInt(1, m_product.get_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                int m_pp_product_bom_id = rs.getInt(1);
                MPPProductBOM m_MPPProductBOM = new MPPProductBOM(Env.getCtx(), m_pp_product_bom_id, null);
                MPPProductBOMLine[] bomLines = m_MPPProductBOM.getLines();
                Collections.addAll(col, bomLines);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException s) {
            log.log(Level.SEVERE, "ERROR:", s);
        }
        return col.toArray(new MPPProductBOMLine[col.size()]);
    }

    private void addBOMLines(MProduct product, BigDecimal qty) {
        MPPProductBOMLine[] bomLines = this.getBOMLines(product);
        for (int i = 0; i < bomLines.length; ++i) {
            this.addBOMLine(bomLines[i], qty);
        }
        log.fine("#" + bomLines.length);
    }

    private void addBOMLine(MPPProductBOMLine line, BigDecimal qty) {
        log.fine("In addBOMLine");
        log.fine(line.toString());
        String bomType = line.getComponentType();
        if (bomType == null) {
            bomType = "P";
        }
        BigDecimal lineQty = new BigDecimal(0);
        MProduct product = this.getProductFromMPPProductBOMLine(line);
        if (product == null) {
            return;
        }
        this.addDisplay(line.getM_Product_ID(), product.getM_Product_ID(), bomType, product.getName(), lineQty, line.getPP_Product_BOM_ID(), line.getFeature(), line.get_ID());
    }

    private void addDisplay(int parentM_Product_ID, int M_Product_ID, String bomType, String name, BigDecimal lineQty, int PP_Product_BOM_ID, String M_Feature, int PP_Product_BOMLine_ID) {
        String title;
        log.fine("M_Product_ID=" + M_Product_ID + ",Type=" + bomType + ",Name=" + name + ",Qty=" + lineQty);
        boolean selected = true;
        if ("CO".equals(bomType)) {
            title = "";
            JCheckBox cb = new JCheckBox(title);
            cb.setSelected(true);
            cb.setEnabled(false);
            this.m_selectionList.add(cb);
            this.add((Component)cb, new ALayoutConstraint(this.m_bomLine++, 0));
        } else if ("VA".equals(bomType)) {
            title = Msg.getMsg(Env.getCtx(), "Optional");
            JCheckBox cb = new JCheckBox(title);
            cb.setSelected(false);
            selected = false;
            cb.addActionListener(this);
            this.m_selectionList.add(cb);
            this.add((Component)cb, new ALayoutConstraint(this.m_bomLine++, 0));
        } else {
            title = M_Feature;
            JRadioButton b = new JRadioButton(title);
            String groupName = String.valueOf(this.getProductFromMPPProductBOM(PP_Product_BOM_ID).get_ID()) + "_" + bomType;
            ButtonGroup group = this.m_buttonGroups.get(groupName);
            if (group == null) {
                log.fine("ButtonGroup=" + groupName);
                group = new ButtonGroup();
                this.m_buttonGroups.put(groupName, group);
                group.add(b);
                b.setSelected(true);
            } else {
                group.add(b);
                b.setSelected(false);
                selected = false;
            }
            b.addActionListener(this);
            this.m_selectionList.add(b);
            this.add((Component)b, new ALayoutConstraint(this.m_bomLine++, 0));
        }
        this.m_productList.add(M_Product_ID);
        this.m_bomLineIDList.add(PP_Product_BOMLine_ID);
        CLabel label = new CLabel(name);
        this.add(label);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (size.width > 600) {
            size.width = 570;
        }
        return size;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean OK;
        KeyNamePair pp;
        log.config(e.getActionCommand());
        Object source = e.getSource();
        if (source instanceof JCheckBox || source instanceof JRadioButton) {
            this.cmd_selection(source);
            if (source instanceof JRadioButton) {
                for (ButtonGroup group : this.m_buttonGroups.values()) {
                    Enumeration<AbstractButton> en = group.getElements();
                    while (en.hasMoreElements()) {
                        if (source != en.nextElement()) continue;
                        Enumeration<AbstractButton> info = group.getElements();
                        while (info.hasMoreElements()) {
                            AbstractButton infoObj = info.nextElement();
                            if (source == infoObj) continue;
                            this.cmd_selection(infoObj);
                        }
                    }
                }
            }
        } else if (source == this.productField || source == this.productQty) {
            this.m_qty = (BigDecimal)this.productQty.getValue();
            pp = (KeyNamePair)this.productField.getSelectedItem();
            this.m_product = MProduct.get(Env.getCtx(), pp.getKey());
            this.createMainPanel();
            this.sizeIt();
        } else if (source == this.orderField) {
            boolean valid;
            pp = (KeyNamePair)this.orderField.getSelectedItem();
            boolean bl = valid = pp != null && pp.getKey() > 0;
            if (this.invoiceField != null) {
                this.invoiceField.setReadWrite(!valid);
            }
            if (this.projectField != null) {
                this.projectField.setReadWrite(!valid);
            }
        } else if (source == this.invoiceField) {
            boolean valid;
            pp = (KeyNamePair)this.invoiceField.getSelectedItem();
            boolean bl = valid = pp != null && pp.getKey() > 0;
            if (this.orderField != null) {
                this.orderField.setReadWrite(!valid);
            }
            if (this.projectField != null) {
                this.projectField.setReadWrite(!valid);
            }
        } else if (source == this.projectField) {
            boolean valid;
            pp = (KeyNamePair)this.projectField.getSelectedItem();
            boolean bl = valid = pp != null && pp.getKey() > 0;
            if (this.orderField != null) {
                this.orderField.setReadWrite(!valid);
            }
            if (this.invoiceField != null) {
                this.invoiceField.setReadWrite(!valid);
            }
        } else if (e.getActionCommand().equals("Ok")) {
            if (this.cmd_save()) {
                this.dispose();
            }
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        }
        boolean bl = OK = this.m_product != null;
        if (OK) {
            KeyNamePair pp2 = null;
            if (this.orderField != null) {
                pp2 = (KeyNamePair)this.orderField.getSelectedItem();
            }
            if ((pp2 == null || pp2.getKey() <= 0) && this.invoiceField != null) {
                pp2 = (KeyNamePair)this.invoiceField.getSelectedItem();
            }
            if ((pp2 == null || pp2.getKey() <= 0) && this.projectField != null) {
                pp2 = (KeyNamePair)this.projectField.getSelectedItem();
            }
            OK = pp2 != null && pp2.getKey() > 0;
        }
        this.confirmPanel.getOKButton().setEnabled(OK);
    }

    private void cmd_selection(Object source) {
        for (int i = 0; i < this.m_selectionList.size(); ++i) {
            if (source != this.m_selectionList.get(i)) continue;
            boolean selected = this.isSelectionSelected(source);
            VNumber qty = this.m_qtyList.get(i);
            qty.setReadWrite(selected);
            return;
        }
        log.log(Level.SEVERE, "not found - " + source);
    }

    private boolean isSelectionSelected(Object source) {
        boolean retValue = false;
        if (source instanceof JCheckBox) {
            retValue = ((JCheckBox)source).isSelected();
        } else if (source instanceof JRadioButton) {
            retValue = ((JRadioButton)source).isSelected();
        } else {
            log.log(Level.SEVERE, "Not valid - " + source);
        }
        return retValue;
    }

    private boolean cmd_save() {
        KeyNamePair pp = (KeyNamePair)this.orderField.getSelectedItem();
        if (pp != null && pp.getKey() > 0) {
            return this.cmd_saveOrder(pp.getKey());
        }
        pp = (KeyNamePair)this.invoiceField.getSelectedItem();
        if (pp != null && pp.getKey() > 0) {
            return this.cmd_saveInvoice(pp.getKey());
        }
        pp = (KeyNamePair)this.projectField.getSelectedItem();
        if (pp != null && pp.getKey() > 0) {
            return this.cmd_saveProject(pp.getKey());
        }
        log.log(Level.SEVERE, "Nothing selected");
        return false;
    }

    private ArrayList<DefaultMutableTreeNode> getProductInstances(int root_m_product_id) {
        log.fine("In getProductInstances root_m_product_id: " + root_m_product_id);
        ArrayList<DefaultMutableTreeNode> productInstancesList = new ArrayList<DefaultMutableTreeNode>();
        try {
            StringBuffer sql1 = new StringBuffer("select a.m_product_id from pp_product_bom a, pp_product_bom b where a.name = b.name || ' Instance' and b.m_product_id = ? and a.bomtype = 'C' and a.bomuse = 'M'");
            log.fine("sql1: " + sql1);
            CPreparedStatement pstmt = DB.prepareStatement(sql1.toString(), null);
            log.fine("root_m_product_id: " + root_m_product_id);
            pstmt.setInt(1, root_m_product_id);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int m_product_id = rs.getInt(1);
                this.m_product = new MProduct(Env.getCtx(), m_product_id, null);
                if (!this.m_product.isVerified()) continue;
                log.fine("Adding product: " + this.m_product.get_ID());
                productInstancesList.add(this.m_RadioButtonTreeCellRenderer.action_loadBOM(this.m_product, false));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException s) {
            log.log(Level.SEVERE, "ERROR:", s);
        }
        log.fine("# of product instances found: " + productInstancesList.size());
        return productInstancesList;
    }

    private ArrayList<DefaultMutableTreeNode> getProductInstances() {
        log.fine("In getProductInstances");
        ArrayList<DefaultMutableTreeNode> productInstancesList = new ArrayList<DefaultMutableTreeNode>();
        try {
            StringBuffer sql1 = new StringBuffer("select a.m_product_id from pp_product_bom a, pp_product_bom b where a.name = b.name || ' Instance' and b.m_product_id = ? and a.bomtype = 'C' and a.bomuse = 'M'");
            log.fine("sql1: " + sql1);
            CPreparedStatement pstmt = DB.prepareStatement(sql1.toString(), null);
            KeyNamePair pp = (KeyNamePair)this.productField.getSelectedItem();
            MProduct m_productConfig = MProduct.get(Env.getCtx(), pp.getKey());
            log.fine("m_productConfig.get_ID " + m_productConfig.get_ID());
            pstmt.setInt(1, m_productConfig.get_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int m_product_id = rs.getInt(1);
                this.m_product = new MProduct(Env.getCtx(), m_product_id, null);
                if (!this.m_product.isVerified()) continue;
                log.fine("Adding product: " + this.m_product.get_ID());
                productInstancesList.add(this.m_RadioButtonTreeCellRenderer.action_loadBOM(this.m_product, false));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException s) {
            log.log(Level.SEVERE, "ERROR:", s);
        }
        log.fine("# of product instances found: " + productInstancesList.size());
        return productInstancesList;
    }

    private HashMap<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> buildConfigBOMIDToBOMLevelToLinesMap(MProduct m_product) {
        log.fine("In buildConfigBOMIDToBOMLevelToLinesMap");
        HashMap<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> m_ConfigBOMIDToBOMLevelToLinesMap = new HashMap<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>>();
        HashMap m_BOMLevelToLinesMap = new HashMap();
        MPPProductBOMLine[] bomLines = this.getBOMLines(m_product);
        int bomLevel = 0;
        ArrayList<MPPProductBOMLine> col = new ArrayList<MPPProductBOMLine>();
        for (int i = 0; i < bomLines.length; ++i) {
            log.fine("bom line from product with product_id: " + this.getProductFromMPPProductBOMLine(bomLines[i]).get_ID());
            col.add(bomLines[i]);
        }
        m_BOMLevelToLinesMap.put(bomLevel, col);
        MPPProductBOMLine m_MPPProductBOMLine = bomLines[0];
        int PP_Product_BOM_ID = m_MPPProductBOMLine.getPP_Product_BOM_ID();
        m_ConfigBOMIDToBOMLevelToLinesMap.put(PP_Product_BOM_ID, m_BOMLevelToLinesMap);
        return m_ConfigBOMIDToBOMLevelToLinesMap;
    }

    private int getBomLevelBetweenPPProductBOMIDs(int top_bom_id, int lower_bom_id) {
        int retValue = 0;
        return retValue;
    }

    private HashMap<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> buildConfigBOMIDToBOMLevelToLinesMapFromSelectionList() {
        log.fine("In buildConfigBOMIDToBOMLevelToLinesMapFromSelectionList");
        KeyNamePair pp = (KeyNamePair)this.productField.getSelectedItem();
        MProduct m_productConfig = MProduct.get(Env.getCtx(), pp.getKey());
        MPPProductBOMLine[] configBOMLines = this.getBOMLines(m_productConfig);
        int PP_ConfigProduct_BOM_ID = configBOMLines[0].getPP_Product_BOM_ID();
        HashMap<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> m_ConfigBOMIDToBOMLevelToLinesMapFromSelectionList = new HashMap<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>>();
        HashMap m_BOMLevelToLinesMap = new HashMap();
        HashMap<Integer, ArrayList<MPPProductBOMLine>> m_BOMLevelToLinesMapFromKey = null;
        for (int i = 0; i < this.m_selectionList.size(); ++i) {
            ArrayList<MPPProductBOMLine> bomLines;
            if (!this.isSelectionSelected(this.m_selectionList.get(i))) continue;
            int PP_Product_BOMLine_ID = this.m_bomLineIDList.get(i);
            log.fine("PP_Product_BOMLine_ID: " + PP_Product_BOMLine_ID);
            MPPProductBOMLine m_MPPProductBOMLine = new MPPProductBOMLine(Env.getCtx(), PP_Product_BOMLine_ID, null);
            m_BOMLevelToLinesMapFromKey = m_ConfigBOMIDToBOMLevelToLinesMapFromSelectionList.get(m_MPPProductBOMLine.getPP_Product_BOM_ID());
            if (m_BOMLevelToLinesMapFromKey == null) {
                m_BOMLevelToLinesMapFromKey = new HashMap();
                m_ConfigBOMIDToBOMLevelToLinesMapFromSelectionList.put(m_MPPProductBOMLine.getPP_Product_BOM_ID(), m_BOMLevelToLinesMapFromKey);
                bomLines = new ArrayList();
                bomLines.add(m_MPPProductBOMLine);
                m_BOMLevelToLinesMapFromKey.put(this.getBomLevelBetweenPPProductBOMIDs(PP_ConfigProduct_BOM_ID, m_MPPProductBOMLine.getPP_Product_BOM_ID()), bomLines);
                continue;
            }
            bomLines = m_BOMLevelToLinesMapFromKey.get(this.getBomLevelBetweenPPProductBOMIDs(PP_ConfigProduct_BOM_ID, m_MPPProductBOMLine.getPP_Product_BOM_ID()));
            bomLines.add(m_MPPProductBOMLine);
        }
        return m_ConfigBOMIDToBOMLevelToLinesMapFromSelectionList;
    }

    private void printBOMLevelToLinesMap(HashMap<Integer, ArrayList<MPPProductBOMLine>> m_BOMLevelToLinesMap) {
        Set<Map.Entry<Integer, ArrayList<MPPProductBOMLine>>> set = m_BOMLevelToLinesMap.entrySet();
        for (Map.Entry<Integer, ArrayList<MPPProductBOMLine>> me : set) {
            log.fine("BOM level: " + ((Object)me.getKey()).toString());
            ArrayList<MPPProductBOMLine> bomLines = me.getValue();
            log.fine("Total BOM line's: " + bomLines.size());
            for (int j = 0; j < bomLines.size(); ++j) {
                MPPProductBOMLine m_MPPProductBOMLine = bomLines.get(j);
                log.fine("bom line #: " + j + " product: " + m_MPPProductBOMLine.getDescription());
            }
        }
    }

    private void printConfigBOMIDToBOMLinesMapForProduct(MProduct m_product, HashMap<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> m_ConfigBOMInstIDToBOMLinesMap) {
        log.fine("In printConfigBOMIDToBOMLinesMapForProduct");
        log.fine("Analyzing product bom id's and corresponding bomlines and levels for those product bom id's for a particular product");
        log.fine("Product: " + m_product.getName() + " has:");
        log.fine("Total BOM's: " + m_ConfigBOMInstIDToBOMLinesMap.size());
        Set<Map.Entry<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>>> set = m_ConfigBOMInstIDToBOMLinesMap.entrySet();
        for (Map.Entry<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> me : set) {
            HashMap<Object, Object> m_BOMLevelToLinesMap = new HashMap();
            log.fine("PP_Product_BOM_ID: " + ((Object)me.getKey()).toString() + " has: ");
            m_BOMLevelToLinesMap = me.getValue();
            Set<Map.Entry<Object, Object>> setLines = m_BOMLevelToLinesMap.entrySet();
            for (Map.Entry<Object, Object> me2 : setLines) {
                ArrayList bomLines = (ArrayList)me2.getValue();
                log.fine("Total bom lines: " + bomLines.size());
                for (int count = 0; count < bomLines.size(); ++count) {
                    MPPProductBOMLine m_MPPProductBOMLine = (MPPProductBOMLine)bomLines.get(count);
                    log.fine("bom line #: " + count + " product: " + m_MPPProductBOMLine.getDescription());
                }
            }
        }
    }

    private int getTotalBOMLines(HashMap<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> m_ConfigBOMInstIDToBOMLinesMap) {
        log.fine("In getTotalBOMLines");
        int retVal = 0;
        Set<Map.Entry<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>>> set = m_ConfigBOMInstIDToBOMLinesMap.entrySet();
        for (Map.Entry<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> me : set) {
            HashMap<Object, Object> m_BOMLevelToLinesMap = new HashMap();
            m_BOMLevelToLinesMap = me.getValue();
            Set<Map.Entry<Object, Object>> set2 = m_BOMLevelToLinesMap.entrySet();
            for (Map.Entry<Object, Object> me2 : set2) {
                ArrayList bomLines = (ArrayList)me2.getValue();
                retVal += bomLines.size();
            }
        }
        log.fine("Total bom lines: " + retVal);
        return retVal;
    }

    private int getTotalBOMLevels(HashMap<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> m_ConfigBOMInstIDToBOMLinesMap) {
        log.fine("In getTotalBOMLevels");
        int maxBOMLevel = 0;
        Set<Map.Entry<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>>> set = m_ConfigBOMInstIDToBOMLinesMap.entrySet();
        for (Map.Entry<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> me : set) {
            HashMap<Object, Object> m_BOMLevelToLinesMap = new HashMap();
            log.fine("PP_Product_BOM_ID: " + ((Object)me.getKey()).toString() + " has: ");
            m_BOMLevelToLinesMap = me.getValue();
            Set<Map.Entry<Object, Object>> setLines = m_BOMLevelToLinesMap.entrySet();
            for (Map.Entry<Object, Object> me2 : setLines) {
                if ((Integer)me2.getKey() <= maxBOMLevel) continue;
                maxBOMLevel = (Integer)me2.getKey();
            }
        }
        log.fine("maxBOMLevel found: " + maxBOMLevel);
        return maxBOMLevel;
    }

    private boolean isSameProductsInProductInstance(int bomLevel, ArrayList<MPPProductBOMLine> configBomLines, HashMap<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> m_ConfigBOMInstIDToBOMLinesMap) {
        log.info("In isSameProductsInProductInstance");
        boolean retVal = true;
        Set<Map.Entry<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>>> set = m_ConfigBOMInstIDToBOMLinesMap.entrySet();
        for (Map.Entry<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> me : set) {
            HashMap<Object, Object> m_BOMLevelToLinesMap = new HashMap();
            log.fine("PP_Product_BOM_ID: " + ((Object)me.getKey()).toString() + " has: ");
            m_BOMLevelToLinesMap = me.getValue();
            Set<Map.Entry<Object, Object>> setLines = m_BOMLevelToLinesMap.entrySet();
            for (Map.Entry<Object, Object> me2 : setLines) {
                if ((Integer)me2.getKey() != bomLevel) continue;
                ArrayList configInstanceBomLines = (ArrayList)me2.getValue();
                log.fine("configBomLines.size: " + configBomLines.size());
                log.fine("configInstanceBomLines.size: " + configInstanceBomLines.size());
                for (int l = 0; l < configBomLines.size(); ++l) {
                    boolean matchedProduct = false;
                    for (int m = 0; m < configInstanceBomLines.size(); ++m) {
                        int chosenProduct_ID = this.getProductFromMPPProductBOMLine(configBomLines.get(l)).get_ID();
                        int instanceProduct_ID = this.getProductFromMPPProductBOMLine(configBomLines.get(m)).get_ID();
                        log.fine("bomLevel: " + bomLevel);
                        log.fine("chosenProduct_ID: " + chosenProduct_ID);
                        log.fine("instanceProduct_ID: " + instanceProduct_ID);
                        if (chosenProduct_ID != instanceProduct_ID) continue;
                        matchedProduct = true;
                    }
                    if (matchedProduct) continue;
                    return false;
                }
            }
        }
        return retVal;
    }

    private boolean isSameProductsAtBOMLevel(int bomLevel, HashMap<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> m_ConfigBOMIDToBOMLinesMap, HashMap<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> m_ConfigBOMInstIDToBOMLinesMap) {
        log.fine("In isSameProductsAtBOMLevel");
        boolean retVal = true;
        Set<Map.Entry<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>>> set = m_ConfigBOMIDToBOMLinesMap.entrySet();
        for (Map.Entry<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> me : set) {
            HashMap<Object, Object> m_BOMLevelToLinesMap = new HashMap();
            log.fine("PP_Product_BOM_ID: " + ((Object)me.getKey()).toString() + " has: ");
            m_BOMLevelToLinesMap = me.getValue();
            Set<Map.Entry<Object, Object>> setLines = m_BOMLevelToLinesMap.entrySet();
            for (Map.Entry<Object, Object> me2 : setLines) {
                ArrayList bomLines;
                if ((Integer)me2.getKey() != bomLevel || this.isSameProductsInProductInstance(bomLevel, bomLines = (ArrayList)me2.getValue(), m_ConfigBOMInstIDToBOMLinesMap)) continue;
                retVal = false;
            }
        }
        return retVal;
    }

    private boolean isSameBOMStructure(HashMap<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> m_ConfigBOMIDToBOMLinesMap, HashMap<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> m_ConfigBOMInstIDToBOMLinesMap) {
        log.fine("In isSameBOMStructure");
        boolean retVal = true;
        int totalProductConfigBOMLevels = this.getTotalBOMLevels(m_ConfigBOMIDToBOMLinesMap);
        int totalProductConfigInstBOMLevels = this.getTotalBOMLevels(m_ConfigBOMInstIDToBOMLinesMap);
        if (totalProductConfigBOMLevels == totalProductConfigInstBOMLevels) {
            for (int i = 0; i < totalProductConfigBOMLevels + 1; ++i) {
                if (this.isSameProductsAtBOMLevel(i, m_ConfigBOMIDToBOMLinesMap, m_ConfigBOMInstIDToBOMLinesMap)) continue;
                retVal = false;
                break;
            }
        } else {
            retVal = false;
        }
        return retVal;
    }

    private boolean pruneProductConfig() {
        log.fine("In pruneProductConfig");
        boolean retVal = false;
        DefaultMutableTreeNode rootProductConfig = this.m_RadioButtonTreeCellRenderer.root;
        Enumeration<TreeNode> children = rootProductConfig.breadthFirstEnumeration();
        log.fine("About to prune");
        if (children != null) {
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                log.fine("Analyzing: " + child);
                log.fine("level: " + child.getLevel());
                nodeUserObject m_nodeUserObject = (nodeUserObject)child.getUserObject();
                log.fine("isMandatory: " + m_nodeUserObject.isMandatory);
                log.fine("isChosen: " + m_nodeUserObject.isChosen);
                if (child.isRoot() || m_nodeUserObject.isChosen || m_nodeUserObject.isMandatory) continue;
                log.fine("Removing: " + child);
                child.removeFromParent();
                retVal = true;
            }
        }
        log.fine("Exiting pruneConfig");
        return retVal;
    }

    private int getNumNodesFromRoot(DefaultMutableTreeNode root) {
        Enumeration<TreeNode> children = root.breadthFirstEnumeration();
        ArrayList<TreeNode> m_ArrayList = Collections.list(children);
        return m_ArrayList.size();
    }

    private boolean isProductContainedAtLevelInProductInstance(int m_product_id, int level, DefaultMutableTreeNode rootProductInstance) {
        log.fine("In isProductContainedAtLevelInProductInstance");
        log.fine("looking for m_product_id: " + m_product_id + " at level: " + level);
        log.fine("rootProductInstance.getDepth: " + rootProductInstance.getDepth());
        log.fine("rootProductInstance.getNumNodesFromRoot: " + this.getNumNodesFromRoot(rootProductInstance));
        boolean retValue = false;
        Enumeration<TreeNode> children = rootProductInstance.breadthFirstEnumeration();
        if (children != null) {
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                nodeUserObject m_nodeUserObject = (nodeUserObject)child.getUserObject();
                log.fine("node: " + child + " product instance m_product_id: " + m_nodeUserObject.M_Product.get_ID() + " at level: " + child.getLevel());
                if (child.getLevel() != level || m_nodeUserObject.M_Product.get_ID() != m_product_id) continue;
                retValue = true;
                return retValue;
            }
        }
        return retValue;
    }

    private void printTree(DefaultMutableTreeNode root) {
        log.fine("In printTree");
        log.fine("root.getDepth: " + root.getDepth());
        log.fine("root.getNumNodesFromRoot: " + this.getNumNodesFromRoot(root));
        Enumeration<TreeNode> children = root.breadthFirstEnumeration();
        if (children != null) {
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                nodeUserObject m_nodeUserObject = (nodeUserObject)child.getUserObject();
                log.fine("node: " + child + " product instance m_product_id: " + m_nodeUserObject.M_Product.get_ID() + " at level: " + child.getLevel());
                log.fine("bom id: " + m_nodeUserObject.bom.get_ID());
                log.fine("isMandatory: " + m_nodeUserObject.isMandatory);
                log.fine("isChosen: " + m_nodeUserObject.isChosen);
            }
        }
    }

    private boolean isConfigEqualToProductInstance(DefaultMutableTreeNode rootProductInstance, DefaultMutableTreeNode rootProductConfig) {
        Enumeration<TreeNode> children;
        log.fine("In isConfigEqualToProductInstance");
        boolean retValue = false;
        boolean done = false;
        log.fine("rootProductConfig.getDepth: " + rootProductConfig.getDepth());
        log.fine("rootProductInstance.getDepth: " + rootProductInstance.getDepth());
        log.fine("rootProductConfig.getNumNodesFromRoot: " + this.getNumNodesFromRoot(rootProductConfig));
        log.fine("rootProductInstance.getNumNodesFromRoot: " + this.getNumNodesFromRoot(rootProductInstance));
        if (this.getNumNodesFromRoot(rootProductConfig) == this.getNumNodesFromRoot(rootProductInstance) && rootProductConfig.getDepth() == rootProductInstance.getDepth() && (children = rootProductConfig.breadthFirstEnumeration()) != null) {
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                nodeUserObject m_nodeUserObject = (nodeUserObject)child.getUserObject();
                if (!m_nodeUserObject.isChosen && !m_nodeUserObject.isMandatory || rootProductConfig.getLevel() - child.getLevel() + 1 <= 1 || m_nodeUserObject.bomLine == null || this.isProductContainedAtLevelInProductInstance(m_nodeUserObject.M_Product.get_ID(), rootProductConfig.getLevel() - child.getLevel() + 1, rootProductInstance)) continue;
                return retValue;
            }
            retValue = true;
            return retValue;
        }
        return retValue;
    }

    private boolean isConfigEqualToProductInstance(DefaultMutableTreeNode rootProductInstance) {
        Enumeration<TreeNode> children;
        log.fine("In isConfigEqualToProductInstance");
        boolean retValue = false;
        boolean done = false;
        DefaultMutableTreeNode rootProductConfig = this.m_RadioButtonTreeCellRenderer.root;
        log.fine("rootProductConfig.getDepth: " + rootProductConfig.getDepth());
        log.fine("rootProductInstance.getDepth: " + rootProductInstance.getDepth());
        log.fine("rootProductConfig.getNumNodesFromRoot: " + this.getNumNodesFromRoot(rootProductConfig));
        log.fine("rootProductInstance.getNumNodesFromRoot: " + this.getNumNodesFromRoot(rootProductInstance));
        if (this.getNumNodesFromRoot(rootProductConfig) == this.getNumNodesFromRoot(rootProductInstance) && rootProductConfig.getDepth() == rootProductInstance.getDepth() && (children = rootProductConfig.breadthFirstEnumeration()) != null) {
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                nodeUserObject m_nodeUserObject = (nodeUserObject)child.getUserObject();
                if (!m_nodeUserObject.isChosen && !m_nodeUserObject.isMandatory || child.getLevel() <= 1 || this.isProductContainedAtLevelInProductInstance(m_nodeUserObject.M_Product.get_ID(), child.getLevel(), rootProductInstance)) continue;
                return retValue;
            }
            retValue = true;
            return retValue;
        }
        return retValue;
    }

    private DefaultMutableTreeNode findProductInstance(DefaultMutableTreeNode rootProductConfig) {
        log.fine("In findProductInstance");
        DefaultMutableTreeNode retNode = null;
        nodeUserObject m_rootNodeUserObject = (nodeUserObject)rootProductConfig.getUserObject();
        ArrayList<DefaultMutableTreeNode> productInstances = this.getProductInstances(m_rootNodeUserObject.M_Product.get_ID());
        if (productInstances.size() > 0) {
            for (int i = 0; i < productInstances.size(); ++i) {
                if (!this.isConfigEqualToProductInstance(productInstances.get(i), rootProductConfig)) continue;
                retNode = productInstances.get(i);
            }
        }
        return retNode;
    }

    private int findProductInstance() {
        log.fine("In findProductInstance");
        int M_Product_ID = -1;
        DefaultMutableTreeNode rootProductConfig = this.m_RadioButtonTreeCellRenderer.root;
        ArrayList<DefaultMutableTreeNode> productInstances = this.getProductInstances();
        if (productInstances.size() > 0) {
            for (int i = 0; i < productInstances.size(); ++i) {
                if (!this.isConfigEqualToProductInstance(productInstances.get(i))) continue;
                nodeUserObject m_nodeUserObject = (nodeUserObject)productInstances.get(i).getUserObject();
                M_Product_ID = m_nodeUserObject.M_Product.get_ID();
            }
        }
        return M_Product_ID;
    }

    private DefaultMutableTreeNode getLowestConfigurableBOMTreeNode() {
        DefaultMutableTreeNode retNode = null;
        log.fine("In getLowestConfigurableBOMTreeNode");
        DefaultMutableTreeNode rootProductConfig = this.m_RadioButtonTreeCellRenderer.root;
        Enumeration<TreeNode> children = rootProductConfig.breadthFirstEnumeration();
        if (children != null) {
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                nodeUserObject m_nodeUserObject = (nodeUserObject)child.getUserObject();
                log.fine("child level: " + child.getLevel());
                log.fine("child: " + child);
                if (child.getLevel() <= 1) continue;
                X_PP_Product_BOM cfr_ignored_0 = m_nodeUserObject.bom;
                if (!m_nodeUserObject.bom.getBOMType().equals("C")) continue;
                X_PP_Product_BOM cfr_ignored_1 = m_nodeUserObject.bom;
                if (!m_nodeUserObject.bom.getBOMUse().equals("A") || m_nodeUserObject.bomLine != null) continue;
                if (retNode == null) {
                    retNode = child;
                    continue;
                }
                if (retNode.getLevel() <= child.getLevel()) continue;
                retNode = child;
            }
        }
        return retNode;
    }

    private boolean replaceProductConfigBOMwithProductFromChoices() {
        boolean retValue = true;
        boolean done = false;
        log.fine("In replaceProductConfigBOMwithProductFromChoices");
        while (!done) {
            DefaultMutableTreeNode lowestProductConfigBOMNode = this.getLowestConfigurableBOMTreeNode();
            log.fine("lowestProductConfigBOMNode: " + lowestProductConfigBOMNode);
            if (lowestProductConfigBOMNode == null) {
                done = true;
                continue;
            }
            DefaultMutableTreeNode foundProductInstanceNode = this.findProductInstance(lowestProductConfigBOMNode);
            log.fine("foundProductInstanceNode: " + foundProductInstanceNode);
            if (foundProductInstanceNode == null) {
                done = true;
                retValue = false;
                continue;
            }
            DefaultMutableTreeNode m_parent = (DefaultMutableTreeNode)lowestProductConfigBOMNode.getParent();
            nodeUserObject m_nodeUserObject = (nodeUserObject)foundProductInstanceNode.getUserObject();
            m_nodeUserObject.isChosen = true;
            m_nodeUserObject.isMandatory = true;
            m_parent.add(foundProductInstanceNode);
            lowestProductConfigBOMNode.removeFromParent();
        }
        return retValue;
    }

    private boolean cmd_saveOrder(int C_Order_ID) {
        log.config("C_Order_ID=" + C_Order_ID);
        MOrder order = new MOrder(Env.getCtx(), C_Order_ID, null);
        if (order.get_ID() == 0) {
            log.log(Level.SEVERE, "Not found - C_Order_ID=" + C_Order_ID);
            return false;
        }
        this.m_qty = (BigDecimal)this.productQty.getValue();
        log.fine("printing product config tree");
        this.printTree(this.m_RadioButtonTreeCellRenderer.root);
        while (this.pruneProductConfig()) {
        }
        int M_Product_ID = -1;
        boolean replaceResult = this.replaceProductConfigBOMwithProductFromChoices();
        log.fine("replaceResult: " + replaceResult);
        if (replaceResult) {
            log.fine("After replacement product config tree");
            this.printTree(this.m_RadioButtonTreeCellRenderer.root);
            M_Product_ID = this.findProductInstance();
        }
        log.fine("M_Product_ID: " + M_Product_ID);
        if (M_Product_ID < 0 || !replaceResult) {
            log.fine("No product instance found for the configuration chosen");
            String warningMsg = "No product instance found for the configuration chosen, create one?";
            String warningTitle = "Warning";
            int response = JOptionPane.showConfirmDialog(null, warningMsg, warningTitle, 0);
            if (response == 0) {
                log.fine("create product instance");
            }
        }
        MOrderLine ol = new MOrderLine(order);
        ol.setM_Product_ID(this.m_product.get_ID(), true);
        ol.setQty(this.m_qty);
        ol.setPrice();
        ol.setTax();
        if (ol.save()) {
            log.fine("order line saved");
        } else {
            log.log(Level.SEVERE, "Line not saved");
        }
        int lineCount = 0;
        log.config("#" + lineCount);
        return true;
    }

    private boolean cmd_saveInvoice(int C_Invoice_ID) {
        log.config("C_Invoice_ID=" + C_Invoice_ID);
        MInvoice invoice = new MInvoice(Env.getCtx(), C_Invoice_ID, null);
        if (invoice.get_ID() == 0) {
            log.log(Level.SEVERE, "Not found - C_Invoice_ID=" + C_Invoice_ID);
            return false;
        }
        int lineCount = 0;
        for (int i = 0; i < this.m_selectionList.size(); ++i) {
            if (!this.isSelectionSelected(this.m_selectionList.get(i))) continue;
            BigDecimal qty = (BigDecimal)this.m_qtyList.get(i).getValue();
            int M_Product_ID = this.m_productList.get(i);
            MInvoiceLine il = new MInvoiceLine(invoice);
            il.setM_Product_ID(M_Product_ID, true);
            il.setQty(qty);
            il.setPrice();
            il.setTax();
            if (il.save()) {
                ++lineCount;
                continue;
            }
            log.log(Level.SEVERE, "Line not saved");
        }
        log.config("#" + lineCount);
        return true;
    }

    private boolean cmd_saveProject(int C_Project_ID) {
        log.config("C_Project_ID=" + C_Project_ID);
        MProject project = new MProject(Env.getCtx(), C_Project_ID, null);
        if (project.get_ID() == 0) {
            log.log(Level.SEVERE, "Not found - C_Project_ID=" + C_Project_ID);
            return false;
        }
        int lineCount = 0;
        for (int i = 0; i < this.m_selectionList.size(); ++i) {
            if (!this.isSelectionSelected(this.m_selectionList.get(i))) continue;
            BigDecimal qty = (BigDecimal)this.m_qtyList.get(i).getValue();
            int M_Product_ID = this.m_productList.get(i);
            MProjectLine pl = new MProjectLine(project);
            pl.setM_Product_ID(M_Product_ID);
            pl.setPlannedQty(qty);
            if (pl.save()) {
                ++lineCount;
                continue;
            }
            log.log(Level.SEVERE, "Line not saved");
        }
        log.config("#" + lineCount);
        return true;
    }
}

