/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.adempiere.exceptions.DBException;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.Adempiere;
import org.compiere.apps.AEnv;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.AWindow;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.apps.search.PAttributeInstance;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VNumber;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MProduct;
import org.compiere.model.MQuery;
import org.compiere.model.MRefList;
import org.compiere.model.MRole;
import org.compiere.model.MUOM;
import org.compiere.model.MWarehouse;
import org.compiere.process.ProcessInfo;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.eevolution.form.MRPDetailed;
import org.eevolution.manufacturing.model.MPPProductPlanning;

public class VMRPDetailed
extends MRPDetailed
implements FormPanel,
ActionListener,
VetoableChangeListener,
ChangeListener,
ListSelectionListener,
TableModelListener,
ASyncProcess {
    private static final long serialVersionUID = 1L;
    private CPanel panel = new CPanel();
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private StatusBar statusBar = new StatusBar();
    private int AD_Client_ID = Env.getAD_Client_ID(this.getCtx());
    protected int p_WindowNo;
    protected String p_keyColumn;
    protected boolean p_multiSelection = true;
    protected String p_whereClause = "";
    protected MiniTable p_table = new MiniTable();
    private int m_keyColumnIndex = -1;
    private boolean m_cancel = false;
    protected ColumnInfo[] p_layout;
    private String m_sqlMain;
    private String m_sqlAdd;
    private Worker m_worker = null;
    private CPanel southPanel = new CPanel();
    private BorderLayout southLayout = new BorderLayout();
    ConfirmPanel confirmPanel = new ConfirmPanel(true, true, true, true, true, true, true);
    protected CPanel parameterPanel = new CPanel();
    private JScrollPane scrollPane = new JScrollPane();
    private JPopupMenu popup = new JPopupMenu();
    private JMenuItem calcMenu = new JMenuItem();
    static final int INFO_WIDTH = 800;
    private CLabel lProduct_ID = new CLabel(Msg.translate(this.getCtx(), "M_Product_ID"));
    private VLookup fProduct_ID;
    private CLabel lAttrSetInstance_ID = new CLabel(Msg.translate(this.getCtx(), "M_AttributeSetInstance_ID"));
    private CButton fAttrSetInstance_ID;
    private CLabel lResource_ID = new CLabel(Msg.translate(this.getCtx(), "S_Resource_ID"));
    private VLookup fResource_ID;
    private CLabel lWarehouse_ID = new CLabel(Msg.translate(this.getCtx(), "M_Warehouse_ID"));
    private VLookup fWarehouse_ID;
    private CLabel lPlanner_ID = new CLabel(Msg.translate(this.getCtx(), "Planner_ID"));
    private VLookup fPlanner_ID;
    private CLabel lDateFrom = new CLabel(Msg.translate(this.getCtx(), "DateFrom"));
    private VDate fDateFrom = new VDate("DateFrom", false, false, true, 15, Msg.translate(this.getCtx(), "DateFrom")){
        private static final long serialVersionUID = 1L;

        @Override
        public void setValue(Object arg0) {
            super.setValue(arg0);
        }
    };
    private CLabel lDateTo = new CLabel(Msg.translate(this.getCtx(), "DateTo"));
    private VDate fDateTo = new VDate("DateTo", false, false, true, 15, Msg.translate(this.getCtx(), "DateTo")){
        private static final long serialVersionUID = 1L;

        @Override
        public void setValue(Object arg0) {
            super.setValue(arg0);
        }
    };
    private CLabel lType = new CLabel();
    private CTextField fType = new CTextField(6);
    private CLabel lUOM = new CLabel();
    private CTextField fUOM = new CTextField(5);
    private CLabel lOrderPeriod = new CLabel();
    private VNumber fOrderPeriod = new VNumber();
    private CLabel lTimefence = new CLabel();
    private VNumber fTimefence = new VNumber();
    private CLabel lLeadtime = new CLabel();
    private VNumber fLeadtime = new VNumber();
    private CLabel lReplenishMin = new CLabel();
    private VNumber fReplenishMin = new VNumber();
    private CLabel lMinOrd = new CLabel();
    private VNumber fMinOrd = new VNumber();
    private CLabel lMaxOrd = new CLabel();
    private VNumber fMaxOrd = new VNumber();
    private CLabel lOrdMult = new CLabel();
    private VNumber fOrdMult = new VNumber();
    private CLabel lOrderQty = new CLabel();
    private VNumber fOrderQty = new VNumber();
    private CLabel lYield = new CLabel();
    private VNumber fYield = new VNumber();
    private CLabel lOnhand = new CLabel();
    private VNumber fOnhand = new VNumber();
    private CLabel lSafetyStock = new CLabel();
    private VNumber fSafetyStock = new VNumber();
    private CLabel lOrdered = new CLabel();
    private VNumber fOrdered = new VNumber();
    private CLabel lReserved = new CLabel();
    private VNumber fReserved = new VNumber();
    private CLabel lAvailable = new CLabel();
    private VNumber fAvailable = new VNumber();
    private CLabel lSupplyType = new CLabel(Msg.translate(this.getCtx(), "TypeMRP"));
    private VLookup fSupplyType = null;
    private VCheckBox fMaster = new VCheckBox("IsMPS", false, false, true, Msg.translate(this.getCtx(), "IsMPS"), "", false);
    private VCheckBox fMRPReq = new VCheckBox("IsRequiredMRP", false, false, true, Msg.translate(this.getCtx(), "IsRequiredMRP"), "", false);
    private VCheckBox fCreatePlan = new VCheckBox("IsCreatePlan", false, false, true, Msg.translate(this.getCtx(), "IsCreatePlan"), "", false);
    private JTabbedPane OrderPlanning;
    private JPanel PanelBottom;
    private JPanel PanelCenter;
    private JPanel PanelFind;
    private JPanel PanelOrder;
    private JPanel Results;
    private JPanel mainPanel;

    public VMRPDetailed() {
        this.initComponents();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("Ok")) {
            this.m_frame.dispose();
        } else if (cmd.equals("Cancel")) {
            this.m_cancel = true;
            this.m_frame.dispose();
        } else if (cmd.equals("Zoom")) {
            this.zoom();
        } else if (cmd.equals("Refresh")) {
            this.executeQuery();
        }
        this.m_frame.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    void enableButtons() {
        boolean enable = true;
        this.confirmPanel.getOKButton().setEnabled(true);
        if (this.hasHistory()) {
            this.confirmPanel.getHistoryButton().setEnabled(enable);
        }
        if (this.hasZoom()) {
            this.confirmPanel.getZoomButton().setEnabled(enable);
        }
    }

    @Override
    public void executeASync(ProcessInfo processInfo) {
    }

    void executeQuery() {
        if (this.m_worker != null && this.m_worker.isAlive()) {
            return;
        }
        this.m_worker = new Worker();
        this.m_worker.start();
    }

    private void fillHead() {
        MPPProductPlanning pp = MPPProductPlanning.find(this.getCtx(), this.getAD_Org_ID(), this.getM_Warehouse_ID(), this.getS_Resource_ID(), this.getM_Product_ID(), null);
        if (pp == null) {
            pp = new MPPProductPlanning(this.getCtx(), 0, null);
        }
        this.fMaster.setSelected(pp.isMPS());
        this.fMRPReq.setSelected(pp.isRequiredMRP());
        this.fCreatePlan.setSelected(pp.isCreatePlan());
        this.fOrderPeriod.setValue(pp.getOrder_Period());
        this.fLeadtime.setValue(pp.getDeliveryTime_Promised());
        this.fTimefence.setValue(pp.getTimeFence());
        this.fMinOrd.setValue(pp.getOrder_Min());
        this.fMaxOrd.setValue(pp.getOrder_Max());
        this.fOrdMult.setValue(pp.getOrder_Pack());
        this.fOrderQty.setValue(pp.getOrder_Qty());
        this.fYield.setValue(pp.getYield());
        this.fType.setText(MRefList.getListName(this.getCtx(), 53228, pp.getOrder_Policy()));
        this.fSafetyStock.setValue(pp.getSafetyStock());
    }

    private void fillPicks() throws Exception {
        this.prepareTable(this.m_layout, this.getTableName(), this.getWhereClause(this.getSQLWhere()), "DatePromised,ProductValue");
    }

    protected int getAD_Org_ID() {
        int warehouse_id = this.getM_Warehouse_ID();
        if (warehouse_id <= 0) {
            return 0;
        }
        return MWarehouse.get(this.getCtx(), warehouse_id).getAD_Org_ID();
    }

    protected Timestamp getDueEnd() {
        return this.fDateTo.getTimestamp();
    }

    protected Timestamp getDueStart() {
        return this.fDateFrom.getTimestamp();
    }

    protected int getM_AttributeSetInstance_ID() {
        Object o = this.fAttrSetInstance_ID.getValue();
        return o != null && o instanceof Integer ? (Integer)o : Integer.valueOf(0);
    }

    protected int getM_Product_ID() {
        Object o = this.fProduct_ID.getValue();
        return o != null && o instanceof Integer ? (Integer)o : Integer.valueOf(0);
    }

    protected int getM_Warehouse_ID() {
        Object o = this.fWarehouse_ID.getValue();
        return o != null && o instanceof Integer ? (Integer)o : Integer.valueOf(0);
    }

    protected int getPlanner_ID() {
        Object o = this.fPlanner_ID.getValue();
        return o != null && o instanceof Integer ? (Integer)o : Integer.valueOf(0);
    }

    protected BigDecimal getQtyOnHand() {
        BigDecimal bd = (BigDecimal)this.fOnhand.getValue();
        return bd != null ? bd : Env.ZERO;
    }

    protected int getS_Resource_ID() {
        Object o = this.fResource_ID.getValue();
        return o != null && o instanceof Integer ? (Integer)o : Integer.valueOf(0);
    }

    @Override
    public Integer getSelectedRowKey() {
        int row = this.p_table.getSelectedRow();
        if (row != -1 && this.m_keyColumnIndex != -1) {
            Object data = this.p_table.getModel().getValueAt(row, this.m_keyColumnIndex);
            if (data instanceof IDColumn) {
                data = ((IDColumn)data).getRecord_ID();
            }
            if (data instanceof Integer) {
                return (Integer)data;
            }
        }
        return null;
    }

    private String getSQLWhere() {
        StringBuffer sql = new StringBuffer();
        if (this.fProduct_ID.getValue() != null) {
            sql.append(" AND " + this.getTableName() + ".M_Product_ID=?");
            sql.append(" AND ((" + this.getTableName() + ".OrderType IN ('SOO','MOP','POO','POR','STK','DOO')) OR (" + this.getTableName() + ".OrderType='FCT' AND " + this.getTableName() + ".DatePromised >= SYSDATE))");
            this.fillHead();
            this.setMRP();
        }
        if (this.isAttributeSetInstance()) {
            sql.append(" AND " + this.getTableName() + ".M_AttributeSetInstance_ID=?");
            this.fillHead();
            this.setMRP();
        }
        if (this.fResource_ID.getValue() != null) {
            sql.append(" AND " + this.getTableName() + ".S_Resource_ID=?");
        }
        if (this.fPlanner_ID.getValue() != null) {
            sql.append(" AND " + this.getTableName() + ".Planner_ID=?");
        }
        if (this.fWarehouse_ID.getValue() != null) {
            sql.append(" AND " + this.getTableName() + ".M_Warehouse_ID=?");
        }
        if (this.fDateFrom.getValue() != null || this.fDateFrom.getValue() != null) {
            Timestamp from = (Timestamp)this.fDateFrom.getValue();
            Timestamp to = (Timestamp)this.fDateTo.getValue();
            if (from == null && to != null) {
                sql.append(" AND TRUNC(" + this.getTableName() + ".DatePromised) <= ?");
            } else if (from != null && to == null) {
                sql.append(" AND TRUNC(" + this.getTableName() + ".DatePromised) >= ?");
            } else if (from != null && to != null) {
                sql.append(" AND TRUNC(" + this.getTableName() + ".DatePromised) BETWEEN ? AND ?");
            }
        }
        log.fine("MRP Info.setWhereClause=" + sql.toString());
        return sql.toString();
    }

    @Override
    public void init(int WindowNo, FormFrame frame) {
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        Env.setContext(this.getCtx(), this.m_WindowNo, "IsSOTrx", "N");
        try {
            this.statInit();
            this.fillPicks();
            this.jbInit();
            this.m_frame.getContentPane().add((Component)this.mainPanel, "Center");
            this.m_frame.getContentPane().add((Component)this.statusBar, "South");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "VMRPDetailed.init", e);
        }
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.OrderPlanning = new JTabbedPane();
        this.PanelOrder = new JPanel();
        this.PanelFind = new JPanel();
        this.PanelCenter = new JPanel();
        this.PanelBottom = new JPanel();
        this.Results = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new BorderLayout());
        this.PanelOrder.setLayout(new BorderLayout());
        this.PanelOrder.add((Component)this.PanelFind, "North");
        this.PanelOrder.add((Component)this.PanelCenter, "Center");
        this.PanelOrder.add((Component)this.PanelBottom, "South");
        this.OrderPlanning.addTab("Order", this.PanelOrder);
        this.OrderPlanning.addTab("Results", this.Results);
        this.mainPanel.add((Component)this.OrderPlanning, "Center");
        this.panel.add((Component)this.mainPanel, "Center");
    }

    private boolean isAttributeSetInstance() {
        return this.getM_AttributeSetInstance_ID() > 0;
    }

    @Override
    public boolean isUILocked() {
        return false;
    }

    protected void jbInit() throws Exception {
        this.mainPanel.setLayout(new BorderLayout());
        this.panel.setLayout(new BorderLayout());
        this.southPanel.setLayout(this.southLayout);
        this.southPanel.add((Component)this.confirmPanel, "Center");
        this.southPanel.add((Component)this.statusBar, "South");
        this.mainPanel.add((Component)this.southPanel, "South");
        this.mainPanel.add((Component)this.parameterPanel, "North");
        this.mainPanel.add((Component)this.scrollPane, "Center");
        this.scrollPane.getViewport().add((Component)this.p_table, null);
        this.confirmPanel.addActionListener(this);
        this.confirmPanel.getResetButton().setVisible(this.hasReset());
        this.confirmPanel.getCustomizeButton().setVisible(this.hasCustomize());
        this.confirmPanel.getHistoryButton().setVisible(this.hasHistory());
        this.confirmPanel.getZoomButton().setVisible(this.hasZoom());
        this.popup.add(this.calcMenu);
        this.calcMenu.setText(Msg.getMsg(this.getCtx(), "Calculator"));
        this.calcMenu.setIcon(new ImageIcon(Adempiere.class.getResource("images/Calculator16.gif")));
        this.calcMenu.addActionListener(this);
        this.p_table.getSelectionModel().addListSelectionListener(this);
        this.enableButtons();
    }

    @Override
    public void lockUI(ProcessInfo processInfo) {
    }

    protected void prepareTable(ColumnInfo[] layout, String from, String staticWhere, String orderBy) {
        int i;
        this.p_layout = layout;
        StringBuffer sql = new StringBuffer("SELECT ");
        for (i = 0; i < layout.length; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(layout[i].getColSQL());
            if (layout[i].isKeyPairCol()) {
                sql.append(",").append(layout[i].getKeyPairColSQL());
            }
            this.p_table.addColumn(layout[i].getColHeader());
            if (layout[i].isColorColumn()) {
                this.p_table.setColorColumn(i);
            }
            if (layout[i].getColClass() != IDColumn.class) continue;
            this.m_keyColumnIndex = i;
        }
        for (i = 0; i < layout.length; ++i) {
            this.p_table.setColumnClass(i, layout[i].getColClass(), layout[i].isReadOnly(), layout[i].getColHeader());
        }
        sql.append(" FROM ").append(from);
        sql.append(" WHERE ");
        this.m_sqlMain = sql.toString();
        this.m_sqlAdd = "";
        if (orderBy != null && orderBy.length() > 0) {
            this.m_sqlAdd = " ORDER BY " + orderBy;
        }
        if (this.m_keyColumnIndex == -1) {
            log.log(Level.SEVERE, "No KeyColumn - " + sql);
        }
        this.p_table.setRowSelectionAllowed(true);
        this.p_table.setMultiSelection(false);
        this.p_table.setEditingColumn(0);
        this.p_table.setSelectionMode(2);
        this.parameterPanel.setPreferredSize(new Dimension(800, this.parameterPanel.getPreferredSize().height));
        this.scrollPane.setPreferredSize(new Dimension(800, 400));
    }

    private void selectAttributeSetInstance() {
        int m_warehouse_id = this.getM_Warehouse_ID();
        int m_product_id = this.getM_Product_ID();
        if (m_product_id <= 0) {
            return;
        }
        MProduct product = MProduct.get(this.getCtx(), m_product_id);
        MWarehouse wh = MWarehouse.get(this.getCtx(), m_warehouse_id);
        String title = product.get_Translation("Name") + " - " + wh.get_Translation("Name");
        PAttributeInstance pai = new PAttributeInstance(this.m_frame.getCFrame(), title, m_warehouse_id, 0, m_product_id, 0);
        if (pai.getM_AttributeSetInstance_ID() != -1) {
            this.fAttrSetInstance_ID.setText(pai.getM_AttributeSetInstanceName());
            this.fAttrSetInstance_ID.setValue(pai.getM_AttributeSetInstance_ID());
        } else {
            this.fAttrSetInstance_ID.setValue(0);
        }
    }

    private void setMRP() {
        int M_Product_ID = this.getM_Product_ID();
        int M_AttributeSetInstance_ID = this.getM_AttributeSetInstance_ID();
        int M_Warehouse_ID = this.getM_Warehouse_ID();
        if (M_Product_ID <= 0) {
            return;
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuffer sql = new StringBuffer("SELECT ").append("BOMQtyOnHandASI(M_Product_ID,?,?,?) as qtyonhand, ").append("BOMQtyReservedASI(M_Product_ID,?,?,?) as qtyreserved, ").append("BOMQtyAvailableASI(M_Product_ID,?,?,?) as qtyavailable, ").append("BOMQtyOrderedASI(M_Product_ID,?,?,?) as qtyordered").append(" FROM M_Product WHERE M_Product_ID=?");
            pstmt = DB.prepareStatement(sql.toString(), null);
            DB.setParameters((PreparedStatement)pstmt, new Object[]{this.getM_AttributeSetInstance_ID(), this.getM_Warehouse_ID(), 0, this.getM_AttributeSetInstance_ID(), this.getM_Warehouse_ID(), 0, this.getM_AttributeSetInstance_ID(), this.getM_Warehouse_ID(), 0, this.getM_AttributeSetInstance_ID(), this.getM_Warehouse_ID(), 0, this.getM_Product_ID()});
            rs = pstmt.executeQuery();
            while (rs.next()) {
                this.fOnhand.setValue(rs.getBigDecimal(1));
                this.fReserved.setValue(rs.getBigDecimal(2));
                this.fAvailable.setValue(rs.getBigDecimal(3));
                this.fOrdered.setValue(rs.getBigDecimal(4));
            }
        }
        catch (SQLException ex) {
            try {
                throw new DBException(ex);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        int uom_id = MProduct.get(this.getCtx(), M_Product_ID).getC_UOM_ID();
        MUOM um = MUOM.get(this.getCtx(), uom_id);
        KeyNamePair kum = new KeyNamePair(um.getC_UOM_ID(), um.get_Translation("Name"));
        this.fUOM.setText(kum.toString());
        BigDecimal replenishLevelMin = Env.ZERO;
        if (this.getM_Warehouse_ID() > 0) {
            String sql = "SELECT Level_Min FROM M_Replenish WHERE AD_Client_ID=? AND M_Product_ID=? AND M_Warehouse_ID=?";
            replenishLevelMin = DB.getSQLValueBD(null, sql, this.AD_Client_ID, M_Product_ID, M_Warehouse_ID);
        }
        this.fReplenishMin.setValue(replenishLevelMin);
    }

    protected void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        int index = 1;
        if (this.getM_Product_ID() > 0) {
            int product_id = this.getM_Product_ID();
            pstmt.setInt(index++, product_id);
            log.fine("Product=" + product_id);
        }
        if (this.isAttributeSetInstance()) {
            int asi = this.getM_AttributeSetInstance_ID();
            pstmt.setInt(index++, asi);
            log.fine("AttributeSetInstance=" + asi);
        }
        if (this.getS_Resource_ID() > 0) {
            int resource_id = this.getS_Resource_ID();
            pstmt.setInt(index++, resource_id);
            log.fine("Resource=" + resource_id);
        }
        if (this.getM_Warehouse_ID() > 0) {
            int warehouse_id = this.getM_Warehouse_ID();
            pstmt.setInt(index++, this.getM_Warehouse_ID());
            log.fine("Warehouse=" + warehouse_id);
        }
        if (this.getPlanner_ID() > 0) {
            int planner_id = this.getPlanner_ID();
            pstmt.setInt(index++, planner_id);
            log.fine("Planner=" + planner_id);
        }
        if (this.getDueStart() != null || this.getDueEnd() != null) {
            Timestamp from = this.getDueStart();
            Timestamp to = this.getDueEnd();
            log.fine("Date From=" + from + ", Date To=" + to);
            if (from == null && to != null) {
                pstmt.setTimestamp(index++, to);
            } else if (from != null && to == null) {
                pstmt.setTimestamp(index++, from);
            } else if (from != null && to != null) {
                pstmt.setTimestamp(index++, from);
                pstmt.setTimestamp(index++, to);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    private void statInit() throws Exception {
        Language language = Language.getLoginLanguage();
        MLookup resourceL = MLookupFactory.get(this.getCtx(), this.p_WindowNo, MColumn.getColumn_ID("S_Resource", "S_Resource_ID"), 19, language, "S_Resource_ID", 0, false, "S_Resource.ManufacturingResourceType= 'PT'");
        this.fResource_ID = new VLookup("S_Resource_ID", false, false, true, resourceL){
            private static final long serialVersionUID = 1L;

            @Override
            public void setValue(Object arg0) {
                super.setValue(arg0);
            }
        };
        this.lResource_ID.setLabelFor(this.fResource_ID);
        this.fResource_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fPlanner_ID = new VLookup("Planner_ID", false, false, true, MLookupFactory.get(this.getCtx(), this.p_WindowNo, 0, MColumn.getColumn_ID("PP_Product_Planning", "Planner_ID"), 18)){
            private static final long serialVersionUID = 1L;

            @Override
            public void setValue(Object arg0) {
                super.setValue(arg0);
            }
        };
        this.lPlanner_ID.setLabelFor(this.fPlanner_ID);
        this.fPlanner_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fWarehouse_ID = new VLookup("M_Warehouse_ID", true, false, true, MLookupFactory.get(this.getCtx(), this.p_WindowNo, 0, MColumn.getColumn_ID("M_Warehouse", "M_Warehouse_ID"), 19)){
            private static final long serialVersionUID = 1L;

            @Override
            public void setValue(Object arg0) {
                super.setValue(arg0);
            }
        };
        this.lWarehouse_ID.setLabelFor(this.fWarehouse_ID);
        this.fWarehouse_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fMaster.setSelected(false);
        this.fMaster.setReadWrite(false);
        this.fMRPReq.setSelected(false);
        this.fMRPReq.setReadWrite(false);
        this.fCreatePlan.setSelected(false);
        this.fCreatePlan.setReadWrite(false);
        this.lUOM.setText(Msg.translate(this.getCtx(), "C_UOM_ID"));
        this.fUOM.setBackground(AdempierePLAF.getInfoBackground());
        this.fUOM.setReadWrite(false);
        this.lType.setText(Msg.translate(this.getCtx(), "Order_Policy"));
        this.fType.setBackground(AdempierePLAF.getInfoBackground());
        this.fType.setReadWrite(false);
        this.lOrderPeriod.setText(Msg.translate(this.getCtx(), "Order_Period"));
        this.fOrderPeriod.setBackground(AdempierePLAF.getInfoBackground());
        this.fOrderPeriod.setReadWrite(false);
        this.lTimefence.setText(Msg.translate(this.getCtx(), "TimeFence"));
        this.fTimefence.setBackground(AdempierePLAF.getInfoBackground());
        this.fTimefence.setReadWrite(false);
        this.lLeadtime.setText(Msg.translate(this.getCtx(), "DeliveryTime_Promised"));
        this.fLeadtime.setBackground(AdempierePLAF.getInfoBackground());
        this.fLeadtime.setReadWrite(false);
        this.lMinOrd.setText(Msg.translate(this.getCtx(), "Order_Min"));
        this.fMinOrd.setBackground(AdempierePLAF.getInfoBackground());
        this.fMinOrd.setReadWrite(false);
        this.lMaxOrd.setText(Msg.translate(this.getCtx(), "Order_Max"));
        this.fMaxOrd.setBackground(AdempierePLAF.getInfoBackground());
        this.fMaxOrd.setReadWrite(false);
        this.lOrdMult.setText(Msg.translate(this.getCtx(), "Order_Pack"));
        this.fOrdMult.setBackground(AdempierePLAF.getInfoBackground());
        this.fOrdMult.setReadWrite(false);
        this.lOrderQty.setText(Msg.translate(this.getCtx(), "Order_Qty"));
        this.fOrderQty.setBackground(AdempierePLAF.getInfoBackground());
        this.fOrderQty.setReadWrite(false);
        this.lYield.setText(Msg.translate(this.getCtx(), "Yield"));
        this.fYield.setBackground(AdempierePLAF.getInfoBackground());
        this.fYield.setReadWrite(false);
        this.lOnhand.setText(Msg.translate(this.getCtx(), "QtyOnHand"));
        this.fOnhand.setBackground(AdempierePLAF.getInfoBackground());
        this.fOnhand.setReadWrite(false);
        this.lSafetyStock.setText(Msg.translate(this.getCtx(), "SafetyStock"));
        this.fSafetyStock.setBackground(AdempierePLAF.getInfoBackground());
        this.fSafetyStock.setReadWrite(false);
        this.lReserved.setText(Msg.translate(this.getCtx(), "QtyReserved"));
        this.fReserved.setBackground(AdempierePLAF.getInfoBackground());
        this.fReserved.setReadWrite(false);
        this.lAvailable.setText(Msg.translate(this.getCtx(), "QtyAvailable"));
        this.fAvailable.setBackground(AdempierePLAF.getInfoBackground());
        this.fAvailable.setReadWrite(false);
        this.lOrdered.setText(Msg.translate(this.getCtx(), "QtyOrdered"));
        this.fOrdered.setBackground(AdempierePLAF.getInfoBackground());
        this.fOrdered.setReadWrite(false);
        this.fProduct_ID = new VLookup("M_Product_ID", true, false, true, MLookupFactory.get(this.getCtx(), this.p_WindowNo, 0, MColumn.getColumn_ID("M_Product", "M_Product_ID"), 30)){
            private static final long serialVersionUID = 1L;

            @Override
            public void setValue(Object arg0) {
                super.setValue(arg0);
                VMRPDetailed.this.fAttrSetInstance_ID.setValue(0);
            }
        };
        this.fAttrSetInstance_ID = new CButton(){
            private static final long serialVersionUID = 1L;
            private Object value;

            @Override
            public Object getValue() {
                return this.value;
            }

            @Override
            public void setText(String text) {
                if (text == null) {
                    text = "---";
                }
                if (((String)text).length() > 23) {
                    text = ((String)text).substring(0, 20) + "...";
                }
                super.setText((String)text);
            }

            @Override
            public void setValue(Object arg0) {
                int i;
                this.value = arg0;
                int n = i = arg0 instanceof Integer ? (Integer)arg0 : 0;
                if (i == 0) {
                    this.setText(null);
                }
            }
        };
        this.fAttrSetInstance_ID.setValue(0);
        this.fAttrSetInstance_ID.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VMRPDetailed.this.selectAttributeSetInstance();
            }
        });
        this.lProduct_ID.setLabelFor(this.fProduct_ID);
        this.fProduct_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.lDateFrom.setLabelFor(this.fDateFrom);
        this.fDateFrom.setBackground(AdempierePLAF.getInfoBackground());
        this.fDateFrom.setToolTipText(Msg.translate(this.getCtx(), "DateFrom"));
        this.lDateTo.setLabelFor(this.fDateTo);
        this.fDateTo.setBackground(AdempierePLAF.getInfoBackground());
        this.fDateTo.setToolTipText(Msg.translate(this.getCtx(), "DateTo"));
        this.fSupplyType = new VLookup("TypeMRP", false, false, true, MLookupFactory.get(this.getCtx(), this.p_WindowNo, 0, MColumn.getColumn_ID("PP_MRP", "TypeMRP"), 17));
        this.lSupplyType.setLabelFor(this.fSupplyType);
        this.fSupplyType.setBackground(AdempierePLAF.getInfoBackground());
        this.parameterPanel.setLayout(new ALayout());
        this.parameterPanel.add((Component)this.lProduct_ID, new ALayoutConstraint(0, 0));
        this.parameterPanel.add((Component)this.fProduct_ID, new ALayoutConstraint(0, 1));
        this.parameterPanel.add((Component)this.lUOM, new ALayoutConstraint(0, 2));
        this.parameterPanel.add((Component)this.fUOM, new ALayoutConstraint(0, 3));
        this.parameterPanel.add((Component)this.lType, new ALayoutConstraint(0, 4));
        this.parameterPanel.add((Component)this.fType, new ALayoutConstraint(0, 5));
        this.parameterPanel.add((Component)this.lAttrSetInstance_ID, new ALayoutConstraint(1, 0));
        this.parameterPanel.add((Component)this.fAttrSetInstance_ID, new ALayoutConstraint(1, 1));
        this.parameterPanel.add((Component)this.lOnhand, new ALayoutConstraint(1, 2));
        this.parameterPanel.add((Component)this.fOnhand, new ALayoutConstraint(1, 3));
        this.parameterPanel.add((Component)this.lOrderPeriod, new ALayoutConstraint(1, 4));
        this.parameterPanel.add((Component)this.fOrderPeriod, new ALayoutConstraint(1, 5));
        this.parameterPanel.add((Component)this.lPlanner_ID, new ALayoutConstraint(2, 0));
        this.parameterPanel.add((Component)this.fPlanner_ID, new ALayoutConstraint(2, 1));
        this.parameterPanel.add((Component)this.lSafetyStock, new ALayoutConstraint(2, 2));
        this.parameterPanel.add((Component)this.fSafetyStock, new ALayoutConstraint(2, 3));
        this.parameterPanel.add((Component)this.lMinOrd, new ALayoutConstraint(2, 4));
        this.parameterPanel.add((Component)this.fMinOrd, new ALayoutConstraint(2, 5));
        this.parameterPanel.add((Component)this.lWarehouse_ID, new ALayoutConstraint(3, 0));
        this.parameterPanel.add((Component)this.fWarehouse_ID, new ALayoutConstraint(3, 1));
        this.parameterPanel.add((Component)this.lReserved, new ALayoutConstraint(3, 2));
        this.parameterPanel.add((Component)this.fReserved, new ALayoutConstraint(3, 3));
        this.parameterPanel.add((Component)this.lMaxOrd, new ALayoutConstraint(3, 4));
        this.parameterPanel.add((Component)this.fMaxOrd, new ALayoutConstraint(3, 5));
        this.parameterPanel.add((Component)this.lResource_ID, new ALayoutConstraint(4, 0));
        this.parameterPanel.add((Component)this.fResource_ID, new ALayoutConstraint(4, 1));
        this.parameterPanel.add((Component)this.lAvailable, new ALayoutConstraint(4, 2));
        this.parameterPanel.add((Component)this.fAvailable, new ALayoutConstraint(4, 3));
        this.parameterPanel.add((Component)this.lOrdMult, new ALayoutConstraint(4, 4));
        this.parameterPanel.add((Component)this.fOrdMult, new ALayoutConstraint(4, 5));
        this.parameterPanel.add((Component)this.lDateFrom, new ALayoutConstraint(5, 0));
        this.parameterPanel.add((Component)this.fDateFrom, new ALayoutConstraint(5, 1));
        this.parameterPanel.add((Component)this.lOrdered, new ALayoutConstraint(5, 2));
        this.parameterPanel.add((Component)this.fOrdered, new ALayoutConstraint(5, 3));
        this.parameterPanel.add((Component)this.lOrderQty, new ALayoutConstraint(5, 4));
        this.parameterPanel.add((Component)this.fOrderQty, new ALayoutConstraint(5, 5));
        this.parameterPanel.add((Component)this.lDateTo, new ALayoutConstraint(6, 0));
        this.parameterPanel.add((Component)this.fDateTo, new ALayoutConstraint(6, 1));
        this.parameterPanel.add((Component)this.lTimefence, new ALayoutConstraint(6, 4));
        this.parameterPanel.add((Component)this.fTimefence, new ALayoutConstraint(6, 5));
        this.parameterPanel.add((Component)this.fMaster, new ALayoutConstraint(7, 1));
        this.parameterPanel.add((Component)this.fCreatePlan, new ALayoutConstraint(7, 3));
        this.parameterPanel.add((Component)this.lLeadtime, new ALayoutConstraint(7, 4));
        this.parameterPanel.add((Component)this.fLeadtime, new ALayoutConstraint(7, 5));
        this.parameterPanel.add((Component)this.fMRPReq, new ALayoutConstraint(8, 3));
        this.parameterPanel.add((Component)this.lYield, new ALayoutConstraint(8, 4));
        this.parameterPanel.add((Component)this.fYield, new ALayoutConstraint(8, 5));
    }

    @Override
    public void tableChanged(TableModelEvent e) {
    }

    @Override
    public void unlockUI(ProcessInfo processInfo) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    @Override
    public void zoom(int AD_Window_ID, MQuery zoomQuery) {
        this.panel.setCursor(Cursor.getPredefinedCursor(3));
        final AWindow frame = new AWindow();
        if (!frame.initWindow(AD_Window_ID, zoomQuery)) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    9.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                AEnv.showCenterScreen(frame);
            }
        }.start();
    }

    class Worker
    extends Thread {
        Worker() {
        }

        @Override
        public void run() {
            MRPDetailed.log.fine("Info.Worker.run");
            VMRPDetailed.this.panel.setCursor(Cursor.getPredefinedCursor(3));
            VMRPDetailed.this.p_table.setRowCount(0);
            StringBuffer sql = new StringBuffer(VMRPDetailed.this.m_sqlMain);
            String dynWhere = VMRPDetailed.this.getWhereClause(VMRPDetailed.this.getSQLWhere());
            if (dynWhere.length() > 0) {
                sql.append(dynWhere);
            }
            sql.append(VMRPDetailed.this.m_sqlAdd);
            StringBuilder sqlFinal = new StringBuilder(MRole.getDefault().addAccessSQL(Msg.parseTranslation(VMRPDetailed.this.getCtx(), sql.toString()), VMRPDetailed.this.getTableName(), true, false));
            try {
                CPreparedStatement pstmt = DB.prepareStatement(sqlFinal.toString(), null);
                MRPDetailed.log.fine("SQL=" + sqlFinal);
                VMRPDetailed.this.setParameters(pstmt, false);
                ResultSet rs = pstmt.executeQuery();
                while (!this.isInterrupted() & rs.next()) {
                    int row = VMRPDetailed.this.p_table.getRowCount();
                    VMRPDetailed.this.p_table.setRowCount(row + 1);
                    int colOffset = 1;
                    for (int col = 0; col < VMRPDetailed.this.p_layout.length; ++col) {
                        Object data = null;
                        Class<?> c = VMRPDetailed.this.p_layout[col].getColClass();
                        int colIndex = col + colOffset;
                        if (c == IDColumn.class) {
                            IDColumn id = new IDColumn(rs.getInt(colIndex));
                            id.setSelected(true);
                            data = id;
                            VMRPDetailed.this.p_table.setColumnReadOnly(0, false);
                        } else if (c == Boolean.class) {
                            data = "Y".equals(rs.getString(colIndex));
                        } else if (c == Timestamp.class) {
                            data = rs.getTimestamp(colIndex);
                        } else if (c == BigDecimal.class) {
                            data = rs.getBigDecimal(colIndex);
                        } else if (c == Double.class) {
                            data = new Double(rs.getDouble(colIndex));
                        } else if (c == Integer.class) {
                            data = rs.getInt(colIndex);
                        } else if (c == KeyNamePair.class) {
                            String display = rs.getString(colIndex);
                            int key = rs.getInt(colIndex + 1);
                            data = new KeyNamePair(key, display);
                            ++colOffset;
                        } else {
                            data = rs.getString(colIndex);
                        }
                        VMRPDetailed.this.p_table.setValueAt(data, row, col);
                    }
                }
                MRPDetailed.log.fine("Info.Worker.run - interrupted=" + this.isInterrupted());
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                MRPDetailed.log.log(Level.SEVERE, "Info.Worker.run - " + sqlFinal, e);
            }
            VMRPDetailed.this.p_table.autoSize();
            VMRPDetailed.this.panel.setCursor(Cursor.getDefaultCursor());
            if (VMRPDetailed.this.getM_Product_ID() > 0) {
                BigDecimal OnHand = VMRPDetailed.this.getQtyOnHand();
                for (int row = 0; row < VMRPDetailed.this.p_table.getRowCount(); ++row) {
                    Timestamp datepromised = (Timestamp)VMRPDetailed.this.p_table.getValueAt(row, 5);
                    Timestamp today = new Timestamp(System.currentTimeMillis());
                    IDColumn id = (IDColumn)VMRPDetailed.this.p_table.getValueAt(row, 0);
                    String TypeMRP = DB.getSQLValueString(null, "SELECT TypeMRP FROM " + VMRPDetailed.this.getTableName() + " WHERE PP_MRP_ID=?", id.getRecord_ID());
                    String OrderType = (String)VMRPDetailed.this.p_table.getValueAt(row, 11);
                    if ("D".equals(TypeMRP) || "FCT".equals(OrderType) && datepromised.after(today)) {
                        BigDecimal QtyGrossReqs = (BigDecimal)VMRPDetailed.this.p_table.getValueAt(row, 6);
                        OnHand = OnHand.subtract(QtyGrossReqs);
                        VMRPDetailed.this.p_table.setValueAt(OnHand, row, 9);
                    }
                    if (!"S".equals(TypeMRP)) continue;
                    BigDecimal QtyScheduledReceipts = (BigDecimal)VMRPDetailed.this.p_table.getValueAt(row, 7);
                    BigDecimal QtyPlan = (BigDecimal)VMRPDetailed.this.p_table.getValueAt(row, 8);
                    if (QtyPlan == null) {
                        QtyPlan = Env.ZERO;
                    }
                    if (QtyScheduledReceipts == null) {
                        QtyScheduledReceipts = Env.ZERO;
                    }
                    OnHand = OnHand.add(QtyScheduledReceipts.add(QtyPlan));
                    VMRPDetailed.this.p_table.setValueAt(OnHand, row, 9);
                }
            }
        }
    }
}

