/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import org.compiere.apps.ADialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VComboBox;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VNumber;
import org.compiere.minigrid.MiniTable;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;
import org.eevolution.hr.model.MHRConcept;
import org.eevolution.hr.model.MHRMovement;
import org.eevolution.hr.model.MHRPeriod;
import org.eevolution.hr.model.MHRProcess;
import org.eevolution.hr.services.HRActionNotice;

public class VHRActionNotice
extends HRActionNotice
implements FormPanel,
ActionListener,
VetoableChangeListener {
    private CTextField fieldDescription = new CTextField(22);
    private VDate fieldValidFrom = new VDate();
    private VNumber fieldQty = new VNumber();
    private VNumber fieldAmount = new VNumber();
    private VDate fieldDate = new VDate();
    private CTextField fieldText = new CTextField(22);
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel parameterPanel = new CPanel();
    private VComboBox fieldProcess = new VComboBox();
    private VComboBox fieldEmployee = new VComboBox();
    private VComboBox fieldConcept = new VComboBox();
    private VComboBox fieldTextLookup = new VComboBox();
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private static CLogger log = CLogger.getCLogger(VHRActionNotice.class);
    private CLabel labelProcess = new CLabel();
    private CLabel labelEmployee = new CLabel();
    private CLabel labelColumnType = new CLabel();
    private VLookup fieldColumnType = null;
    private CLabel labelConcept = new CLabel();
    private JLabel labelValue = new JLabel();
    private JLabel dataStatus = new JLabel();
    private JScrollPane dataPane = new JScrollPane();
    private VNumber fieldRuleE = new VNumber();
    private MiniTable miniTable = new MiniTable();
    private CPanel commandPanel = new CPanel();
    private FlowLayout commandLayout = new FlowLayout();
    private JButton bOk = ConfirmPanel.createOKButton(true);
    private CLabel labelValidFrom = new CLabel();
    private CLabel labelDescription = new CLabel();
    private GridBagLayout parameterLayout = new GridBagLayout();

    @Override
    public void init(int n, FormFrame formFrame) {
        log.info("");
        this.m_WindowNo = n;
        this.m_frame = formFrame;
        Env.setContext(Env.getCtx(), this.m_WindowNo, "IsSOTrx", "Y");
        try {
            super.dynInit();
            this.dynInit();
            this.jbInit();
            formFrame.getContentPane().add((Component)this.mainPanel, "Center");
            formFrame.setSize(1000, 400);
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "init", exception);
        }
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    private void jbInit() {
        CompiereColor.setBackground(this.mainPanel);
        this.mainPanel.setLayout(this.mainLayout);
        this.mainPanel.setPreferredSize(new Dimension(1000, 400));
        this.parameterPanel.setLayout(this.parameterLayout);
        this.labelProcess.setLabelFor(this.fieldProcess);
        this.labelProcess.setText(Msg.translate(Env.getCtx(), "HR_Process_ID"));
        this.labelEmployee.setLabelFor(this.fieldEmployee);
        this.labelEmployee.setText(Msg.translate(Env.getCtx(), "HR_Employee_ID"));
        this.labelConcept.setLabelFor(this.fieldConcept);
        this.labelConcept.setText(Msg.translate(Env.getCtx(), "HR_Concept_ID"));
        this.labelValidFrom.setLabelFor(this.fieldValidFrom);
        this.labelValidFrom.setText(Msg.translate(Env.getCtx(), "Date"));
        this.labelDescription.setLabelFor(this.fieldDescription);
        this.labelDescription.setText(Msg.translate(Env.getCtx(), "Description"));
        this.labelColumnType.setLabelFor(this.fieldColumnType);
        this.labelColumnType.setText(Msg.translate(Env.getCtx(), "ColumnType"));
        this.mainPanel.add((Component)this.parameterPanel, "North");
        this.parameterPanel.add((Component)this.labelProcess, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldProcess, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelEmployee, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldEmployee, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelValidFrom, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldValidFrom, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelConcept, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldConcept, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelColumnType, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldColumnType, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelValue, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldQty, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldAmount, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldDate, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldText, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldTextLookup, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelDescription, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldDescription, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.bOk, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.dataStatus, "South");
        this.mainPanel.add((Component)this.dataPane, "Center");
        this.dataPane.getViewport().add((Component)this.miniTable, null);
        this.commandPanel.setLayout(this.commandLayout);
        this.commandLayout.setAlignment(2);
        this.commandLayout.setHgap(10);
    }

    @Override
    public void dynInit() throws Exception {
        this.fieldProcess = new VComboBox(VHRActionNotice.getProcess());
        this.fieldProcess.addActionListener(this);
        this.fieldProcess.setMandatory(true);
        this.fieldEmployee.addActionListener(this);
        this.fieldEmployee.setReadWrite(false);
        this.fieldEmployee.setMandatory(true);
        this.fieldConcept.addActionListener(this);
        this.fieldConcept.setReadWrite(false);
        this.fieldConcept.setMandatory(true);
        this.fieldValidFrom.setReadWrite(false);
        this.fieldValidFrom.setMandatory(true);
        this.fieldValidFrom.addVetoableChangeListener(this);
        this.fieldDescription.setValue("");
        this.fieldDescription.setReadWrite(false);
        this.fieldColumnType = new VLookup("ColumnType", true, true, false, this.getColumnTypeLookup());
        this.fieldColumnType.setReadWrite(false);
        this.fieldTextLookup.setReadWrite(true);
        this.fieldQty.setReadWrite(false);
        this.fieldQty.setDisplayType(29);
        this.fieldQty.setVisible(true);
        this.fieldAmount.setDisplayType(12);
        this.fieldAmount.setVisible(false);
        this.fieldDate.setVisible(false);
        this.fieldText.setVisible(false);
        this.fieldTextLookup.setVisible(false);
        this.fieldRuleE.setVisible(false);
        this.bOk.addActionListener(this);
        this.miniTable = new MiniTable();
        this.configureMiniTable(this.miniTable);
    }

    private void executeQuery() {
        this.executeQuery(Env.getCtx(), this.miniTable, 1);
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        this.fieldConcept.setReadWrite(true);
        log.fine("Event" + propertyChangeEvent);
        log.fine("Event Source " + propertyChangeEvent.getSource());
        log.fine("Event Property " + propertyChangeEvent.getPropertyName());
        Integer n = this.getPayrollProcess().getHR_Period_ID();
        String string = DB.TO_DATE((Timestamp)this.fieldValidFrom.getValue());
        int n2 = DB.getSQLValueEx(null, "SELECT HR_Period_ID FROM HR_Period WHERE " + string + " >= StartDate AND " + string + " <= EndDate AND HR_Period_ID = " + n, new Object[0]);
        if (n2 < 0) {
            this.fieldConcept.setReadWrite(false);
            return;
        }
        this.fieldConcept.setReadWrite(true);
        if (this.fieldConcept != null) {
            this.movementId = this.seekMovement((Timestamp)this.fieldValidFrom.getValue());
        }
    }

    private void loadTextMsgLookup(int n) {
        this.fieldTextLookup.removeAllItems();
        this.isLookupTextMsg = false;
        if (n == 0) {
            return;
        }
        ArrayList<ValueNamePair> arrayList = this.getConceptReference(n);
        for (ValueNamePair valueNamePair : arrayList) {
            this.fieldTextLookup.addItem(valueNamePair);
        }
        this.isLookupTextMsg = true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        log.fine("Event " + actionEvent);
        log.fine("Event Source " + actionEvent.getSource());
        if (actionEvent.getSource().equals(this.fieldProcess)) {
            KeyNamePair keyNamePair = (KeyNamePair)this.fieldProcess.getSelectedItem();
            if (keyNamePair != null) {
                this.payrollProcessId = keyNamePair.getKey();
                this.payrollProcess = new MHRProcess(Env.getCtx(), this.payrollProcessId, null);
                if (this.payrollProcess.getHR_Period_ID() > 0) {
                    KeyNamePair[] keyNamePairArray = MHRPeriod.getById(Env.getCtx(), this.payrollProcess.getHR_Period_ID(), null);
                    this.dateStart = keyNamePairArray.getStartDate();
                    this.dateEnd = keyNamePairArray.getEndDate();
                } else {
                    this.dateEnd = this.payrollProcess.getDateAcct();
                }
                this.payrollId = this.payrollProcess.getHR_Payroll_ID();
                this.fieldEmployee.removeAllItems();
                for (KeyNamePair keyNamePair2 : VHRActionNotice.getEmployeeValid(this.payrollProcess)) {
                    this.fieldEmployee.addItem(keyNamePair2);
                }
                this.fieldEmployee.setSelectedIndex(0);
                this.fieldEmployee.setReadWrite(true);
            }
        } else if (actionEvent.getSource().equals(this.fieldEmployee)) {
            KeyNamePair keyNamePair = (KeyNamePair)this.fieldEmployee.getSelectedItem();
            if (keyNamePair != null) {
                this.partnerId = keyNamePair.getKey();
            }
            if (this.partnerId > 0) {
                this.fieldValidFrom.setValue(this.dateEnd);
                this.fieldValidFrom.setReadWrite(true);
                this.fieldConcept.removeAllItems();
                for (KeyNamePair keyNamePair3 : this.getConcept(this.payrollProcess, this.fieldProcess != null)) {
                    this.fieldConcept.addItem(keyNamePair3);
                }
                this.reloadMovement();
                this.fieldConcept.setReadWrite(true);
            }
        } else if (actionEvent.getSource().equals(this.fieldConcept)) {
            KeyNamePair keyNamePair = (KeyNamePair)this.fieldConcept.getSelectedItem();
            if (keyNamePair != null) {
                this.conceptId = keyNamePair.getKey();
            }
            this.reloadMovement();
        } else if (actionEvent instanceof ActionEvent && actionEvent.getSource().equals(this.bOk)) {
            this.conceptId = ((KeyNamePair)this.fieldConcept.getSelectedItem()).getKey();
            this.partnerId = ((KeyNamePair)this.fieldEmployee.getSelectedItem()).getKey();
            this.payrollId = this.getPayrollProcess().getHR_Payroll_ID();
            if (this.payrollProcess.getHR_Period_ID() > 0) {
                MHRPeriod mHRPeriod = MHRPeriod.getById(Env.getCtx(), this.payrollProcess.getHR_Period_ID(), null);
                this.dateStart = mHRPeriod.getStartDate();
                this.dateEnd = mHRPeriod.getEndDate();
            } else {
                this.dateEnd = this.payrollProcess.getDateAcct();
            }
            this.quantity = (BigDecimal)this.fieldQty.getValue();
            this.amount = (BigDecimal)this.fieldAmount.getValue();
            this.text = this.isLookupTextMsg ? (String)this.fieldTextLookup.getValue() : (String)this.fieldText.getValue();
            this.serviceDate = (Timestamp)this.fieldDate.getValue();
            this.description = (String)this.fieldDescription.getValue();
            this.validFrom = (Timestamp)this.fieldValidFrom.getValue();
            this.validTo = (Timestamp)this.fieldValidFrom.getValue();
            if (this.conceptId <= 0 || this.fieldProcess.getValue() == null || (Integer)this.fieldProcess.getValue() <= 0 || this.fieldEmployee.getValue() == null || (Integer)this.fieldEmployee.getValue() <= 0) {
                ADialog.error(this.m_WindowNo, this.mainPanel, Msg.translate(Env.getCtx(), "FillMandatory") + Msg.translate(Env.getCtx(), "HR_Process_ID") + ", " + Msg.translate(Env.getCtx(), "HR_Employee_ID") + ", " + Msg.translate(Env.getCtx(), "HR_Concept_ID"));
            } else {
                this.saveMovement();
            }
        }
        this.executeQuery();
    }

    private void reloadMovement() {
        if (this.conceptId > 0) {
            MHRConcept mHRConcept = MHRConcept.getById(Env.getCtx(), this.conceptId, null);
            this.loadTextMsgLookup(mHRConcept.getAD_Reference_ID());
            this.fieldColumnType.setValue(mHRConcept.getColumnType());
            this.fieldColumnType.setVisible(true);
            this.movementId = this.seekMovement((Timestamp)this.fieldValidFrom.getValue());
            this.fieldText.setValue("");
            this.fieldDate.setValue(null);
            this.fieldQty.setValue(Env.ZERO);
            this.fieldAmount.setValue(Env.ZERO);
            if (this.movementId > 0) {
                MHRMovement mHRMovement = new MHRMovement(Env.getCtx(), this.movementId, null);
                this.fieldDescription.setValue(mHRMovement.getDescription());
                if (mHRConcept.getColumnType().equals("Q")) {
                    this.fieldQty.setValue(mHRMovement.getQty());
                } else if (mHRConcept.getColumnType().equals("A")) {
                    this.fieldAmount.setValue(mHRMovement.getAmount());
                } else if (mHRConcept.getColumnType().equals("T")) {
                    if (this.isLookupTextMsg) {
                        this.fieldTextLookup.setValue(mHRMovement.getTextMsg());
                    } else {
                        this.fieldText.setValue(mHRMovement.getTextMsg());
                    }
                } else if (mHRConcept.getColumnType().equals("D")) {
                    this.fieldDate.setValue(mHRMovement.getServiceDate());
                }
            } else {
                this.fieldQty.setValue(null);
                this.fieldAmount.setValue(null);
                this.fieldDescription.setValue(null);
                this.fieldText.setValue(null);
                this.fieldTextLookup.setValue(null);
                this.fieldDate.setValue(null);
            }
            if (mHRConcept.getColumnType().equals("Q")) {
                this.fieldQty.setVisible(true);
                this.fieldQty.setReadWrite(true);
                this.fieldAmount.setVisible(false);
                this.fieldDate.setVisible(false);
                this.fieldText.setVisible(false);
                this.fieldTextLookup.setVisible(false);
                this.fieldRuleE.setVisible(false);
            } else if (mHRConcept.getColumnType().equals("A")) {
                this.fieldQty.setVisible(false);
                this.fieldAmount.setVisible(true);
                this.fieldAmount.setReadWrite(true);
                this.fieldDate.setVisible(false);
                this.fieldText.setVisible(false);
                this.fieldTextLookup.setVisible(false);
                this.fieldRuleE.setVisible(false);
            } else if (mHRConcept.getColumnType().equals("D")) {
                this.fieldQty.setVisible(false);
                this.fieldAmount.setVisible(false);
                this.fieldDate.setVisible(true);
                this.fieldDate.setReadWrite(true);
                this.fieldText.setVisible(false);
                this.fieldTextLookup.setVisible(false);
                this.fieldRuleE.setVisible(false);
            } else if (mHRConcept.getColumnType().equals("T")) {
                if (this.isLookupTextMsg) {
                    this.fieldText.setVisible(false);
                    this.fieldText.setReadWrite(false);
                    this.fieldTextLookup.setVisible(true);
                    this.fieldTextLookup.setReadWrite(true);
                } else {
                    this.fieldTextLookup.setVisible(false);
                    this.fieldTextLookup.setReadWrite(false);
                    this.fieldText.setVisible(true);
                    this.fieldText.setReadWrite(true);
                }
                this.fieldQty.setVisible(false);
                this.fieldAmount.setVisible(false);
                this.fieldDate.setVisible(false);
                this.fieldRuleE.setVisible(false);
            }
            this.fieldDescription.setReadWrite(true);
        }
    }
}

