/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import org.adempiere.core.domains.models.X_PP_Order_BOMLine;
import org.adempiere.exceptions.DBException;
import org.compiere.apps.form.GenForm;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.eevolution.manufacturing.model.MPPOrder;
import org.eevolution.manufacturing.model.MPPOrderBOMLine;

public class OrderReceiptIssue
extends GenForm {
    private static CLogger log = CLogger.getCLogger(OrderReceiptIssue.class);
    String m_sql = "";
    private boolean m_isOnlyReceipt = false;
    private boolean m_OnlyIssue = false;
    protected boolean m_IsBackflush = false;
    protected Timestamp m_movementDate = null;
    protected BigDecimal m_orderedQty = Env.ZERO;
    protected BigDecimal m_DeliveredQty = Env.ZERO;
    protected BigDecimal m_toDeliverQty = Env.ZERO;
    protected BigDecimal m_scrapQty = Env.ZERO;
    protected BigDecimal m_rejectQty = Env.ZERO;
    protected BigDecimal m_openQty = Env.ZERO;
    protected BigDecimal m_qtyBatchs = Env.ZERO;
    protected BigDecimal m_qtyBatchSize = Env.ZERO;
    protected int m_M_AttributeSetInstance_ID = 0;
    protected int m_M_Locator_ID = 0;
    private int m_PP_Order_ID = 0;
    private MPPOrder m_PP_order = null;

    @Override
    public void configureMiniTable(IMiniTable issue) {
        issue.addColumn("PP_Order_BOMLine_ID");
        issue.addColumn("IsCritical");
        issue.addColumn("Value");
        issue.addColumn("M_Product_ID");
        issue.addColumn("C_UOM_ID");
        issue.addColumn("M_AttributeSetInstance_ID");
        issue.addColumn("QtyRequired");
        issue.addColumn("QtyDelivered");
        issue.addColumn("QtyToDeliver");
        issue.addColumn("QtyScrap");
        issue.addColumn("QtyOnHand");
        issue.addColumn("QtyReserved");
        issue.addColumn("QtyAvailable");
        issue.addColumn("M_Locator_ID");
        issue.addColumn("M_Warehouse_ID");
        issue.addColumn("QtyBOM");
        issue.addColumn("IsQtyPercentage");
        issue.addColumn("QtyBatch");
        issue.setMultiSelection(true);
        issue.setColumnClass(0, IDColumn.class, false, " ");
        issue.setColumnClass(1, Boolean.class, true, Msg.translate(Env.getCtx(), "IsCritical"));
        issue.setColumnClass(2, String.class, true, Msg.translate(Env.getCtx(), "Value"));
        issue.setColumnClass(3, KeyNamePair.class, true, Msg.translate(Env.getCtx(), "M_Product_ID"));
        issue.setColumnClass(4, KeyNamePair.class, true, Msg.translate(Env.getCtx(), "C_UOM_ID"));
        issue.setColumnClass(5, String.class, true, Msg.translate(Env.getCtx(), "M_AttributeSetInstance_ID"));
        issue.setColumnClass(6, BigDecimal.class, true, Msg.translate(Env.getCtx(), "QtyRequired"));
        issue.setColumnClass(7, BigDecimal.class, true, Msg.translate(Env.getCtx(), "QtyDelivered"));
        issue.setColumnClass(8, BigDecimal.class, false, Msg.translate(Env.getCtx(), "QtyToDeliver"));
        issue.setColumnClass(9, BigDecimal.class, false, Msg.translate(Env.getCtx(), "QtyScrap"));
        issue.setColumnClass(10, BigDecimal.class, true, Msg.translate(Env.getCtx(), "QtyOnHand"));
        issue.setColumnClass(11, BigDecimal.class, true, Msg.translate(Env.getCtx(), "QtyReserved"));
        issue.setColumnClass(12, BigDecimal.class, true, Msg.translate(Env.getCtx(), "QtyAvailable"));
        issue.setColumnClass(13, String.class, true, Msg.translate(Env.getCtx(), "M_Locator_ID"));
        issue.setColumnClass(14, KeyNamePair.class, true, Msg.translate(Env.getCtx(), "M_Warehouse_ID"));
        issue.setColumnClass(15, BigDecimal.class, true, Msg.translate(Env.getCtx(), "QtyBom"));
        issue.setColumnClass(16, Boolean.class, true, Msg.translate(Env.getCtx(), "IsQtyPercentage"));
        issue.setColumnClass(17, BigDecimal.class, true, Msg.translate(Env.getCtx(), "QtyBatch"));
        issue.autoSize();
        issue.setRowCount(0);
        this.m_sql = "SELECT obl.PP_Order_BOMLine_ID,obl.IsCritical,p.Value,obl.M_Product_ID,p.Name,p.C_UOM_ID,u.Name,obl.QtyRequired,obl.QtyReserved,bomQtyAvailable(obl.M_Product_ID,obl.M_Warehouse_ID,0 ) AS QtyAvailable,bomQtyOnHand(obl.M_Product_ID,obl.M_Warehouse_ID,0) AS QtyOnHand,p.M_Locator_ID,obl.M_Warehouse_ID,w.Name,obl.QtyBom,obl.isQtyPercentage,obl.QtyBatch,obl.ComponentType,obl.QtyRequired - QtyDelivered AS QtyOpen,obl.QtyDelivered FROM PP_Order_BOMLine obl INNER JOIN M_Product p ON (obl.M_Product_ID = p.M_Product_ID)  INNER JOIN C_UOM u ON (p.C_UOM_ID = u.C_UOM_ID)  INNER JOIN M_Warehouse w ON (w.M_Warehouse_ID = obl.M_Warehouse_ID)  WHERE obl.PP_Order_ID = ? ORDER BY obl.Line";
    }

    private String createHTMLTable(String[][] table) {
        StringBuffer html = new StringBuffer("<table width=\"100%\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">");
        for (int i = 0; i < table.length; ++i) {
            if (table[i] == null) continue;
            html.append("<tr>");
            for (int j = 0; j < table[i].length; ++j) {
                html.append("<td>");
                if (table[i][j] != null) {
                    html.append(table[i][j]);
                }
                html.append("</td>");
            }
            html.append("</tr>");
        }
        html.append("</table>");
        return html.toString();
    }

    public void createIssue(MPPOrder order, IMiniTable issue) {
        int i;
        Timestamp movementDate;
        Timestamp minGuaranteeDate = movementDate = this.getMovementDate();
        boolean isCompleteQtyDeliver = false;
        ArrayList[][] m_issue = new ArrayList[issue.getRowCount()][1];
        int row = 0;
        for (i = 0; i < issue.getRowCount(); ++i) {
            ArrayList<Object> data = new ArrayList<Object>();
            IDColumn id = (IDColumn)issue.getValueAt(i, 0);
            KeyNamePair key = new KeyNamePair(id.getRecord_ID(), id.isSelected() ? "Y" : "N");
            data.add(key);
            data.add(issue.getValueAt(i, 1));
            data.add(issue.getValueAt(i, 2));
            data.add(issue.getValueAt(i, 3));
            data.add(this.getValueBigDecimal(issue, i, 8));
            data.add(this.getValueBigDecimal(issue, i, 9));
            KeyNamePair location = (KeyNamePair)issue.getValueAt(i, 13);
            if (location != null) {
                data.add(location.getID());
            } else {
                data.add(0);
            }
            m_issue[row][0] = data;
            ++row;
        }
        isCompleteQtyDeliver = MPPOrder.isQtyAvailable(order, m_issue, minGuaranteeDate);
        for (i = 0; i < m_issue.length; ++i) {
            MStorage[] storages;
            KeyNamePair key = (KeyNamePair)m_issue[i][0].get(0);
            boolean isSelected = key.getName().equals("Y");
            if (key == null || !isSelected) continue;
            Boolean isCritical = (Boolean)m_issue[i][0].get(1);
            String value = (String)m_issue[i][0].get(2);
            KeyNamePair productkey = (KeyNamePair)m_issue[i][0].get(3);
            int productId = productkey.getKey();
            X_PP_Order_BOMLine orderbomLine = null;
            int orderBOMLineId = 0;
            int attributeSetInstanceId = 0;
            int locatorId = 0;
            BigDecimal qtyToDeliver = (BigDecimal)m_issue[i][0].get(4);
            BigDecimal qtyScrapComponent = (BigDecimal)m_issue[i][0].get(5);
            MProduct product = MProduct.get(order.getCtx(), productId);
            if (product == null || product.get_ID() == 0 || !product.isStocked()) continue;
            if (value == null && isSelected) {
                attributeSetInstanceId = key.getKey();
                locatorId = Integer.valueOf((String)m_issue[i][0].get(6));
                if (attributeSetInstanceId == 0) {
                    attributeSetInstanceId = key.getKey();
                }
                if ((orderbomLine = MPPOrderBOMLine.forM_Product_ID(Env.getCtx(), order.get_ID(), productId, order.get_TrxName())) != null) {
                    orderBOMLineId = orderbomLine.get_ID();
                }
            } else if (value != null && isSelected) {
                orderBOMLineId = key.getKey();
                if (orderBOMLineId > 0) {
                    orderbomLine = new MPPOrderBOMLine(order.getCtx(), orderBOMLineId, order.get_TrxName());
                }
                attributeSetInstanceId = orderbomLine.getM_AttributeSetInstance_ID();
            }
            MStorage[] totalStorages = MPPOrder.getStorages(Env.getCtx(), productId, order.getM_Warehouse_ID(), attributeSetInstanceId, minGuaranteeDate, order.get_TrxName());
            if (locatorId > 0) {
                int finalLocatorId = locatorId;
                storages = (MStorage[])Arrays.stream(totalStorages).filter(storaage -> storaage.getM_Locator_ID() == finalLocatorId).toArray(MStorage[]::new);
            } else {
                storages = totalStorages;
            }
            boolean forceIssue = false;
            BigDecimal toIssue = qtyToDeliver.add(qtyScrapComponent);
            if ((storages == null || storages.length == 0) && toIssue.signum() < 0 && toIssue.add(orderbomLine.getQtyDelivered()).signum() >= 0) {
                forceIssue = true;
            }
            MPPOrder.createIssue(order, (MPPOrderBOMLine)orderbomLine, movementDate, qtyToDeliver, qtyScrapComponent, Env.ZERO, storages, forceIssue);
        }
    }

    public void executeQuery(IMiniTable issue) {
        String sql = "SELECT obl.PP_Order_BOMLine_ID,obl.IsCritical,p.Value,obl.M_Product_ID,p.Name,p.C_UOM_ID,u.Name,obl.QtyRequired,obl.QtyReserved,bomQtyAvailable(obl.M_Product_ID,obl.M_Warehouse_ID,0 ) AS QtyAvailable,bomQtyOnHand(obl.M_Product_ID,obl.M_Warehouse_ID,0) AS QtyOnHand,p.M_Locator_ID,obl.M_Warehouse_ID,w.Name,obl.QtyBom,obl.isQtyPercentage,obl.QtyBatch,obl.ComponentType,obl.QtyRequired - QtyDelivered AS QtyOpen,obl.QtyDelivered FROM PP_Order_BOMLine obl INNER JOIN M_Product p ON (obl.M_Product_ID = p.M_Product_ID)  INNER JOIN C_UOM u ON (p.C_UOM_ID = u.C_UOM_ID)  INNER JOIN M_Warehouse w ON (w.M_Warehouse_ID = obl.M_Warehouse_ID)  WHERE obl.PP_Order_ID = ? ORDER BY obl.Line";
        int row = 0;
        issue.setRowCount(row);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement("SELECT obl.PP_Order_BOMLine_ID,obl.IsCritical,p.Value,obl.M_Product_ID,p.Name,p.C_UOM_ID,u.Name,obl.QtyRequired,obl.QtyReserved,bomQtyAvailable(obl.M_Product_ID,obl.M_Warehouse_ID,0 ) AS QtyAvailable,bomQtyOnHand(obl.M_Product_ID,obl.M_Warehouse_ID,0) AS QtyOnHand,p.M_Locator_ID,obl.M_Warehouse_ID,w.Name,obl.QtyBom,obl.isQtyPercentage,obl.QtyBatch,obl.ComponentType,obl.QtyRequired - QtyDelivered AS QtyOpen,obl.QtyDelivered FROM PP_Order_BOMLine obl INNER JOIN M_Product p ON (obl.M_Product_ID = p.M_Product_ID)  INNER JOIN C_UOM u ON (p.C_UOM_ID = u.C_UOM_ID)  INNER JOIN M_Warehouse w ON (w.M_Warehouse_ID = obl.M_Warehouse_ID)  WHERE obl.PP_Order_ID = ? ORDER BY obl.Line", null);
            pstmt.setInt(1, this.getPP_Order_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                issue.setRowCount(row + 1);
                IDColumn id = new IDColumn(rs.getInt(1));
                BigDecimal qtyBom = rs.getBigDecimal(15);
                Boolean isQtyPercentage = rs.getString(16).equals("Y");
                Boolean isCritical = rs.getString(2).equals("Y");
                BigDecimal qtyBatch = rs.getBigDecimal(17);
                BigDecimal qtyRequired = rs.getBigDecimal(8);
                BigDecimal qtyOnHand = rs.getBigDecimal(11);
                BigDecimal qtyOpen = rs.getBigDecimal(19);
                BigDecimal qtyDelivered = rs.getBigDecimal(20);
                String componentType = rs.getString(18);
                BigDecimal toDeliverQty = this.getToDeliverQty();
                BigDecimal openQty = this.getOpenQty();
                BigDecimal scrapQty = this.getScrapQty();
                BigDecimal componentToDeliverQty = Env.ZERO;
                BigDecimal componentScrapQty = Env.ZERO;
                BigDecimal componentQtyReq = Env.ZERO;
                BigDecimal componentQtyToDel = Env.ZERO;
                id.setSelected(this.isOnlyReceipt());
                issue.setValueAt(id, row, 0);
                issue.setValueAt(isCritical, row, 1);
                issue.setValueAt(rs.getString(3), row, 2);
                issue.setValueAt(new KeyNamePair(rs.getInt(4), rs.getString(5)), row, 3);
                issue.setValueAt(new KeyNamePair(rs.getInt(6), rs.getString(7)), row, 4);
                issue.setValueAt(qtyRequired, row, 6);
                issue.setValueAt(qtyDelivered, row, 7);
                issue.setValueAt(qtyOnHand, row, 10);
                issue.setValueAt(rs.getBigDecimal(9), row, 11);
                issue.setValueAt(rs.getBigDecimal(10), row, 12);
                issue.setValueAt(new KeyNamePair(rs.getInt(13), rs.getString(14)), row, 14);
                issue.setValueAt(qtyBom, row, 15);
                issue.setValueAt(isQtyPercentage, row, 16);
                issue.setValueAt(qtyBatch, row, 17);
                if (componentType.equals("CO") || componentType.equals("PK")) {
                    id.setSelected(qtyOnHand.signum() > 0 && qtyRequired.signum() > 0);
                    issue.setValueAt(id, row, 0);
                    if (isQtyPercentage.booleanValue()) {
                        BigDecimal qtyBatchPerc = qtyBatch.divide(Env.ONEHUNDRED, 8, RoundingMode.HALF_UP);
                        if (this.isBackflush()) {
                            if (qtyRequired.signum() == 0 || qtyOpen.signum() == 0) {
                                componentToDeliverQty = Env.ZERO;
                            } else {
                                componentToDeliverQty = toDeliverQty.multiply(qtyBatchPerc);
                                if (qtyRequired.subtract(qtyDelivered).signum() < 0 | componentToDeliverQty.signum() == 0) {
                                    componentToDeliverQty = qtyRequired.subtract(qtyDelivered);
                                }
                            }
                            if (componentToDeliverQty.signum() != 0) {
                                componentQtyToDel = componentToDeliverQty.setScale(4, RoundingMode.HALF_UP);
                                issue.setValueAt(componentToDeliverQty, row, 8);
                            }
                        } else {
                            componentToDeliverQty = qtyOpen;
                            if (componentToDeliverQty.signum() != 0) {
                                componentQtyReq = openQty.multiply(qtyBatchPerc);
                                componentQtyToDel = componentToDeliverQty.setScale(4, RoundingMode.HALF_UP);
                                issue.setValueAt(componentToDeliverQty.setScale(8, RoundingMode.HALF_UP), row, 8);
                                issue.setValueAt(openQty.multiply(qtyBatchPerc), row, 6);
                            }
                        }
                        if (scrapQty.signum() != 0) {
                            componentScrapQty = scrapQty.multiply(qtyBatchPerc);
                            if (componentScrapQty.signum() != 0) {
                                issue.setValueAt(componentScrapQty, row, 9);
                            }
                        } else {
                            issue.setValueAt(componentScrapQty, row, 9);
                        }
                    } else {
                        if (this.isBackflush()) {
                            componentToDeliverQty = componentType.equals("PK") ? qtyRequired.subtract(qtyDelivered) : toDeliverQty.multiply(qtyBom);
                            if (componentToDeliverQty.signum() != 0) {
                                componentQtyReq = componentType.equals("PK") ? qtyRequired.subtract(qtyDelivered) : toDeliverQty.multiply(qtyBom);
                                componentQtyToDel = componentToDeliverQty;
                                issue.setValueAt(componentQtyReq, row, 6);
                                issue.setValueAt(componentToDeliverQty, row, 8);
                            }
                        } else {
                            componentToDeliverQty = qtyOpen;
                            if (componentToDeliverQty.signum() != 0) {
                                componentQtyReq = componentType.equals("PK") ? qtyOpen : openQty.multiply(qtyBom);
                                componentQtyToDel = componentToDeliverQty;
                                issue.setValueAt(componentQtyReq, row, 6);
                                issue.setValueAt(componentToDeliverQty, row, 8);
                            }
                        }
                        if (scrapQty.signum() != 0) {
                            componentScrapQty = scrapQty.multiply(qtyBom);
                            if (componentScrapQty.signum() != 0) {
                                issue.setValueAt(componentScrapQty, row, 9);
                            }
                        } else {
                            issue.setValueAt(componentScrapQty, row, 9);
                        }
                    }
                } else if (componentType.equals("TL")) {
                    componentToDeliverQty = qtyBom;
                    if (componentToDeliverQty.signum() != 0) {
                        componentQtyReq = qtyBom;
                        componentQtyToDel = componentToDeliverQty;
                        issue.setValueAt(qtyBom, row, 6);
                        issue.setValueAt(componentToDeliverQty, row, 8);
                    }
                } else {
                    issue.setValueAt(Env.ZERO, row, 6);
                }
                ++row;
                if (!this.isOnlyIssue() && !this.isBackflush()) continue;
                int warehouse_id = rs.getInt(13);
                int product_id = rs.getInt(4);
                row += this.lotes(row, id, warehouse_id, product_id, componentQtyReq, componentQtyToDel, issue);
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        issue.autoSize();
    }

    public String generateSummaryTable(IMiniTable issue, String productField, String uomField, String attribute, String toDeliverQty, String deliveredQtyField, String scrapQtyField, boolean isBackflush, boolean isOnlyIssue, boolean isOnlyReceipt) {
        String[][] table;
        StringBuffer iText = new StringBuffer();
        iText.append("<b>");
        iText.append(Msg.parseTranslation(Env.getCtx(), "@IsShipConfirm@"));
        iText.append("</b>");
        iText.append("<br />");
        if (isOnlyReceipt || isBackflush) {
            table = new String[][]{{Msg.translate(Env.getCtx(), "Name"), Msg.translate(Env.getCtx(), "C_UOM_ID"), Msg.translate(Env.getCtx(), "M_AttributeSetInstance_ID"), Msg.translate(Env.getCtx(), "QtyToDeliver"), Msg.translate(Env.getCtx(), "QtyDelivered"), Msg.translate(Env.getCtx(), "QtyScrap")}, {productField, uomField, attribute, toDeliverQty, deliveredQtyField, scrapQtyField}};
            iText.append(this.createHTMLTable(table));
        }
        if (isBackflush || isOnlyIssue) {
            iText.append("<br /><br />");
            table = new ArrayList();
            table.add(new String[]{Msg.translate(Env.getCtx(), "Value"), Msg.translate(Env.getCtx(), "Name"), Msg.translate(Env.getCtx(), "C_UOM_ID"), Msg.translate(Env.getCtx(), "M_AttributeSetInstance_ID"), Msg.translate(Env.getCtx(), "QtyToDeliver"), Msg.translate(Env.getCtx(), "QtyDelivered"), Msg.translate(Env.getCtx(), "QtyScrap")});
            block0: for (int i = 0; i < issue.getRowCount(); ++i) {
                IDColumn id = (IDColumn)issue.getValueAt(i, 0);
                if (id == null || !id.isSelected()) continue;
                KeyNamePair m_productkey = (KeyNamePair)issue.getValueAt(i, 3);
                int m_M_Product_ID = m_productkey.getKey();
                KeyNamePair m_uomkey = (KeyNamePair)issue.getValueAt(i, 4);
                if (issue.getValueAt(i, 5) == null) {
                    Timestamp m_movementDate;
                    Timestamp minGuaranteeDate = m_movementDate = this.getMovementDate();
                    MStorage[] storages = MPPOrder.getStorages(Env.getCtx(), m_M_Product_ID, this.getPP_Order().getM_Warehouse_ID(), 0, minGuaranteeDate, null);
                    BigDecimal qtyDelivered = this.getValueBigDecimal(issue, i, 7);
                    BigDecimal toDelivery = this.getValueBigDecimal(issue, i, 8);
                    BigDecimal scrap = this.getValueBigDecimal(issue, i, 9);
                    BigDecimal toIssue = toDelivery.add(scrap);
                    if (storages == null || storages.length == 0) {
                        if (toIssue.signum() >= 0 || qtyDelivered.signum() <= 0 || qtyDelivered.add(toIssue).signum() < 0) continue;
                        String[] row = new String[]{"", "", "", "", "0.00", "0.00", "0.00"};
                        row[0] = issue.getValueAt(i, 2) != null ? issue.getValueAt(i, 2).toString() : "";
                        row[1] = m_productkey.toString();
                        row[2] = m_uomkey != null ? m_uomkey.toString() : "";
                        String desc = null;
                        row[3] = desc != null ? desc : "";
                        row[4] = toIssue.setScale(2, RoundingMode.HALF_UP).toString();
                        row[5] = this.getValueBigDecimal(issue, i, 7).setScale(2, RoundingMode.HALF_UP).toString();
                        row[6] = this.getValueBigDecimal(issue, i, 9).toString();
                        table.add(row);
                        continue;
                    }
                    for (MStorage storage : storages) {
                        if (storage.getQtyOnHand().signum() == 0) continue;
                        BigDecimal issueact = toIssue;
                        if (issueact.compareTo(storage.getQtyOnHand()) > 0) {
                            issueact = storage.getQtyOnHand();
                        }
                        toIssue = toIssue.subtract(issueact);
                        String desc = new MAttributeSetInstance(Env.getCtx(), storage.getM_AttributeSetInstance_ID(), null).getDescription();
                        String[] row = new String[]{"", "", "", "", "0.00", "0.00", "0.00"};
                        row[0] = issue.getValueAt(i, 2) != null ? issue.getValueAt(i, 2).toString() : "";
                        row[1] = m_productkey.toString();
                        row[2] = m_uomkey != null ? m_uomkey.toString() : "";
                        row[3] = desc != null ? desc : "";
                        row[4] = issueact.setScale(2, RoundingMode.HALF_UP).toString();
                        row[5] = this.getValueBigDecimal(issue, i, 7).setScale(2, RoundingMode.HALF_UP).toString();
                        row[6] = this.getValueBigDecimal(issue, i, 9).toString();
                        table.add(row);
                        if (toIssue.signum() <= 0) continue block0;
                    }
                    continue;
                }
                String[] row = new String[]{"", "", "", "", "0.00", "0.00", "0.00"};
                row[0] = issue.getValueAt(i, 2) != null ? issue.getValueAt(i, 2).toString() : "";
                row[1] = m_productkey.toString();
                row[2] = m_uomkey != null ? m_uomkey.toString() : "";
                row[3] = issue.getValueAt(i, 5) != null ? issue.getValueAt(i, 5).toString() : "";
                row[4] = this.getValueBigDecimal(issue, i, 8).toString();
                row[5] = this.getValueBigDecimal(issue, i, 7).toString();
                row[6] = this.getValueBigDecimal(issue, i, 9).toString();
                table.add(row);
            }
            String[][] tableArray = (String[][])table.toArray((T[])new String[table.size()][]);
            iText.append(this.createHTMLTable(tableArray));
        }
        return iText.toString();
    }

    protected BigDecimal getDeliveredQty() {
        return this.m_DeliveredQty;
    }

    protected int getM_AttributeSetInstance_ID() {
        return this.m_M_AttributeSetInstance_ID;
    }

    protected int getM_Locator_ID() {
        return this.m_M_Locator_ID;
    }

    protected Timestamp getMovementDate() {
        return this.m_movementDate;
    }

    protected BigDecimal getOpenQty() {
        return this.m_openQty;
    }

    protected BigDecimal getOrderedQty() {
        return this.m_orderedQty;
    }

    protected MPPOrder getPP_Order() {
        int id = this.getPP_Order_ID();
        if (id <= 0) {
            this.m_PP_order = null;
            return null;
        }
        if (this.m_PP_order == null || this.m_PP_order.get_ID() != id) {
            this.m_PP_order = new MPPOrder(Env.getCtx(), id, null);
        }
        return this.m_PP_order;
    }

    protected int getPP_Order_ID() {
        return this.m_PP_Order_ID;
    }

    protected BigDecimal getQtyBatchs() {
        return this.m_qtyBatchs;
    }

    protected BigDecimal getQtyBatchSize() {
        return this.m_qtyBatchSize;
    }

    protected BigDecimal getRejectQty() {
        return this.m_rejectQty;
    }

    protected BigDecimal getScrapQty() {
        return this.m_scrapQty;
    }

    protected BigDecimal getToDeliverQty() {
        return this.m_toDeliverQty;
    }

    private BigDecimal getValueBigDecimal(IMiniTable issue, int row, int col) {
        BigDecimal bd = (BigDecimal)issue.getValueAt(row, col);
        return bd == null ? Env.ZERO : bd;
    }

    protected boolean isBackflush() {
        return this.m_IsBackflush;
    }

    protected boolean isOnlyIssue() {
        return this.m_OnlyIssue;
    }

    protected boolean isOnlyReceipt() {
        return this.m_isOnlyReceipt;
    }

    private int lotes(int row, IDColumn id, int Warehouse_ID, int M_Product_ID, BigDecimal qtyRequired, BigDecimal qtyToDelivery, IMiniTable issue) {
        int linesNo = 0;
        BigDecimal qtyRequiredActual = qtyRequired;
        String sql = "SELECT s.M_Product_ID , s.QtyOnHand, s.M_AttributeSetInstance_ID, p.Name, masi.Description, l.M_Locator_ID , l.Value, w.Value, w.M_warehouse_ID,p.Value  FROM M_Storage s  INNER JOIN M_Product p ON (s.M_Product_ID = p.M_Product_ID)  INNER JOIN C_UOM u ON (u.C_UOM_ID = p.C_UOM_ID)  INNER JOIN M_AttributeSetInstance masi ON (masi.M_AttributeSetInstance_ID = s.M_AttributeSetInstance_ID)  INNER JOIN M_Warehouse w ON (w.M_Warehouse_ID = ?)  INNER JOIN M_Locator l ON(l.M_Warehouse_ID=w.M_Warehouse_ID and s.M_Locator_ID=l.M_Locator_ID)  WHERE s.M_Product_ID = ? and s.QtyOnHand > 0  and s.M_AttributeSetInstance_ID <> 0  ORDER BY s.Created ";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement("SELECT s.M_Product_ID , s.QtyOnHand, s.M_AttributeSetInstance_ID, p.Name, masi.Description, l.M_Locator_ID , l.Value, w.Value, w.M_warehouse_ID,p.Value  FROM M_Storage s  INNER JOIN M_Product p ON (s.M_Product_ID = p.M_Product_ID)  INNER JOIN C_UOM u ON (u.C_UOM_ID = p.C_UOM_ID)  INNER JOIN M_AttributeSetInstance masi ON (masi.M_AttributeSetInstance_ID = s.M_AttributeSetInstance_ID)  INNER JOIN M_Warehouse w ON (w.M_Warehouse_ID = ?)  INNER JOIN M_Locator l ON(l.M_Warehouse_ID=w.M_Warehouse_ID and s.M_Locator_ID=l.M_Locator_ID)  WHERE s.M_Product_ID = ? and s.QtyOnHand > 0  and s.M_AttributeSetInstance_ID <> 0  ORDER BY s.Created ", null);
            pstmt.setInt(1, Warehouse_ID);
            pstmt.setInt(2, M_Product_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                issue.setRowCount(row + 1);
                BigDecimal qtyOnHand = rs.getBigDecimal(2);
                IDColumn id1 = new IDColumn(rs.getInt(3));
                id1.setSelected(false);
                issue.setValueAt(id1, row, 0);
                KeyNamePair productkey = new KeyNamePair(rs.getInt(1), rs.getString(4));
                issue.setValueAt(productkey, row, 3);
                issue.setValueAt(qtyOnHand, row, 10);
                issue.setValueAt(rs.getString(5), row, 5);
                KeyNamePair locatorKey = new KeyNamePair(rs.getInt(6), rs.getString(7));
                issue.setValueAt(locatorKey, row, 13);
                KeyNamePair m_warehousekey = new KeyNamePair(rs.getInt(9), rs.getString(8));
                issue.setValueAt(m_warehousekey, row, 14);
                issue.setValueAt(Env.ZERO, row, 6);
                issue.setValueAt(Env.ZERO, row, 8);
                issue.setValueAt(Env.ZERO, row, 9);
                if (qtyRequiredActual.compareTo(qtyOnHand) < 0) {
                    issue.setValueAt(qtyRequiredActual.signum() > 0 ? qtyRequiredActual : Env.ZERO, row, 6);
                } else {
                    issue.setValueAt(qtyOnHand, row, 6);
                }
                qtyRequiredActual = qtyRequiredActual.subtract(qtyOnHand);
                ++linesNo;
                ++row;
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return linesNo;
    }

    @Override
    public void saveSelection(IMiniTable miniTable) {
        log.info("");
        ArrayList<Integer> results = new ArrayList<Integer>();
        this.setSelection(null);
        int rows = miniTable.getRowCount();
        for (int i = 0; i < rows; ++i) {
            IDColumn id = (IDColumn)miniTable.getValueAt(i, 0);
            if (id == null || !id.isSelected()) continue;
            results.add(id.getRecord_ID());
        }
        if (results.size() == 0) {
            return;
        }
        log.config("Selected #" + results.size());
        this.setSelection(results);
    }

    protected void setDeliveredQty(BigDecimal qty) {
        this.m_DeliveredQty = qty;
    }

    protected void setIsBackflush(boolean IsBackflush) {
        this.m_IsBackflush = IsBackflush;
    }

    protected void setIsOnlyIssue(boolean onlyIssue) {
        this.m_OnlyIssue = onlyIssue;
    }

    protected void setIsOnlyReceipt(boolean isOnlyReceipt) {
        this.m_isOnlyReceipt = isOnlyReceipt;
    }

    protected void setM_AttributeSetInstance_ID(int M_AttributeSetInstance_ID) {
        this.m_M_AttributeSetInstance_ID = M_AttributeSetInstance_ID;
    }

    protected void setM_Locator_ID(int M_Locator_ID) {
        this.m_M_Locator_ID = M_Locator_ID;
    }

    protected void setMovementDate(Timestamp date) {
        this.m_movementDate = date;
    }

    protected void setOpenQty(BigDecimal qty) {
        this.m_openQty = qty;
    }

    protected void setOrderedQty(BigDecimal qty) {
        this.m_orderedQty = qty;
    }

    protected void setPP_Order_ID(int PP_Order_ID) {
        this.m_PP_Order_ID = PP_Order_ID;
    }

    protected void setQtyBatchs(BigDecimal qty) {
        this.m_qtyBatchs = qty;
    }

    protected void setQtyBatchSize(BigDecimal qty) {
        this.m_qtyBatchSize = qty;
    }

    protected void setRejectQty(BigDecimal qty) {
        this.m_rejectQty = qty;
    }

    protected void setScrapQty(BigDecimal qty) {
        this.m_scrapQty = qty;
    }

    protected void setToDeliverQty(BigDecimal qty) {
        this.m_toDeliverQty = qty;
    }

    public void showMessage(String message, boolean error) {
    }
}

