/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.apps.IStatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.GenForm;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.print.MPrintFormat;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.eevolution.distribution.model.MDDOrder;
import org.eevolution.distribution.model.MDDOrderLine;
import org.eevolution.distribution.services.InventoryMovementService;

public class OrderDistributionReceipt
extends GenForm {
    public FormFrame m_frame;
    public Object m_DD_Order_ID = null;
    public Object m_MovementDate = null;
    private static CLogger log = CLogger.getCLogger(OrderDistributionReceipt.class);

    @Override
    public void dynInit() throws Exception {
        this.setTitle("MovementGenerateInfo");
        MPrintFormat format = MPrintFormat.get(Env.getCtx(), MPrintFormat.getPrintFormat_ID("Inventory Move Hdr (Example)", MMovement.Table_ID, 0), false);
        this.setPrintFormat(format);
        this.setAskPrintMsg("PrintMovements");
    }

    @Override
    public void configureMiniTable(IMiniTable miniTable) {
        miniTable.addColumn("DD_Order_ID");
        miniTable.addColumn("QtyInTransit");
        miniTable.addColumn("C_UOM_ID");
        miniTable.addColumn("Value");
        miniTable.addColumn("M_Product_ID");
        miniTable.addColumn("M_WarehouseSource_ID");
        miniTable.setMultiSelection(true);
        miniTable.setColumnClass(0, IDColumn.class, false, " ");
        miniTable.setColumnClass(1, BigDecimal.class, false, Msg.translate(Env.getCtx(), "QtyInTransit"));
        miniTable.setColumnClass(2, String.class, true, Msg.translate(Env.getCtx(), "C_UOM_ID"));
        miniTable.setColumnClass(3, String.class, true, Msg.translate(Env.getCtx(), "M_Product_ID"));
        miniTable.setColumnClass(4, String.class, true, Msg.translate(Env.getCtx(), "Value"));
        miniTable.setColumnClass(5, String.class, true, Msg.translate(Env.getCtx(), "WarehouseSource"));
        miniTable.autoSize();
    }

    private String getOrderSQL() {
        StringBuffer sql = new StringBuffer("SELECT ol.DD_OrderLine_ID, ol.QtyInTransit , uom.Name , p.Value ,p.Name  , w.Name FROM DD_OrderLine ol INNER JOIN DD_Order o ON (o.DD_Order_ID=ol.DD_Order_ID) INNER JOIN M_Product p ON (p.M_Product_ID=ol.M_Product_ID)  INNER JOIN C_UOM uom  ON (uom.C_UOM_ID=ol.C_UOM_ID) INNER JOIN M_Locator  l ON (l.M_Locator_ID = ol.M_Locator_ID) INNER JOIN M_Warehouse  w ON (w.M_Warehouse_ID = l.M_Warehouse_ID) WHERE o.DocStatus= 'CO' AND  ol.QtyInTransit > 0  AND  o.DD_Order_ID = ? ");
        return sql.toString();
    }

    public void executeQuery(IMiniTable miniTable) {
        log.info("");
        String sql = "";
        if (this.m_DD_Order_ID == null) {
            return;
        }
        sql = this.getOrderSQL();
        log.fine(sql);
        int row = 0;
        miniTable.setRowCount(row);
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, Integer.parseInt(this.m_DD_Order_ID.toString()));
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                miniTable.setRowCount(row + 1);
                miniTable.setValueAt(new IDColumn(rs.getInt(1)), row, 0);
                miniTable.setValueAt(rs.getBigDecimal(2), row, 1);
                miniTable.setValueAt(rs.getString(3), row, 2);
                miniTable.setValueAt(rs.getString(4), row, 4);
                miniTable.setValueAt(rs.getString(5), row, 3);
                miniTable.setValueAt(rs.getString(6), row, 5);
                ++row;
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        miniTable.autoSize();
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void saveSelection(IMiniTable miniTable) {
        log.info("");
        ArrayList<Integer> results = new ArrayList<Integer>();
        this.setSelection(null);
        int rows = miniTable.getRowCount();
        for (int i = 0; i < rows; ++i) {
            IDColumn id = (IDColumn)miniTable.getValueAt(i, 0);
            if (id == null || !id.isSelected()) continue;
            results.add(id.getRecord_ID());
        }
        if (results.size() == 0) {
            return;
        }
        log.config("Selected #" + results.size());
        this.setSelection(results);
    }

    public String generate(MiniTable miniTable, IStatusBar statusBar, String docActionSelected) {
        String info = "";
        log.info("DD_Order_ID=" + this.m_DD_Order_ID);
        log.info("MovementDate" + this.m_MovementDate);
        String trxName = Trx.createTrxName("MVG");
        Trx trx = Trx.get(trxName, true);
        this.setSelectionActive(false);
        statusBar.setStatusLine(Msg.translate(Env.getCtx(), "M_Movement_ID"));
        statusBar.setStatusDB(String.valueOf(this.getSelection().size()));
        Properties m_ctx = Env.getCtx();
        Timestamp movementDate = (Timestamp)this.m_MovementDate;
        MDDOrder order = new MDDOrder(m_ctx, Integer.parseInt(this.m_DD_Order_ID.toString()), trxName);
        MMovement movement = InventoryMovementService.createMovementFromOrder(order, movementDate);
        movement.saveEx();
        ArrayList<Integer> ids = this.getSelection();
        int i = 0;
        for (int DD_OrderLine_ID : ids) {
            MDDOrderLine oline = new MDDOrderLine(m_ctx, DD_OrderLine_ID, trxName);
            MMovementLine line = new MMovementLine(movement);
            line.setM_Product_ID(oline.getM_Product_ID());
            BigDecimal QtyDeliver = (BigDecimal)miniTable.getValueAt(i, 1);
            if (QtyDeliver == null | QtyDeliver.compareTo(oline.getQtyInTransit()) > 0) {
                throw new AdempiereException("Error in Qty");
            }
            InventoryMovementService.setMovementOrderLine(line, oline, QtyDeliver, true);
            line.saveEx();
            ++i;
        }
        if (!movement.processIt("CO")) {
            log.warning("Failed: " + movement);
        }
        movement.setDocStatus("CO");
        movement.setDocAction("CL");
        movement.saveEx();
        return info;
    }
}

