/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.distribution.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.core.domains.models.X_DD_OrderLine;
import org.adempiere.core.domains.models.X_M_AttributeSet;
import org.adempiere.core.domains.models.X_M_Locator;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MCharge;
import org.compiere.model.MLocator;
import org.compiere.model.MMovementLine;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.model.MUOM;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.distribution.model.MDDOrder;

public class MDDOrderLine
extends X_DD_OrderLine {
    private static final long serialVersionUID = -8878804332001384969L;
    private static CLogger s_log = CLogger.getCLogger(MDDOrderLine.class);
    private int m_M_PriceList_ID = 0;
    private boolean m_IsSOTrx = true;
    private Integer m_precision = null;
    private MProduct m_product = null;
    private MDDOrder m_parent = null;

    public static BigDecimal getNotReserved(Properties properties, int n, int n2, int n3, int n4) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(n);
        arrayList.add(n2);
        arrayList.add(n4);
        Object object = "SELECT SUM(QtyOrdered-QtyDelivered-QtyReserved) FROM DD_OrderLine ol INNER JOIN DD_Order o ON (ol.DD_Order_ID=o.DD_Order_ID) WHERE ol.M_Locator_ID=? AND M_Product_ID=? AND o.IsSOTrx='N' AND o.DocStatus='DR' AND QtyOrdered-QtyDelivered-QtyReserved<>0 AND ol.DD_OrderLine_ID<>?";
        if (n3 != 0) {
            object = (String)object + " AND M_AttributeSetInstance_ID=?";
            arrayList.add(n3);
        }
        return DB.getSQLValueBD(null, ((String)object).toString(), arrayList);
    }

    public MDDOrderLine(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setFreightAmt(Env.ZERO);
            this.setLineNetAmt(Env.ZERO);
            this.setM_AttributeSetInstance_ID(0);
            this.setQtyEntered(Env.ZERO);
            this.setQtyInTransit(Env.ZERO);
            this.setConfirmedQty(Env.ZERO);
            this.setTargetQty(Env.ZERO);
            this.setPickedQty(Env.ZERO);
            this.setQtyOrdered(Env.ZERO);
            this.setQtyDelivered(Env.ZERO);
            this.setQtyReserved(Env.ZERO);
            this.setIsDescription(false);
            this.setProcessed(false);
            this.setLine(0);
        }
    }

    public MDDOrderLine(MDDOrder mDDOrder) {
        this(mDDOrder.getCtx(), 0, mDDOrder.get_TrxName());
        if (mDDOrder.get_ID() == 0) {
            throw new IllegalArgumentException("Header not saved");
        }
        this.setDD_Order_ID(mDDOrder.getDD_Order_ID());
        this.setOrder(mDDOrder);
    }

    public MDDOrderLine(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public void setOrder(MDDOrder mDDOrder) {
        this.setClientOrg(mDDOrder);
        this.setDateOrdered(mDDOrder.getDateOrdered());
        this.setDatePromised(mDDOrder.getDatePromised());
        this.setHeaderInfo(mDDOrder);
    }

    public void setHeaderInfo(MDDOrder mDDOrder) {
        this.m_parent = mDDOrder;
        this.m_IsSOTrx = mDDOrder.isSOTrx();
    }

    public MDDOrder getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MDDOrder(this.getCtx(), this.getDD_Order_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public void setProduct(MProduct mProduct) {
        this.m_product = mProduct;
        if (this.m_product != null) {
            this.setM_Product_ID(this.m_product.getM_Product_ID());
            this.setC_UOM_ID(this.m_product.getC_UOM_ID());
        } else {
            this.setM_Product_ID(0);
            this.set_ValueNoCheck("C_UOM_ID", null);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int n, boolean bl) {
        if (bl) {
            this.setProduct(MProduct.get(this.getCtx(), n));
        } else {
            super.setM_Product_ID(n);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int n, int n2) {
        super.setM_Product_ID(n);
        if (n2 != 0) {
            super.setC_UOM_ID(n2);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public MProduct getProduct() {
        if (this.m_product == null && this.getM_Product_ID() != 0) {
            this.m_product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        }
        return this.m_product;
    }

    @Override
    public void setM_AttributeSetInstance_ID(int n) {
        if (n == 0) {
            this.set_Value("M_AttributeSetInstance_ID", (Object)0);
        } else {
            super.setM_AttributeSetInstance_ID(n);
        }
    }

    public boolean canChangeWarehouse() {
        if (this.getQtyDelivered().signum() != 0) {
            this.log.saveError("Error", Msg.translate(this.getCtx(), "QtyDelivered") + "=" + this.getQtyDelivered());
            return false;
        }
        if (this.getQtyReserved().signum() != 0) {
            this.log.saveError("Error", Msg.translate(this.getCtx(), "QtyReserved") + "=" + this.getQtyReserved());
            return false;
        }
        return true;
    }

    @Override
    public int getAD_OrgTrx_ID() {
        int n = super.getAD_OrgTrx_ID();
        if (n == 0) {
            n = this.getParent().getAD_OrgTrx_ID();
        }
        return n;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("MDDOrderLine[").append(this.get_ID()).append(",Line=").append(this.getLine()).append(",Ordered=").append(this.getQtyOrdered()).append(",Delivered=").append(this.getQtyDelivered()).append(",Reserved=").append(this.getQtyReserved()).append("]");
        return stringBuffer.toString();
    }

    public void addDescription(String string) {
        String string2 = this.getDescription();
        if (string2 == null) {
            this.setDescription(string);
        } else {
            this.setDescription(string2 + " | " + string);
        }
    }

    public String getDescriptionText() {
        return super.getDescription();
    }

    public String getName() {
        this.getProduct();
        if (this.m_product != null) {
            return this.m_product.getName();
        }
        if (this.getC_Charge_ID() != 0) {
            MCharge mCharge = MCharge.get(this.getCtx(), this.getC_Charge_ID());
            return mCharge.getName();
        }
        return "";
    }

    @Override
    public void setC_Charge_ID(int n) {
        super.setC_Charge_ID(n);
        if (n > 0) {
            this.set_ValueNoCheck("C_UOM_ID", null);
        }
    }

    public void setQty(BigDecimal bigDecimal) {
        super.setQtyEntered(bigDecimal);
        super.setQtyOrdered(this.getQtyEntered());
    }

    @Override
    public void setQtyEntered(BigDecimal bigDecimal) {
        if (bigDecimal != null && this.getC_UOM_ID() != 0) {
            int n = MUOM.getPrecision(this.getCtx(), this.getC_UOM_ID());
            bigDecimal = bigDecimal.setScale(n, RoundingMode.HALF_UP);
        }
        super.setQtyEntered(bigDecimal);
    }

    @Override
    public void setQtyOrdered(BigDecimal bigDecimal) {
        MProduct mProduct = this.getProduct();
        if (bigDecimal != null && mProduct != null) {
            int n = mProduct.getUOMPrecision();
            bigDecimal = bigDecimal.setScale(n, RoundingMode.HALF_UP);
        }
        super.setQtyOrdered(bigDecimal);
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        int n;
        MProduct mProduct;
        int n2;
        if (bl && this.getParent().isComplete()) {
            this.log.saveError("ParentComplete", Msg.translate(this.getCtx(), "DD_OrderLine"));
            return false;
        }
        if (this.m_M_PriceList_ID == 0) {
            this.setHeaderInfo(this.getParent());
        }
        if (!bl && (this.is_ValueChanged("M_Product_ID") || this.is_ValueChanged("M_Locator_ID") || this.is_ValueChanged("M_LocatorTo_ID")) && !this.canChangeWarehouse()) {
            return false;
        }
        if (this.getC_Charge_ID() != 0 && this.getM_Product_ID() != 0) {
            this.setM_Product_ID(0);
        }
        if (this.getM_Product_ID() == 0) {
            this.setM_AttributeSetInstance_ID(0);
        }
        if (this.getC_UOM_ID() == 0 && (this.getM_Product_ID() != 0 || this.getC_Charge_ID() != 0) && (n2 = MUOM.getDefault_UOM_ID(this.getCtx())) > 0) {
            this.setC_UOM_ID(n2);
        }
        if (bl || this.is_ValueChanged("QtyEntered")) {
            this.setQtyEntered(this.getQtyEntered());
        }
        if (bl || this.is_ValueChanged("QtyOrdered")) {
            this.setQtyOrdered(this.getQtyOrdered());
        }
        if (this.m_IsSOTrx && this.getM_AttributeSetInstance_ID() != 0 && (bl || this.is_ValueChanged("M_Product_ID") || this.is_ValueChanged("M_AttributeSetInstance_ID") || this.is_ValueChanged("M_Warehouse_ID")) && (mProduct = this.getProduct()).isStocked()) {
            PO pO;
            boolean bl2;
            n = mProduct.getM_AttributeSet_ID();
            boolean bl3 = bl2 = n != 0;
            if (bl2) {
                pO = MAttributeSet.get(this.getCtx(), n);
                bl2 = ((X_M_AttributeSet)pO).isInstanceAttribute();
            }
            if (bl2) {
                pO = MLocator.get(this.getCtx(), this.getM_Locator_ID());
                MStorage[] mStorageArray = MStorage.getWarehouse(this.getCtx(), ((X_M_Locator)pO).getM_Warehouse_ID(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), n, false, null, true, this.get_TrxName());
                BigDecimal bigDecimal = Env.ZERO;
                for (int i = 0; i < mStorageArray.length; ++i) {
                    if (mStorageArray[i].getM_AttributeSetInstance_ID() != this.getM_AttributeSetInstance_ID()) continue;
                    bigDecimal = bigDecimal.add(mStorageArray[i].getQtyOnHand());
                }
                if (this.getQtyOrdered().compareTo(bigDecimal) > 0) {
                    this.log.warning("Qty - Stock=" + bigDecimal + ", Ordered=" + this.getQtyOrdered());
                    this.log.saveError("QtyInsufficient", "=" + bigDecimal);
                    return false;
                }
            }
        }
        if (Env.ZERO.compareTo(this.getFreightAmt()) != 0) {
            this.setFreightAmt(Env.ZERO);
        }
        if (this.getLine() == 0) {
            String string = "SELECT COALESCE(MAX(Line),0)+10 FROM DD_OrderLine WHERE DD_Order_ID=?";
            n = DB.getSQLValue(this.get_TrxName(), string, this.getDD_Order_ID());
            this.setLine(n);
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        if (Env.ZERO.compareTo(this.getQtyDelivered()) != 0) {
            this.log.saveError("DeleteError", Msg.translate(this.getCtx(), "QtyDelivered") + "=" + this.getQtyDelivered());
            return false;
        }
        if (Env.ZERO.compareTo(this.getQtyReserved()) != 0) {
            this.log.saveError("DeleteError", Msg.translate(this.getCtx(), "QtyReserved") + "=" + this.getQtyReserved());
            return false;
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean bl, boolean bl2) {
        if (!bl2) {
            return bl2;
        }
        return true;
    }

    @Override
    protected boolean afterDelete(boolean bl) {
        if (!bl) {
            return bl;
        }
        return true;
    }

    public BigDecimal getQtyToDeliver() {
        return this.getQtyOrdered().subtract(this.getQtyInTransit()).subtract(this.getQtyDelivered());
    }

    public BigDecimal getCalculateQtyReserved() {
        BigDecimal bigDecimal = this.getQtyOrdered().subtract(this.getQtyReserved()).subtract(this.getQtyDelivered());
        return bigDecimal;
    }

    public BigDecimal getWeight() {
        return Optional.ofNullable(this.getProduct().getWeight()).orElseGet(() -> BigDecimal.ZERO);
    }

    public BigDecimal getVolume() {
        return Optional.ofNullable(this.getProduct().getVolume()).orElseGet(() -> BigDecimal.ZERO);
    }

    public List<MMovementLine> getMovementLines() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DD_OrderLine_ID").append("=?");
        return new Query(this.getCtx(), "M_MovementLine", stringBuilder.toString(), this.get_TrxName()).setClient_ID().setOrderBy("Created").setParameters(this.getDD_OrderLine_ID()).list();
    }

    public void orderedStock() {
        MLocator mLocator = MLocator.get(this.getCtx(), this.getM_LocatorTo_ID());
        this.log.fine("Line=" + this.getLine() + " - Ordered=" + this.getQtyOrdered() + ",Reserved=" + this.getQtyReserved() + ",Delivered=" + this.getQtyDelivered());
        if (!MStorage.add(this.getCtx(), mLocator.getM_Warehouse_ID(), mLocator.getM_Locator_ID(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), this.getM_AttributeSetInstance_ID(), Env.ZERO, Env.ZERO, this.getCalculateQtyReserved(), this.get_TrxName())) {
            throw new AdempiereException("@M_Storage_ID@ @Error@ @To@ @QtyReserved@");
        }
        this.setQtyReserved(this.getQtyReserved().add(this.getCalculateQtyReserved()));
    }

    public void reserveStock() {
        MLocator mLocator = MLocator.get(this.getCtx(), this.getM_Locator_ID());
        this.log.fine("Line=" + this.getLine() + " - Ordered=" + this.getQtyOrdered() + ",Reserved=" + this.getQtyReserved() + ",Delivered=" + this.getQtyDelivered());
        if (!MStorage.add(this.getCtx(), mLocator.getM_Warehouse_ID(), mLocator.getM_Locator_ID(), this.getM_Product_ID(), this.getM_AttributeSetInstanceTo_ID(), this.getM_AttributeSetInstance_ID(), Env.ZERO, this.getCalculateQtyReserved(), Env.ZERO, this.get_TrxName())) {
            throw new AdempiereException("@M_Storage_ID@ @Error@ @To@ @QtyReserved@");
        }
        this.setQtyReserved(this.getQtyReserved().add(this.getCalculateQtyReserved()));
    }
}

