/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import io.vavr.CheckedFunction1;
import io.vavr.collection.List;
import io.vavr.collection.Stream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.stream.StreamSupport;

public class ResultSetIterable<T>
implements Iterable<T> {
    private final ResultSet resultSet;
    private final CheckedFunction1<ResultSet, T> onNext;

    public ResultSetIterable(ResultSet resultSet, CheckedFunction1<ResultSet, T> onNext) {
        this.resultSet = resultSet;
        this.onNext = onNext;
    }

    private boolean resultSetHasNext() {
        try {
            return this.resultSet.next();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<T> iterator() {
        try {
            return new Iterator<T>(){
                boolean hasNext;
                {
                    this.hasNext = ResultSetIterable.this.resultSetHasNext();
                }

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public T next() {
                    Object result = null;
                    try {
                        result = ResultSetIterable.this.onNext.apply((Object)ResultSetIterable.this.resultSet);
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                    this.hasNext = ResultSetIterable.this.resultSetHasNext();
                    return result;
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Stream<T> asJavaStream() {
        return Stream.ofAll(StreamSupport.stream(this.spliterator(), false));
    }

    public Stream<T> stream() {
        return Stream.ofAll(this.asJavaStream());
    }

    public List<T> toList() {
        return this.stream().toList();
    }

    public java.util.List<T> asJavaList() {
        return this.stream().toList().asJava();
    }
}

