/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.logging.Level;
import org.compiere.model.MColumn;
import org.compiere.model.MRefTable;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Language;

public final class DisplayType {
    public static final int String = 10;
    public static final int Integer = 11;
    public static final int Amount = 12;
    public static final int ID = 13;
    public static final int Text = 14;
    public static final int Date = 15;
    public static final int DateTime = 16;
    public static final int List = 17;
    public static final int Table = 18;
    public static final int TableDir = 19;
    public static final int YesNo = 20;
    public static final int Location = 21;
    public static final int Number = 22;
    public static final int Binary = 23;
    public static final int Time = 24;
    public static final int Account = 25;
    public static final int RowID = 26;
    public static final int Color = 27;
    public static final int Button = 28;
    public static final int Quantity = 29;
    public static final int Search = 30;
    public static final int Locator = 31;
    public static final int Image = 32;
    public static final int Assignment = 33;
    public static final int Memo = 34;
    public static final int PAttribute = 35;
    public static final int TextLong = 36;
    public static final int CostPrice = 37;
    public static final int FilePath = 38;
    public static final int FileName = 39;
    public static final int FilePathOrName = 53670;
    public static final int URL = 40;
    public static final int PrinterName = 42;
    public static final int Chart = 53370;
    private static final int MAX_DIGITS = 28;
    private static final int INTEGER_DIGITS = 10;
    private static final int MAX_FRACTION = 12;
    private static final int AMOUNT_FRACTION = 2;
    private static CLogger s_log = CLogger.getCLogger(DisplayType.class);

    public static boolean isID(int displayType) {
        return displayType == 13 || displayType == 18 || displayType == 19 || displayType == 30 || displayType == 21 || displayType == 31 || displayType == 25 || displayType == 33 || displayType == 35 || displayType == 32 || displayType == 27;
    }

    public static boolean isNumeric(int displayType) {
        return displayType == 12 || displayType == 22 || displayType == 37 || displayType == 11 || displayType == 29;
    }

    public static int getDefaultPrecision(int displayType) {
        if (displayType == 12) {
            return 2;
        }
        if (displayType == 22) {
            return 6;
        }
        if (displayType == 37 || displayType == 29) {
            return 4;
        }
        return 0;
    }

    public static boolean isText(int displayType) {
        return displayType == 10 || displayType == 14 || displayType == 36 || displayType == 34 || displayType == 38 || displayType == 39 || displayType == 53670 || displayType == 40 || displayType == 42;
    }

    public static boolean isDate(int displayType) {
        return displayType == 15 || displayType == 16 || displayType == 24;
    }

    public static boolean isLookup(int displayType) {
        return displayType == 17 || displayType == 18 || displayType == 19 || displayType == 30;
    }

    public static boolean isLOB(int displayType) {
        return displayType == 23 || displayType == 36;
    }

    public static DecimalFormat getNumberFormat(int displayType, Language language, String pattern) {
        Language myLanguage = language;
        if (myLanguage == null) {
            myLanguage = Language.getLoginLanguage();
        }
        Locale locale = myLanguage.getLocale();
        DecimalFormat format = null;
        format = locale != null ? (DecimalFormat)NumberFormat.getNumberInstance(locale) : (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        if (pattern != null && pattern.length() > 0) {
            try {
                format.applyPattern(pattern);
                return format;
            }
            catch (IllegalArgumentException e) {
                s_log.log(Level.WARNING, "Invalid number format: " + pattern);
            }
        } else if (displayType == 11) {
            format.setParseIntegerOnly(true);
            format.setMaximumIntegerDigits(10);
            format.setMaximumFractionDigits(0);
        } else if (displayType == 29) {
            format.setMaximumIntegerDigits(28);
            format.setMaximumFractionDigits(12);
        } else if (displayType == 12) {
            format.setMaximumIntegerDigits(28);
            format.setMaximumFractionDigits(12);
            format.setMinimumFractionDigits(2);
        } else if (displayType == 37) {
            format.setMaximumIntegerDigits(28);
            format.setMaximumFractionDigits(12);
            format.setMinimumFractionDigits(2);
        } else {
            format.setMaximumIntegerDigits(28);
            format.setMaximumFractionDigits(12);
            format.setMinimumFractionDigits(1);
        }
        return format;
    }

    public static DecimalFormat getNumberFormat(int displayType, Language language) {
        return DisplayType.getNumberFormat(displayType, language, null);
    }

    public static DecimalFormat getNumberFormat(int displayType) {
        return DisplayType.getNumberFormat(displayType, null);
    }

    public static SimpleDateFormat getDateFormat() {
        return DisplayType.getDateFormat(15, null);
    }

    public static SimpleDateFormat getDateFormat(Language language) {
        return DisplayType.getDateFormat(15, language);
    }

    public static SimpleDateFormat getDateFormat(int displayType) {
        return DisplayType.getDateFormat(displayType, null);
    }

    public static SimpleDateFormat getDateFormat(int displayType, Language language) {
        return DisplayType.getDateFormat(displayType, language, null);
    }

    public static SimpleDateFormat getDateFormat(int displayType, Language language, String pattern) {
        Language myLanguage = language;
        if (myLanguage == null) {
            myLanguage = Env.getLanguage(Env.getCtx());
        }
        if (pattern != null && pattern.length() > 0) {
            SimpleDateFormat format = (SimpleDateFormat)DateFormat.getInstance();
            try {
                format.applyPattern(pattern);
                return format;
            }
            catch (IllegalArgumentException e) {
                s_log.log(Level.WARNING, "Invalid date pattern: " + pattern);
            }
        }
        if (displayType == 16) {
            return myLanguage.getDateTimeFormat();
        }
        if (displayType == 24) {
            return myLanguage.getTimeFormat();
        }
        return myLanguage.getDateFormat();
    }

    public static SimpleDateFormat getDateFormat_JDBC() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    public static SimpleDateFormat getTimestampFormat_Default() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public static Class getClass(int displayType, boolean yesNoAsBoolean) {
        if (DisplayType.isText(displayType) || displayType == 17) {
            return String.class;
        }
        if (DisplayType.isID(displayType) || displayType == 11) {
            return Integer.class;
        }
        if (DisplayType.isNumeric(displayType)) {
            return BigDecimal.class;
        }
        if (DisplayType.isDate(displayType)) {
            return Timestamp.class;
        }
        if (displayType == 20) {
            return yesNoAsBoolean ? Boolean.class : String.class;
        }
        if (displayType == 28) {
            return String.class;
        }
        if (DisplayType.isLOB(displayType)) {
            return byte[].class;
        }
        return Object.class;
    }

    public static String getSQLDataType(int displayType, String columnName, int fieldLength, int referenceValueId) {
        if (columnName.equals("EntityType") || columnName.equals("AD_Language")) {
            return "VARCHAR2(" + fieldLength + ")";
        }
        if (DisplayType.isID(displayType)) {
            if (displayType == 32 && columnName.equals("BinaryData")) {
                return "BLOB";
            }
            if (referenceValueId > 0) {
                MRefTable reference = MRefTable.getById(Env.getCtx(), referenceValueId);
                if (reference != null) {
                    MColumn column = MColumn.get(Env.getCtx(), reference.getAD_Key());
                    return DisplayType.getSQLDataType(column.getAD_Reference_ID(), column.getColumnName(), column.getFieldLength(), column.getAD_Reference_Value_ID());
                }
            } else {
                if (columnName.endsWith("_ID") || columnName.endsWith("tedBy") || columnName.endsWith("_Acct")) {
                    return "NUMBER(10)";
                }
                if (fieldLength < 4) {
                    return "CHAR(" + fieldLength + ")";
                }
                return "VARCHAR2(" + fieldLength + ")";
            }
        }
        if (displayType == 11) {
            return "NUMBER(10)";
        }
        if (DisplayType.isDate(displayType)) {
            return "DATE";
        }
        if (DisplayType.isNumeric(displayType)) {
            return "NUMBER";
        }
        if (displayType == 23) {
            return "BLOB";
        }
        if (displayType == 36 || displayType == 14 && fieldLength >= 4000 || displayType == 34 && fieldLength >= 4000) {
            return "CLOB";
        }
        if (displayType == 20) {
            return "CHAR(1)";
        }
        if (displayType == 17) {
            if (fieldLength == 1) {
                return "CHAR(" + fieldLength + ")";
            }
            return "NVARCHAR2(" + fieldLength + ")";
        }
        if (displayType == 27) {
            if (columnName.endsWith("_ID")) {
                return "NUMBER(10)";
            }
            return "CHAR(" + fieldLength + ")";
        }
        if (displayType == 28) {
            if (columnName.endsWith("_ID")) {
                return "NUMBER(10)";
            }
            return "CHAR(" + fieldLength + ")";
        }
        if (!DisplayType.isText(displayType)) {
            s_log.severe("Unhandled Data Type = " + displayType);
        }
        return "NVARCHAR2(" + fieldLength + ")";
    }

    public static boolean isSameType(MColumn column, int dataType, int dataLength) {
        int columnDataType = DisplayType.getDBDataType(column.getAD_Reference_ID(), column.getColumnName(), column.getFieldLength(), column.getAD_Reference_Value_ID());
        int columnDataLength = DisplayType.getDBDataLength(column.getAD_Reference_ID(), column.getColumnName(), column.getFieldLength(), column.getAD_Reference_Value_ID());
        if (columnDataType == dataType) {
            return columnDataLength == 0 || columnDataLength == dataLength;
        }
        if (!(dataType != 12 && dataType != -9 || columnDataType != 12 && columnDataType != -9 && columnDataType != 1)) {
            return columnDataLength == 0 || columnDataLength == dataLength;
        }
        if (!(dataType != 2 && dataType != 3 || columnDataType != 2 && columnDataType != 3)) {
            return columnDataLength == 0 || columnDataLength == dataLength;
        }
        if (!(dataType != 93 && dataType != 2014 && dataType != 92 && dataType != 2013 && dataType != 91 || columnDataType != 93 && columnDataType != 2014 && columnDataType != 92 && columnDataType != 2013 && columnDataType != 91)) {
            return columnDataLength == 0 || columnDataLength == dataLength;
        }
        if (dataType == 2005 && columnDataType == 2005) {
            return true;
        }
        return dataType == 2004 && columnDataType == 2004;
    }

    public static int getDBDataLength(MColumn column) {
        if (column == null) {
            return 0;
        }
        return DisplayType.getDBDataLength(column.getAD_Reference_ID(), column.getColumnName(), column.getFieldLength(), column.getAD_Reference_Value_ID());
    }

    public static int getDBDataLength(int displayType, String columnName, int fieldLength, int referenceValueId) {
        if (columnName.equals("EntityType") || columnName.equals("AD_Language")) {
            return fieldLength;
        }
        if (DisplayType.isID(displayType)) {
            if (displayType == 32 && columnName.equals("BinaryData")) {
                return 0;
            }
            if (referenceValueId > 0) {
                MRefTable reference = MRefTable.getById(Env.getCtx(), referenceValueId);
                if (reference != null) {
                    MColumn column = MColumn.get(Env.getCtx(), reference.getAD_Key());
                    return DisplayType.getDBDataLength(column.getAD_Reference_ID(), column.getColumnName(), column.getFieldLength(), column.getAD_Reference_Value_ID());
                }
            } else {
                if (columnName.endsWith("_ID") || columnName.endsWith("tedBy") || columnName.endsWith("_Acct")) {
                    return 10;
                }
                if (fieldLength < 4) {
                    return fieldLength;
                }
            }
            return fieldLength;
        }
        if (displayType == 11) {
            if (fieldLength <= 0 || fieldLength > 10) {
                return 10;
            }
            return fieldLength;
        }
        if (DisplayType.isDate(displayType)) {
            if (fieldLength <= 0 || fieldLength > 7) {
                return 7;
            }
            return fieldLength;
        }
        if (DisplayType.isNumeric(displayType)) {
            if (fieldLength <= 0 || fieldLength > 22) {
                return 22;
            }
            return fieldLength;
        }
        if (displayType == 23) {
            return 0;
        }
        if (displayType == 36 || displayType == 14 && fieldLength >= 4000) {
            return fieldLength;
        }
        if (displayType == 20) {
            return 1;
        }
        if (displayType == 17) {
            return fieldLength;
        }
        if (displayType == 28) {
            if (columnName.endsWith("_ID")) {
                return 10;
            }
            return fieldLength;
        }
        if (!DisplayType.isText(displayType)) {
            s_log.severe("Unhandled Data Type = " + displayType);
        }
        return fieldLength;
    }

    private static int getDBDataType(int displayType, String columnName, int fieldLength, int referenceValueId) {
        if (columnName.equals("EntityType") || columnName.equals("AD_Language")) {
            return 12;
        }
        if (DisplayType.isID(displayType)) {
            if (displayType == 32 && columnName.equals("BinaryData")) {
                return 2004;
            }
            if (referenceValueId > 0) {
                MRefTable reference = MRefTable.getById(Env.getCtx(), referenceValueId);
                if (reference != null) {
                    MColumn column = MColumn.get(Env.getCtx(), reference.getAD_Key());
                    return DisplayType.getDBDataType(column.getAD_Reference_ID(), column.getColumnName(), column.getFieldLength(), column.getAD_Reference_Value_ID());
                }
            } else {
                if (columnName.endsWith("_ID") || columnName.endsWith("tedBy") || columnName.endsWith("_Acct")) {
                    return 3;
                }
                if (fieldLength < 4) {
                    return 1;
                }
                return 12;
            }
        }
        if (displayType == 11) {
            return 3;
        }
        if (DisplayType.isDate(displayType)) {
            return 93;
        }
        if (DisplayType.isNumeric(displayType)) {
            return 3;
        }
        if (displayType == 23) {
            return 2004;
        }
        if (displayType == 36 || displayType == 14 && fieldLength >= 4000) {
            return 2005;
        }
        if (displayType == 20) {
            return 1;
        }
        if (displayType == 17) {
            if (fieldLength == 1) {
                return 1;
            }
            return -9;
        }
        if (displayType == 27) {
            if (columnName.endsWith("_ID")) {
                return 3;
            }
            return 1;
        }
        if (displayType == 28) {
            if (columnName.endsWith("_ID")) {
                return 3;
            }
            return 1;
        }
        if (!DisplayType.isText(displayType)) {
            s_log.severe("Unhandled Data Type = " + displayType);
        }
        return -9;
    }

    public static String getDescription(int displayType) {
        if (displayType == 10) {
            return "String";
        }
        if (displayType == 11) {
            return "Integer";
        }
        if (displayType == 12) {
            return "Amount";
        }
        if (displayType == 13) {
            return "ID";
        }
        if (displayType == 14) {
            return "Text";
        }
        if (displayType == 15) {
            return "Date";
        }
        if (displayType == 16) {
            return "DateTime";
        }
        if (displayType == 17) {
            return "List";
        }
        if (displayType == 18) {
            return "Table";
        }
        if (displayType == 19) {
            return "TableDir";
        }
        if (displayType == 20) {
            return "YesNo";
        }
        if (displayType == 21) {
            return "Location";
        }
        if (displayType == 22) {
            return "Number";
        }
        if (displayType == 23) {
            return "Binary";
        }
        if (displayType == 24) {
            return "Time";
        }
        if (displayType == 25) {
            return "Account";
        }
        if (displayType == 26) {
            return "RowID";
        }
        if (displayType == 27) {
            return "Color";
        }
        if (displayType == 28) {
            return "Button";
        }
        if (displayType == 29) {
            return "Quantity";
        }
        if (displayType == 30) {
            return "Search";
        }
        if (displayType == 31) {
            return "Locator";
        }
        if (displayType == 32) {
            return "Image";
        }
        if (displayType == 33) {
            return "Assignment";
        }
        if (displayType == 34) {
            return "Memo";
        }
        if (displayType == 35) {
            return "PAttribute";
        }
        if (displayType == 36) {
            return "TextLong";
        }
        if (displayType == 37) {
            return "CostPrice";
        }
        if (displayType == 38) {
            return "FilePath";
        }
        if (displayType == 39) {
            return "FileName";
        }
        if (displayType == 40) {
            return "URL";
        }
        if (displayType == 42) {
            return "PrinterName";
        }
        return "UNKNOWN DisplayType=" + displayType;
    }
}

