/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.util.KeyNamePair;

public class DependentRecordAccess {
    private Properties context;
    private Map<String, List<KeyNamePair>> referencedColumnsMap = new HashMap<String, List<KeyNamePair>>();

    public DependentRecordAccess(Properties context) {
        this.context = context;
    }

    private void loadReferencedTables(String tableName) {
        if (this.referencedColumnsMap.containsKey(tableName)) {
            return;
        }
        ArrayList referencedColumns = new ArrayList();
        String whereClause = "AD_Column.ColumnSQL IS NULL AND EXISTS(SELECT 1 FROM AD_Column c \t\t\t\t\t\tLEFT JOIN AD_Ref_Table rt ON(rt.AD_Reference_ID = c.AD_Reference_Value_ID) \t\t\t\t\t\tLEFT JOIN AD_Column rc ON(rc.AD_Column_ID = rt.AD_Key) \t\t\t\t\t\tLEFT JOIN AD_Table rrt ON(rrt.TableName || '_ID' = c.ColumnName) \t\t\t\t\t\tLEFT JOIN AD_Column dtc ON(dtc.AD_Table_ID = COALESCE(rrt.AD_Table_ID, rc.AD_Table_ID) AND dtc.ColumnSQL IS NULL) \t\t\t\t\t\tLEFT JOIN AD_Ref_Table rrrt ON(rrrt.AD_Reference_ID = dtc.AD_Reference_Value_ID) \t\t\t\t\t\tLEFT JOIN AD_Column rrc ON(rrc.AD_Column_ID = rrrt.AD_Key) \t\t\t\t\t\tLEFT JOIN AD_Table errt ON(errt.TableName || '_ID' = dtc.ColumnName) \t\t\t\t\t\tWHERE c.AD_Column_ID = AD_Column.AD_Column_ID \t\t\t\t\t\tAND (errt.TableName = ? OR errt.AD_Table_ID = ?)) AND EXISTS(SELECT 1 FROM AD_Table t \t\t\t\t\t\tWHERE t.AD_Table_ID = AD_Column.AD_Table_ID\t\t\t\t\t\tAND t.TableName || '_ID' <> AD_Column.ColumnName\t\t\t\t\t\tAND ? || '_ID' <> AD_Column.ColumnName)";
        new Query(this.context, "AD_Column", whereClause, null).setParameters(tableName, MTable.getTable_ID(tableName), tableName).getIDsAsList().forEach(columnId -> Optional.ofNullable(MColumn.get(this.context, columnId)).ifPresent(column -> referencedColumns.add(new KeyNamePair(column.getAD_Column_ID(), MTable.getTableName(this.context, column.getAD_Table_ID())))));
        this.referencedColumnsMap.put(tableName, referencedColumns);
    }

    public boolean isMatchedForTable(String accessTableName, String tableName) {
        this.loadReferencedTables(accessTableName);
        if (!this.referencedColumnsMap.containsKey(accessTableName)) {
            return false;
        }
        return this.referencedColumnsMap.get(accessTableName).stream().filter(column -> column.getName().equals(tableName)).findFirst().isPresent();
    }

    public List<Integer> getColumnIds(String accessTableName, String tableName) {
        this.loadReferencedTables(accessTableName);
        if (!this.referencedColumnsMap.containsKey(accessTableName)) {
            return null;
        }
        return this.referencedColumnsMap.get(accessTableName).stream().filter(column -> column.getName().equals(tableName)).map(column -> column.getKey()).collect(Collectors.toList());
    }
}

