/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import io.vavr.API;
import io.vavr.Function4;
import io.vavr.control.Try;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.sql.RowSet;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.adempiere.exceptions.DBException;
import org.adempiere.util.Check;
import org.compiere.Adempiere;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.CConnection;
import org.compiere.db.Database;
import org.compiere.db.ProxyFactory;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MLanguage;
import org.compiere.model.MRole;
import org.compiere.model.MSequence;
import org.compiere.model.MSysConfig;
import org.compiere.model.MSystem;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.POResultSet;
import org.compiere.process.SequenceCheck;
import org.compiere.util.CLogErrorBuffer;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CStatementVO;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.ResultSetRunnable;
import org.compiere.util.Trx;
import org.compiere.util.ValueNamePair;

public final class DB {
    private static CConnection s_cc = null;
    private static CLogger log = CLogger.getCLogger(DB.class);
    private static Object s_ccLock = new Object();
    public static final String SQLSTATEMENT_SEPARATOR = "; ";
    private static final char QUOTE = '\'';
    public static final String SQL_EmptyList = "(-1)";
    public static Function4<String, String, io.vavr.collection.List<Object>, ResultSetRunnable<ResultSet>, Try<Void>> runResultSetFunction = (Function4 & Serializable)(trxName, sql, parameters, callback) -> {
        AtomicReference preparedStatementReference = new AtomicReference();
        AtomicReference resultSetReference = new AtomicReference();
        return Try.run(() -> {
            CPreparedStatement prepareStatement = DB.prepareStatement(sql, trxName);
            if (API.Option((Object)parameters).isDefined()) {
                DB.setParameters((PreparedStatement)prepareStatement, parameters.asJava());
            }
            preparedStatementReference.set(prepareStatement);
            ResultSet resultSet = ((CPreparedStatement)preparedStatementReference.get()).executeQuery();
            callback.run(resultSet);
            resultSetReference.set(resultSet);
        }).andFinally(() -> DB.close((ResultSet)resultSetReference.get(), (Statement)preparedStatementReference.get()));
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean afterMigration(Properties ctx) {
        MSystem system = MSystem.get(ctx);
        if (!system.isJustMigrated()) {
            return false;
        }
        log.info("Role");
        String sql = "SELECT * FROM AD_Role";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MRole role = new MRole(ctx, rs, null);
                role.updateAccessRecords();
            }
        }
        catch (Exception e) {
            try {
                log.log(Level.SEVERE, "(1)", e);
            }
            catch (Throwable throwable) {
                DB.close(rs);
                DB.close(pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs);
            DB.close(pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs);
        DB.close(pstmt);
        rs = null;
        pstmt = null;
        try {
            Class<?> clazz = Class.forName("org.compiere.MigrateData");
            clazz.newInstance();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Data", e);
        }
        log.info("Language");
        MLanguage.maintain(ctx);
        log.info("Sequence");
        SequenceCheck.validate(ctx);
        log.info("Costing");
        MAcctSchema[] ass = MAcctSchema.getClientAcctSchema(ctx, 0);
        for (int i2 = 0; i2 < ass.length; ++i2) {
            ass[i2].checkCosting();
            ass[i2].saveEx();
        }
        system.setIsJustMigrated(false);
        return system.save();
    }

    public static void updateMail() {
        Object envName = Ini.getAdempiereHome();
        if (envName == null) {
            return;
        }
        File envFile = new File((String)(envName = (String)envName + File.separator + "AdempiereEnv.properties"));
        if (!envFile.exists()) {
            return;
        }
        Properties env = new Properties();
        try {
            FileInputStream in = new FileInputStream(envFile);
            env.load(in);
            in.close();
        }
        catch (Exception e) {
            return;
        }
        String updated = env.getProperty("ADEMPIERE_MAIL_UPDATED");
        if (updated != null && updated.equals("Y")) {
            return;
        }
        String server = env.getProperty("ADEMPIERE_MAIL_SERVER");
        if (server == null || server.length() == 0) {
            return;
        }
        String adminEMail = env.getProperty("ADEMPIERE_ADMIN_EMAIL");
        if (adminEMail == null || adminEMail.length() == 0) {
            return;
        }
        String mailUser = env.getProperty("ADEMPIERE_MAIL_USER");
        if (mailUser == null || mailUser.length() == 0) {
            return;
        }
        String mailPassword = env.getProperty("ADEMPIERE_MAIL_PASSWORD");
        StringBuffer sql = new StringBuffer("UPDATE AD_Client SET").append(" SMTPHost=").append(DB.TO_STRING(server)).append(", RequestEMail=").append(DB.TO_STRING(adminEMail)).append(", RequestUser=").append(DB.TO_STRING(mailUser)).append(", RequestUserPW=").append(DB.TO_STRING(mailPassword)).append(", IsSMTPAuthorization='Y' WHERE AD_Client_ID=0");
        int no = DB.executeUpdate(sql.toString(), null);
        log.fine("Client #" + no);
        sql = new StringBuffer("UPDATE AD_User SET ").append(" EMail=").append(DB.TO_STRING(adminEMail)).append(", EMailUser=").append(DB.TO_STRING(mailUser)).append(", EMailUserPW=").append(DB.TO_STRING(mailPassword)).append(" WHERE AD_User_ID IN (0,100)");
        no = DB.executeUpdate(sql.toString(), null);
        log.fine("User #" + no);
        try {
            env.setProperty("ADEMPIERE_MAIL_UPDATED", "Y");
            FileOutputStream out = new FileOutputStream(envFile);
            env.store(out, "");
            out.flush();
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDBTarget(CConnection cc) {
        if (cc == null) {
            throw new IllegalArgumentException("Connection is NULL");
        }
        if (s_cc != null && s_cc.equals(cc)) {
            return;
        }
        DB.closeTarget();
        Object object = s_ccLock;
        synchronized (object) {
            s_cc = cc;
        }
        s_cc.setDataSource();
        log.config(s_cc + " - DS=" + s_cc.isDataSource());
    }

    public static boolean connect() {
        boolean success = false;
        try {
            Connection connID;
            Connection connRO;
            Connection connRW = DB.getConnectionRW();
            if (connRW != null) {
                s_cc.readInfo(connRW);
                connRW.close();
            }
            if ((connRO = DB.getConnectionRO()) != null) {
                connRO.close();
            }
            if ((connID = DB.getConnectionID()) != null) {
                connID.close();
            }
            success = connRW != null && connRO != null && connID != null;
        }
        catch (Exception e) {
            System.err.println("Could not connect to DB - " + e.getLocalizedMessage());
            e.printStackTrace();
            success = false;
        }
        return success;
    }

    public static boolean isConnected() {
        return DB.isConnected(true);
    }

    public static boolean isConnected(boolean createNew) {
        if (s_cc == null) {
            return false;
        }
        boolean success = false;
        CLogErrorBuffer eb = CLogErrorBuffer.get(false);
        if (eb != null && eb.isIssueError()) {
            eb.setIssueError(false);
        } else {
            eb = null;
        }
        try {
            Connection conn = DB.getConnectionRW(createNew);
            if (conn != null) {
                conn.close();
            }
            success = conn != null;
        }
        catch (Exception e) {
            success = false;
        }
        if (eb != null) {
            eb.setIssueError(true);
        }
        return success;
    }

    public static Connection getConnectionRW() {
        return DB.getConnectionRW(true);
    }

    public static Connection getConnectionRW(boolean createNew) {
        return DB.createConnection(true, false, 2);
    }

    public static Connection getConnectionID() {
        return DB.createConnection(false, false, 2);
    }

    public static Connection getConnectionRO() {
        return DB.createConnection(true, true, 2);
    }

    public static Connection createConnection(boolean autoCommit, int trxLevel) {
        Connection conn = s_cc.getConnection(autoCommit, trxLevel);
        if (CLogMgt.isLevelFinest()) {
            // empty if block
        }
        try {
            if (conn != null && conn.getAutoCommit() != autoCommit) {
                throw new IllegalStateException("Failed to set the requested auto commit mode on connection. [autoCommit=" + autoCommit + "]");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return conn;
    }

    public static Connection createConnection(boolean autoCommit, boolean readOnly, int trxLevel) {
        Connection conn = s_cc.getConnection(autoCommit, trxLevel);
        if (conn == null) {
            throw new IllegalStateException("DB.getConnectionRO - @NoDBConnection@");
        }
        try {
            if (conn.getAutoCommit() != autoCommit) {
                throw new IllegalStateException("Failed to set the requested auto commit mode on connection. [autocommit=" + autoCommit + "]");
            }
        }
        catch (SQLException exception) {
            log.severe(exception.getMessage());
        }
        return conn;
    }

    public static AdempiereDatabase getDatabase() {
        if (s_cc != null) {
            return s_cc.getDatabase();
        }
        log.severe("No Database Connection");
        return null;
    }

    public static AdempiereDatabase getDatabase(String URL2) {
        return Database.getDatabaseFromURL(URL2);
    }

    public static boolean isOracle() {
        if (s_cc != null) {
            return s_cc.isOracle();
        }
        log.severe("No Database Connection");
        return false;
    }

    public static boolean isPostgreSQL() {
        if (s_cc != null) {
            return s_cc.isPostgreSQL();
        }
        log.severe("No Database");
        return false;
    }

    public static boolean isMySQL() {
        if (s_cc != null) {
            return s_cc.isMySQL();
        }
        log.severe("No Database Connection");
        return false;
    }

    public static boolean isMariaDB() {
        if (s_cc != null) {
            return s_cc.isMariaDB();
        }
        log.severe("No Database Connection");
        return false;
    }

    public static String getDatabaseInfo() {
        if (s_cc != null) {
            return s_cc.getDBInfo();
        }
        return "No Database";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDatabaseOK(Properties ctx) {
        DB.validateSupportedUUIDFromDB();
        String version = "?";
        String sql = "SELECT Version FROM AD_System";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                version = rs.getString(1);
            }
        }
        catch (SQLException e) {
            boolean bl;
            try {
                log.log(Level.SEVERE, "Problem with AD_System Table - Run system.sql script - " + e.toString());
                bl = false;
            }
            catch (Throwable throwable) {
                DB.close(rs);
                DB.close(pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs);
            DB.close(pstmt);
            rs = null;
            pstmt = null;
            return bl;
        }
        DB.close(rs);
        DB.close(pstmt);
        rs = null;
        pstmt = null;
        log.info("DB_Version=" + version);
        if (Adempiere.DB_VERSION.equals(version)) {
            return true;
        }
        String AD_Message = "DatabaseVersionError";
        String title = Adempiere.getName() + " " + Msg.getMsg(ctx, AD_Message, true);
        String msg = Msg.getMsg(ctx, AD_Message);
        msg = MessageFormat.format(msg, Adempiere.DB_VERSION, version);
        Object[] options = new Object[]{"Migrate"};
        JOptionPane.showOptionDialog(null, msg, title, -1, 0, UIManager.getIcon("OptionPane.errorIcon"), options, options[0]);
        JOptionPane.showMessageDialog(null, "Start RUN_Migrate (in utils)\nSee: http://wiki.adempiere.net/maintain", title, 1);
        Env.exitEnv(1);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBuildOK(Properties ctx) {
        String buildClient = Adempiere.getImplementationVersion();
        String buildDatabase = "";
        boolean failOnBuild = false;
        String sql = "SELECT LastBuildInfo, IsFailOnBuildDiffer FROM AD_System";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                buildDatabase = rs.getString(1);
                failOnBuild = rs.getString(2).equals("Y");
            }
        }
        catch (SQLException e) {
            boolean bl;
            try {
                log.log(Level.SEVERE, "Problem with AD_System Table - Run system.sql script - " + e.toString());
                bl = false;
            }
            catch (Throwable throwable) {
                DB.close(rs);
                DB.close(pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs);
            DB.close(pstmt);
            rs = null;
            pstmt = null;
            return bl;
        }
        DB.close(rs);
        DB.close(pstmt);
        rs = null;
        pstmt = null;
        log.info("Build DB=" + buildDatabase);
        log.info("Build Cl=" + buildClient);
        if (buildClient.equals(buildDatabase)) {
            return true;
        }
        String AD_Message = "BuildVersionError";
        String title = Adempiere.getName() + " " + Msg.getMsg(ctx, AD_Message, true);
        String msg = Msg.getMsg(ctx, AD_Message);
        msg = MessageFormat.format(msg, buildClient, buildDatabase);
        if (!failOnBuild) {
            log.warning(msg);
            return true;
        }
        JOptionPane.showMessageDialog(null, msg, title, 0);
        Env.exitEnv(1);
        return false;
    }

    public static void closeTarget() {
        boolean closed = false;
        if (s_cc != null) {
            closed = true;
            s_cc.setDataSource(null);
        }
        s_cc = null;
        if (closed) {
            log.fine("closed");
        }
    }

    public static CallableStatement prepareCall(String sql) {
        return DB.prepareCall(sql, 1008, null);
    }

    public static CallableStatement prepareCall(String SQL, int resultSetConcurrency, String trxName) {
        if (SQL == null || SQL.length() == 0) {
            throw new IllegalArgumentException("Required parameter missing - " + SQL);
        }
        return ProxyFactory.newCCallableStatement(1003, resultSetConcurrency, SQL, trxName);
    }

    public static CPreparedStatement prepareStatement(String sql) {
        int concurrency = 1007;
        String upper = sql.toUpperCase();
        if (upper.startsWith("UPDATE ") || upper.startsWith("DELETE ")) {
            concurrency = 1008;
        }
        return DB.prepareStatement(sql, 1003, concurrency, null);
    }

    public static CPreparedStatement prepareStatement(String sql, String trxName) {
        int concurrency = 1007;
        String upper = sql.toUpperCase();
        if (upper.startsWith("UPDATE ") || upper.startsWith("DELETE ")) {
            concurrency = 1008;
        }
        return DB.prepareStatement(sql, 1003, concurrency, trxName);
    }

    public static CPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) {
        return DB.prepareStatement(sql, resultSetType, resultSetConcurrency, null);
    }

    public static CPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, String trxName) {
        if (sql == null || sql.length() == 0) {
            throw new IllegalArgumentException("No SQL");
        }
        return ProxyFactory.newCPreparedStatement(resultSetType, resultSetConcurrency, sql, trxName);
    }

    public static Statement createStatement() {
        return DB.createStatement(1003, 1007, null);
    }

    public static Statement createStatement(int resultSetType, int resultSetConcurrency, String trxName) {
        return ProxyFactory.newCStatement(resultSetType, resultSetConcurrency, trxName);
    }

    public static void setParameters(PreparedStatement stmt, Object[] params) throws SQLException {
        if (params == null || params.length == 0) {
            return;
        }
        for (int i2 = 0; i2 < params.length; ++i2) {
            DB.setParameter(stmt, i2 + 1, params[i2]);
        }
    }

    public static void setParameters(PreparedStatement stmt, List<?> params) throws SQLException {
        if (params == null || params.size() == 0) {
            return;
        }
        for (int i2 = 0; i2 < params.size(); ++i2) {
            DB.setParameter(stmt, i2 + 1, params.get(i2));
        }
    }

    public static void setParameter(PreparedStatement pstmt, int index, Object param) throws SQLException {
        if (param == null) {
            pstmt.setObject(index, null);
        } else if (param instanceof String) {
            pstmt.setString(index, (String)param);
        } else if (param instanceof Integer) {
            pstmt.setInt(index, (Integer)param);
        } else if (param instanceof BigDecimal) {
            pstmt.setBigDecimal(index, (BigDecimal)param);
        } else if (param instanceof Timestamp) {
            pstmt.setTimestamp(index, (Timestamp)param);
        } else if (param instanceof Boolean) {
            pstmt.setString(index, (Boolean)param != false ? "Y" : "N");
        } else {
            throw new DBException("Unknown parameter type " + index + " - " + param);
        }
    }

    public static int executeUpdate(String sql) {
        return DB.executeUpdate(sql, null, false, null);
    }

    public static int executeUpdate(String sql, String trxName) {
        return DB.executeUpdate(sql, trxName, 0);
    }

    public static int executeUpdate(String sql, String trxName, int timeOut) {
        return DB.executeUpdate(sql, null, false, trxName, timeOut);
    }

    public static int executeUpdate(String sql, boolean ignoreError) {
        return DB.executeUpdate(sql, null, ignoreError, null);
    }

    public static int executeUpdate(String sql, boolean ignoreError, String trxName) {
        return DB.executeUpdate(sql, ignoreError, trxName, 0);
    }

    public static int executeUpdate(String sql, boolean ignoreError, String trxName, int timeOut) {
        return DB.executeUpdate(sql, null, ignoreError, trxName, timeOut);
    }

    public static int executeUpdate(String sql, int param, String trxName) {
        return DB.executeUpdate(sql, param, trxName, 0);
    }

    public static int executeUpdate(String sql, int param, String trxName, int timeOut) {
        return DB.executeUpdate(sql, new Object[]{param}, false, trxName, timeOut);
    }

    public static int executeUpdate(String sql, int param, boolean ignoreError, String trxName) {
        return DB.executeUpdate(sql, param, ignoreError, trxName, 0);
    }

    public static int executeUpdate(String sql, int param, boolean ignoreError, String trxName, int timeOut) {
        return DB.executeUpdate(sql, new Object[]{param}, ignoreError, trxName, timeOut);
    }

    public static int executeUpdate(String sql, Object[] params, boolean ignoreError, String trxName) {
        return DB.executeUpdate(sql, params, ignoreError, trxName, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(String sql, Object[] params, boolean ignoreError, String trxName, int timeOut) {
        CPreparedStatement cs;
        int no;
        block7: {
            if (sql == null || sql.length() == 0) {
                throw new IllegalArgumentException("Required parameter missing - " + sql);
            }
            DB.verifyTrx(trxName, sql);
            no = -1;
            cs = null;
            try {
                cs = ProxyFactory.newCPreparedStatement(1003, 1008, sql, trxName);
                DB.setParameters((PreparedStatement)cs, params);
                if (timeOut > 0) {
                    cs.setQueryTimeout(timeOut);
                }
                no = cs.executeUpdate();
                if (trxName != null) break block7;
                cs.commit();
            }
            catch (Exception e) {
                block8: {
                    try {
                        e = DB.getSQLException(e);
                        if (ignoreError) {
                            log.log(Level.SEVERE, cs.getSql() + " [" + trxName + "] - " + e.getMessage());
                            break block8;
                        }
                        log.log(Level.SEVERE, cs.getSql() + " [" + trxName + "]", e);
                        log.saveError("DBExecuteError", e);
                    }
                    catch (Throwable throwable) {
                        DB.close(cs);
                        cs = null;
                        throw throwable;
                    }
                }
                DB.close(cs);
                cs = null;
            }
        }
        DB.close(cs);
        cs = null;
        return no;
    }

    public static int executeUpdateEx(String sql, Object[] params, String trxName) throws DBException {
        return DB.executeUpdateEx(sql, params, trxName, 0);
    }

    public static int executeUpdateEx(String sql, Object[] params, String trxName, int timeOut) throws DBException {
        if (sql == null || sql.length() == 0) {
            throw new IllegalArgumentException("Required parameter missing - " + sql);
        }
        DB.verifyTrx(trxName, sql);
        int no = -1;
        CPreparedStatement cs = null;
        try {
            cs = ProxyFactory.newCPreparedStatement(1003, 1008, sql, trxName);
            DB.setParameters((PreparedStatement)cs, params);
            if (timeOut > 0) {
                cs.setQueryTimeout(timeOut);
            }
            no = cs.executeUpdate();
            if (trxName == null) {
                cs.commit();
            }
        }
        catch (Exception e) {
            try {
                throw new DBException(e);
            }
            catch (Throwable throwable) {
                DB.close(cs);
                cs = null;
                throw throwable;
            }
        }
        DB.close(cs);
        cs = null;
        return no;
    }

    public static int executeUpdateMultiple(String sql, boolean ignoreError, String trxName) {
        if (sql == null || sql.length() == 0) {
            throw new IllegalArgumentException("Required parameter missing - " + sql);
        }
        int index = sql.indexOf(SQLSTATEMENT_SEPARATOR);
        if (index == -1) {
            return DB.executeUpdate(sql, null, ignoreError, trxName);
        }
        int no = 0;
        String[] statements = sql.split(SQLSTATEMENT_SEPARATOR);
        for (int i2 = 0; i2 < statements.length; ++i2) {
            log.fine(statements[i2]);
            no += DB.executeUpdate(statements[i2], null, ignoreError, trxName);
        }
        return no;
    }

    public static int executeUpdateMultipleEx(String sql, String trxName) throws DBException {
        if (sql == null || sql.length() == 0) {
            throw new IllegalArgumentException("Required parameter missing - " + sql);
        }
        int index = sql.indexOf(SQLSTATEMENT_SEPARATOR);
        if (index == -1) {
            return DB.executeUpdateEx(sql, null, trxName);
        }
        int no = 0;
        String[] statements = sql.split(SQLSTATEMENT_SEPARATOR);
        for (int i2 = 0; i2 < statements.length; ++i2) {
            log.fine(statements[i2]);
            no += DB.executeUpdateEx(statements[i2], null, trxName);
        }
        return no;
    }

    public static int executeUpdateEx(String sql, String trxName) throws DBException {
        return DB.executeUpdateEx(sql, trxName, 0);
    }

    public static int executeUpdateEx(String sql, String trxName, int timeOut) throws DBException {
        return DB.executeUpdateEx(sql, null, trxName, timeOut);
    }

    public static boolean commit(boolean throwException, String trxName) throws SQLException, IllegalStateException {
        if (trxName == null) {
            return true;
        }
        try {
            Trx trx = Trx.get(trxName, false);
            if (trx != null) {
                return trx.commit(true);
            }
            if (throwException) {
                throw new IllegalStateException("Could not load transation with identifier: " + trxName);
            }
            return false;
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "[" + trxName + "]", e);
            if (throwException) {
                throw e;
            }
            return false;
        }
    }

    public static boolean rollback(boolean throwException, String trxName) throws SQLException {
        try {
            Trx trx;
            Connection conn = null;
            Trx trx2 = trx = trxName == null ? null : Trx.get(trxName, true);
            if (trx != null) {
                return trx.rollback(true);
            }
            conn = DB.getConnectionRW();
            if (conn != null && !conn.getAutoCommit()) {
                conn.rollback();
            }
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "[" + trxName + "]", e);
            if (throwException) {
                throw e;
            }
            return false;
        }
        return true;
    }

    public static RowSet getRowSet(String sql) {
        CStatementVO info = DB.isOracle() || DB.isPostgreSQL() ? new CStatementVO(1004, 1007, DB.getDatabase().convertStatement(sql)) : new CStatementVO(1004, 1007, sql);
        CPreparedStatement stmt = ProxyFactory.newCPreparedStatement(info);
        RowSet retValue = stmt.getRowSet();
        DB.close(stmt);
        return retValue;
    }

    public static int getSQLValueEx(String trxName, String sql, Object ... params) throws DBException {
        ResultSet rs;
        CPreparedStatement pstmt;
        int retValue;
        block5: {
            retValue = -1;
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, trxName);
                DB.setParameters((PreparedStatement)pstmt, params);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    retValue = rs.getInt(1);
                    break block5;
                }
                log.fine("No Value " + sql);
            }
            catch (SQLException e) {
                try {
                    throw new DBException(e, sql);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return retValue;
    }

    public static int getSQLValueEx(String trxName, String sql, List<Object> params) {
        return DB.getSQLValueEx(trxName, sql, params.toArray(new Object[params.size()]));
    }

    public static int getSQLValue(String trxName, String sql, Object ... params) {
        int retValue = -1;
        try {
            retValue = DB.getSQLValueEx(trxName, sql, params);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, DB.getSQLException(e));
        }
        return retValue;
    }

    public static int getSQLValue(String trxName, String sql, List<Object> params) {
        return DB.getSQLValue(trxName, sql, params.toArray(new Object[params.size()]));
    }

    public static String getSQLValueStringEx(String trxName, String sql, Object ... params) {
        ResultSet rs;
        CPreparedStatement pstmt;
        String retValue;
        block5: {
            retValue = null;
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, trxName);
                DB.setParameters((PreparedStatement)pstmt, params);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    retValue = rs.getString(1);
                    break block5;
                }
                log.fine("No Value " + sql);
            }
            catch (SQLException e) {
                try {
                    throw new DBException(e, sql);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return retValue;
    }

    public static String getSQLValueStringEx(String trxName, String sql, List<Object> params) {
        return DB.getSQLValueStringEx(trxName, sql, params.toArray(new Object[params.size()]));
    }

    public static String getSQLValueString(String trxName, String sql, Object ... params) {
        String retValue = null;
        try {
            retValue = DB.getSQLValueStringEx(trxName, sql, params);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, DB.getSQLException(e));
        }
        return retValue;
    }

    public static String getSQLValueString(String trxName, String sql, List<Object> params) {
        return DB.getSQLValueString(trxName, sql, params.toArray(new Object[params.size()]));
    }

    public static void validateSupportedUUIDFromDB() {
        String testUUID = DB.getUUID(null, true);
        s_cc.setIsSupportedUUIDFromDB(testUUID != null);
    }

    private static String getUUID(String trxName, boolean onlyFromBD) {
        String uuid = null;
        uuid = s_cc.isSupportedUUIDFromDB() || onlyFromBD ? (DB.isOracle() ? DB.getSQLValueString(trxName, "SELECT getUUID() FROM DUAL", new Object[0]) : DB.getSQLValueString(trxName, "SELECT getUUID()", new Object[0])) : UUID.randomUUID().toString();
        return uuid;
    }

    public static String getUUID(String trxName) {
        return DB.getUUID(trxName, false);
    }

    public static boolean isSupportedUUIDFromDB() {
        return s_cc.isSupportedUUIDFromDB();
    }

    public static BigDecimal getSQLValueBDEx(String trxName, String sql, Object ... params) throws DBException {
        ResultSet rs;
        CPreparedStatement pstmt;
        BigDecimal retValue;
        block5: {
            retValue = null;
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, trxName);
                DB.setParameters((PreparedStatement)pstmt, params);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    retValue = rs.getBigDecimal(1);
                    break block5;
                }
                log.fine("No Value " + sql);
            }
            catch (SQLException e) {
                try {
                    throw new DBException(e, sql);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return retValue;
    }

    public static BigDecimal getSQLValueBDEx(String trxName, String sql, List<Object> params) throws DBException {
        return DB.getSQLValueBDEx(trxName, sql, params.toArray(new Object[params.size()]));
    }

    public static BigDecimal getSQLValueBD(String trxName, String sql, Object ... params) {
        try {
            return DB.getSQLValueBDEx(trxName, sql, params);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, DB.getSQLException(e));
            return null;
        }
    }

    public static BigDecimal getSQLValueBD(String trxName, String sql, List<Object> params) {
        return DB.getSQLValueBD(trxName, sql, params.toArray(new Object[params.size()]));
    }

    public static Timestamp getSQLValueTSEx(String trxName, String sql, Object ... params) {
        ResultSet rs;
        CPreparedStatement pstmt;
        Timestamp retValue;
        block5: {
            retValue = null;
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, trxName);
                DB.setParameters((PreparedStatement)pstmt, params);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    retValue = rs.getTimestamp(1);
                    break block5;
                }
                log.fine("No Value " + sql);
            }
            catch (SQLException e) {
                try {
                    throw new DBException(e, sql);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return retValue;
    }

    public static Timestamp getSQLValueTSEx(String trxName, String sql, List<Object> params) throws DBException {
        return DB.getSQLValueTSEx(trxName, sql, params.toArray(new Object[params.size()]));
    }

    public static Timestamp getSQLValueTS(String trxName, String sql, Object ... params) {
        try {
            return DB.getSQLValueTSEx(trxName, sql, params);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, DB.getSQLException(e));
            return null;
        }
    }

    public static Timestamp getSQLValueTS(String trxName, String sql, List<Object> params) {
        Object[] arr = new Object[params.size()];
        params.toArray(arr);
        return DB.getSQLValueTS(trxName, sql, arr);
    }

    public static KeyNamePair[] getKeyNamePairs(String sql, boolean optional) {
        return DB.getKeyNamePairs(sql, optional, (Object[])null);
    }

    public static KeyNamePair[] getKeyNamePairs(String sql, boolean optional, Object ... params) {
        return DB.getKeyNamePairs(null, sql, optional, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyNamePair[] getKeyNamePairs(String trxName, String sql, boolean optional, Object ... params) {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<KeyNamePair> list = new ArrayList<KeyNamePair>();
        if (optional) {
            list.add(new KeyNamePair(-1, ""));
        }
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            DB.setParameters((PreparedStatement)pstmt, params);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
            }
        }
        catch (Exception e) {
            try {
                log.log(Level.SEVERE, sql, DB.getSQLException(e));
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        KeyNamePair[] retValue = new KeyNamePair[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static int[] getIDsEx(String trxName, String sql, Object ... params) throws DBException {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<Integer> list = new ArrayList<Integer>();
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            DB.setParameters((PreparedStatement)pstmt, params);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(rs.getInt(1));
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        int[] retValue = new int[list.size()];
        for (int i2 = 0; i2 < retValue.length; ++i2) {
            retValue[i2] = (Integer)list.get(i2);
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isSOTrx(String TableName, String whereClause) {
        boolean noIsSOTrxColumn;
        boolean isSOTrx;
        block19: {
            block18: {
                ResultSet rs;
                CPreparedStatement pstmt;
                if (TableName == null || TableName.length() == 0) {
                    log.severe("No TableName");
                    return true;
                }
                if (whereClause == null || whereClause.length() == 0) {
                    log.severe("No Where Clause");
                    return true;
                }
                isSOTrx = true;
                noIsSOTrxColumn = false;
                if (MTable.get(Env.getCtx(), TableName).getColumn("IsSOTrx") == null) {
                    noIsSOTrxColumn = true;
                } else {
                    block16: {
                        String sql = "SELECT IsSOTrx FROM " + TableName + " WHERE " + whereClause;
                        pstmt = null;
                        rs = null;
                        pstmt = DB.prepareStatement(sql, null);
                        rs = pstmt.executeQuery();
                        if (!rs.next()) break block16;
                        isSOTrx = "Y".equals(rs.getString(1));
                    }
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                }
                break block18;
                catch (Exception e) {
                    try {
                        noIsSOTrxColumn = true;
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                }
            }
            if (noIsSOTrxColumn && TableName.endsWith("Line")) {
                ResultSet rs2;
                CPreparedStatement pstmt2;
                noIsSOTrxColumn = false;
                String hdr = TableName.substring(0, TableName.indexOf("Line"));
                if (MTable.get(Env.getCtx(), hdr).getColumn("IsSOTrx") == null) {
                    noIsSOTrxColumn = true;
                } else {
                    block17: {
                        String sql = "SELECT IsSOTrx FROM " + hdr + " h WHERE h." + hdr + "_ID IN (SELECT l." + hdr + "_ID FROM " + TableName + " l WHERE " + whereClause + ")";
                        pstmt2 = null;
                        rs2 = null;
                        pstmt2 = DB.prepareStatement(sql, null);
                        rs2 = pstmt2.executeQuery();
                        if (!rs2.next()) break block17;
                        isSOTrx = "Y".equals(rs2.getString(1));
                    }
                    DB.close(rs2, pstmt2);
                    rs2 = null;
                    pstmt2 = null;
                }
                break block19;
                catch (Exception ee) {
                    try {
                        noIsSOTrxColumn = true;
                    }
                    catch (Throwable throwable) {
                        DB.close(rs2, pstmt2);
                        rs2 = null;
                        pstmt2 = null;
                        throw throwable;
                    }
                    DB.close(rs2, pstmt2);
                    rs2 = null;
                    pstmt2 = null;
                }
            }
        }
        if (noIsSOTrxColumn) {
            log.log(Level.FINEST, TableName + " - No SOTrx");
        }
        return isSOTrx;
    }

    public static int getNextID(Properties ctx, String TableName, String trxName) {
        if (ctx == null) {
            throw new IllegalArgumentException("Context missing");
        }
        if (TableName == null || TableName.length() == 0) {
            throw new IllegalArgumentException("TableName missing");
        }
        return DB.getNextID(Env.getAD_Client_ID(ctx), TableName, trxName);
    }

    public static int getNextID(int AD_Client_ID, String TableName, String trxName) {
        boolean SYSTEM_NATIVE_SEQUENCE = MSysConfig.getBooleanValue("SYSTEM_NATIVE_SEQUENCE", false);
        boolean adempiereSys = false;
        if (Ini.isClient()) {
            adempiereSys = Ini.isPropertyBool("AdempiereSys");
        } else {
            String sysProperty = Env.getCtx().getProperty("AdempiereSys", "N");
            boolean bl = adempiereSys = "y".equalsIgnoreCase(sysProperty) || "true".equalsIgnoreCase(sysProperty);
        }
        if (SYSTEM_NATIVE_SEQUENCE && !adempiereSys) {
            int m_sequence_id = CConnection.get().getDatabase().getNextID(TableName + "_SEQ");
            return m_sequence_id;
        }
        return MSequence.getNextID(AD_Client_ID, TableName, trxName);
    }

    public static String getDocumentNo(int C_DocType_ID, String trxName) {
        return MSequence.getDocumentNo(C_DocType_ID, trxName, false);
    }

    public static String getDocumentNo(int C_DocType_ID, String trxName, boolean definite) {
        return DB.getDocumentNo(C_DocType_ID, trxName, definite, null);
    }

    public static String getDocumentNo(int C_DocType_ID, String trxName, boolean definite, PO po) {
        return MSequence.getDocumentNo(C_DocType_ID, trxName, definite, po);
    }

    public static String getDocumentNo(int AD_Client_ID, String TableName, String trxName) {
        return DB.getDocumentNo(AD_Client_ID, TableName, trxName, null);
    }

    public static String getDocumentNo(int AD_Client_ID, String TableName, String trxName, PO po) {
        String dn = MSequence.getDocumentNo(AD_Client_ID, TableName, trxName, po);
        if (dn == null) {
            throw new DBException("No DocumentNo");
        }
        return dn;
    }

    public static String getDocumentNo(Properties ctx, int WindowNo, String TableName, boolean onlyDocType, String trxName) {
        if (ctx == null || TableName == null || TableName.length() == 0) {
            throw new IllegalArgumentException("Required parameter missing");
        }
        int AD_Client_ID = Env.getContextAsInt(ctx, WindowNo, "AD_Client_ID");
        int C_DocType_ID = Env.getContextAsInt(ctx, WindowNo + "|C_DocTypeTarget_ID");
        if (C_DocType_ID == 0) {
            C_DocType_ID = Env.getContextAsInt(ctx, WindowNo + "|C_DocType_ID");
        }
        if (C_DocType_ID == 0) {
            log.fine("Window=" + WindowNo + " - Target=" + Env.getContextAsInt(ctx, WindowNo + "|C_DocTypeTarget_ID") + "/" + Env.getContextAsInt(ctx, WindowNo, "C_DocTypeTarget_ID") + " - Actual=" + Env.getContextAsInt(ctx, WindowNo + "|C_DocType_ID") + "/" + Env.getContextAsInt(ctx, WindowNo, "C_DocType_ID"));
            return DB.getDocumentNo(AD_Client_ID, TableName, trxName);
        }
        String retValue = DB.getDocumentNo(C_DocType_ID, trxName, false);
        if (!onlyDocType && retValue == null) {
            return DB.getDocumentNo(AD_Client_ID, TableName, trxName);
        }
        return retValue;
    }

    public static boolean isRemoteObjects() {
        return false;
    }

    public static boolean isRemoteProcess() {
        return false;
    }

    public static void printWarning(String comment, SQLWarning warning) {
        if (comment == null || warning == null || comment.length() == 0) {
            throw new IllegalArgumentException("Required parameter missing");
        }
        log.warning(comment);
        for (SQLWarning warn = warning; warn != null; warn = warn.getNextWarning()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(warn.getMessage()).append("; State=").append(warn.getSQLState()).append("; ErrorCode=").append(warn.getErrorCode());
            log.warning(buffer.toString());
        }
    }

    public static String TO_DATE(Timestamp time, boolean dayOnly) {
        return s_cc.getDatabase().TO_DATE(time, dayOnly);
    }

    public static String TO_DATE(Timestamp day) {
        return DB.TO_DATE(day, true);
    }

    public static String TO_CHAR(String columnName, int displayType, String AD_Language) {
        if (columnName == null || AD_Language == null || columnName.length() == 0) {
            throw new IllegalArgumentException("Required parameter missing");
        }
        return s_cc.getDatabase().TO_CHAR(columnName, displayType, AD_Language);
    }

    public static String TO_NUMBER(BigDecimal number, int displayType) {
        return s_cc.getDatabase().TO_NUMBER(number, displayType);
    }

    public static String TO_STRING(String txt) {
        return DB.TO_STRING(txt, 0);
    }

    public static String TO_STRING(String txt, int maxLength) {
        if (txt == null || txt.length() == 0) {
            return "NULL";
        }
        String text = txt;
        if (maxLength != 0 && text.length() > maxLength) {
            text = txt.substring(0, maxLength);
        }
        StringBuffer out = new StringBuffer();
        out.append('\'');
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char c = text.charAt(i2);
            if (c == '\'') {
                out.append("''");
                continue;
            }
            out.append(c);
        }
        out.append('\'');
        return out.toString();
    }

    public static void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void close(Statement st) {
        try {
            if (st != null) {
                st.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void close(ResultSet rs, Statement st) {
        DB.close(rs);
        DB.close(st);
    }

    public static void close(POResultSet<?> rs) {
        if (rs != null) {
            rs.close();
        }
    }

    public static Exception getSQLException(Exception e) {
        for (Throwable e1 = e; e1 != null; e1 = e1.getCause()) {
            if (!(e1 instanceof SQLException)) continue;
            return (SQLException)e1;
        }
        return e;
    }

    public static void main(String[] args) {
        Adempiere.startup(true);
        MSystem system = MSystem.get(Env.getCtx());
        system.setIsJustMigrated(true);
        DB.afterMigration(Env.getCtx());
    }

    public static int getSQLValue(String trxName, String sql) {
        return DB.getSQLValue(trxName, sql, new Object[0]);
    }

    public static int getSQLValue(String trxName, String sql, int int_param1) {
        return DB.getSQLValue(trxName, sql, new Object[]{int_param1});
    }

    public static int getSQLValue(String trxName, String sql, int int_param1, int int_param2) {
        return DB.getSQLValue(trxName, sql, new Object[]{int_param1, int_param2});
    }

    public static int getSQLValue(String trxName, String sql, String str_param1) {
        return DB.getSQLValue(trxName, sql, new Object[]{str_param1});
    }

    public static int getSQLValue(String trxName, String sql, int int_param1, String str_param2) {
        return DB.getSQLValue(trxName, sql, new Object[]{int_param1, str_param2});
    }

    public static String getSQLValueString(String trxName, String sql, int int_param1) {
        return DB.getSQLValueString(trxName, sql, new Object[]{int_param1});
    }

    public static BigDecimal getSQLValueBD(String trxName, String sql, int int_param1) {
        return DB.getSQLValueBD(trxName, sql, new Object[]{int_param1});
    }

    public static ValueNamePair[] getValueNamePairs(String sql, boolean optional, List<Object> params) {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<ValueNamePair> list = new ArrayList<ValueNamePair>();
        if (optional) {
            list.add(ValueNamePair.EMPTY);
        }
        try {
            pstmt = DB.prepareStatement(sql, null);
            DB.setParameters((PreparedStatement)pstmt, params);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new ValueNamePair(rs.getString(1), rs.getString(2)));
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return list.toArray(new ValueNamePair[list.size()]);
    }

    public static KeyNamePair[] getKeyNamePairs(String sql, boolean optional, List<Object> params) {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<KeyNamePair> list = new ArrayList<KeyNamePair>();
        if (optional) {
            list.add(KeyNamePair.EMPTY);
        }
        try {
            pstmt = DB.prepareStatement(sql, null);
            DB.setParameters((PreparedStatement)pstmt, params);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return list.toArray(new KeyNamePair[list.size()]);
    }

    public static void createT_Selection(int AD_PInstance_ID, Collection<Integer> selection, String trxName) {
        StringBuffer insert = new StringBuffer();
        insert.append("INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) ");
        int counter = 0;
        for (Integer selectedId : selection) {
            if (++counter > 1) {
                insert.append(" UNION ");
            }
            insert.append("SELECT ");
            insert.append(AD_PInstance_ID);
            insert.append(", ");
            insert.append(selectedId);
            insert.append(" FROM DUAL ");
            if (counter < 1000) continue;
            DB.executeUpdateEx(insert.toString(), trxName);
            insert = new StringBuffer();
            insert.append("INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) ");
            counter = 0;
        }
        if (counter > 0) {
            DB.executeUpdateEx(insert.toString(), trxName);
        }
    }

    public static void createT_Selection_Browse(int AD_PInstance_ID, LinkedHashMap<Integer, LinkedHashMap<String, Object>> selection, String trxName) {
        StringBuilder insert = new StringBuilder();
        insert.append("INSERT INTO T_Selection_Browse (AD_PInstance_ID, T_Selection_ID, ColumnName , Value_String, Value_Number , Value_Date) VALUES(?,?,?,?,?,?) ");
        for (Map.Entry<Integer, LinkedHashMap<String, Object>> records : selection.entrySet()) {
            LinkedHashMap<String, Object> fields = records.getValue();
            for (Map.Entry<String, Object> field : fields.entrySet()) {
                Comparable<BigDecimal> value;
                ArrayList<Object> parameters = new ArrayList<Object>();
                parameters.add(AD_PInstance_ID);
                parameters.add(records.getKey());
                parameters.add(field.getKey());
                Object data = field.getValue();
                if (data instanceof String) {
                    parameters.add(data);
                    parameters.add(null);
                    parameters.add(null);
                } else if (data instanceof BigDecimal || data instanceof Integer || data instanceof Double) {
                    parameters.add(null);
                    if (data instanceof Double) {
                        value = BigDecimal.valueOf((Double)data);
                        parameters.add(value);
                    } else {
                        parameters.add(data);
                    }
                    parameters.add(null);
                } else if (data instanceof Integer) {
                    parameters.add(null);
                    parameters.add((Integer)data);
                    parameters.add(null);
                } else if (data instanceof Timestamp || data instanceof Date) {
                    parameters.add(null);
                    parameters.add(null);
                    if (data instanceof Date) {
                        value = new Timestamp(((Date)data).getTime());
                        parameters.add(value);
                    } else {
                        parameters.add(data);
                    }
                } else {
                    parameters.add(data);
                    parameters.add(null);
                    parameters.add(null);
                }
                DB.executeUpdateEx(insert.toString(), parameters.toArray(), null);
            }
        }
    }

    public static void createT_Selection(int AD_PInstance_ID, Map<Integer, List<String>> saveKeys, int viewIDIndex, String trxName) {
        StringBuilder insert = new StringBuilder();
        insert.append("INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID, ViewID) ");
        int counter = 0;
        for (Integer selectedId : saveKeys.keySet()) {
            if (++counter > 1) {
                insert.append(" UNION ");
            }
            insert.append("SELECT ");
            insert.append(AD_PInstance_ID);
            insert.append(", ");
            insert.append(selectedId);
            insert.append(", ");
            List<String> viewIDValues = saveKeys.get(selectedId);
            if (viewIDValues == null || viewIDIndex < 0 || viewIDValues.get(viewIDIndex) == null) {
                insert.append("NULL");
            } else {
                insert.append("'");
                insert.append(viewIDValues.get(viewIDIndex));
                insert.append("'");
            }
            insert.append(" FROM DUAL ");
            if (counter < 1000) continue;
            DB.executeUpdateEx(insert.toString(), trxName);
            insert = new StringBuilder("INSERT INTO T_SELECTION (AD_PINSTANCE_ID, T_SELECTION_ID, ViewID) ");
            counter = 0;
        }
        if (counter > 0) {
            DB.executeUpdateEx(insert.toString(), trxName);
        }
    }

    private static void verifyTrx(String trxName, String sql) {
        if (trxName != null && Trx.get(trxName, false) == null) {
            log.severe("Transaction closed or never opened (" + trxName + ") => this is equivalent to commit without trx (autocommit) --> " + sql);
        }
    }

    public static String buildSqlList(List<? extends Object> paramsIn, List<Object> paramsOut) {
        Check.assumeNotNull(paramsOut, "paramsOut not null", new Object[0]);
        if (paramsIn == null || paramsIn.isEmpty()) {
            return SQL_EmptyList;
        }
        StringBuilder sql = new StringBuilder("?");
        int len = paramsIn.size();
        for (int i2 = 1; i2 < len; ++i2) {
            sql.append(",?");
        }
        paramsOut.addAll(paramsIn);
        return sql.insert(0, "(").append(")").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isTableOrViewExists(String tableName) {
        ResultSet rs;
        Connection conn;
        block15: {
            boolean bl;
            block14: {
                conn = DB.getConnectionRO();
                rs = null;
                try {
                    DatabaseMetaData metadata = conn.getMetaData();
                    rs = metadata.getTables(null, null, DB.isPostgreSQL() ? tableName.toLowerCase() : tableName.toUpperCase(), null);
                    if (rs.next()) {
                        bl = true;
                        DB.close(rs);
                        break block14;
                    }
                    DB.close(rs);
                    break block15;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            try {
                conn.close();
                return bl;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return bl;
        }
        try {
            conn.close();
            return false;
        }
        catch (SQLException metadata) {
            return false;
        }
        finally {
            DB.close(rs);
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public static Timestamp getCurrentTimeFromDatabase() {
        return DB.getSQLValueTS(null, "SELECT getdate() FROM DUAL", new Object[0]);
    }

    public static Try<Void> runResultSet(String trxName, String sql, List<Object> parameters, ResultSetRunnable<ResultSet> resultSet) {
        return (Try)runResultSetFunction.apply((Object)trxName, (Object)sql, (Object)io.vavr.collection.List.ofAll(parameters), resultSet);
    }
}

