/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.request.apps;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.logging.Level;
import org.adempiere.core.domains.models.I_AD_User;
import org.adempiere.core.domains.models.I_A_Asset;
import org.adempiere.core.domains.models.I_C_BPartner;
import org.adempiere.core.domains.models.I_C_Campaign;
import org.adempiere.core.domains.models.I_C_Invoice;
import org.adempiere.core.domains.models.I_C_Order;
import org.adempiere.core.domains.models.I_C_OrderLine;
import org.adempiere.core.domains.models.I_C_Payment;
import org.adempiere.core.domains.models.I_C_Project;
import org.adempiere.core.domains.models.I_M_InOut;
import org.adempiere.core.domains.models.I_M_Product;
import org.adempiere.core.domains.models.I_M_RMA;
import org.adempiere.core.domains.models.I_R_Request;
import org.compiere.model.GridTab;
import org.compiere.model.MOrderLine;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.ValueNamePair;

public class Request {
    protected StringBuffer whereClause = null;
    protected int tableId;
    protected int recordId;
    protected int partnerId;
    protected HashMap<String, ValueNamePair> requestList = new HashMap();
    protected String REQUEST_PROCESSED = "Y";
    protected String REQUEST_UNPROCESSED = "N";
    protected String REQUEST_ALL = "";
    protected static CLogger log = CLogger.getCLogger(Request.class);

    protected void buildWhereClause() {
        this.whereClause = new StringBuffer();
        this.whereClause.append("(AD_Table_ID=").append(this.tableId).append(" AND Record_ID=").append(this.recordId).append(")");
        if (this.tableId == MUser.Table_ID) {
            this.whereClause.append(" OR AD_User_ID=").append(this.recordId).append(" OR SalesRep_ID=").append(this.recordId);
        } else if (this.tableId == I_C_BPartner.Table_ID) {
            this.whereClause.append(" OR C_BPartner_ID=").append(this.recordId);
        } else if (this.tableId == I_C_Order.Table_ID) {
            this.whereClause.append(" OR C_Order_ID=").append(this.recordId);
        } else if (this.tableId == I_C_Invoice.Table_ID) {
            this.whereClause.append(" OR C_Invoice_ID=").append(this.recordId);
        } else if (this.tableId == I_C_Payment.Table_ID) {
            this.whereClause.append(" OR C_Payment_ID=").append(this.recordId);
        } else if (this.tableId == I_M_Product.Table_ID) {
            this.whereClause.append(" OR M_Product_ID=").append(this.recordId);
        } else if (this.tableId == I_C_Project.Table_ID) {
            this.whereClause.append(" OR C_Project_ID=").append(this.recordId);
        } else if (this.tableId == I_C_Campaign.Table_ID) {
            this.whereClause.append(" OR C_Campaign_ID=").append(this.recordId);
        } else if (this.tableId == I_A_Asset.Table_ID) {
            this.whereClause.append(" OR A_Asset_ID=").append(this.recordId);
        }
    }

    protected void defineGridTab(GridTab gridTab) {
        MOrderLine oLine;
        gridTab.dataNew(false);
        gridTab.setValue("AD_Table_ID", (Object)this.tableId);
        gridTab.setValue("Record_ID", (Object)this.recordId);
        if (this.partnerId != 0) {
            gridTab.setValue("C_BPartner_ID", (Object)this.partnerId);
        }
        if (this.tableId == I_C_BPartner.Table_ID) {
            gridTab.setValue("C_BPartner_ID", (Object)this.recordId);
        } else if (this.tableId == I_AD_User.Table_ID) {
            gridTab.setValue("AD_User_ID", (Object)this.recordId);
        } else if (this.tableId == I_C_Project.Table_ID) {
            gridTab.setValue("C_Project_ID", (Object)this.recordId);
        } else if (this.tableId == I_A_Asset.Table_ID) {
            gridTab.setValue("A_Asset_ID", (Object)this.recordId);
        } else if (this.tableId == I_C_Order.Table_ID) {
            gridTab.setValue("C_Order_ID", (Object)this.recordId);
        } else if (this.tableId == I_C_Invoice.Table_ID) {
            gridTab.setValue("C_Invoice_ID", (Object)this.recordId);
        } else if (this.tableId == I_M_Product.Table_ID) {
            gridTab.setValue("M_Product_ID", (Object)this.recordId);
        } else if (this.tableId == I_C_Payment.Table_ID) {
            gridTab.setValue("C_Payment_ID", (Object)this.recordId);
        } else if (this.tableId == I_M_InOut.Table_ID) {
            gridTab.setValue("M_InOut_ID", (Object)this.recordId);
        } else if (this.tableId == I_M_RMA.Table_ID) {
            gridTab.setValue("M_RMA_ID", (Object)this.recordId);
        } else if (this.tableId == I_C_Campaign.Table_ID) {
            gridTab.setValue("C_Campaign_ID", (Object)this.recordId);
        } else if (this.tableId == I_R_Request.Table_ID) {
            gridTab.setValue("R_RequestRelated_ID", (Object)this.recordId);
        } else if (this.tableId == I_C_OrderLine.Table_ID && (oLine = new MOrderLine(Env.getCtx(), this.recordId, null)) != null) {
            gridTab.setValue("C_Order_ID", (Object)oLine.getC_Order_ID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashMap<String, ValueNamePair> getRequestList() {
        if (this.requestList != null && this.requestList.size() > 0) {
            return this.requestList;
        }
        String sql = "SELECT r.R_Request_ID,r.DocumentNo,coalesce  (r.Summary,''),COALESCE(rt.Name,' '),COALESCE(rg.Name,' '),COALESCE(rc.Name,' '), COALESCE(rs.Name,' '),COALESCE(rrep.Name,' ') , r.Processed , r.DateNextAction FROM R_Request r JOIN R_RequestType rt ON (r.R_RequestType_ID = rt.R_RequestType_ID) LEFT JOIN R_Group rg ON (r.R_Group_ID = rg.R_Group_ID) LEFT JOIN R_Category rc ON (r.R_Category_ID = rc.R_Category_ID) LEFT JOIN R_Status rs ON (r.R_Status_ID = rs.R_Status_ID) LEFT JOIN AD_User rrep ON (r.SalesRep_ID = rrep.AD_User_ID) WHERE " + this.whereClause + "ORDER BY R_Request_ID";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String requestId = rs.getString(1);
                String documentNo = rs.getString(2);
                String requestSummary = rs.getString(3);
                String requestType = rs.getString(4);
                String requestGroup = rs.getString(5);
                String requestCategory = rs.getString(6);
                String requestStatus = rs.getString(7);
                String requestResponsible = rs.getString(8);
                String processed = rs.getString(9);
                String nextAction = rs.getString(10);
                StringBuilder requestInfo = new StringBuilder();
                requestInfo.append(documentNo).append("_");
                requestInfo.append(nextAction).append("_");
                requestInfo.append(requestResponsible).append("_");
                requestInfo.append(requestSummary).append("_");
                requestInfo.append(requestType).append("_");
                requestInfo.append(requestGroup).append("_");
                requestInfo.append(requestCategory).append("_");
                requestInfo.append(requestStatus);
                ValueNamePair valueNamePair = new ValueNamePair(processed, requestInfo.toString());
                this.requestList.put(requestId, valueNamePair);
            }
        }
        catch (Exception e) {
            try {
                log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
        }
        DB.close(rs, pstmt);
        return this.requestList;
    }

    protected int getCount() {
        return this.getRequestList().size();
    }

    protected long getProcessingCount() {
        return this.getRequestList().entrySet().stream().filter(requestEntry -> ((ValueNamePair)requestEntry.getValue()).getID().equals(this.REQUEST_PROCESSED)).count();
    }

    protected long getUnprocessingCount() {
        return this.getRequestList().entrySet().stream().filter(requestEntry -> ((ValueNamePair)requestEntry.getValue()).getID().equals(this.REQUEST_UNPROCESSED)).count();
    }
}

