/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.project.process;

import java.util.List;
import java.util.logging.Level;
import org.compiere.model.MProductPricing;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.MProjectPhase;
import org.compiere.model.MProjectTask;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Msg;

public class ProjectLinePricing
extends SvrProcess {
    private int m_C_ProjectLine_ID = 0;
    private int m_C_Project_ID = 0;
    private int m_C_ProjectPhase_ID = 0;
    private int m_C_ProjectTask_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
        if (this.getTable_ID() == MProject.Table_ID) {
            this.m_C_Project_ID = this.getRecord_ID();
        } else if (this.getTable_ID() == MProjectPhase.Table_ID) {
            this.m_C_ProjectPhase_ID = this.getRecord_ID();
        } else if (this.getTable_ID() == MProjectTask.Table_ID) {
            this.m_C_ProjectTask_ID = this.getRecord_ID();
        } else if (this.getTable_ID() == MProjectLine.Table_ID) {
            this.m_C_ProjectLine_ID = this.getRecord_ID();
        }
    }

    @Override
    protected String doIt() throws Exception {
        String retValue = "";
        if (this.m_C_Project_ID != 0) {
            MProject project = new MProject(this.getCtx(), this.m_C_Project_ID, this.get_TrxName());
            retValue = this.processProject(project);
        } else if (this.m_C_ProjectPhase_ID != 0) {
            MProjectPhase phase = new MProjectPhase(this.getCtx(), this.m_C_ProjectPhase_ID, this.get_TrxName());
            retValue = this.processProjectPhase(phase);
        } else if (this.m_C_ProjectTask_ID != 0) {
            MProjectTask pTask = new MProjectTask(this.getCtx(), this.m_C_ProjectTask_ID, this.get_TrxName());
            retValue = this.processProjectTask(pTask);
        } else if (this.m_C_ProjectLine_ID != 0) {
            MProjectLine pLine = new MProjectLine(this.getCtx(), this.m_C_ProjectLine_ID, this.get_TrxName());
            retValue = this.processProjectLines(pLine);
        }
        return retValue;
    }

    private String processProject(MProject project) {
        Object retValue;
        block4: {
            block3: {
                retValue = "";
                if (!project.getProjectLineLevel().equals("P")) break block3;
                List<MProjectLine> pLines = project.getLines();
                if (pLines.size() <= 0) break block4;
                for (MProjectLine mProjectLine : pLines) {
                    retValue = (String)retValue + this.processProjectLines(mProjectLine);
                }
                break block4;
            }
            List<MProjectPhase> lPhases = project.getPhases();
            if (lPhases.size() > 0) {
                for (MProjectPhase mProjectPhase : lPhases) {
                    retValue = (String)retValue + this.processProjectPhase(mProjectPhase);
                }
            }
        }
        return retValue;
    }

    private String processProjectPhase(MProjectPhase mProjectPhase) {
        Object retValue;
        block5: {
            MProject project;
            block6: {
                retValue = "";
                if (mProjectPhase.getC_ProjectPhase_ID() == 0) break block5;
                project = (MProject)mProjectPhase.getC_Project();
                if (!project.getProjectLineLevel().equals("A")) break block6;
                List<MProjectLine> pLines = mProjectPhase.getLines();
                if (pLines.size() > 0) {
                    for (MProjectLine mProjectLine : pLines) {
                        retValue = (String)retValue + this.processProjectLines(mProjectLine);
                    }
                } else {
                    if (project.getM_PriceList_ID() == 0) {
                        throw new IllegalArgumentException("No PriceList");
                    }
                    boolean isSOTrx = true;
                    MProductPricing pp = new MProductPricing(mProjectPhase.getM_Product_ID(), project.getC_BPartner_ID(), mProjectPhase.getPP_Product_BOM_ID(), mProjectPhase.getQty(), isSOTrx, null);
                    pp.setM_PriceList_ID(project.getM_PriceList_ID());
                    pp.setPriceDate(project.getDateContract());
                    mProjectPhase.setPlannedAmt(pp.getPriceStd().multiply(mProjectPhase.getQty()));
                    mProjectPhase.saveEx();
                    retValue = (String)retValue + Msg.getElement(this.getCtx(), "PriceList") + pp.getPriceList() + " - " + Msg.getElement(this.getCtx(), "PriceStd") + pp.getPriceStd() + " - " + Msg.getElement(this.getCtx(), "PriceLimit") + pp.getPriceLimit();
                }
                break block5;
            }
            if (!project.getProjectLineLevel().equals("T")) break block5;
            List<MProjectTask> pTasks = mProjectPhase.getTasks();
            for (MProjectTask mProjectTask : pTasks) {
                retValue = (String)retValue + this.processProjectTask(mProjectTask);
            }
        }
        return retValue;
    }

    private String processProjectTask(MProjectTask pTask) {
        Object retValue = "";
        if (pTask.getC_ProjectTask_ID() != 0) {
            MProjectLine[] pLines = pTask.getLines();
            if (pLines.length > 0) {
                for (MProjectLine mProjectLine : pLines) {
                    retValue = (String)retValue + this.processProjectLines(mProjectLine);
                }
            } else {
                MProject project = new MProject(this.getCtx(), pTask.getC_ProjectPhase().getC_Project_ID(), this.get_TrxName());
                if (project.getM_PriceList_ID() == 0) {
                    throw new IllegalArgumentException("No PriceList");
                }
                boolean isSOTrx = true;
                MProductPricing pp = new MProductPricing(pTask.getM_Product_ID(), project.getC_BPartner_ID(), pTask.getPP_Product_BOM_ID(), pTask.getQty(), isSOTrx, null);
                pp.setM_PriceList_ID(project.getM_PriceList_ID());
                pp.setPriceDate(project.getDateContract());
                pTask.setPlannedAmt(pp.getPriceStd().multiply(pTask.getQty()));
                pTask.saveEx();
                retValue = (String)retValue + Msg.getElement(this.getCtx(), "PriceList") + pp.getPriceList() + " - " + Msg.getElement(this.getCtx(), "PriceStd") + pp.getPriceStd() + " - " + Msg.getElement(this.getCtx(), "PriceLimit") + pp.getPriceLimit();
            }
        }
        return retValue;
    }

    private String processProjectLines(MProjectLine projectLine) {
        Object retValue = "";
        this.log.info("doIt - " + projectLine);
        if (projectLine.getM_Product_ID() == 0) {
            throw new IllegalArgumentException("No Product");
        }
        MProject project = new MProject(this.getCtx(), projectLine.getC_Project_ID(), this.get_TrxName());
        if (project.getM_PriceList_ID() == 0) {
            throw new IllegalArgumentException("No PriceList");
        }
        boolean isSOTrx = true;
        MProductPricing pp = new MProductPricing(projectLine.getM_Product_ID(), project.getC_BPartner_ID(), projectLine.getPP_Product_BOM_ID(), projectLine.getPlannedQty(), isSOTrx, null);
        pp.setM_PriceList_ID(project.getM_PriceList_ID());
        pp.setPriceDate(project.getDateContract());
        projectLine.setPlannedPrice(pp.getPriceStd());
        projectLine.setPlannedMarginAmt(pp.getPriceStd().subtract(pp.getPriceLimit()));
        projectLine.saveEx();
        retValue = (String)retValue + Msg.getElement(this.getCtx(), "PriceList") + pp.getPriceList() + " - " + Msg.getElement(this.getCtx(), "PriceStd") + pp.getPriceStd() + " - " + Msg.getElement(this.getCtx(), "PriceLimit") + pp.getPriceLimit();
        return retValue;
    }
}

