/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCurrency;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MProject;
import org.compiere.model.MRfQ;
import org.compiere.model.MRfQLine;
import org.compiere.model.MRfQLineQty;
import org.compiere.model.MRfQResponse;
import org.compiere.process.RfQCreateSOAbstract;
import org.compiere.util.Env;

public class RfQCreateSO
extends RfQCreateSOAbstract {
    private static BigDecimal ONEHUNDRED = new BigDecimal(100);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String doIt() throws Exception {
        MRfQResponse[] responses;
        MProject project = null;
        int org_ID = Env.getContextAsInt(this.getCtx(), 0, "AD_Org_ID");
        MRfQ rfq = new MRfQ(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        int projectId = rfq.get_ValueAsInt("C_Project_ID");
        if (projectId > 0 && org_ID != (project = new MProject(this.getCtx(), projectId, this.get_TrxName())).getAD_Org_ID()) {
            throw new AdempiereException("ERROR: Organizacion logueada debe ser la misma del proyecto");
        }
        if (rfq.get_ID() == 0) {
            throw new IllegalArgumentException("No RfQ found");
        }
        this.log.info("doIt - " + rfq);
        if (rfq.getC_BPartner_ID() == 0 || rfq.getC_BPartner_Location_ID() == 0) {
            throw new Exception("No Business Partner/Location");
        }
        MBPartner bp = new MBPartner(this.getCtx(), rfq.getC_BPartner_ID(), this.get_TrxName());
        MOrder order = new MOrder(this.getCtx(), 0, this.get_TrxName());
        order.setIsSOTrx(true);
        if (this.getDocTypeId() != 0) {
            order.setC_DocTypeTarget_ID(this.getDocTypeId());
        } else {
            order.setC_DocTypeTarget_ID();
        }
        order.setBPartner(bp);
        order.setC_BPartner_Location_ID(rfq.getC_BPartner_Location_ID());
        order.setSalesRep_ID(rfq.getSalesRep_ID());
        order.set_ValueOfColumn("C_RfQ_ID", (Object)rfq.getC_RfQ_ID());
        int campaignId = rfq.get_ValueAsInt("C_Campaign_ID");
        int user1Id = rfq.get_ValueAsInt("User1_ID");
        if (campaignId > 0) {
            order.set_ValueOfColumn("C_Campaign_ID", (Object)campaignId);
        }
        if (user1Id > 0) {
            order.set_ValueOfColumn("User1_ID", (Object)user1Id);
        }
        if (projectId > 0) {
            order.set_ValueOfColumn("C_Project_ID", (Object)projectId);
            order.set_ValueOfColumn("S_Contract_ID", project.get_Value("S_Contract_ID"));
        }
        if (rfq.getDateWorkComplete() != null) {
            order.setDatePromised(rfq.getDateWorkComplete());
        }
        order.setC_Currency_ID(rfq.getC_Currency_ID());
        for (MRfQResponse response : responses = rfq.getResponses(true, false)) {
            if (!response.isSelectedWinner()) continue;
            order.setDropShip_BPartner_ID(response.getC_BPartner_ID());
            order.setIsDropShip(true);
            MBPartner partner = new MBPartner(this.getCtx(), response.getC_BPartner_ID(), null);
            MBPartnerLocation partnerLocation = partner.getPrimaryC_BPartner_Location();
            if (partnerLocation == null || partnerLocation.get_ID() <= 0) break;
            order.setDropShip_Location_ID(partnerLocation.get_ID());
            break;
        }
        MPriceList soList = null;
        MCurrency cur = (MCurrency)order.getC_Currency();
        MBPartner partner = (MBPartner)order.getC_BPartner();
        if (partner.get_ValueAsInt("M_PriceList_ID") > 0) {
            soList = new MPriceList(this.getCtx(), partner.get_ValueAsInt("M_PriceList_ID"), this.get_TrxName());
            if (soList.getC_Currency_ID() == cur.get_ID()) {
                order.setM_PriceList_ID(soList.get_ID());
            } else {
                soList = MPriceList.getDefault(this.getCtx(), true, cur.getISO_Code());
                if (soList == null || soList.get_ID() <= 0) throw new AdempiereException("No se obtuvo lista de precios de venta predeterminada en " + cur.getISO_Code());
                order.setM_PriceList_ID(soList.get_ID());
            }
        } else {
            soList = MPriceList.getDefault(this.getCtx(), true, cur.getISO_Code());
            if (soList == null || soList.get_ID() <= 0) throw new AdempiereException("No se obtuvo lista de precios de venta predeterminada en " + cur.getISO_Code());
            order.setM_PriceList_ID(soList.get_ID());
        }
        order.saveEx();
        for (MRfQLine line : rfq.getLines()) {
            for (MRfQLineQty lineQty : line.getQtys()) {
                if (!lineQty.isActive() || !lineQty.isOfferQty()) continue;
                MOrderLine orderLine = new MOrderLine(order);
                orderLine.setM_Product_ID(line.getM_Product_ID(), lineQty.getC_UOM_ID());
                orderLine.setDescription(line.getDescription());
                orderLine.setQty(lineQty.getQty());
                orderLine.setPrice();
                BigDecimal price = lineQty.getOfferAmt();
                if (price == null || price.signum() == 0) {
                    price = lineQty.getBestResponseAmt();
                    if (price == null || price.signum() == 0) {
                        price = Env.ZERO;
                        this.log.warning(" - BestResponse=0 - " + lineQty);
                    } else {
                        BigDecimal margin = lineQty.getMargin();
                        if (margin == null || margin.signum() == 0) {
                            margin = rfq.getMargin();
                        }
                        if (margin != null && margin.signum() != 0) {
                            margin = margin.add(ONEHUNDRED);
                            price = price.multiply(margin).divide(ONEHUNDRED, 2, 4);
                            orderLine.setPriceList(lineQty.getBestResponseAmt());
                        }
                    }
                }
                orderLine.setPrice(price);
                int projectTaskId = line.get_ValueAsInt("C_ProjectTask_ID");
                int projectPhaseId = line.get_ValueAsInt("C_ProjectPhase_ID");
                if (projectPhaseId > 0) {
                    orderLine.set_ValueOfColumn("C_ProjectPhase_ID", (Object)projectPhaseId);
                    if (order.get_ValueAsInt("C_ProjectPhase_ID") == 0) {
                        order.set_ValueOfColumn("C_ProjectPhase_ID", (Object)orderLine.getC_ProjectPhase_ID());
                        order.saveEx();
                    }
                }
                if (projectTaskId > 0) {
                    orderLine.set_ValueOfColumn("C_ProjectTask_ID", (Object)projectTaskId);
                    if (order.get_ValueAsInt("C_ProjectTask_ID") == 0) {
                        order.set_ValueOfColumn("C_ProjectTask_ID", (Object)orderLine.getC_ProjectTask_ID());
                        order.saveEx();
                    }
                }
                orderLine.saveEx();
            }
        }
        rfq.setC_Order_ID(order.getC_Order_ID());
        rfq.saveEx();
        return order.getDocumentNo();
    }
}

