/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import org.adempiere.core.domains.models.X_C_BPartner;
import org.adempiere.core.domains.models.X_C_Order;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRfQ;
import org.compiere.model.MRfQLine;
import org.compiere.model.MRfQResponse;
import org.compiere.model.MRfQResponseLine;
import org.compiere.model.MRfQResponseLineQty;
import org.compiere.process.RfQCreatePOAbstract;

public class RfQCreatePO
extends RfQCreatePOAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        MRfQ rfq = new MRfQ(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (rfq.get_ID() == 0) {
            throw new IllegalArgumentException("No RfQ found");
        }
        this.log.info(rfq.toString());
        MRfQResponse[] responses = rfq.getResponses(true, true);
        this.log.config("#Responses=" + responses.length);
        if (responses.length == 0) {
            throw new IllegalArgumentException("No completed RfQ Responses found");
        }
        for (MRfQResponse response : responses) {
            if (!response.isSelectedWinner()) continue;
            MBPartner bp = new MBPartner(this.getCtx(), response.getC_BPartner_ID(), this.get_TrxName());
            this.log.config("Winner=" + bp);
            MOrder order = new MOrder(this.getCtx(), 0, this.get_TrxName());
            order.setIsSOTrx(false);
            if (this.getDocTypeId() != 0) {
                order.setC_DocTypeTarget_ID(this.getDocTypeId());
            } else {
                order.setC_DocTypeTarget_ID();
            }
            order.setBPartner(bp);
            order.setC_BPartner_Location_ID(response.getC_BPartner_Location_ID());
            order.setSalesRep_ID(rfq.getSalesRep_ID());
            order.set_ValueOfColumn("C_RfQ_ID", (Object)rfq.getC_RfQ_ID());
            int campaignId = rfq.get_ValueAsInt("C_Campaign_ID");
            int user1Id = rfq.get_ValueAsInt("User1_ID");
            int projectId = rfq.get_ValueAsInt("C_Project_ID");
            if (campaignId > 0) {
                order.set_ValueOfColumn("C_Campaign_ID", (Object)campaignId);
            }
            if (user1Id > 0) {
                order.set_ValueOfColumn("User1_ID", (Object)user1Id);
            }
            if (projectId > 0) {
                order.set_ValueOfColumn("C_Project_ID", (Object)projectId);
            }
            if (response.getDateWorkComplete() != null) {
                order.setDatePromised(response.getDateWorkComplete());
            } else if (rfq.getDateWorkComplete() != null) {
                order.setDatePromised(rfq.getDateWorkComplete());
            }
            order.saveEx();
            for (MRfQResponseLine line : response.getLines(false)) {
                if (!line.isActive()) continue;
                for (MRfQResponseLineQty lineQty : line.getQtys(false)) {
                    if (!lineQty.getRfQLineQty().isActive() || !lineQty.getRfQLineQty().isPurchaseQty()) continue;
                    MOrderLine orderLine = new MOrderLine(order);
                    orderLine.setM_Product_ID(line.getRfQLine().getM_Product_ID(), lineQty.getRfQLineQty().getC_UOM_ID());
                    orderLine.setDescription(line.getDescription());
                    orderLine.setQty(lineQty.getRfQLineQty().getQty());
                    BigDecimal price = lineQty.getNetAmt();
                    orderLine.setPrice();
                    orderLine.setPrice(price);
                    MRfQLine rFqline = line.getRfQLine();
                    int projectTaskId = rFqline.get_ValueAsInt("C_ProjectTask_ID");
                    int projectPhaseId = rFqline.get_ValueAsInt("C_ProjectPhase_ID");
                    if (projectPhaseId > 0) {
                        orderLine.set_ValueOfColumn("C_ProjectPhase_ID", (Object)projectPhaseId);
                    }
                    if (projectTaskId > 0) {
                        orderLine.set_ValueOfColumn("C_ProjectTask_ID", (Object)projectTaskId);
                    }
                    orderLine.saveEx();
                }
            }
            response.setC_Order_ID(order.getC_Order_ID());
            response.saveEx();
            return order.getDocumentNo();
        }
        int noOrders = 0;
        for (int i = 0; i < responses.length; ++i) {
            MRfQResponse response = responses[i];
            X_C_BPartner bp = null;
            X_C_Order order = null;
            MRfQResponseLine[] lines = response.getLines(false);
            for (int j = 0; j < lines.length; ++j) {
                MRfQResponseLine line = lines[j];
                if (!line.isActive() || !line.isSelectedWinner()) continue;
                if (bp == null || bp.getC_BPartner_ID() != response.getC_BPartner_ID()) {
                    bp = new MBPartner(this.getCtx(), response.getC_BPartner_ID(), this.get_TrxName());
                    order = null;
                }
                this.log.config("Line=" + line + ", Winner=" + (MBPartner)bp);
                if (order == null) {
                    order = new MOrder(this.getCtx(), 0, this.get_TrxName());
                    order.setIsSOTrx(false);
                    ((MOrder)order).setC_DocTypeTarget_ID();
                    ((MOrder)order).setBPartner((MBPartner)bp);
                    ((MOrder)order).setC_BPartner_Location_ID(response.getC_BPartner_Location_ID());
                    order.setSalesRep_ID(rfq.getSalesRep_ID());
                    order.saveEx();
                    ++noOrders;
                    this.addLog(0, null, null, order.getDocumentNo());
                }
                MRfQResponseLineQty[] qtys = line.getQtys(false);
                for (int k = 0; k < qtys.length; ++k) {
                    MRfQResponseLineQty qty = qtys[k];
                    if (!qty.getRfQLineQty().isActive() || !qty.getRfQLineQty().isPurchaseQty()) continue;
                    MOrderLine ol = new MOrderLine((MOrder)order);
                    ol.setM_Product_ID(line.getRfQLine().getM_Product_ID(), qty.getRfQLineQty().getC_UOM_ID());
                    ol.setDescription(line.getDescription());
                    ol.setQty(qty.getRfQLineQty().getQty());
                    BigDecimal price = qty.getNetAmt();
                    ol.setPrice();
                    ol.setPrice(price);
                    ol.saveEx();
                }
            }
            if (order == null) continue;
            response.setC_Order_ID(order.getC_Order_ID());
            response.saveEx();
        }
        return "#" + noOrders;
    }
}

