/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.List;
import org.adempiere.core.domains.models.X_PP_Product_BOM;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MProjectPhase;
import org.compiere.model.MProjectTask;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProjectTaskPhaseCopyBOMAbstract;
import org.eevolution.manufacturing.model.MPPProductBOM;
import org.eevolution.services.dsl.ProcessBuilder;

public class ProjectTaskPhaseCopyBOM
extends ProjectTaskPhaseCopyBOMAbstract {
    int m_C_Project_ID = 0;
    int m_C_ProjectPhase_ID = 0;
    int m_C_ProjectTask_ID = 0;
    private static int PROCESSID_PRODUCT_BOM_COPY = 53004;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        MProject project = null;
        MProjectPhase phase = null;
        MProjectTask task = null;
        String resultBOM = "";
        if (this.getTable_ID() == MProjectTask.Table_ID) {
            task = new MProjectTask(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
            this.m_C_ProjectTask_ID = task.getC_ProjectTask_ID();
            phase = (MProjectPhase)task.getC_ProjectPhase();
            this.m_C_ProjectPhase_ID = phase.getC_ProjectPhase_ID();
            resultBOM = this.copyBOM(null, task, (MProduct)task.getM_Product());
            this.addLog(resultBOM);
        } else if (this.getTable_ID() == MProjectPhase.Table_ID) {
            phase = new MProjectPhase(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
            this.m_C_ProjectPhase_ID = phase.getC_ProjectPhase_ID();
            resultBOM = this.processPhase(phase);
        } else if (this.getTable_ID() == MProject.Table_ID) {
            this.m_C_Project_ID = this.getRecord_ID();
            project = new MProject(this.getCtx(), this.m_C_Project_ID, this.get_TrxName());
            resultBOM = this.processProject(project);
        }
        return resultBOM;
    }

    private String processProject(MProject project) {
        Object result = "";
        List<MProjectPhase> phases = project.getPhases();
        for (MProjectPhase mProjectPhase : phases) {
            result = (String)result + this.processPhase(mProjectPhase);
        }
        return result;
    }

    private String processPhase(MProjectPhase phase) {
        Object result = "";
        Object resultBOM = "";
        resultBOM = (String)resultBOM + this.copyBOM(phase, null, (MProduct)phase.getM_Product());
        this.addLog((String)resultBOM);
        result = (String)result + (String)resultBOM + "\n";
        List<MProjectTask> ptasks = phase.getTasks();
        for (MProjectTask mProjectTask : ptasks) {
            resultBOM = this.copyBOM(null, mProjectTask, (MProduct)mProjectTask.getM_Product());
            this.addLog((String)resultBOM);
            result = (String)result + (String)resultBOM + "\n";
        }
        return result;
    }

    private String copyBOM(MProjectPhase phase, MProjectTask task, MProduct product) {
        Object result = "";
        X_PP_Product_BOM defaultBOM = null;
        MPPProductBOM newBOM = null;
        Object level = "";
        if (phase != null) {
            level = " @C_ProjectPhase_ID@ " + phase.getName();
        } else if (task != null) {
            level = " @C_ProjectTask_ID@ " + task.getName();
        }
        if (product == null) {
            return "@M_Product_ID@ @NotFound@ " + (String)level;
        }
        if (!product.isBOM() || !product.isVerified()) {
            return "@invalid@ @PP_Product_BOM_ID@ " + (String)level;
        }
        if (this.m_C_ProjectTask_ID != 0) {
            if (task != null) {
                defaultBOM = (MPPProductBOM)task.getPP_Product_BOM();
            } else if (this.m_C_ProjectPhase_ID != 0 && phase != null) {
                defaultBOM = (MPPProductBOM)phase.getPP_Product_BOM();
            }
        }
        if (defaultBOM == null || defaultBOM.getPP_Product_BOM_ID() == 0) {
            defaultBOM = MPPProductBOM.getDefault(product, this.get_TrxName());
        }
        if (defaultBOM == null) {
            return "@PP_Product_BOM_ID@ @NotFound@ " + (String)level;
        }
        newBOM = new MPPProductBOM(this.getCtx(), 0, this.get_TrxName());
        MPPProductBOM.copyValues(defaultBOM, newBOM, true);
        newBOM.setIsDefault(false);
        newBOM.setValue("");
        newBOM.saveEx();
        if (this.m_C_ProjectTask_ID != 0 && task != null) {
            task.setPP_Product_BOM_ID(newBOM.getPP_Product_BOM_ID());
            task.save();
        } else if (this.m_C_ProjectPhase_ID != 0 && phase != null) {
            phase.setPP_Product_BOM_ID(newBOM.getPP_Product_BOM_ID());
            phase.save();
        }
        ProcessInfo processInfo = ProcessBuilder.create(this.getCtx()).process(PROCESSID_PRODUCT_BOM_COPY).withRecordId(MPPProductBOM.Table_ID, newBOM.getPP_Product_BOM_ID()).withoutTransactionClose().withParameter("PP_Product_BOM_ID", defaultBOM.getPP_Product_BOM_ID()).execute(this.get_TrxName());
        result = processInfo.getSummary() + (String)level;
        return result;
    }
}

