/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MProduct;
import org.compiere.model.MProductionBatch;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.MProjectPhase;
import org.compiere.model.MProjectTask;
import org.compiere.model.MRefList;
import org.compiere.model.MWarehouse;
import org.compiere.process.ProjectGenerateProductionBatchOrderAbstract;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.wf.MWorkflow;
import org.eevolution.manufacturing.model.MPPProductBOM;

public class ProjectGenerateProductionBatchOrder
extends ProjectGenerateProductionBatchOrderAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        MProject project = new MProject(this.getCtx(), this.getProjectId(), this.get_TrxName());
        if (project.getC_Project_ID() <= 0) {
            throw new AdempiereException("@C_Project@ @NotFound@");
        }
        AtomicReference<Optional<Timestamp>> atomicDateOrdered = new AtomicReference<Optional<Timestamp>>();
        AtomicInteger atomicBOMId = new AtomicInteger(0);
        AtomicInteger atomicWorkflowId = new AtomicInteger(0);
        AtomicReference<MProjectPhase> atomicProjectPhase = new AtomicReference<MProjectPhase>();
        AtomicReference<MProjectTask> atomicProjectTask = new AtomicReference<MProjectTask>();
        AtomicReference<BigDecimal> atomicQuantity = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        MProduct product = null;
        if (this.getProjectLineId() > 0) {
            MProjectLine projectLine = new MProjectLine(this.getCtx(), this.getProjectLineId(), this.get_TrxName());
            if (projectLine.get_ValueAsInt("M_ProductionBatch_ID") > 0) {
                MProductionBatch order = new MProductionBatch(this.getCtx(), projectLine.get_ValueAsInt("M_ProductionBatch_ID"), this.get_TrxName());
                throw new AdempiereException(order.getDocumentInfo() + " @AlreadyExists@ @To@ @C_ProjectLine_ID@");
            }
            product = MProduct.get(this.getCtx(), projectLine.getM_Product_ID());
            this.validProduct(product);
            atomicBOMId.set(this.getProductBOMId() > 0 ? this.getProductBOMId() : MPPProductBOM.getDefault(product, this.get_TrxName()).getPP_Product_BOM_ID());
            atomicWorkflowId.set(this.getWorkflowId() > 0 ? this.getWorkflowId() : MWorkflow.getWorkflowSearchKey(product));
            atomicQuantity.set(projectLine.getPlannedQty());
            projectLine.getProjectPhase().ifPresent(projectPhaseLine -> {
                Optional<Timestamp> dateOrderedOptional = Optional.ofNullable(Optional.ofNullable(projectPhaseLine.getDateStartSchedule()).orElse(project.getDateStartSchedule()));
                atomicProjectPhase.set((MProjectPhase)projectPhaseLine);
                atomicDateOrdered.set(Optional.ofNullable(dateOrderedOptional.orElse(Optional.ofNullable(projectPhaseLine.getStartDate()).orElse(project.getDateStartSchedule()))));
            });
            projectLine.getProjectTask().ifPresent(projectTaskLine -> {
                MProjectPhase projectPhase = (MProjectPhase)projectTaskLine.getC_ProjectPhase();
                atomicProjectTask.set((MProjectTask)projectTaskLine);
                atomicProjectPhase.set(projectPhase);
                Optional<Timestamp> dateOrderedOptional = Optional.ofNullable(Optional.ofNullable(projectTaskLine.getDateStartSchedule()).orElse(Optional.ofNullable(projectPhase.getDateStartSchedule()).orElse(project.getDateStartSchedule())));
                dateOrderedOptional.ifPresent(dateOrdered -> atomicDateOrdered.set(Optional.ofNullable(dateOrdered)));
            });
        } else if (this.getProjectTaskId() > 0) {
            MProjectTask projectTask = new MProjectTask(this.getCtx(), this.getProjectTaskId(), this.get_TrxName());
            if (!"P".equals(projectTask.getProjInvoiceRule())) {
                String errorMessage = "@ProjInvoiceRule@ " + MRefList.getListName(this.getCtx(), 383, "P");
                throw new AdempiereException(errorMessage);
            }
            product = MProduct.get(this.getCtx(), projectTask.getM_Product_ID());
            this.validProduct(product);
            atomicBOMId.set(this.getProductBOMId() > 0 ? this.getProductBOMId() : MPPProductBOM.getDefault(product, this.get_TrxName()).getPP_Product_BOM_ID());
            atomicWorkflowId.set(this.getWorkflowId() > 0 ? this.getWorkflowId() : MWorkflow.getWorkflowSearchKey(product));
            atomicQuantity.set(projectTask.getQty());
            MProjectPhase projectPhase = (MProjectPhase)projectTask.getC_ProjectPhase();
            Optional<Timestamp> dateOrderedPhase = Optional.ofNullable(projectPhase.getDateStartSchedule());
            atomicProjectPhase.set(projectPhase);
            atomicProjectTask.set(projectTask);
            Optional<Timestamp> dateOrderedTask = Optional.ofNullable(projectTask.getDateStartSchedule());
            atomicDateOrdered.set(Optional.ofNullable(dateOrderedTask.orElse(dateOrderedPhase.orElse(project.getDateStartSchedule()))));
        } else if (this.getProjectPhaseId() > 0) {
            MProjectPhase projectPhase = new MProjectPhase(this.getCtx(), this.getProjectPhaseId(), this.get_TrxName());
            if (!"P".equals(projectPhase.getProjInvoiceRule())) {
                String errorMessage = "@ProjInvoiceRule@ " + MRefList.getListName(this.getCtx(), 383, "P");
                throw new AdempiereException(errorMessage);
            }
            product = MProduct.get(this.getCtx(), projectPhase.getM_Product_ID());
            this.validProduct(product);
            atomicBOMId.set(this.getProductBOMId() > 0 ? this.getProductBOMId() : MPPProductBOM.getDefault(product, this.get_TrxName()).getPP_Product_BOM_ID());
            atomicWorkflowId.set(this.getWorkflowId() > 0 ? this.getWorkflowId() : MWorkflow.getWorkflowSearchKey(product));
            atomicQuantity.set(projectPhase.getQty());
            Optional<Timestamp> dateOrderedPhase = Optional.ofNullable(projectPhase.getDateStartSchedule());
            atomicProjectPhase.set(projectPhase);
            atomicDateOrdered.set(Optional.ofNullable(dateOrderedPhase.orElse(Optional.ofNullable(projectPhase.getStartDate()).orElse(project.getDateStartSchedule()))));
        }
        Timestamp dateOrdered = (Timestamp)((Optional)atomicDateOrdered.get()).orElseThrow(() -> new AdempiereException("@DateStartSchedule@ @NotFound@"));
        if (project.getM_Warehouse_ID() == 0) {
            throw new AdempiereException("@M_Warehouse_ID@ @NotFound@");
        }
        MProductionBatch order = this.createOrderProductionBatch(project, Optional.ofNullable((MProjectPhase)atomicProjectPhase.get()), Optional.ofNullable((MProjectTask)atomicProjectTask.get()), Optional.ofNullable(product), atomicBOMId.get(), dateOrdered, atomicQuantity.get());
        this.addLog(Msg.parseTranslation(this.getCtx(), "@M_ProductionBatch_ID@ ") + order.getDocumentInfo());
        return "@Ok@";
    }

    private MProductionBatch createOrderProductionBatch(MProject project, Optional<MProjectPhase> projectPhaseOptional, Optional<MProjectTask> projectTaskOptional, Optional<MProduct> productOptional, Integer bomId, Timestamp dateOrdered, BigDecimal orderdQuantity) throws Exception {
        MProductionBatch order = new MProductionBatch(this.getCtx(), 0, this.get_TrxName());
        order.setMovementDate(dateOrdered);
        order.setQtyOrdered(orderdQuantity);
        order.setTargetQty(orderdQuantity);
        order.setC_Project_ID(project.getC_Project_ID());
        Optional.ofNullable((MWarehouse)project.getM_Warehouse()).ifPresent(warehouse -> order.setM_Locator_ID(MLocator.getDefault(warehouse).getM_Locator_ID()));
        Optional.ofNullable(MDocType.getDocType("MPO")).ifPresent(docTypeID -> order.setC_DocType_ID((int)docTypeID));
        productOptional.ifPresent(product -> order.setM_Product_ID(product.getM_Product_ID()));
        order.setCountOrder(0);
        order.setQtyCompleted(Env.ZERO);
        order.saveEx();
        projectPhaseOptional.ifPresent(projectPhase -> {
            projectPhase.set_ValueOfColumn("M_ProductionBatch_ID", (Object)order.getM_ProductionBatch_ID());
            projectPhase.saveEx();
        });
        projectTaskOptional.ifPresent(projectTask -> {
            projectTask.set_ValueOfColumn("M_ProductionBatch_ID", (Object)order.getM_ProductionBatch_ID());
            projectTask.saveEx();
        });
        order.processIt("CO");
        return order;
    }

    private void validProduct(MProduct product) {
        if (product == null) {
            throw new AdempiereException("@M_Product_ID@ @NotFound@");
        }
        if (!product.isBOM()) {
            throw new AdempiereException("@M_Product_ID@ @IsBOM@ @NotFound@");
        }
    }
}

