/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.List;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.MProjectPhase;
import org.compiere.model.MProjectTask;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProjectGenSOAbstract;

public class ProjectGenSO
extends ProjectGenSOAbstract {
    private MOrder m_Order = null;
    private int m_C_DocType_ID = 0;
    private int m_Lines = 0;
    private MProject m_MProject = null;
    private MProjectPhase m_MProjectPhase = null;
    private MProjectTask m_MProjectTask = null;
    private MProjectLine m_MProjectLine = null;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getTable_ID() == MProject.Table_ID) {
            this.m_MProject = new MProject(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        } else if (this.getTable_ID() == MProjectPhase.Table_ID) {
            this.m_MProjectPhase = new MProjectPhase(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
            this.m_MProject = new MProject(this.getCtx(), this.m_MProjectPhase.getC_Project_ID(), this.get_TrxName());
        } else if (this.getTable_ID() == MProjectTask.Table_ID) {
            this.m_MProjectTask = new MProjectTask(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
            this.m_MProjectPhase = new MProjectPhase(this.getCtx(), this.m_MProjectTask.getC_ProjectPhase_ID(), this.get_TrxName());
            this.m_MProject = new MProject(this.getCtx(), this.m_MProjectPhase.getC_Project_ID(), this.get_TrxName());
        } else if (this.getTable_ID() == MProjectLine.Table_ID) {
            this.m_MProjectLine = new MProjectLine(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
            if (this.m_MProjectLine.getC_ProjectTask_ID() != 0) {
                this.m_MProjectTask = new MProjectTask(this.getCtx(), this.m_MProjectLine.getC_ProjectTask_ID(), this.get_TrxName());
            }
            if (this.m_MProjectLine.getC_ProjectPhase_ID() != 0) {
                this.m_MProjectPhase = new MProjectPhase(this.getCtx(), this.m_MProjectLine.getC_ProjectPhase_ID(), this.get_TrxName());
            }
            if (this.m_MProjectLine.getC_Project_ID() != 0) {
                this.m_MProject = new MProject(this.getCtx(), this.m_MProjectLine.getC_Project_ID(), this.get_TrxName());
            }
        }
        this.m_C_DocType_ID = this.getDocTypeId();
    }

    @Override
    protected String doIt() throws Exception {
        Object retValue = "";
        retValue = this.createOrderHeader();
        if (((String)retValue).equals("")) {
            if (this.m_MProjectLine != null) {
                retValue = this.processProjectLines(this.m_MProjectLine);
            } else if (this.m_MProjectTask != null) {
                retValue = this.processProjectTask(this.m_MProjectTask);
            } else if (this.m_MProjectPhase != null) {
                retValue = this.processProjectPhase(this.m_MProjectPhase);
            } else if (this.m_MProject != null) {
                retValue = this.processProject(this.m_MProject);
            }
            if (this.m_Lines == 0) {
                this.rollback();
            } else {
                retValue = "@Generated@ @C_Order_ID@ " + this.m_Order.getDocumentNo();
            }
        }
        return retValue;
    }

    private String processProject(MProject project) {
        Object retValue;
        block4: {
            block3: {
                retValue = "";
                if (!project.getProjectLineLevel().equals("P")) break block3;
                List<MProjectLine> pLines = project.getLines();
                if (pLines.size() <= 0) break block4;
                for (MProjectLine mProjectLine : pLines) {
                    retValue = (String)retValue + this.processProjectLines(mProjectLine);
                }
                break block4;
            }
            List<MProjectPhase> lPhases = this.getPhases();
            if (lPhases.size() > 0) {
                for (MProjectPhase mProjectPhase : lPhases) {
                    retValue = (String)retValue + this.processProjectPhase(mProjectPhase);
                }
            }
        }
        return retValue;
    }

    private String processProjectPhase(MProjectPhase mProjectPhase) {
        Object retValue = "";
        if (mProjectPhase.getC_ProjectPhase_ID() != 0) {
            if (mProjectPhase.getM_Product_ID() != 0) {
                MProduct product = (MProduct)mProjectPhase.getM_Product();
                retValue = this.createOrderLine(product, mProjectPhase.getQty(), mProjectPhase);
            }
            List<MProjectTask> pTasks = this.getTasks(mProjectPhase);
            for (MProjectTask mProjectTask : pTasks) {
                retValue = (String)retValue + this.processProjectTask(mProjectTask);
            }
        }
        return retValue;
    }

    private String processProjectTask(MProjectTask pTask) {
        String retValue = "";
        if (pTask.getC_ProjectTask_ID() != 0 && pTask.getM_Product_ID() != 0) {
            MProduct product = (MProduct)pTask.getM_Product();
            retValue = this.createOrderLine(product, pTask.getQty(), pTask);
        }
        return retValue;
    }

    private String processProjectLines(MProjectLine projectLine) {
        this.log.info("doIt - " + projectLine);
        if (projectLine.getM_Product_ID() == 0) {
            return "@NotFound@ @M_Product_ID@";
        }
        MProduct product = (MProduct)projectLine.getM_Product();
        return this.createOrderLine(product, projectLine.getPlannedQty(), projectLine);
    }

    private String createOrderHeader() {
        if (this.m_C_DocType_ID == 0) {
            return "@Invalid@ @C_DocType_ID@";
        }
        MDocType docType = new MDocType(this.getCtx(), this.m_C_DocType_ID, this.get_TrxName());
        this.m_Order = new MOrder(this.m_MProject, true, docType.getDocSubTypeSO());
        if (!this.m_Order.save()) {
            return "@SaveError@ @C_Order_ID@";
        }
        return "";
    }

    private String createOrderLine(MProduct product, BigDecimal Qty, PO entity) {
        if (this.m_Order == null || this.m_Order.getC_Order_ID() == 0) {
            return "@Invalid@ @C_Order_ID@";
        }
        MOrderLine line = new MOrderLine(this.m_Order);
        line.setM_Product_ID(product.getM_Product_ID());
        line.setC_Project_ID(this.m_MProject.getC_Project_ID());
        if (entity instanceof MProjectPhase) {
            line.setC_ProjectPhase_ID(entity.get_ID());
        } else if (entity instanceof MProjectTask) {
            line.setC_ProjectPhase_ID(entity.get_ValueAsInt("C_ProjectPhase_ID"));
            line.setC_ProjectTask_ID(entity.get_ID());
        }
        line.setQty(Qty);
        if (!line.save()) {
            return "@SaveError@ @C_OrderLine_ID@";
        }
        ++this.m_Lines;
        return "";
    }

    public List<MProjectPhase> getPhases() {
        String whereClause = "C_Project_ID=? AND NOT EXISTS (SELECT 1 FROM C_Order o INNER JOIN C_OrderLine ol ON (o.C_Order_ID = ol.C_Order_ID) WHERE ol.C_ProjectPhase_ID = C_ProjectPhase.C_ProjectPhase_ID AND ol.C_ProjectTask_ID IS NULL AND o.DocStatus IN ('CO','CL','DR','IP') )";
        return new Query(this.getCtx(), "C_ProjectPhase", "C_Project_ID=? AND NOT EXISTS (SELECT 1 FROM C_Order o INNER JOIN C_OrderLine ol ON (o.C_Order_ID = ol.C_Order_ID) WHERE ol.C_ProjectPhase_ID = C_ProjectPhase.C_ProjectPhase_ID AND ol.C_ProjectTask_ID IS NULL AND o.DocStatus IN ('CO','CL','DR','IP') )", this.get_TrxName()).setParameters(this.m_MProject.getC_Project_ID()).setOrderBy("SeqNo").list();
    }

    public List<MProjectTask> getTasks(MProjectPhase phase) {
        return new Query(this.getCtx(), "C_ProjectTask", "C_ProjectPhase_ID=?AND NOT EXISTS (SELECT 1 FROM C_Order o INNER JOIN C_OrderLine ol ON (o.C_Order_ID = ol.C_Order_ID) WHERE ol.C_ProjectTask_ID = C_ProjectTask.C_ProjectTask_ID AND o.DocStatus IN ('CO','CL','DR','IP') )", this.get_TrxName()).setClient_ID().setParameters(phase.getC_ProjectPhase_ID()).setOrderBy("SeqNo").list();
    }
}

