/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoLog;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class ProcessInfoUtil {
    private static CLogger s_log = CLogger.getCLogger(ProcessInfoUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setSummaryFromDB(ProcessInfo pi) {
        sleepTime = 2000;
        noRetry = 5;
        sql = "SELECT Result, ErrorMsg FROM AD_PInstance WHERE AD_PInstance_ID=? AND Result IS NOT NULL";
        pstmt = null;
        rs = null;
        try {
            pstmt = DB.prepareStatement(sql, 1003, 1007, null);
            noTry = 0;
lbl9:
            // 2 sources

            while (noTry < noRetry) {
                pstmt.setInt(1, pi.getAD_PInstance_ID());
                rs = pstmt.executeQuery();
                if (!rs.next()) ** GOTO lbl-1000
                i = rs.getInt(1);
                if (i == 1) {
                    pi.setSummary(Msg.getMsg(Env.getCtx(), "Success"));
                } else {
                    pi.setSummary(Msg.getMsg(Env.getCtx(), "Failure"), true);
                }
                Message = rs.getString(2);
                if (Message != null) {
                    pi.addSummary("  (" + Msg.parseTranslation(Env.getCtx(), Message) + ")");
                }
                ** GOTO lbl34
            }
            ** GOTO lbl44
        }
        catch (SQLException e) {
            try {
                ProcessInfoUtil.s_log.log(Level.SEVERE, sql, e);
                pi.setSummary(e.getLocalizedMessage(), true);
            }
            catch (Throwable var9_11) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw var9_11;
            }
lbl34:
            // 1 sources

            DB.close(rs, pstmt);
            return;
lbl-1000:
            // 1 sources

            {
                try {
                    ProcessInfoUtil.s_log.fine("sleeping");
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException ie) {
                    ProcessInfoUtil.s_log.log(Level.SEVERE, "Sleep Thread", ie);
                }
                ++noTry;
                ** GOTO lbl9
            }
lbl44:
            // 1 sources

            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            pi.setSummary(Msg.getMsg(Env.getCtx(), "Timeout"), true);
            return;
            DB.close(rs, pstmt);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogFromDB(ProcessInfo pi) {
        if (pi.getLogList() != null && pi.getLogList().size() > 0) {
            return;
        }
        String sql = "SELECT AD_PInstance_Log_ID, P_ID, P_Date, P_Number, P_Msg FROM AD_PInstance_Log WHERE AD_PInstance_ID=? ORDER BY AD_PInstance_Log_ID";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, pi.getAD_PInstance_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                pi.addLog(rs.getInt(1), rs.getInt(2), rs.getTimestamp(3), rs.getBigDecimal(4), rs.getString(5));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, "setLogFromDB", e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }

    public static void saveLogToDB(ProcessInfo pi) {
        ProcessInfoLog[] logs = pi.getLogs();
        if (logs == null || logs.length == 0) {
            return;
        }
        if (pi.getAD_PInstance_ID() == 0) {
            return;
        }
        for (int i2 = 0; i2 < logs.length; ++i2) {
            StringBuffer sql = new StringBuffer("INSERT INTO AD_PInstance_Log (AD_PInstance_ID, AD_PInstance_Log_ID, P_Date, P_ID, P_Number, P_Msg) VALUES (");
            sql.append(pi.getAD_PInstance_ID()).append(",").append(logs[i2].getLog_ID()).append(",");
            if (logs[i2].getP_Date() == null) {
                sql.append("NULL,");
            } else {
                sql.append(DB.TO_DATE(logs[i2].getP_Date(), false)).append(",");
            }
            if (logs[i2].getP_ID() == 0) {
                sql.append("NULL,");
            } else {
                sql.append(logs[i2].getP_ID()).append(",");
            }
            if (logs[i2].getP_Number() == null) {
                sql.append("NULL,");
            } else {
                sql.append(logs[i2].getP_Number()).append(",");
            }
            if (logs[i2].getP_Msg() == null) {
                sql.append("NULL)");
            } else {
                sql.append(DB.TO_STRING(logs[i2].getP_Msg(), 2000)).append(")");
            }
            DB.executeUpdate(sql.toString(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setParameterFromDB(ProcessInfo pi) {
        ArrayList<ProcessInfoParameter> list = new ArrayList<ProcessInfoParameter>();
        String sql = "SELECT p.ParameterName, p.P_String,p.P_String_To, p.P_Number,p.P_Number_To, p.P_Date,p.P_Date_To, p.Info,p.Info_To,  i.AD_Client_ID, i.AD_Org_ID, i.AD_User_ID FROM AD_PInstance_Para p INNER JOIN AD_PInstance i ON (p.AD_PInstance_ID=i.AD_PInstance_ID) WHERE p.AD_PInstance_ID=? ORDER BY p.SeqNo";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, pi.getAD_PInstance_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String ParameterName = rs.getString(1);
                Object Parameter2 = rs.getString(2);
                Object Parameter_To = rs.getString(3);
                if (Parameter2 == null && Parameter_To == null) {
                    Parameter2 = rs.getBigDecimal(4);
                    Parameter_To = rs.getBigDecimal(5);
                }
                if (Parameter2 == null && Parameter_To == null) {
                    Parameter2 = rs.getTimestamp(6);
                    Parameter_To = rs.getTimestamp(7);
                }
                String Info2 = rs.getString(8);
                String Info_To = rs.getString(9);
                list.add(new ProcessInfoParameter(ParameterName, Parameter2, Parameter_To, Info2, Info_To));
                if ("Selection".equals(ParameterName) && Parameter2 != null && "Y".equals(Parameter2)) {
                    pi.setIsSelection(true);
                }
                if (pi.getAD_Client_ID() == null) {
                    pi.setAD_Client_ID(rs.getInt(10));
                }
                if (pi.getAD_User_ID() != null) continue;
                pi.setAD_User_ID(rs.getInt(12));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        ProcessInfoParameter[] pars = new ProcessInfoParameter[list.size()];
        list.toArray(pars);
        pi.setParameter(pars);
    }
}

