/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInvoice;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionLine;
import org.compiere.model.MUser;
import org.compiere.process.PSCreateFromInvoiceAbstract;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class PSCreateFromInvoice
extends PSCreateFromInvoiceAbstract {
    private int seqNo = 10;
    private boolean isNew = false;
    private MPaySelection paymentSelection = null;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() <= 0 && this.getBankAccountId() == 0 && this.getPayDate() == null) {
            throw new AdempiereException("@C_PaySelection_ID@ @NotFound@");
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.getRecord_ID() > 0) {
            this.paymentSelection = new MPaySelection(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
            this.seqNo = this.paymentSelection.getLastLineNo();
        } else {
            this.paymentSelection = new MPaySelection(this.getCtx(), 0, this.get_TrxName());
            this.paymentSelection.setC_BankAccount_ID(this.getBankAccountId());
            this.paymentSelection.setDateDoc(this.getDateDoc());
            this.paymentSelection.setPayDate(this.getPayDate());
            if (this.getDocTypeTargetId() > 0) {
                this.paymentSelection.setC_DocType_ID(this.getDocTypeTargetId());
            }
            MUser user = MUser.get(this.getCtx(), this.getAD_User_ID());
            String userName = "";
            if (user != null) {
                userName = user.getName();
            }
            this.paymentSelection.setDescription(Msg.getMsg(Env.getCtx(), "VPaySelect") + " - " + userName + " - " + DisplayType.getDateFormat(15).format(this.getPayDate()));
            this.paymentSelection.saveEx();
            this.isNew = true;
        }
        for (Integer key : this.getSelectionKeys()) {
            int C_Invoice_ID = key;
            int C_InvoicePaySchedule_ID = this.getSelectionAsInt(key, "INV_C_InvoicePaySchedule_ID");
            String PaymentRule = this.getSelectionAsString(key, "INV_PaymentRule");
            BigDecimal AmtSource = this.getSelectionAsBigDecimal(key, "INV_AmtSource");
            BigDecimal OpenAmt = this.getSelectionAsBigDecimal(key, "INV_OpenAmt");
            BigDecimal PayAmt = this.getSelectionAsBigDecimal(key, "INV_PayAmt");
            BigDecimal DiscountAmt = this.getSelectionAsBigDecimal(key, "INV_DiscountAmt");
            this.seqNo += 10;
            MPaySelectionLine line = new MPaySelectionLine(this.paymentSelection, this.seqNo, PaymentRule);
            MInvoice invoice = new MInvoice(this.getCtx(), C_Invoice_ID, this.get_TrxName());
            if (invoice.isInDispute()) {
                throw new AdempiereException("ERROR: El documento " + invoice.getDocumentNo() + " se encuentra EN NEGOCIACION");
            }
            line.setInvoice(C_Invoice_ID, C_InvoicePaySchedule_ID, AmtSource, OpenAmt, PayAmt, DiscountAmt);
            line.saveEx();
        }
        if (this.isNew) {
            this.paymentSelection.load(this.get_TrxName());
            if (!this.paymentSelection.processIt("CO")) {
                throw new AdempiereException("@Error@ " + this.paymentSelection.getProcessMsg());
            }
            this.paymentSelection.saveEx();
            return this.paymentSelection.getDescription();
        }
        return "@OK@";
    }
}

