/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.process.OrderLineCreateShipmentAbstract;
import org.compiere.util.Env;

public class OrderLineCreateShipment
extends OrderLineCreateShipmentAbstract {
    @Override
    protected void prepare() {
        super.prepare();
        if (this.getMovementDate() == null) {
            this.setMovementDate(Env.getContextAsDate(this.getCtx(), "#Date"));
            if (this.getMovementDate() == null) {
                this.setMovementDate(new Timestamp(System.currentTimeMillis()));
            }
        }
        if (this.getDocAction() == null) {
            this.setDocAction("CO");
        } else if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("PR");
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("C_OrderLine_ID=" + this.getRecord_ID());
        if (this.getRecord_ID() == 0) {
            throw new IllegalArgumentException("@C_OrderLine_ID@ @NotFound@");
        }
        MOrderLine line = new MOrderLine(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (line.get_ID() == 0) {
            throw new IllegalArgumentException("@C_OrderLine_ID@ @NotFound@");
        }
        MOrder order = new MOrder(this.getCtx(), line.getC_Order_ID(), this.get_TrxName());
        if (!"CO".equals(order.getDocStatus())) {
            throw new IllegalArgumentException("@CreateShipment.OrderNotCompleted@");
        }
        if (line.getQtyOrdered().subtract(line.getQtyDelivered()).compareTo(Env.ZERO) <= 0) {
            return "@CreateShipment.LineShipped@";
        }
        MInOut shipment = new MInOut(order, this.getDocTypeId(), this.getMovementDate());
        shipment.setM_Warehouse_ID(line.getM_Warehouse_ID());
        shipment.setMovementDate(line.getDatePromised());
        shipment.saveEx();
        BigDecimal qtyToDeliver = line.getQtyOrdered().subtract(line.getQtyDelivered());
        MInOutLine sline = new MInOutLine(shipment);
        sline.setOrderLine(line, 0, qtyToDeliver);
        sline.setQtyEntered(qtyToDeliver);
        sline.setC_UOM_ID(line.getC_UOM_ID());
        sline.setQty(qtyToDeliver);
        sline.setM_Warehouse_ID(line.getM_Warehouse_ID());
        sline.saveEx();
        if (!shipment.processIt(this.getDocAction())) {
            this.log.warning("Failed: " + shipment);
        }
        shipment.saveEx();
        return "@M_InOut_ID@ @Created@: " + shipment.getDocumentNo();
    }
}

