/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.openup.LUY.model.MLUYCFEType;
import org.openup.core.model.MAllocInvoice;

public class InOutCreateInvoice
extends SvrProcess {
    private int p_M_InOut_ID = 0;
    private int p_M_PriceList_ID = 0;
    private String p_InvoiceDocumentNo = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("M_PriceList_ID")) {
                this.p_M_PriceList_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("InvoiceDocumentNo")) {
                this.p_InvoiceDocumentNo = (String)para[i].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_M_InOut_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("M_InOut_ID=" + this.p_M_InOut_ID + ", M_PriceList_ID=" + this.p_M_PriceList_ID + ", InvoiceDocumentNo=" + this.p_InvoiceDocumentNo);
        if (this.p_M_InOut_ID == 0) {
            throw new IllegalArgumentException("No Shipment");
        }
        MInOut ship = new MInOut(this.getCtx(), this.p_M_InOut_ID, this.get_TrxName());
        if (ship.get_ID() == 0) {
            throw new IllegalArgumentException("Shipment not found");
        }
        if (!"CO".equals(ship.getDocStatus())) {
            throw new IllegalArgumentException("Shipment not completed");
        }
        MInvoice invoice = new MInvoice(ship, null);
        if (this.p_M_PriceList_ID != 0 && ship.getM_RMA_ID() == 0) {
            invoice.setM_PriceList_ID(this.p_M_PriceList_ID);
        }
        if (this.p_InvoiceDocumentNo != null && this.p_InvoiceDocumentNo.length() > 0) {
            invoice.setDocumentNo(this.p_InvoiceDocumentNo);
        }
        if (invoice.isSOTrx()) {
            MLUYCFEType mLuyCfeType = MLUYCFEType.getDefaultEx(this.getCtx(), invoice.getAD_Org_ID(), invoice.getC_BPartner().getC_TaxGroup_ID(), "ARC", this.get_TrxName());
            invoice.setC_DocTypeTarget_ID(mLuyCfeType.getC_DocType_ID());
        } else {
            int docTypeID = MDocType.getDocType("API", " AND IsDefault = 'Y'");
            invoice.setC_DocTypeTarget_ID(docTypeID);
        }
        if (!invoice.save()) {
            throw new IllegalArgumentException("Cannot save Invoice");
        }
        MInOutLine[] shipLines = ship.getLines(false);
        for (int i = 0; i < shipLines.length; ++i) {
            MInOutLine sLine = shipLines[i];
            MInvoiceLine line = new MInvoiceLine(invoice);
            line.setShipLine(sLine);
            if (sLine.sameOrderLineUOM()) {
                line.setQtyEntered(sLine.getQtyEntered());
            } else {
                line.setQtyEntered(sLine.getMovementQty());
            }
            line.setQtyInvoiced(sLine.getMovementQty());
            if (line.save()) continue;
            throw new IllegalArgumentException("Cannot save Invoice Line");
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String sqlStr = "SELECT o_i.C_Invoice_ID\nFROM C_Invoice inv\nJOIN C_InvoiceLine invL ON inv.C_Invoice_ID=invL.C_Invoice_ID\nJOIN C_OrderLine oL ON invL.C_OrderLine_ID=oL.C_OrderLine_ID\nJOIN M_InOutLine ioL ON oL.C_OrderLine_ID=ioL.C_OrderLine_ID\nJOIN M_RMALine rmaL ON ioL.M_RMALine_ID=rmaL.M_RMALine_ID\nJOIN M_RMA rma ON rmaL.M_RMA_ID=rma.M_RMA_ID\nJOIN M_InOutLine o_ioL ON rmaL.M_InOutLine_ID=o_ioL.M_InOutLine_ID\nJOIN M_InOut o_io ON o_ioL.M_InOut_ID=o_io.M_InOut_ID\nJOIN C_OrderLine o_oL ON o_ioL.C_OrderLine_ID=o_oL.C_OrderLine_ID\nJOIN C_Order o_o ON o_oL.C_Order_ID=o_o.C_Order_ID\nJOIN C_InvoiceLine o_iL ON o_il.C_OrderLine_ID=o_oL.C_OrderLine_ID AND o_iL.C_InvoiceLine_ID<>invL.C_InvoiceLIne_ID\nJOIN C_Invoice o_i ON o_il.C_Invoice_ID=o_i.C_Invoice_ID\n\nWHERE rma.docStatus IN ('CO','CL')\nAND o_io.docStatus IN ('CO','CL')\nAND o_o.docStatus IN ('CO','CL')\nAND o_i.docStatus IN ('CO','CL')\nAND inv.C_Invoice_ID=" + invoice.get_ID() + "\nGROUP BY o_i.C_Invoice_ID";
            pstmt = DB.prepareStatement(sqlStr, this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MInvoice originalInvoice = new MInvoice(this.getCtx(), rs.getInt("C_Invoice_ID"), this.get_TrxName());
                MAllocInvoice link = new MAllocInvoice(originalInvoice, invoice, false);
                link.setFromProcess(true);
                link.saveEx();
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        return invoice.getDocumentNo();
    }
}

