/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MSequence;
import org.compiere.model.MSequenceCtl;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;

public class GenerateSequenceLines
extends SvrProcess {
    private MSequence model = null;

    @Override
    protected void prepare() {
        this.model = new MSequence(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
    }

    @Override
    protected String doIt() throws Exception {
        int start = this.model.getStartNo();
        int end = this.model.get_ValueAsInt("EndNo");
        String prefijo = this.model.getPrefix();
        String sufijo = this.model.getSuffix();
        int seqNo = 10;
        try {
            this.deleteOldData();
            for (int i = start; i <= end; ++i) {
                Object docNo = String.valueOf(i);
                MSequenceCtl line = new MSequenceCtl(this.getCtx(), 0, this.get_TrxName());
                line.setAD_Sequence_ID(this.model.get_ID());
                line.setSeqNo(seqNo);
                line.setIsApply(false);
                if (prefijo != null && !prefijo.equalsIgnoreCase("")) {
                    docNo = prefijo + (String)docNo;
                }
                if (sufijo != null && !sufijo.equalsIgnoreCase("")) {
                    docNo = (String)docNo + sufijo;
                }
                line.setDocumentNo((String)docNo);
                line.saveEx();
                seqNo += 10;
            }
        }
        catch (Exception e) {
            throw new AdempiereException(e.getMessage());
        }
        return "OK";
    }

    private void deleteOldData() {
        List<MSequenceCtl> lines = this.model.getControlLines("and isapply = 'Y'");
        if (lines.size() > 0) {
            throw new AdempiereException("Imposible borrar, existen lineas con documentos emitidos");
        }
        DB.executeUpdateEx("delete from ad_sequencectl where ad_sequence_id = " + this.model.get_ID(), this.get_TrxName());
    }
}

