/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.Adempiere;
import org.compiere.acct.Doc;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MDiscountSchema;
import org.compiere.model.MPeriod;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.process.GardenWorldCleanupAbstract;
import org.compiere.util.CLogMgt;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.eevolution.services.dsl.ProcessBuilder;

public class GardenWorldCleanup
extends GardenWorldCleanupAbstract {
    private static final int GARDEN_WORLD_CLIENT_ID = 11;
    static final int DESIRED_MIN_YEAR_OFFSET = 2;
    static final String SUCCESS_MSG = "GardenWorldCleanup:Success";
    static final String NO_CHANGES_MSG = "GardenWorldCleanup:No_changes_required";
    static final String CLIENT_NOT_FOUND_MSG = "GardenWorldCleanup:Client_not_found";
    private Timestamp currentDate = TimeUtil.getDay(System.currentTimeMillis());
    private Timestamp minPeriodDate = null;
    private Timestamp maxPeriodDate = null;
    private int periodYearOffset = 0;
    private int docMonthOffset = 0;
    private String dateColumnSQL = " SELECT t.tablename,c.ColumnName FROM AD_Column c  JOIN AD_Table t ON c.AD_Table_ID=t.AD_Table_ID  JOIN AD_Reference r ON     (c.AD_Reference_ID = r.AD_Reference_ID)  JOIN (SELECT nc.AD_Table_ID        FROM AD_Table nc JOIN AD_Column c        ON (nc.AD_Table_ID = c.AD_Table_ID)      WHERE c.ColumnName = 'AD_Client_ID') nc    ON (nc.AD_Table_ID = t.AD_Table_ID)  WHERE r.validationtype='D' AND r.name IN ('Date','DateTime')  AND c.columnsql IS NULL  AND c.columnName NOT IN ('Created','Updated')  AND upper(t.tableName) NOT LIKE 'I_%' AND upper(t.tableName) NOT LIKE 'T_%'  AND upper(t.tableName) NOT LIKE 'RV%'  AND upper(t.tableName) != 'AD_SESSION'  AND t.tableName <> 'C_Period'  AND t.isview='N' AND t.EntityType='D'";
    private String sqlOrderBy = " ORDER BY t.tablename";
    private Timestamp minDocDate;
    private Timestamp maxDocDate;

    public static void main(String[] args) {
        CLogMgt.setLevel(Level.INFO);
        Adempiere.startupEnvironment(false);
        if (!DB.isConnected()) {
            System.exit(1);
        }
        Properties context = Env.getCtx();
        try {
            ProcessBuilder.create(context).process(GardenWorldCleanup.class).withTitle("Updating Garden World").executeUsingSystemRole();
        }
        catch (AdempiereException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    void closePreparedStatement(PreparedStatement pstm) {
        DB.close(pstm);
    }

    String findDateColumnAssociatedWithPeriod(MTable table2) {
        MColumn column;
        String tableName = table2.getTableName();
        if (this.isTableKnownToHavePeriodButNoDate(tableName)) {
            return null;
        }
        String dateAcctColumn = this.getDateAcctColumnName(tableName);
        if (dateAcctColumn == null && (column = table2.getColumn("DateAcct")) != null) {
            dateAcctColumn = "DateAcct";
        }
        if (dateAcctColumn == null) {
            this.log.warning(tableName + " has C_Period_ID but the date field associated with it is unknown. Check the table to see if there is a spefic date and update the " + this.getClass().getCanonicalName() + " class to be able to find it");
        }
        return dateAcctColumn;
    }

    void findDateLimitsForDocument(String tableName) {
        String dateAcctColumn = this.getDateAcctColumnName(tableName);
        if (dateAcctColumn != null) {
            this.setMinMaxDocDate(tableName, dateAcctColumn);
        }
    }

    void findDocDateLimits() {
        this.minDocDate = null;
        this.maxDocDate = null;
        CPreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            pstm = this.getPreparedStatement(this.dateColumnSQL + this.sqlOrderBy, this.get_TrxName());
            rs = pstm.executeQuery();
            String tableName = null;
            while (rs.next()) {
                tableName = rs.getString(1);
                this.findDateLimitsForDocument(tableName);
            }
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, e.getLocalizedMessage());
                throw new AdempiereException("", e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstm);
                throw throwable;
            }
        }
        DB.close(rs, pstm);
    }

    String getDateAcctColumnName(String tableName) {
        return Doc.getDateAcctColumnName(tableName);
    }

    int getDocMonthOffset() {
        return this.docMonthOffset;
    }

    CPreparedStatement getPreparedStatement(String sql, String trxName) {
        return DB.prepareStatement(sql, trxName);
    }

    Query getQuery(Properties ctx, String tableName, String whereClause, String trxName) {
        return new Query(ctx, tableName, whereClause, trxName);
    }

    Timestamp getMaxPeriodEndDate() {
        return MPeriod.getMaxPeriodEndDate(this.getCtx(), 11, 0, this.get_TrxName());
    }

    Timestamp getMinPeriodStartDate() {
        return MPeriod.getMinPeriodStartDate(this.getCtx(), 11, 0, this.get_TrxName());
    }

    Timestamp getTargetEarliestPeriodStartDate() {
        return TimeUtil.getDay(this.getTargetStartYear(), 1, 1);
    }

    int getTargetStartYear() {
        Timestamp date = this.currentDate;
        int year = TimeUtil.getYearFromTimestamp(date);
        return year - 2;
    }

    int getYearOffSet() {
        return this.periodYearOffset;
    }

    boolean isTableKnownToHavePeriodButNoDate(String tableName) {
        return tableName.equals("M_ForecastLine");
    }

    boolean isTimeStampNotNullOrZero(Timestamp ts) {
        return ts != null && ts.getTime() != 0L;
    }

    void setCurrentDate(Timestamp currentDate) {
        this.currentDate = currentDate;
    }

    void setDocMonthOffset(int docMonthOffset) {
        this.docMonthOffset = docMonthOffset;
    }

    void setMinMaxDocDate(String tableName, String dateAcctColumn) {
        String sql = "SELECT MIN(" + dateAcctColumn + "), MAX(" + dateAcctColumn + ") from " + tableName + " WHERE AD_Client_ID=11 ";
        this.log.fine("Looking at table/column " + tableName + "/" + dateAcctColumn);
        CPreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            pstm = DB.prepareStatement(sql, this.get_TrxName());
            rs = pstm.executeQuery();
            while (rs.next()) {
                Timestamp minDateValue = rs.getTimestamp(1);
                Timestamp maxDateValue = rs.getTimestamp(2);
                if (this.minDocDate == null) {
                    this.minDocDate = minDateValue;
                }
                if (this.maxDocDate == null) {
                    this.maxDocDate = maxDateValue;
                }
                if (this.isTimeStampNotNullOrZero(minDateValue) && this.minDocDate.after(minDateValue)) {
                    this.minDocDate = minDateValue;
                }
                if (!this.isTimeStampNotNullOrZero(maxDateValue) || maxDateValue.after(this.currentDate) || !this.maxDocDate.before(maxDateValue)) continue;
                this.maxDocDate = maxDateValue;
            }
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, e.getLocalizedMessage());
                throw new AdempiereException("Problem finding the date limits", e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstm);
                throw throwable;
            }
        }
        DB.close(rs, pstm);
    }

    void setYearOffSet(int offSet) {
        this.periodYearOffset = offSet;
    }

    String translate(String message) {
        return Msg.translate(this.getCtx(), message);
    }

    void cleanup_bankStatement() {
        String updateBankStatementSQL = "UPDATE C_BankStatement SET NAME = to_char(StatementDate, 'YYYY-MM-DD') where AD_Client_ID=11";
        DB.executeUpdate(updateBankStatementSQL, this.get_TrxName());
    }

    void cleanup_discountSchema() {
        new Query(this.getCtx(), "M_DiscountSchema", null, this.get_TrxName()).setClient_ID().list(MDiscountSchema.class).stream().forEach(schema -> {
            String name = schema.getName();
            schema.setName(name.substring(0, name.indexOf(" ")) + " " + TimeUtil.getYearFromTimestamp(schema.getValidFrom()));
            schema.saveEx(this.get_TrxName());
        });
    }

    void cleanup_priceListVersions() {
        new Query(this.getCtx(), "M_PriceList_Version", null, this.get_TrxName()).setClient_ID().list(MPriceListVersion.class).stream().forEach(plVersion -> {
            String name = plVersion.getName();
            plVersion.setName(name.substring(0, name.indexOf(" ")) + " " + TimeUtil.getYearFromTimestamp(plVersion.getValidFrom()));
            plVersion.saveEx(this.get_TrxName());
        });
    }

    void updatePeriodFieldsToMatchDates(String tableName) {
        String dateAcctColumn;
        MTable table2 = MTable.get(this.getCtx(), tableName);
        MColumn periodColumn = table2.getColumn("C_Period_ID");
        if (periodColumn != null && (dateAcctColumn = this.findDateColumnAssociatedWithPeriod(table2)) != null) {
            this.log.fine("Table: " + tableName + " dateAcctColumn: " + dateAcctColumn);
            String updatePeriodSql = "update " + tableName + " set  C_Period_ID=(SELECT C_Period_ID from C_Period WHERE " + dateAcctColumn + " BETWEEN StartDate and EndDate and AD_Client_ID=11) WHERE AD_Client_ID=11 AND EXISTS (SELECT C_Period_ID from C_Period WHERE " + dateAcctColumn + " BETWEEN StartDate and EndDate and AD_Client_ID=11)";
            CPreparedStatement pstm = null;
            try {
                pstm = this.getPreparedStatement(updatePeriodSql, this.get_TrxName());
                pstm.executeUpdate();
                this.closePreparedStatement(pstm);
            }
            catch (SQLException e) {
                try {
                    this.log.severe(e.getLocalizedMessage());
                    throw new AdempiereException("Problem in updating periods according to new accounting values. Table: " + tableName + ", DateAcct Column: " + dateAcctColumn, e);
                }
                catch (Throwable throwable) {
                    this.closePreparedStatement(pstm);
                    throw throwable;
                }
            }
        }
    }

    void updateTable(String tableName, String columnName) {
        if (this.docMonthOffset == 0 || tableName.isEmpty() || columnName.isEmpty()) {
            return;
        }
        String sql = "UPDATE " + tableName + " SET  " + columnName + " = trunc(( CASE WHEN add_months(" + columnName + ", " + this.docMonthOffset + ") >= ?         AND add_months(" + columnName + ", " + this.docMonthOffset + ") <= ?         THEN add_months(" + columnName + ", " + this.docMonthOffset + ")      WHEN add_months(" + columnName + ", " + this.docMonthOffset + ") < ?         THEN ?     WHEN add_months(" + columnName + ", " + this.docMonthOffset + ") > ?         THEN ? ELSE " + columnName + " END ), 'DD')  WHERE " + columnName + " IS NOT NULL  AND AD_Client_ID=11";
        CPreparedStatement pstm = null;
        try {
            pstm = DB.prepareStatement(sql, this.get_TrxName());
            pstm.setTimestamp(1, this.minPeriodDate);
            pstm.setTimestamp(2, this.maxPeriodDate);
            pstm.setTimestamp(3, this.minPeriodDate);
            pstm.setTimestamp(4, this.minPeriodDate);
            pstm.setTimestamp(5, this.maxPeriodDate);
            pstm.setTimestamp(6, this.maxPeriodDate);
            pstm.executeUpdate();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, e.getLocalizedMessage());
            throw new AdempiereException("Problem in adding years to date columns", e);
        }
        finally {
            this.closePreparedStatement(pstm);
        }
    }

    boolean gardenWorldDoesNotExist() {
        String whereClause = "AD_Client_ID=?";
        MClient gwClient = (MClient)this.getQuery(this.getCtx(), "AD_Client", "AD_Client_ID=?", null).setParameters(11).first();
        if (gwClient == null) {
            this.log.severe("GardenWorld Client not found!");
        }
        return gwClient == null;
    }

    void clearSessionLog() {
        String whereClientID = " WHERE AD_Client_ID=11";
        DB.executeUpdateEx("DELETE FROM AD_PInstance WHERE AD_Client_ID=11", this.get_TrxName());
        DB.executeUpdateEx("DELETE FROM AD_ChangeLog cl WHERE cl.AD_SESSION_ID IN (SELECT AD_SESSION_ID FROM AD_Session WHERE AD_Client_ID=11)", this.get_TrxName());
    }

    void determinePeriodOffset() {
        Timestamp targetPeriodStart = this.getTargetEarliestPeriodStartDate();
        Timestamp earliestPeriodStart = this.getMinPeriodStartDate();
        this.periodYearOffset = TimeUtil.getYearsBetween(earliestPeriodStart, targetPeriodStart);
        this.minPeriodDate = targetPeriodStart;
        this.maxPeriodDate = TimeUtil.addDuration(this.getMaxPeriodEndDate(), "Y", this.periodYearOffset);
    }

    void determineDocDateOffset() {
        this.findDocDateLimits();
        this.docMonthOffset = this.minDocDate.after(this.minPeriodDate) ? 0 : TimeUtil.getMonthsBetween(this.minDocDate, this.minPeriodDate) + 1;
    }

    protected boolean isSufficentlyUpToDate() {
        return this.periodYearOffset == 0 && this.docMonthOffset == 0;
    }

    protected void adjustCalendarYearAndPeriods() {
        if (this.periodYearOffset == 0) {
            return;
        }
        int monthOffset = this.periodYearOffset * 12;
        String whereADClientIDClause = " WHERE ad_client_id=11";
        String updatePeriod = "UPDATE C_Period SET StartDate = add_months(Startdate, " + monthOffset + "),    EndDate = add_months(Enddate, " + monthOffset + "),    Name = to_char(add_months(Enddate, " + monthOffset + "),'YYYY-MM')  WHERE ad_client_id=11";
        DB.executeUpdate(updatePeriod, this.get_TrxName());
        String updateYear = "UPDATE C_Year SET fiscalyear=(SELECT max(to_char(p.enddate,'YYYY-MM'))  FROM c_period p where p.c_year_id=c_year.c_year_id)  WHERE ad_client_id=11";
        DB.executeUpdate(updateYear, this.get_TrxName());
        updateYear = "UPDATE C_Year SET fiscalyear=(SELECT max(to_char(p.enddate,'YYYY'))  FROM c_period p where p.c_year_id=c_year.c_year_id)  WHERE ad_client_id=11";
        DB.executeUpdate(updateYear, this.get_TrxName());
    }

    protected void updateDates() {
        CPreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            pstm = this.getPreparedStatement(this.dateColumnSQL + this.sqlOrderBy, this.get_TrxName());
            rs = pstm.executeQuery();
            String tableName = null;
            String columnName = null;
            while (rs.next()) {
                tableName = rs.getString(1);
                columnName = rs.getString(2);
                this.updateTable(tableName, columnName);
            }
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, e.getLocalizedMessage());
                throw new AdempiereException("", e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstm);
                throw throwable;
            }
        }
        DB.close(rs, pstm);
    }

    protected void updatePeriods() {
        CPreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            pstm = DB.prepareStatement(this.dateColumnSQL + this.sqlOrderBy, this.get_TrxName());
            rs = pstm.executeQuery();
            String tableName = null;
            while (rs.next()) {
                tableName = rs.getString(1);
                this.updatePeriodFieldsToMatchDates(tableName);
            }
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, e.getLocalizedMessage());
                throw new AdempiereException("", e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstm);
                throw throwable;
            }
        }
        DB.close(rs, pstm);
    }

    protected void cleanUp() {
        this.cleanup_priceListVersions();
        this.cleanup_bankStatement();
        this.cleanup_discountSchema();
    }

    protected String reportResults(String message) {
        this.findDocDateLimits();
        this.log.info("Document Dates min/max = " + this.minDocDate + "/" + this.maxDocDate);
        this.log.info("Period dates min/max =" + this.getMinPeriodStartDate() + "/" + this.getMaxPeriodEndDate());
        this.log.info(this.translate(message));
        return Msg.wrapMsg(message);
    }

    @Override
    protected String doIt() {
        if (this.gardenWorldDoesNotExist()) {
            return Msg.wrapMsg("ERROR") + " " + Msg.wrapMsg(CLIENT_NOT_FOUND_MSG);
        }
        this.clearSessionLog();
        this.determinePeriodOffset();
        this.determineDocDateOffset();
        if (this.isSufficentlyUpToDate()) {
            return this.reportResults(NO_CHANGES_MSG);
        }
        this.adjustCalendarYearAndPeriods();
        this.updateDates();
        this.updatePeriods();
        this.cleanUp();
        return this.reportResults(SUCCESS_MSG);
    }
}

