/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.adempiere.core.domains.models.I_A_Asset_Addition;
import org.adempiere.core.domains.models.I_A_Asset_Disposed;
import org.adempiere.core.domains.models.I_A_Depreciation_Entry;
import org.adempiere.core.domains.models.I_DD_Order;
import org.adempiere.core.domains.models.I_HR_Process;
import org.adempiere.core.domains.models.X_M_Production;
import org.adempiere.core.domains.models.X_M_ProductionBatch;
import org.adempiere.core.domains.models.X_PP_Cost_Collector;
import org.adempiere.core.domains.models.X_PP_Order;
import org.compiere.acct.Doc;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MBankStatement;
import org.compiere.model.MCash;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MInventory;
import org.compiere.model.MInvoice;
import org.compiere.model.MJournal;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MMovement;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.MProjectIssue;
import org.compiere.model.MRequisition;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.process.FactAcctResetAbstract;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;

public class FactAcctReset
extends FactAcctResetAbstract {
    private int countReset = 0;
    private int countDelete = 0;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() {
        Optional.ofNullable(MClient.get(this.getCtx(), this.getAD_Client_ID()).getAcctSchema()).ifPresent(accountingSchemaDefault -> Arrays.stream(this.getAccountingDocumentTablesIds()).forEach(tableId -> {
            MTable table2 = MTable.get(this.getCtx(), tableId);
            if (this.isDeletePosting()) {
                this.delete((MAcctSchema)accountingSchemaDefault, table2);
            } else {
                this.reset((MAcctSchema)accountingSchemaDefault, table2);
            }
        }));
        return "@Updated@ = " + this.countReset + ", @Deleted@ = " + this.countDelete;
    }

    private int[] getAccountingDocumentTablesIds() {
        StringBuilder whereClause = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>();
        whereClause.append("AD_Table").append(".").append("IsView").append("=? ");
        parameters.add("N");
        if (this.getTableId() > 0) {
            whereClause.append(" AND ").append("AD_Table").append(".").append("AD_Table_ID").append("=?");
            parameters.add(this.getTableId());
        }
        whereClause.append(" AND EXISTS (SELECT 1 FROM ").append("AD_Column").append(" WHERE ").append("AD_Table").append(".").append("AD_Table_ID").append("=").append("AD_Column").append(".").append("AD_Table_ID").append(" AND ").append("AD_Column").append(".").append("ColumnName").append("=? AND ").append("AD_Column").append(".").append("IsActive").append("=?)");
        parameters.add("Posted");
        parameters.add("Y");
        return new Query(this.getCtx(), "AD_Table", whereClause.toString(), this.get_TrxName()).setParameters(parameters).getIDs();
    }

    private void reset(MAcctSchema accountingSchemaDefault, MTable accountingDocumentTable) {
        Timestamp today = TimeUtil.trunc(new Timestamp(System.currentTimeMillis()), "D");
        if (accountingSchemaDefault.isAutoPeriodControl()) {
            Timestamp temp = TimeUtil.addDays(today, -accountingSchemaDefault.getPeriod_OpenHistory());
            if (this.getDateAcct() == null || this.getDateAcct().before(temp)) {
                this.setDateAcct(temp);
                this.log.info("DateAcct From set to: " + this.getDateAcct());
            }
            temp = TimeUtil.addDays(today, accountingSchemaDefault.getPeriod_OpenFuture());
            if (this.getDateAcctTo() == null || this.getDateAcctTo().after(temp)) {
                this.setDateAcctTo(temp);
                this.log.info("DateAcct To set to: " + this.getDateAcctTo());
            }
        }
        String docBaseType = this.getDocumentBaseType(accountingDocumentTable.get_ID(), accountingDocumentTable.getTableName());
        String dateAccountingColumn = this.getDateAcct(accountingDocumentTable.get_ID());
        StringBuilder resetProcessing = new StringBuilder();
        resetProcessing.append("UPDATE ").append(accountingDocumentTable.getTableName()).append(" SET Processing='N' WHERE AD_Client_ID=").append(this.getClientId()).append(" AND (Processing<>'N' OR Processing IS NULL)");
        AtomicInteger unlocked = new AtomicInteger(0);
        Trx.run(trxName -> unlocked.set(DB.executeUpdate(resetProcessing.toString(), trxName)));
        StringBuilder resetUpdate = new StringBuilder();
        resetUpdate.append("UPDATE ").append(accountingDocumentTable.getTableName()).append(" SET Posted='N' WHERE AD_Client_ID=").append(this.getClientId()).append(" AND (Posted NOT IN ('Y','N') OR Posted IS NULL) ");
        resetUpdate.append(" AND EXISTS (SELECT 1 FROM  C_Period p INNER JOIN C_PeriodControl pc ON (p.C_Period_ID=pc.C_Period_ID) WHERE");
        resetUpdate.append(" p.AD_Client_ID=").append(this.getClientId()).append(" AND ");
        resetUpdate.append(dateAccountingColumn).append(" >= p.StartDate AND ").append(dateAccountingColumn).append(" <= p.EndDate ");
        resetUpdate.append(" AND pc.PeriodStatus = 'O' AND pc.DocBaseType ").append(docBaseType);
        if (this.getDateAcct() != null) {
            resetUpdate.append(" AND ").append(dateAccountingColumn).append(" >= ").append(DB.TO_DATE(this.getDateAcct()));
        }
        if (this.getDateAcctTo() != null) {
            resetUpdate.append(" AND ").append(dateAccountingColumn).append(" <= ").append(DB.TO_DATE(this.getDateAcctTo()));
        }
        resetUpdate.append(")");
        AtomicInteger invalid = new AtomicInteger(0);
        Trx.run(trxName -> invalid.set(DB.executeUpdate(resetUpdate.toString(), trxName)));
        StringBuilder resetUpdateMarkedAsPosted = new StringBuilder();
        resetUpdateMarkedAsPosted.append("UPDATE ").append(accountingDocumentTable.getTableName()).append(" SET Posted='N' WHERE AD_Client_ID=").append(this.getClientId());
        resetUpdateMarkedAsPosted.append(" AND Posted='Y' AND NOT EXISTS (SELECT 1 FROM Fact_Acct fa  WHERE AD_Table_ID=").append(accountingDocumentTable.get_ID()).append(" AND Record_ID=").append(accountingDocumentTable.getTableName()).append(".").append(accountingDocumentTable.getTableName()).append("_ID)");
        resetUpdateMarkedAsPosted.append(" AND EXISTS (SELECT 1 FROM  C_Period p INNER JOIN C_PeriodControl pc ON (p.C_Period_ID=pc.C_Period_ID) WHERE ");
        resetUpdateMarkedAsPosted.append("p.AD_Client_ID=").append(this.getClientId()).append(" AND ");
        resetUpdateMarkedAsPosted.append(dateAccountingColumn).append(" >= p.StartDate AND ").append(dateAccountingColumn).append(" <= p.EndDate ");
        resetUpdateMarkedAsPosted.append(" AND pc.PeriodStatus = 'O' AND pc.DocBaseType ").append(docBaseType);
        if (this.getDateAcct() != null) {
            resetUpdateMarkedAsPosted.append(" AND ").append(dateAccountingColumn).append(" >= ").append(DB.TO_DATE(this.getDateAcct()));
        }
        if (this.getDateAcctTo() != null) {
            resetUpdateMarkedAsPosted.append(" AND ").append(dateAccountingColumn).append(" <= ").append(DB.TO_DATE(this.getDateAcctTo()));
        }
        resetUpdateMarkedAsPosted.append(")");
        AtomicInteger invalidMarkedAsPosted = new AtomicInteger(0);
        Trx.run(trxName -> invalidMarkedAsPosted.set(DB.executeUpdate(resetUpdateMarkedAsPosted.toString(), trxName)));
        if (unlocked.get() + invalid.get() + invalidMarkedAsPosted.get() != 0) {
            this.log.fine(accountingDocumentTable.getTableName() + " - Unlocked=" + unlocked.get() + " - Invalid=" + invalid.get() + " Invalid marked as posted=" + invalidMarkedAsPosted.get());
        }
        this.countReset += unlocked.get() + invalid.get() + invalidMarkedAsPosted.get();
    }

    private void delete(MAcctSchema accountingSchemaDefault, MTable accountingDocumentTable) {
        Timestamp today = TimeUtil.trunc(new Timestamp(System.currentTimeMillis()), "D");
        if (accountingSchemaDefault.isAutoPeriodControl()) {
            Timestamp temp = TimeUtil.addDays(today, -accountingSchemaDefault.getPeriod_OpenHistory());
            if (this.getDateAcct() == null || this.getDateAcct().before(temp)) {
                this.setDateAcct(temp);
                this.log.info("DateAcct From set to: " + this.getDateAcct());
            }
            temp = TimeUtil.addDays(today, accountingSchemaDefault.getPeriod_OpenFuture());
            if (this.getDateAcctTo() == null || this.getDateAcctTo().after(temp)) {
                this.setDateAcctTo(temp);
                this.log.info("DateAcct To set to: " + this.getDateAcctTo());
            }
        }
        this.reset(accountingSchemaDefault, accountingDocumentTable);
        this.countReset = 0;
        String dateAccountingColumn = this.getDateAcct(accountingDocumentTable.get_ID());
        Object docBaseType = this.getDocumentBaseType(accountingDocumentTable.get_ID(), accountingDocumentTable.getTableName());
        if (docBaseType == null) {
            String s = accountingDocumentTable.getTableName() + ": Unknown DocBaseType";
            this.log.severe(s);
            this.addLog(s);
            docBaseType = "";
            return;
        }
        docBaseType = " AND pc.DocBaseType " + (String)docBaseType;
        StringBuilder updateStatement = new StringBuilder();
        updateStatement.append("UPDATE ").append(accountingDocumentTable.getTableName()).append(" SET Posted='N', Processing='N'").append(" WHERE ").append(accountingDocumentTable.getTableName()).append(".").append("AD_Client_ID=").append(this.getClientId()).append(" AND (").append(accountingDocumentTable.getTableName()).append(".Posted<>'N' OR ").append(accountingDocumentTable.getTableName()).append(".Posted IS NULL OR ").append(accountingDocumentTable.getTableName()).append(".Processing<>'N' OR ").append(accountingDocumentTable.getTableName()).append(".Processing IS NULL)").append(" AND NOT EXISTS (SELECT 1 FROM Fact_Acct fact WHERE fact.AD_Table_ID=").append(accountingDocumentTable.get_ID()).append(" AND fact.Record_ID=").append(accountingDocumentTable.getTableName()).append(".").append(accountingDocumentTable.getTableName()).append("_ID)");
        if (!accountingSchemaDefault.isAutoPeriodControl()) {
            updateStatement.append(" AND EXISTS (SELECT 1 FROM  C_Period p INNER JOIN C_PeriodControl pc ON (p.C_Period_ID=pc.C_Period_ID) WHERE ").append("p.AD_Client_ID=").append(this.getClientId()).append(" AND ").append(dateAccountingColumn).append(" >= p.StartDate AND ").append(dateAccountingColumn).append(" <= p.EndDate ").append(" AND pc.PeriodStatus = 'O' ").append((String)docBaseType).append(")");
        }
        if (this.getDateAcct() != null) {
            updateStatement.append(" AND ").append(dateAccountingColumn).append(" >= ").append(DB.TO_DATE(this.getDateAcct()));
        }
        if (this.getDateAcctTo() != null) {
            updateStatement.append(" AND ").append(dateAccountingColumn).append(" <= ").append(DB.TO_DATE(this.getDateAcctTo()));
        }
        this.log.log(Level.FINE, updateStatement.toString());
        AtomicInteger reset = new AtomicInteger(0);
        Trx.run(trxName -> reset.set(DB.executeUpdate(updateStatement.toString(), trxName)));
        StringBuilder deleteStatement = new StringBuilder("DELETE FROM Fact_Acct ");
        deleteStatement.append("WHERE Fact_Acct.AD_Client_ID=").append(this.getClientId()).append(" AND AD_Table_ID=").append(accountingDocumentTable.get_ID());
        if (!accountingSchemaDefault.isAutoPeriodControl()) {
            deleteStatement.append(" AND EXISTS (SELECT 1 FROM C_PeriodControl pc ").append(" WHERE pc.AD_Client_ID=").append(this.getClientId()).append(" AND pc.PeriodStatus = 'O'").append((String)docBaseType).append(" AND Fact_Acct.C_Period_ID=pc.C_Period_ID)");
        } else {
            deleteStatement.append(" AND EXISTS (SELECT 1 FROM C_PeriodControl pc ").append(" WHERE pc.AD_Client_ID=").append(this.getClientId()).append(" AND Fact_Acct.C_Period_ID=pc.C_Period_ID)");
        }
        if (this.getDateAcct() != null) {
            deleteStatement.append(" AND Fact_Acct.DateAcct >= ").append(DB.TO_DATE(this.getDateAcct()));
        }
        if (this.getDateAcctTo() != null) {
            deleteStatement.append(" AND Fact_Acct.DateAcct <= ").append(DB.TO_DATE(this.getDateAcctTo()));
        }
        this.log.log(Level.FINE, deleteStatement.toString());
        AtomicInteger deleted = new AtomicInteger(0);
        Trx.run(trxName -> deleted.set(DB.executeUpdate(deleteStatement.toString(), trxName)));
        this.log.info(accountingDocumentTable.getTableName() + "( ID : " + accountingDocumentTable.get_ID() + ") - Reset=" + reset.get() + " - Deleted=" + deleted.get());
        String s = "@" + accountingDocumentTable.getTableName() + "_ID@ - @Reset@=" + reset + " - @Deleted@=" + deleted;
        this.addLog(s);
        this.countReset += reset.get();
        this.countDelete += deleted.get();
    }

    public String getDateAcct(int tableId) {
        return Doc.getDateAcctColumnName(MTable.getTableName(this.getCtx(), tableId));
    }

    public String getDocumentBaseType(int tableId, String tableName) {
        String docBaseType = null;
        docBaseType = tableId == MInvoice.Table_ID ? "IN ('API','APC','ARI','ARC','ARF')" : (tableId == MInOut.Table_ID ? "IN ('MMS','MMR')" : (tableId == MPayment.Table_ID ? "IN ('APP','ARR')" : (tableId == MOrder.Table_ID ? "IN ('SOO','POO')" : (tableId == MProjectIssue.Table_ID ? "= 'PJI'" : (tableId == MBankStatement.Table_ID ? "= 'CMB'" : (tableId == MCash.Table_ID ? "= 'CMC'" : (tableId == MAllocationHdr.Table_ID ? "= 'CMA'" : (tableId == MJournal.Table_ID ? "= 'GLJ'" : (tableId == MMovement.Table_ID ? "= 'MMM'" : (tableId == MRequisition.Table_ID ? "= 'POR'" : (tableId == MInventory.Table_ID ? "= 'MMI'" : (tableId == X_M_Production.Table_ID ? "= 'MMP'" : (tableId == MMatchInv.Table_ID ? "= 'MXI'" : (tableId == MMatchPO.Table_ID ? "= 'MXP'" : (tableId == X_PP_Order.Table_ID ? "IN ('MOP','MOF','MQO')" : (tableId == X_PP_Cost_Collector.Table_ID ? "IN ('MCC')" : (tableId == I_DD_Order.Table_ID ? "= 'DOO'" : (tableId == I_HR_Process.Table_ID ? "= 'HRP'" : (tableId == X_PP_Cost_Collector.Table_ID ? "= 'MCC'" : (tableId == I_A_Asset_Addition.Table_ID ? "= 'FAA'" : (tableId == I_A_Depreciation_Entry.Table_ID ? "= 'FAD'" : (tableId == I_A_Asset_Disposed.Table_ID ? "= 'FDP'" : (tableId == X_M_ProductionBatch.Table_ID ? "= 'MPO'" : "IS NOT NULL ")))))))))))))))))))))));
        return docBaseType;
    }
}

