/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.File;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.I_C_Order;
import org.adempiere.core.domains.models.I_DD_Order;
import org.adempiere.core.domains.models.I_HR_Process;
import org.adempiere.core.domains.models.I_PP_Cost_Collector;
import org.adempiere.core.domains.models.I_PP_Order;
import org.compiere.acct.Doc;
import org.compiere.db.CConnection;
import org.compiere.interfaces.Server;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MBankStatement;
import org.compiere.model.MCash;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MInOut;
import org.compiere.model.MInventory;
import org.compiere.model.MInvoice;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MMovement;
import org.compiere.model.MPayment;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionBatch;
import org.compiere.model.MRequisition;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.process.DocAction;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class DocumentEngine
implements DocAction {
    private DocAction document;
    private String docStatus = "DR";
    private String message = null;
    private String action = null;
    protected Properties ctx = null;
    protected Integer clientId = null;
    protected Integer tableId = null;
    protected Integer recordId = null;
    protected String trxName = null;
    private static CLogger log = CLogger.getCLogger(DocumentEngine.class);
    private static final String EXCEPTION_MSG = "Document Engine is not a Document";

    public DocumentEngine() {
        this.document = null;
        this.docStatus = null;
    }

    public DocumentEngine(DocAction po) {
        this(po, null);
    }

    public DocumentEngine(DocAction po, String status) {
        this.document = Objects.requireNonNull(po);
        this.docStatus = Optional.ofNullable(status).orElse("DR");
        this.ctx = this.document.getCtx();
        this.clientId = Env.getAD_Client_ID(this.ctx);
        this.tableId = this.document.get_Table_ID();
        this.recordId = this.document.get_ID();
        this.trxName = this.document.get_TrxName();
    }

    protected CLogger getLogger() {
        return log;
    }

    @Override
    public String getDocStatus() {
        return this.docStatus;
    }

    @Override
    public void setDocStatus(String ignored) {
    }

    public boolean isDrafted() {
        return "DR".equals(this.docStatus);
    }

    public boolean isInvalid() {
        return "IN".equals(this.docStatus);
    }

    public boolean isInProgress() {
        return "IP".equals(this.docStatus);
    }

    public boolean isApproved() {
        return "AP".equals(this.docStatus);
    }

    public boolean isNotApproved() {
        return "NA".equals(this.docStatus);
    }

    public boolean isWaiting() {
        return "WP".equals(this.docStatus) || "WC".equals(this.docStatus);
    }

    public boolean isCompleted() {
        return "CO".equals(this.docStatus);
    }

    public boolean isReversed() {
        return "RE".equals(this.docStatus);
    }

    public boolean isClosed() {
        return "CL".equals(this.docStatus);
    }

    public boolean isVoided() {
        return "VO".equals(this.docStatus);
    }

    public boolean isUnknown() {
        return "??".equals(this.docStatus) || !this.isDrafted() && !this.isInvalid() && !this.isInProgress() && !this.isNotApproved() && !this.isApproved() && !this.isWaiting() && !this.isCompleted() && !this.isReversed() && !this.isClosed() && !this.isVoided();
    }

    public boolean processIt(String processAction, String docAction) {
        this.message = null;
        this.action = null;
        if (this.isValidAction(processAction)) {
            this.action = processAction;
        } else if (this.isValidAction(docAction)) {
            this.action = docAction;
        } else {
            if (processAction.equals("--") || docAction.equals("--")) {
                if (this.document != null) {
                    this.document.get_Logger().info("**** No Action (Prc=" + processAction + "/Doc=" + docAction + ") " + this.document);
                }
                return true;
            }
            throw new IllegalStateException("Status=" + this.getDocStatus() + " - Invalid Actions: Process=" + processAction + ", Doc=" + docAction);
        }
        if (this.document != null) {
            this.document.get_Logger().info("**** Action=" + this.action + " (Prc=" + processAction + "/Doc=" + docAction + ") " + this.document);
        }
        boolean success = this.processIt(this.action);
        if (this.document != null) {
            this.document.get_Logger().fine("**** Action=" + this.action + " - Success=" + success);
        }
        return success;
    }

    @Override
    public boolean processIt(String docAction) {
        this.message = null;
        this.action = docAction;
        if ("XL".equals(this.action)) {
            return this.unlockIt();
        }
        if ("IN".equals(this.action)) {
            return this.invalidateIt();
        }
        if ("PR".equals(this.action)) {
            return "IP".equals(this.prepareIt());
        }
        if ("AP".equals(this.action)) {
            return this.approveIt();
        }
        if ("RJ".equals(this.action)) {
            return this.rejectIt();
        }
        if ("CO".equals(this.action) || "WC".equals(this.action)) {
            return this.prepareThenCompleteIt();
        }
        if ("RE".equals(this.action)) {
            return this.reActivateIt();
        }
        if ("RA".equals(this.action)) {
            return this.reverseAccrualIt();
        }
        if ("RC".equals(this.action)) {
            return this.reverseCorrectIt();
        }
        if ("CL".equals(this.action)) {
            return this.closeIt();
        }
        if ("VO".equals(this.action)) {
            return this.voidIt();
        }
        if ("PO".equals(this.action)) {
            return this.postIt();
        }
        return false;
    }

    private boolean prepareThenCompleteIt() {
        boolean ok;
        String status = null;
        if ((this.isDrafted() || this.isInvalid()) && !"IP".equals(status = this.prepareIt())) {
            return false;
        }
        status = this.completeIt();
        boolean bl = ok = "CO".equals(status) || "IP".equals(status) || "WP".equals(status) || "WC".equals(status);
        if (this.document != null && ok) {
            ArrayList<PO> docsPostProcess = this.postProcessDocument();
            this.postTheDocAndAnyPostProcessDocs(status, docsPostProcess);
        }
        return ok;
    }

    protected void postTheDocAndAnyPostProcessDocs(String status, ArrayList<PO> docsPostProcess) {
        if ("CO".equals(status) && this.isClientAccountingImmediate()) {
            this.document.saveEx();
            this.postIt();
            if (!docsPostProcess.isEmpty()) {
                for (PO docafter : docsPostProcess) {
                    this.getNewDocumentEngine().withContext(docafter.getCtx()).withAD_Client_ID(docafter.getAD_Client_ID()).withAD_Table_ID(docafter.get_Table_ID()).withRecord_ID(docafter.get_ID()).withTrxName(docafter.get_TrxName()).postImmediate(true);
                }
            }
        }
    }

    protected static DocumentEngine get() {
        return new DocumentEngine();
    }

    protected static DocumentEngine get(DocAction doc, String docStatus) {
        return new DocumentEngine(doc, docStatus);
    }

    protected DocumentEngine getNewDocumentEngine() {
        return new DocumentEngine();
    }

    boolean isClientAccountingImmediate() {
        return MClient.isClientAccountingImmediate();
    }

    protected ArrayList<PO> postProcessDocument() {
        ArrayList<Object> docsPostProcess = new ArrayList();
        if (this.document instanceof MInvoice) {
            docsPostProcess = ((MInvoice)this.document).getDocsPostProcess();
        }
        if (this.document instanceof MInOut) {
            docsPostProcess = ((MInOut)this.document).getDocsPostProcess();
        }
        if (!docsPostProcess.isEmpty()) {
            for (PO pO : docsPostProcess) {
                pO.setProcessedOn("Processed", true, false);
                pO.saveEx();
            }
        }
        return docsPostProcess;
    }

    @Override
    public boolean unlockIt() {
        if (!this.isValidAction("XL")) {
            return false;
        }
        if (this.document != null) {
            if (this.document.unlockIt()) {
                this.docStatus = "DR";
                this.document.setDocStatus(this.docStatus);
                return true;
            }
            return false;
        }
        this.docStatus = "DR";
        return true;
    }

    @Override
    public boolean invalidateIt() {
        if (!this.isValidAction("IN")) {
            return false;
        }
        if (this.document != null) {
            if (this.document.invalidateIt()) {
                this.docStatus = "IN";
                this.document.setDocStatus(this.docStatus);
                return true;
            }
            return false;
        }
        this.docStatus = "IN";
        return true;
    }

    @Override
    public String prepareIt() {
        if (!this.isValidAction("PR")) {
            return this.docStatus;
        }
        if (this.document != null) {
            this.docStatus = this.document.prepareIt();
            this.document.setDocStatus(this.docStatus);
        }
        return this.docStatus;
    }

    @Override
    public boolean approveIt() {
        if (!this.isValidAction("AP")) {
            return false;
        }
        if (this.document != null) {
            if (this.document.approveIt()) {
                this.docStatus = "AP";
                this.document.setDocStatus(this.docStatus);
                return true;
            }
            return false;
        }
        this.docStatus = "AP";
        return true;
    }

    @Override
    public boolean rejectIt() {
        if (!this.isValidAction("RJ")) {
            return false;
        }
        if (this.document != null) {
            if (this.document.rejectIt()) {
                this.docStatus = "NA";
                this.document.setDocStatus(this.docStatus);
                return true;
            }
            return false;
        }
        this.docStatus = "NA";
        return true;
    }

    @Override
    public String completeIt() {
        if (!this.isValidAction("CO")) {
            return this.docStatus;
        }
        if (this.document != null) {
            this.docStatus = this.document.completeIt();
            this.document.setDocStatus(this.docStatus);
        }
        return this.docStatus;
    }

    public boolean postIt() {
        if (!this.isValidAction("PO") || this.document == null) {
            return false;
        }
        boolean force = true;
        String error = this.postImmediate(force);
        return error == null;
    }

    @Override
    public boolean voidIt() {
        if (!this.isValidAction("VO")) {
            return false;
        }
        if (this.document != null) {
            if (this.document.voidIt()) {
                this.docStatus = "VO";
                this.document.setDocStatus(this.docStatus);
                return true;
            }
            return false;
        }
        this.docStatus = "VO";
        return true;
    }

    @Override
    public boolean closeIt() {
        if (!(this.document != null && this.document.get_Table_ID() == I_C_Order.Table_ID || this.isValidAction("CL"))) {
            return false;
        }
        if (this.document != null) {
            if (this.document.closeIt()) {
                this.docStatus = "CL";
                this.document.setDocStatus(this.docStatus);
                return true;
            }
            return false;
        }
        this.docStatus = "CL";
        return true;
    }

    @Override
    public boolean reverseCorrectIt() {
        if (!this.isValidAction("RC")) {
            return false;
        }
        if (this.document != null) {
            if (this.document.reverseCorrectIt()) {
                this.docStatus = "RE";
                this.document.setDocStatus(this.docStatus);
                return true;
            }
            return false;
        }
        this.docStatus = "RE";
        return true;
    }

    @Override
    public boolean reverseAccrualIt() {
        if (!this.isValidAction("RA")) {
            return false;
        }
        if (this.document != null) {
            if (this.document.reverseAccrualIt()) {
                this.docStatus = "RE";
                this.document.setDocStatus(this.docStatus);
                return true;
            }
            return false;
        }
        this.docStatus = "RE";
        return true;
    }

    @Override
    public boolean reActivateIt() {
        if (!this.isValidAction("RE")) {
            return false;
        }
        if (this.document != null) {
            if (this.document.reActivateIt()) {
                this.docStatus = "IP";
                this.document.setDocStatus(this.docStatus);
                return true;
            }
            return false;
        }
        this.docStatus = "IP";
        return true;
    }

    void setStatus(String newStatus) {
        this.docStatus = newStatus;
    }

    public String[] getActionOptions() {
        if (this.isInvalid()) {
            return new String[]{"PR", "IN", "XL", "VO"};
        }
        if (this.isDrafted()) {
            return new String[]{"PR", "IN", "CO", "XL", "VO"};
        }
        if (this.isInProgress() || this.isApproved()) {
            return new String[]{"CO", "WC", "AP", "RJ", "XL", "VO", "PR"};
        }
        if (this.isNotApproved()) {
            return new String[]{"RJ", "PR", "XL", "VO"};
        }
        if (this.isWaiting()) {
            return new String[]{"CO", "WC", "RE", "VO", "CL"};
        }
        if (this.isCompleted()) {
            return new String[]{"CL", "RE", "RA", "RC", "PO", "VO"};
        }
        if (this.isClosed()) {
            return new String[]{"PO", "OP"};
        }
        if (this.isReversed() || this.isVoided()) {
            return new String[]{"PO"};
        }
        return new String[0];
    }

    public boolean isValidAction(String action) {
        String[] options = this.getActionOptions();
        for (int i = 0; i < options.length; ++i) {
            if (!options[i].equals(action)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getProcessMsg() {
        return this.message;
    }

    public void setProcessMsg(String msg) {
        this.message = msg;
    }

    @Override
    public String getSummary() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public String getDocumentNo() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public String getDocumentInfo() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public int getDoc_User_ID() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public int getC_Currency_ID() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public BigDecimal getApprovalAmt() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public int getAD_Client_ID() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public int getAD_Org_ID() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public String getDocAction() {
        return this.action;
    }

    @Override
    public boolean save() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public void saveEx() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public Properties getCtx() {
        if (this.document != null) {
            return this.document.getCtx();
        }
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public int get_ID() {
        if (this.document != null) {
            return this.document.get_ID();
        }
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public int get_Table_ID() {
        if (this.document != null) {
            return this.document.get_Table_ID();
        }
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public CLogger get_Logger() {
        if (this.document != null) {
            return this.document.get_Logger();
        }
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public String get_TrxName() {
        return null;
    }

    @Override
    public File createPDF() {
        return null;
    }

    public static int getValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int tableId, String[] docAction, String[] options) {
        if (options == null) {
            throw new IllegalArgumentException("Option array parameter is null");
        }
        if (docAction == null) {
            throw new IllegalArgumentException("Doc action array parameter is null");
        }
        int index = 0;
        if (processing != null) {
            boolean locked = "Y".equals(processing);
            if (!locked && processing instanceof Boolean) {
                locked = (Boolean)processing;
            }
            if (locked) {
                options[index++] = "XL";
            }
        }
        if (docStatus.equals("NA")) {
            options[index++] = "PR";
            options[index++] = "VO";
        } else if (docStatus.equals("DR") || docStatus.equals("IN")) {
            options[index++] = "CO";
            options[index++] = "PR";
            options[index++] = "VO";
        } else if (docStatus.equals("IP") || docStatus.equals("AP")) {
            options[index++] = "CO";
            options[index++] = "VO";
        } else if (docStatus.equals("CO")) {
            options[index++] = "CL";
        } else if (docStatus.equals("WP") || docStatus.equals("WC")) {
            options[index++] = "VO";
            options[index++] = "PR";
        } else if (docStatus.equals("CL") || docStatus.equals("VO") || docStatus.equals("RE")) {
            return 0;
        }
        if (tableId == I_C_Order.Table_ID) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                options[index++] = "PR";
                options[index++] = "CL";
                if ("Y".equals(isSOTrx) && ("OB".equals(orderType) || "ON".equals(orderType))) {
                    docAction[0] = "PR";
                }
            } else if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RE";
            } else if (docStatus.equals("WP")) {
                options[index++] = "RE";
                options[index++] = "CL";
            }
        } else if (tableId == MRequisition.Table_ID) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                options[index++] = "PR";
                options[index++] = "CL";
            } else if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RE";
            } else if (docStatus.equals("WP")) {
                options[index++] = "RE";
                options[index++] = "CL";
            }
        } else if (tableId == MInOut.Table_ID) {
            if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RC";
                options[index++] = "RA";
            }
        } else if (tableId == MInvoice.Table_ID) {
            if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RC";
                options[index++] = "RA";
            }
        } else if (tableId == MPayment.Table_ID) {
            if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RC";
                options[index++] = "RA";
            }
        } else if (tableId == MJournal.Table_ID || tableId == MJournalBatch.Table_ID) {
            if (docStatus.equals("CO")) {
                options[index++] = "RC";
                options[index++] = "RA";
                options[index++] = "RE";
            }
        } else if (tableId == MAllocationHdr.Table_ID) {
            if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RC";
                options[index++] = "RA";
            }
        } else if (tableId == MCash.Table_ID) {
            if (docStatus.equals("CO")) {
                options[index++] = "VO";
            }
        } else if (tableId == MBankStatement.Table_ID) {
            if (docStatus.equals("CO")) {
                options[index++] = "VO";
            }
        } else if (tableId == MMovement.Table_ID || tableId == MInventory.Table_ID) {
            if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RC";
                options[index++] = "RA";
            }
        } else if (tableId == MProduction.Table_ID) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                options[index++] = "PR";
            } else if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RC";
                options[index++] = "RA";
            }
        } else if (tableId == MProductionBatch.Table_ID) {
            if (docStatus.equals("CO")) {
                options[index++] = "VO";
            }
        } else if (tableId == I_PP_Order.Table_ID) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                options[index++] = "PR";
                options[index++] = "CL";
            } else if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RE";
            }
        } else if (tableId == I_PP_Cost_Collector.Table_ID) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                options[index++] = "PR";
                options[index++] = "CL";
            } else if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RC";
            }
        } else if (tableId == I_DD_Order.Table_ID) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                options[index++] = "PR";
                options[index++] = "CL";
            } else if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RE";
            }
        } else if (tableId == I_HR_Process.Table_ID) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                options[index++] = "PR";
                options[index++] = "CL";
            } else if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RE";
                options[index++] = "RC";
                options[index++] = "RA";
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readReferenceList(ArrayList<String> v_value, ArrayList<String> v_name, ArrayList<String> v_description) {
        if (v_value == null) {
            throw new IllegalArgumentException("v_value parameter is null");
        }
        if (v_name == null) {
            throw new IllegalArgumentException("v_name parameter is null");
        }
        if (v_description == null) {
            throw new IllegalArgumentException("v_description parameter is null");
        }
        Object sql = Env.isBaseLanguage(Env.getCtx(), "AD_Ref_List") ? "SELECT Value, Name, Description FROM AD_Ref_List WHERE AD_Reference_ID=? ORDER BY Name" : "SELECT l.Value, t.Name, t.Description FROM AD_Ref_List l, AD_Ref_List_Trl t WHERE l.AD_Ref_List_ID=t.AD_Ref_List_ID AND t.AD_Language='" + Env.getAD_Language(Env.getCtx()) + "' AND l.AD_Reference_ID=? ORDER BY t.Name";
        CPreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = DB.prepareStatement((String)sql, null);
            preparedStatement.setInt(1, 135);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String value = resultSet.getString(1);
                String name = resultSet.getString(2);
                String description = resultSet.getString(3);
                if (description == null) {
                    description = "";
                }
                v_value.add(value);
                v_name.add(name);
                v_description.add(description);
            }
        }
        catch (SQLException e) {
            try {
                log.log(Level.SEVERE, (String)sql, e);
            }
            catch (Throwable throwable) {
                DB.close(resultSet, preparedStatement);
                resultSet = null;
                preparedStatement = null;
                throw throwable;
            }
            DB.close(resultSet, preparedStatement);
            resultSet = null;
            preparedStatement = null;
        }
        DB.close(resultSet, preparedStatement);
        resultSet = null;
        preparedStatement = null;
    }

    public static int checkActionAccess(int clientId, int roleId, int docTypeId, String[] options, int maxIndex) {
        return MRole.get(Env.getCtx(), roleId).checkActionAccess(clientId, docTypeId, options, maxIndex);
    }

    public static String postImmediate(Properties ctx, int clientId, int tableId, int recordId, boolean force, String trxName) {
        DocumentEngine docEngine = DocumentEngine.get().withContext(ctx).withAD_Client_ID(clientId).withAD_Table_ID(tableId).withRecord_ID(recordId).withTrxName(trxName);
        return docEngine.postImmediate(force);
    }

    public DocumentEngine withTrxName(String trxName) {
        if (this.document == null) {
            this.trxName = trxName;
        }
        return this;
    }

    public DocumentEngine withRecord_ID(int recordId) {
        if (this.document == null) {
            this.recordId = recordId;
        }
        return this;
    }

    public DocumentEngine withAD_Table_ID(int tableId) {
        if (this.document == null) {
            this.tableId = tableId;
        }
        return this;
    }

    public DocumentEngine withAD_Client_ID(int clientId) {
        if (this.document == null) {
            this.clientId = clientId;
        }
        return this;
    }

    public DocumentEngine withContext(Properties ctx) {
        if (this.document == null) {
            this.ctx = ctx;
        }
        return this;
    }

    public static boolean processIt(DocAction doc, String processAction) {
        boolean success = false;
        DocumentEngine engine = DocumentEngine.get(doc, doc.getDocStatus());
        success = engine.processIt(processAction, doc.getDocAction());
        return success;
    }

    public String postImmediate(boolean force) {
        Objects.requireNonNull(this.ctx);
        Objects.requireNonNull(this.clientId);
        Objects.requireNonNull(this.tableId);
        Objects.requireNonNull(this.recordId);
        String tableName = MTable.getTableName(this.ctx, this.tableId);
        if (MColumn.getColumn_ID(tableName, "Posted") <= 0) {
            return null;
        }
        String error = null;
        if (MClient.isClientAccounting()) {
            this.getLogger().info("Table=" + tableName + ", Record=" + this.recordId);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema(this.ctx, this.clientId);
            Doc doc = this.getDoc(ass, tableName, this.recordId, this.trxName);
            if (doc == null) {
                return "NoDoc";
            }
            error = doc.postImmediate(force);
            return error;
        }
        CConnection serverConnection = this.getServerConnection();
        if (serverConnection.isAppsServerOK(true)) {
            this.getLogger().config("trying server");
            try {
                Server server = this.getServer();
                if (server != null) {
                    Properties p = Env.getRemoteCallCtx(Env.getCtx());
                    error = server.postImmediate(p, this.clientId, this.tableId, this.recordId, force, null);
                    this.getLogger().config("from Server: " + (error == null ? "OK" : error));
                } else {
                    error = "NoAppsServer";
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "(RE)", e);
                error = e.getMessage();
            }
        }
        return error;
    }

    public CConnection getServerConnection() {
        return CConnection.get();
    }

    public Server getServer() {
        return this.getServerConnection().getServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Doc getDoc(MAcctSchema[] acctSchemas, String tableName, int recordId, String trxName) {
        ResultSet rs;
        CPreparedStatement pstmt;
        Doc doc;
        block5: {
            doc = null;
            String sql = "SELECT * FROM " + tableName + " WHERE " + tableName + "_ID=? AND Processed='Y'";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, trxName);
                pstmt.setInt(1, recordId);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    doc = this.getDoc(acctSchemas, tableName, rs, trxName);
                    break block5;
                }
                this.getLogger().severe("Not Found: " + tableName + "_ID=" + recordId);
            }
            catch (Exception e) {
                try {
                    this.getLogger().log(Level.SEVERE, sql, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return doc;
    }

    public Doc getDoc(MAcctSchema[] acctSchemas, String tableName, ResultSet rs, String trxName) throws AdempiereUserError {
        Doc doc = null;
        String packageName = "org.compiere.acct";
        String className = null;
        int firstUnderscore = tableName.indexOf("_");
        className = firstUnderscore == 1 ? packageName + ".Doc_" + tableName.substring(2).replace("_", "") : packageName + ".Doc_" + tableName.replace("_", "");
        try {
            Class<?> cClass = Class.forName(className);
            Constructor<?> cnstr = cClass.getConstructor(MAcctSchema[].class, ResultSet.class, String.class);
            doc = (Doc)cnstr.newInstance(acctSchemas, rs, trxName);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Doc Class invalid: " + className + " (" + e.toString() + ")");
            throw new AdempiereUserError("Doc Class invalid: " + className + " (" + e.toString() + ")");
        }
        if (doc == null) {
            this.getLogger().log(Level.SEVERE, "Unknown table =" + tableName);
        }
        return doc;
    }

    protected Object getDocument() {
        return this.document;
    }
}

