/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.compiere.model.MProject;
import org.compiere.model.MProjectPhase;
import org.compiere.model.MProjectTask;
import org.compiere.model.MProjectTypePhase;
import org.compiere.model.MProjectTypeTask;
import org.compiere.process.CopyProjectTypeTasksIntoProjectAbstract;
import org.compiere.process.ProcessInfoParameter;

public class CopyProjectTypeTasksIntoProject
extends CopyProjectTypeTasksIntoProjectAbstract {
    private int p_C_Project_ID = 0;
    private MProject m_project;

    @Override
    protected void prepare() {
        super.prepare();
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (name.equals("C_Project_ID")) {
                this.p_C_Project_ID = ((BigDecimal)para[i].getParameter()).intValue();
                this.m_project = MProject.getById(this.getCtx(), this.p_C_Project_ID, this.get_TrxName());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        int count = 0;
        List<MProjectTypeTask> projectTypeTasks = this.getInstancesForSelection(this.get_TrxName());
        this.populateProjectTasks(this.m_project, projectTypeTasks);
        this.correctProjectSequences(this.m_project);
        return "@Created@/@Updated@ #" + count;
    }

    private int populateProjectTasks(MProject project, List<MProjectTypeTask> projectTypeTasks) {
        AtomicInteger count = new AtomicInteger(0);
        projectTypeTasks.stream().forEach(projectTypeTask -> {
            MProjectTask projectTask;
            MProjectTypePhase projectTypePhase = (MProjectTypePhase)projectTypeTask.getC_Phase();
            MProjectPhase projectPhase = this.getProjectPhase(project, projectTypePhase);
            if (projectPhase == null) {
                projectPhase = new MProjectPhase(project, projectTypePhase);
                projectPhase.setProjInvoiceRule(project.getProjInvoiceRule());
                if (projectPhase.getM_Product_ID() != 0) {
                    projectPhase.setProjInvoiceRule("P");
                }
                projectPhase.saveEx();
            }
            if ((projectTask = this.getProjectTask(projectPhase, (MProjectTypeTask)projectTypeTask)) == null) {
                projectTask = new MProjectTask(projectPhase, (MProjectTypeTask)projectTypeTask);
                projectTask.setProjInvoiceRule(project.getProjInvoiceRule());
                if (projectTask.getM_Product_ID() != 0) {
                    projectTask.setProjInvoiceRule("P");
                }
                projectTask.saveEx();
                count.updateAndGet(no -> no + 1);
            }
        });
        return count.get();
    }

    private MProjectPhase getProjectPhase(MProject project, MProjectTypePhase projectTypePhase) {
        MProjectPhase resultProjectPhase = null;
        List<MProjectPhase> projectPhases = project.getPhases();
        for (MProjectPhase projectPhase : projectPhases) {
            if (projectPhase.getC_Phase_ID() != projectTypePhase.getC_Phase_ID() || !projectPhase.getName().equalsIgnoreCase(projectTypePhase.getName())) continue;
            resultProjectPhase = projectPhase;
            break;
        }
        return resultProjectPhase;
    }

    private MProjectTask getProjectTask(MProjectPhase projectPhase, MProjectTypeTask projectTypeTask) {
        MProjectTask resultProjectTask = null;
        List<MProjectTask> projectTasks = projectPhase.getTasks();
        for (MProjectTask projectTask : projectTasks) {
            if (!projectTask.getName().equalsIgnoreCase(projectTypeTask.getName())) continue;
            resultProjectTask = projectTask;
            break;
        }
        return resultProjectTask;
    }

    private boolean correctProjectSequences(MProject project) {
        int seqNoPhase = 10;
        for (MProjectPhase projectPhase : project.getPhases()) {
            projectPhase.setSeqNo(seqNoPhase);
            seqNoPhase += 10;
            projectPhase.saveEx();
            int seqNoTask = 10;
            for (MProjectTask projectTask : projectPhase.getTasks()) {
                projectTask.setSeqNo(seqNoTask);
                seqNoTask += 10;
                projectTask.saveEx();
            }
        }
        return true;
    }
}

