/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.adempiere.core.domains.models.X_I_BankStatement;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBank;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPayment;
import org.compiere.model.MProcess;
import org.compiere.model.MSequence;
import org.compiere.process.BankStatementPaymentAbstract;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.eevolution.services.dsl.ProcessBuilder;

public class BankStatementPayment
extends BankStatementPaymentAbstract {
    @Override
    protected String doIt() throws Exception {
        int tableId = this.getTable();
        int recordId = this.getRecord();
        if (tableId == 0) {
            tableId = this.getTable_ID();
        }
        if (recordId == 0) {
            recordId = this.getRecord_ID();
        }
        this.log.info("Table_ID=" + tableId + ", Record_ID=" + recordId);
        int user1Id = this.getParameterAsInt("User1_ID");
        int contractId = this.getParameterAsInt("S_Contract_ID");
        if (this.isSelection()) {
            String transactionType = this.getParameterAsString("TrxType");
            if (Util.isEmpty(transactionType)) {
                throw new AdempiereException("@TrxType@ @NotFound@");
            }
            int chargeId = this.getParameterAsInt("C_Charge_ID");
            int bPartnerId = this.getParameterAsInt("C_BPartner_ID");
            int created = 0;
            for (int key : this.getSelectionKeys()) {
                int bankStatementLineId = this.getSelectionAsInt(key, "BSL_C_BankStatementLine_ID");
                MBankStatementLine bankStatementLine = new MBankStatementLine(this.getCtx(), bankStatementLineId, this.get_TrxName());
                if (transactionType.equals("B")) {
                    MBank bank = MBank.get(this.getCtx(), bankStatementLine.getParent().getBankAccount().getC_Bank_ID());
                    if (bank.getC_BPartner_ID() == 0) {
                        throw new AdempiereException("@C_Bank_ID@ @C_BPartner_ID@ @NotFound@");
                    }
                    bPartnerId = bank.getC_BPartner_ID();
                } else if (transactionType.equals("U")) {
                    bPartnerId = MOrgInfo.get(this.getCtx(), bankStatementLine.getAD_Org_ID(), this.get_TrxName()).getUnidentifiedBPartner_ID();
                    if (bPartnerId == 0) {
                        throw new AdempiereException("@AD_Org_ID@ @UnidentifiedBPartner_ID@ @NotFound@");
                    }
                } else if (transactionType.equals("T")) {
                    MOrg org = new MOrg(this.getCtx(), bankStatementLine.getAD_Org_ID(), this.get_TrxName());
                    int partner_ID = org.getLinkedC_BPartner_ID(this.get_TrxName());
                    if (partner_ID <= 0) {
                        throw new AdempiereException("No existe Socio del Negocio Ligado a la Organizaci\u00f3n");
                    }
                    if (bankStatementLine.getParent().getBankAccount().getC_BankAccount_ID() == this.getParameterAsInt("C_BankAccount_ID")) {
                        throw new AdempiereException("Cuenta bancaria origen y destino deben ser distintas");
                    }
                    Object documentNo = null;
                    int docNo = 0;
                    MSequence paymentSeq = MSequence.get(this.getCtx(), this.getAD_Client_ID(), "Payment_DocNo_InterTransfer", this.get_TrxName());
                    if (paymentSeq != null && paymentSeq.get_ID() > 0) {
                        docNo = MSequence.getNextID_ForName(this.getAD_Client_ID(), 0, "Payment_DocNo_InterTransfer", this.get_TrxName());
                        documentNo = paymentSeq.getPrefix() != null && !paymentSeq.getPrefix().equalsIgnoreCase("") ? paymentSeq.getPrefix() + (String)documentNo : String.valueOf(docNo).trim();
                    } else {
                        throw new AdempiereException("ERROR: No se obtuvo secuencia para nro. de documento de Pago/Cobro por Transferencia entre Cuentas");
                    }
                    String description = "Generado desde Conciliaci\u00f3n Bancaria Nro. " + bankStatementLine.getParent().getDocumentNo() + " | ";
                    if (bankStatementLine.getDescription() != null && !bankStatementLine.getDescription().equalsIgnoreCase("")) {
                        description = bankStatementLine.getDescription() + " | " + description;
                    }
                    int process_ID = MProcess.getProcess_ID("UY_BankTransferMultiCur", this.get_TrxName());
                    ProcessBuilder.create(this.getCtx()).process(process_ID).withParameter("From_C_BankAccount_ID", bankStatementLine.getParent().getBankAccount().getC_BankAccount_ID()).withParameter("To_C_BankAccount_ID", this.getParameterAsInt("C_BankAccount_ID")).withParameter("C_BPartner_ID", partner_ID).withParameter("C_Currency_ID", bankStatementLine.getC_Currency_ID()).withParameter("C_Charge_ID", this.getParameterAsInt("C_Charge_ID")).withParameter("DocumentNo", documentNo).withParameter("DocumentNoTo", documentNo).withParameter("Amount", bankStatementLine.getTrxAmt()).withParameter("Description", description).withParameter("StatementDate", bankStatementLine.getStatementLineDate()).withParameter("CurrencyRate", this.getParameterAsBigDecimal("CurrencyRate")).withParameter("TenderType", "A").withParameter("DateAcct", bankStatementLine.getDateAcct()).withParameter("IsAutoReconciled", false).withParameter("IsFromConciliation", true).withParameter("C_BankStatementLine_ID", bankStatementLineId).withoutTransactionClose().execute(this.get_TrxName());
                }
                if (bPartnerId != 0) {
                    bankStatementLine.setC_BPartner_ID(bPartnerId);
                }
                if (chargeId != 0) {
                    bankStatementLine.setC_Charge_ID(chargeId);
                }
                if (!transactionType.equals("T")) {
                    this.createPayment(bankStatementLine, user1Id, contractId);
                }
                ++created;
            }
            return "@Created@: " + created;
        }
        if (tableId == X_I_BankStatement.Table_ID) {
            return this.createPayment(new X_I_BankStatement(this.getCtx(), recordId, this.get_TrxName()));
        }
        if (tableId == MBankStatementLine.Table_ID) {
            return this.createPayment(new MBankStatementLine(this.getCtx(), recordId, this.get_TrxName()), user1Id, contractId);
        }
        return "Ok";
    }

    private String createPayment(X_I_BankStatement importBankStatement) throws Exception {
        if (importBankStatement == null || importBankStatement.getC_Payment_ID() != 0) {
            return "--";
        }
        this.log.fine(importBankStatement.toString());
        if (importBankStatement.getC_Invoice_ID() == 0 && importBankStatement.getC_BPartner_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ @C_Invoice_ID@ / @C_BPartner_ID@");
        }
        if (importBankStatement.getC_BankAccount_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ @C_BankAccount_ID@");
        }
        String documentNo = importBankStatement.getReferenceNo();
        if (Util.isEmpty(documentNo)) {
            documentNo = importBankStatement.getEftReference();
        }
        String checkNo = importBankStatement.getEftCheckNo();
        MPayment payment = this.createPayment(importBankStatement.getC_Invoice_ID(), importBankStatement.getC_BPartner_ID(), importBankStatement.getC_Currency_ID(), importBankStatement.getStmtAmt(), importBankStatement.getTrxAmt(), importBankStatement.getC_BankAccount_ID(), importBankStatement.getStatementLineDate() == null ? importBankStatement.getStatementDate() : importBankStatement.getStatementLineDate(), importBankStatement.getDateAcct(), importBankStatement.getDescription(), importBankStatement.getAD_Org_ID(), importBankStatement.getC_Charge_ID(), false, documentNo, checkNo, 0, 0);
        importBankStatement.setC_Payment_ID(payment.getC_Payment_ID());
        importBankStatement.setC_Currency_ID(payment.getC_Currency_ID());
        importBankStatement.setTrxAmt(payment.getPayAmt(true));
        importBankStatement.saveEx();
        String retString = "@C_Payment_ID@ = " + payment.getDocumentNo();
        if (payment.getOverUnderAmt().signum() != 0) {
            retString = retString + " - @OverUnderAmt@=" + payment.getOverUnderAmt();
        }
        return retString;
    }

    private String createPayment(MBankStatementLine bankStatementLine, int user1ID, int contractID) throws Exception {
        if (bankStatementLine == null || bankStatementLine.getC_Payment_ID() != 0) {
            return "--";
        }
        this.log.fine(bankStatementLine.toString());
        if (bankStatementLine.getC_Invoice_ID() == 0 && bankStatementLine.getC_BPartner_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ @C_Invoice_ID@ / @C_BPartner_ID@");
        }
        MBankStatement bankStatement = new MBankStatement(this.getCtx(), bankStatementLine.getC_BankStatement_ID(), this.get_TrxName());
        String documentNo = bankStatementLine.getReferenceNo();
        if (Util.isEmpty(documentNo)) {
            documentNo = bankStatementLine.getEftReference();
        }
        String checkNo = bankStatementLine.getEftCheckNo();
        MPayment payment = this.createPayment(bankStatementLine.getC_Invoice_ID(), bankStatementLine.getC_BPartner_ID(), bankStatementLine.getC_Currency_ID(), bankStatementLine.getStmtAmt(), bankStatementLine.getTrxAmt(), bankStatement.getC_BankAccount_ID(), bankStatementLine.getStatementLineDate(), bankStatementLine.getDateAcct(), bankStatementLine.getDescription(), bankStatementLine.getAD_Org_ID(), bankStatementLine.getC_Charge_ID(), this.getParameterAsString("TrxType").equals("U"), documentNo, checkNo, user1ID, contractID);
        bankStatementLine.setPayment(payment);
        bankStatementLine.saveEx();
        String retString = "@C_Payment_ID@ = " + payment.getDocumentNo();
        if (payment.getOverUnderAmt().signum() != 0) {
            retString = retString + " - @OverUnderAmt@=" + payment.getOverUnderAmt();
        }
        return retString;
    }

    private MPayment createPayment(int invoiceId, int bPartnerId, int currencyId, BigDecimal statementAmount, BigDecimal transactionAmount, int bankAccountId, Timestamp transactionDate, Timestamp accountingDate, String description, int organizationId, int chargeId, boolean isUnidentified, String documentNo, String checkNo, int user1ID, int contractID) {
        BigDecimal paymentAmount = transactionAmount;
        if (paymentAmount == null || Env.ZERO.compareTo(paymentAmount) == 0) {
            paymentAmount = statementAmount;
        }
        if (invoiceId == 0 && (paymentAmount == null || Env.ZERO.compareTo(paymentAmount) == 0)) {
            throw new IllegalStateException("@PayAmt@ = 0");
        }
        if (paymentAmount == null) {
            paymentAmount = Env.ZERO;
        }
        MOrgInfo organizationInfo = MOrgInfo.get(this.getCtx(), organizationId, this.get_TrxName());
        String transactionType = this.getParameterAsString("TrxType");
        MPayment payment = new MPayment(this.getCtx(), 0, this.get_TrxName());
        payment.setAD_Org_ID(organizationId);
        payment.setC_BankAccount_ID(bankAccountId);
        payment.setTenderType("A");
        if (transactionDate != null) {
            payment.setDateTrx(transactionDate);
        } else if (accountingDate != null) {
            payment.setDateTrx(accountingDate);
        }
        if (accountingDate != null) {
            payment.setDateAcct(accountingDate);
        } else {
            payment.setDateAcct(payment.getDateTrx());
        }
        payment.setDescription(description);
        if (invoiceId != 0) {
            MInvoice invoice = new MInvoice(this.getCtx(), invoiceId, null);
            payment.setC_DocType_ID(invoice.isSOTrx());
            payment.setC_Invoice_ID(invoice.getC_Invoice_ID());
            payment.setC_BPartner_ID(invoice.getC_BPartner_ID());
            if (paymentAmount.signum() != 0) {
                payment.setC_Currency_ID(currencyId);
                if (invoice.isSOTrx()) {
                    payment.setPayAmt(paymentAmount);
                } else {
                    payment.setPayAmt(paymentAmount.negate());
                }
                payment.setOverUnderAmt(invoice.getGrandTotal(true).subtract(payment.getPayAmt()));
            } else {
                payment.setC_Currency_ID(invoice.getC_Currency_ID());
                payment.setPayAmt(invoice.getGrandTotal(true));
            }
        } else if (bPartnerId != 0) {
            payment.setC_BPartner_ID(bPartnerId);
            payment.setC_Currency_ID(currencyId);
            if (chargeId != 0 && !isUnidentified) {
                payment.setC_Charge_ID(chargeId);
            }
            boolean isReceipt = paymentAmount.signum() > 0;
            payment.setPayAmt(paymentAmount.abs());
            if (organizationInfo.getUnidentifiedDocumentType(isReceipt) != 0) {
                payment.setC_DocType_ID(organizationInfo.getUnidentifiedDocumentType(isReceipt));
            } else {
                payment.setC_DocType_ID(isReceipt);
            }
        } else {
            throw new AdempiereException("@C_Invoice_ID@ / @C_BPartner_ID@ @NotFound@");
        }
        if (!Util.isEmpty(documentNo)) {
            payment.setDocumentNo(documentNo);
        }
        if (!Util.isEmpty(checkNo)) {
            payment.setCheckNo(checkNo);
        }
        payment.setIsUnidentifiedPayment(isUnidentified);
        if (user1ID > 0) {
            payment.setUser1_ID(user1ID);
        }
        if (contractID > 0) {
            payment.set_ValueOfColumn("S_Contract_ID", (Object)contractID);
        }
        if (transactionType.equals("B") || transactionType.equals("O")) {
            int campaignID;
            int activityID = this.getParameterAsInt("C_Activity_ID");
            if (activityID > 0) {
                payment.setC_Activity_ID(activityID);
            }
            if ((campaignID = this.getParameterAsInt("C_Campaign_ID")) > 0) {
                payment.setC_Campaign_ID(campaignID);
            }
        }
        payment.saveEx();
        payment.processIt("CO");
        payment.saveEx();
        return payment;
    }
}

