/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.core.domains.models.X_PP_Product_BOMLine;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.process.BOMVerifyAbstract;

public class BOMVerify
extends BOMVerifyAbstract {
    private ArrayList<MProduct> foundproducts = new ArrayList();
    private ArrayList<MProduct> validproducts = new ArrayList();
    private ArrayList<MProduct> invalidproducts = new ArrayList();
    private ArrayList<MProduct> containinvalidproducts = new ArrayList();
    private ArrayList<MProduct> checkedproducts = new ArrayList();

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getProductId() == 0) {
            this.setProductId(this.getRecord_ID());
        }
    }

    private List<Integer> getProductLists() {
        StringBuffer whereClause = new StringBuffer("IsBOM = 'Y'");
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (this.getProductCategoryId() == 0) {
            whereClause.append(" AND AD_Client_ID = ?");
            parameters.add(this.getAD_Client_ID());
        } else {
            whereClause.append(" AND M_Product_Category_ID = ?");
            parameters.add(this.getProductCategoryId());
        }
        if (!this.isReValidate()) {
            whereClause.append(" AND IsVerified <> 'Y'");
        }
        return new Query(this.getCtx(), "M_Product", whereClause.toString(), this.get_TrxName()).setParameters(parameters).setClient_ID().setOnlyActiveRecords(true).setOrderBy("Name").getIDsAsList();
    }

    @Override
    protected String doIt() throws Exception {
        if (this.getProductId() != 0) {
            this.log.info("M_Product_ID=" + this.getProductId());
            this.checkProduct(new MProduct(this.getCtx(), this.getProductId(), this.get_TrxName()));
            return "Product Checked";
        }
        this.log.info("M_Product_Category_ID=" + this.getProductCategoryId() + ", IsReValidate=" + this.isReValidate());
        AtomicInteger counter = new AtomicInteger(0);
        this.getProductLists().forEach(productId -> {
            this.checkProduct(new MProduct(this.getCtx(), (int)productId, this.get_TrxName()));
            counter.incrementAndGet();
        });
        return "#" + counter;
    }

    private void checkProduct(MProduct product) {
        if (product.isBOM() && !this.checkedproducts.contains(product)) {
            this.validateProduct(product);
        }
    }

    public static List<Integer> getBOMLinesFromProduct(MProduct product) {
        String whereClause = "PP_Product_BOM_ID IN ( SELECT PP_PRODUCT_BOM_ID FROM PP_PRODUCT_BOM WHERE M_PRODUCT_ID = " + product.getM_Product_ID() + ")";
        return new Query(product.getCtx(), "PP_Product_BOMLine", whereClause, product.get_TrxName()).setClient_ID().getIDsAsList();
    }

    private boolean validateProduct(MProduct product) {
        if (!product.isBOM()) {
            return false;
        }
        this.log.config(product.getName());
        this.foundproducts.add(product);
        AtomicBoolean containsinvalid = new AtomicBoolean(false);
        AtomicBoolean invalid = new AtomicBoolean(false);
        BOMVerify.getBOMLinesFromProduct(product).forEach(productBomLineId -> {
            X_PP_Product_BOMLine productBomLine = new X_PP_Product_BOMLine(this.getCtx(), (int)productBomLineId, this.get_TrxName());
            MProduct pp = new MProduct(this.getCtx(), productBomLine.getM_Product_ID(), this.get_TrxName());
            if (!pp.isBOM()) {
                this.log.finer(pp.getName());
            } else {
                if (this.validproducts.contains(pp)) {
                    // empty if block
                }
                if (this.invalidproducts.contains(pp)) {
                    containsinvalid.set(true);
                } else if (this.foundproducts.contains(pp)) {
                    invalid.set(true);
                    this.addLog(0, null, null, product.getValue() + " recursively contains " + pp.getValue());
                } else if (!this.validateProduct(pp)) {
                    containsinvalid.set(true);
                }
            }
        });
        this.checkedproducts.add(product);
        this.foundproducts.remove(product);
        if (invalid.get()) {
            this.invalidproducts.add(product);
            product.setIsVerified(false);
            product.save();
            return false;
        }
        if (containsinvalid.get()) {
            this.containinvalidproducts.add(product);
            product.setIsVerified(false);
            product.save();
            return false;
        }
        this.validproducts.add(product);
        product.setIsVerified(true);
        product.save();
        return true;
    }
}

