/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import org.compiere.model.MQuery;
import org.compiere.print.ArchiveEngine;
import org.compiere.print.CPaper;
import org.compiere.print.layout.LayoutEngine;
import org.compiere.print.layout.Page;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.spin.util.ILayoutView;

public class View
extends CPanel
implements ILayoutView {
    private static final long serialVersionUID = 5640892952739279088L;
    private LayoutEngine m_layout;
    private int m_zoomLevel = 2;
    public static final String[] ZOOM_OPTIONS = new String[]{"200%", "150%", "100%", "75%", "50%"};
    private static HashMap<String, Double> ZOOM_ScaleValues = new HashMap();
    public static int MARGIN;
    private static Color COLOR_BACKGROUND;
    private static CLogger log;

    public int getMarginSize(boolean doScale) {
        double scale = doScale ? this.getScale() : 1.0;
        return (int)((double)MARGIN * scale);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getMaximumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(this.getPaperWidth() + 2 * this.getMarginSize(true), (this.getPaperHeight() + this.getMarginSize(true)) * this.getPageCount() + this.getMarginSize(true));
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMaximumSize();
    }

    public boolean isArchivable() {
        return ArchiveEngine.isValid(this.m_layout);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        g2D.scale(this.getScale(), this.getScale());
        Rectangle bounds = g2D.getClipBounds();
        g2D.setColor(COLOR_BACKGROUND);
        g2D.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        for (int page = 0; page < this.m_layout.getPages().size(); ++page) {
            Rectangle pageRectangle = this.getRectangleOfPage(page + 1, false);
            if (!bounds.intersects(pageRectangle)) continue;
            Page p2 = this.m_layout.getPages().get(page);
            p2.paint(g2D, pageRectangle, true, false);
            this.m_layout.getHeaderFooter().paint(g2D, pageRectangle, true);
        }
    }

    public void setZoomLevel(int level) {
        this.m_zoomLevel = level;
    }

    public void setZoomLevel(String levelString) {
        for (int i2 = 0; i2 < ZOOM_OPTIONS.length; ++i2) {
            if (!ZOOM_OPTIONS[i2].equals(levelString)) continue;
            this.setZoomLevel(i2);
            break;
        }
    }

    public int getZoomLevel() {
        return this.m_zoomLevel;
    }

    private double getScale() {
        double scale = 1.0;
        if (this.m_zoomLevel >= 0) {
            Double scaleZoom = ZOOM_ScaleValues.get(ZOOM_OPTIONS[this.m_zoomLevel]);
            scale = scaleZoom != null ? scaleZoom : 1.0;
        }
        return scale;
    }

    public Rectangle getRectangleOfPage(int pageNo) {
        return this.getRectangleOfPage(pageNo, true);
    }

    public Rectangle getRectangleOfPage(int pageNo, boolean doScale) {
        int y = this.getMarginSize(doScale) + (pageNo - 1) * (this.getPaperHeight(doScale) + this.getMarginSize(doScale));
        return new Rectangle(this.getMarginSize(doScale), y, this.getPaperWidth(doScale), this.getPaperHeight(doScale));
    }

    public float getPageNoAt(Point p2) {
        float y = (float)((double)p2.y / this.getScale());
        float pageHeight = this.getPaperHeight(false) + this.getMarginSize(false);
        return 1.0f + y / pageHeight;
    }

    public int getPageCount() {
        return this.m_layout.getPages().size();
    }

    public String getPageInfo(int pageNo) {
        return this.m_layout.getPageInfo(pageNo);
    }

    public String getPageInfoMax() {
        return this.m_layout.getPageInfoMax();
    }

    public CPaper getPaper() {
        return this.m_layout.getPaper();
    }

    public int getPaperHeight() {
        return this.getPaperHeight(true);
    }

    public int getPaperHeight(boolean doScale) {
        double scale = doScale ? this.getScale() : 1.0;
        return (int)(this.m_layout.getPaper().getHeight(true) * scale);
    }

    public int getPaperWidth() {
        return this.getPaperWidth(true);
    }

    public int getPaperWidth(boolean doScale) {
        double scale = doScale ? this.getScale() : 1.0;
        return (int)(this.m_layout.getPaper().getWidth(true) * scale);
    }

    public MQuery getDrillDown(Point absolutePoint) {
        int pageNo = (int)this.getPageNoAt(absolutePoint);
        Rectangle pageRectangle = this.getRectangleOfPage(pageNo, false);
        Point relativePoint = new Point((int)((double)absolutePoint.x / this.getScale() - (double)pageRectangle.x), (int)((double)absolutePoint.y / this.getScale() - (double)pageRectangle.y));
        Page page = this.m_layout.getPages().get(pageNo - 1);
        log.config("Relative=" + relativePoint + ", " + page);
        MQuery retValue = page.getDrillDown(relativePoint);
        if (retValue == null) {
            retValue = this.m_layout.getHeaderFooter().getDrillDown(relativePoint);
        }
        return retValue;
    }

    public MQuery getDrillAcross(Point absolutePoint) {
        int pageNo = (int)this.getPageNoAt(absolutePoint);
        Rectangle pageRectangle = this.getRectangleOfPage(pageNo);
        Point relativePoint = new Point((int)((double)absolutePoint.x / this.getScale() - (double)pageRectangle.x), (int)((double)absolutePoint.y / this.getScale() - (double)pageRectangle.y));
        Page page = this.m_layout.getPages().get(pageNo - 1);
        log.config("Relative=" + relativePoint + ", " + page);
        return page.getDrillAcross(relativePoint);
    }

    @Override
    public void loadView(LayoutEngine layoutEngine) {
        this.m_layout = layoutEngine;
    }

    @Override
    public void reloadVew() {
        this.revalidate();
    }

    @Override
    public boolean isLoaded() {
        return this.m_layout != null;
    }

    static {
        ZOOM_ScaleValues.put("200%", 2.0);
        ZOOM_ScaleValues.put("150%", 1.5);
        ZOOM_ScaleValues.put("100%", 1.0);
        ZOOM_ScaleValues.put("75%", 0.75);
        ZOOM_ScaleValues.put("50%", 0.5);
        MARGIN = 5;
        COLOR_BACKGROUND = Color.lightGray;
        log = CLogger.getCLogger(View.class);
    }
}

