/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_AD_PrintTableFormat;
import org.compiere.model.MAttachment;
import org.compiere.model.MImage;
import org.compiere.print.MPrintColor;
import org.compiere.print.MPrintFont;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MPrintTableFormat
extends X_AD_PrintTableFormat {
    private static final long serialVersionUID = -357529310875242899L;
    private Font standard_Font = new Font(null);
    private Font pageHeader_Font;
    private Font pageFooter_Font;
    private Color pageHeaderFG_Color;
    private Color pageHeaderBG_Color;
    private Color pageFooterFG_Color;
    private Color pageFooterBG_Color;
    private Font parameter_Font;
    private Color parameter_Color;
    private Font header_Font;
    private Color headerFG_Color;
    private Color headerBG_Color;
    private Color hdrLine_Color;
    private Stroke header_Stroke;
    private Font funct_Font;
    private Color functFG_Color;
    private Color functBG_Color;
    private Color lineH_Color;
    private Color lineV_Color;
    private Stroke lineH_Stroke;
    private Stroke lineV_Stroke;
    private Image m_image = null;
    private Image m_image_water_mark = null;
    private static CCache<Integer, MPrintTableFormat> s_cache = new CCache("AD_PrintTableFormat", 3);
    private static CLogger s_log = CLogger.getCLogger(MPrintTableFormat.class);

    public MPrintTableFormat(Properties ctx, int AD_PrintTableFormat_ID, String trxName) {
        super(ctx, AD_PrintTableFormat_ID, trxName);
        if (AD_PrintTableFormat_ID == 0) {
            this.setIsDefault(false);
            this.setIsPaintHeaderLines(true);
            this.setIsPaintBoundaryLines(false);
            this.setIsPaintHLines(false);
            this.setIsPaintVLines(false);
            this.setIsPrintFunctionSymbols(true);
        }
    }

    public MPrintTableFormat(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setStandard_Font(Font standardFont) {
        if (standardFont != null) {
            this.standard_Font = standardFont;
        }
    }

    public Font getStandard_Font() {
        return this.standard_Font;
    }

    public Font getHeader_Font() {
        if (this.header_Font != null) {
            return this.header_Font;
        }
        int i2 = this.getHdr_PrintFont_ID();
        if (i2 != 0) {
            this.header_Font = MPrintFont.get(i2).getFont();
        }
        if (this.header_Font == null) {
            this.header_Font = new Font(this.standard_Font.getName(), 1, this.standard_Font.getSize());
        }
        return this.header_Font;
    }

    public Color getHeaderFG_Color() {
        if (this.headerFG_Color != null) {
            return this.headerFG_Color;
        }
        int i2 = this.getHdrTextFG_PrintColor_ID();
        if (i2 != 0) {
            this.headerFG_Color = MPrintColor.get(this.getCtx(), i2).getColor();
        }
        if (this.headerFG_Color == null) {
            this.headerFG_Color = MPrintColor.blackBlue;
        }
        return this.headerFG_Color;
    }

    public Color getHeaderBG_Color() {
        if (this.headerBG_Color != null) {
            return this.headerBG_Color;
        }
        int i2 = this.getHdrTextBG_PrintColor_ID();
        if (i2 != 0) {
            this.headerBG_Color = MPrintColor.get(this.getCtx(), i2).getColor();
        }
        if (this.headerBG_Color == null) {
            this.headerBG_Color = Color.cyan;
        }
        return this.headerBG_Color;
    }

    public Color getHeaderLine_Color() {
        if (this.hdrLine_Color != null) {
            return this.hdrLine_Color;
        }
        int i2 = this.getHdrLine_PrintColor_ID();
        if (i2 != 0) {
            this.hdrLine_Color = MPrintColor.get(this.getCtx(), i2).getColor();
        }
        if (this.hdrLine_Color == null) {
            this.hdrLine_Color = MPrintColor.blackBlue;
        }
        return this.hdrLine_Color;
    }

    public Stroke getHeader_Stroke() {
        if (this.header_Stroke == null) {
            float width = this.getHdrStroke().floatValue();
            if (this.getHdrStrokeType() == null || "S".equals(this.getHdrStrokeType())) {
                this.header_Stroke = new BasicStroke(width);
            } else if ("D".equals(this.getHdrStrokeType())) {
                this.header_Stroke = new BasicStroke(width, 0, 2, 1.0f, this.getPatternDashed(width), 0.0f);
            } else if ("d".equals(this.getHdrStrokeType())) {
                this.header_Stroke = new BasicStroke(width, 0, 2, 1.0f, this.getPatternDotted(width), 0.0f);
            } else if ("2".equals(this.getHdrStrokeType())) {
                this.header_Stroke = new BasicStroke(width, 0, 2, 1.0f, this.getPatternDash_Dotted(width), 0.0f);
            }
            if (this.header_Stroke == null) {
                this.header_Stroke = new BasicStroke(width);
            }
        }
        return this.header_Stroke;
    }

    @Override
    public BigDecimal getHdrStroke() {
        BigDecimal retValue = super.getHdrStroke();
        if (retValue == null || Env.ZERO.compareTo(retValue) <= 0) {
            retValue = new BigDecimal(2.0);
        }
        return retValue;
    }

    public Font getFunct_Font() {
        if (this.funct_Font != null) {
            return this.funct_Font;
        }
        int i2 = this.getFunct_PrintFont_ID();
        if (i2 != 0) {
            this.funct_Font = MPrintFont.get(i2).getFont();
        }
        if (this.funct_Font == null) {
            this.funct_Font = new Font(this.standard_Font.getName(), 3, this.standard_Font.getSize());
        }
        return this.funct_Font;
    }

    public Color getFunctBG_Color() {
        if (this.functBG_Color != null) {
            return this.functBG_Color;
        }
        int i2 = this.getFunctBG_PrintColor_ID();
        if (i2 != 0) {
            this.functBG_Color = MPrintColor.get(this.getCtx(), i2).getColor();
        }
        if (this.functBG_Color == null) {
            this.functBG_Color = Color.white;
        }
        return this.functBG_Color;
    }

    public Color getFunctFG_Color() {
        if (this.functFG_Color != null) {
            return this.functFG_Color;
        }
        int i2 = this.getFunctFG_PrintColor_ID();
        if (i2 != 0) {
            this.functFG_Color = MPrintColor.get(this.getCtx(), i2).getColor();
        }
        if (this.functFG_Color == null) {
            this.functFG_Color = MPrintColor.darkGreen;
        }
        return this.functFG_Color;
    }

    public Font getParameter_Font() {
        if (this.parameter_Font == null) {
            this.parameter_Font = new Font(this.standard_Font.getName(), 2, this.standard_Font.getSize());
        }
        return this.parameter_Font;
    }

    public Color getParameter_Color() {
        if (this.parameter_Color == null) {
            this.parameter_Color = Color.darkGray;
        }
        return this.parameter_Color;
    }

    public Font getPageHeader_Font() {
        if (this.pageHeader_Font == null) {
            this.pageHeader_Font = new Font(this.standard_Font.getName(), 1, this.standard_Font.getSize());
        }
        return this.pageHeader_Font;
    }

    public Color getPageHeaderFG_Color() {
        if (this.pageHeaderFG_Color == null) {
            this.pageHeaderFG_Color = MPrintColor.blackBlue;
        }
        return this.pageHeaderFG_Color;
    }

    public Color getPageHeaderBG_Color() {
        if (this.pageHeaderBG_Color == null) {
            this.pageHeaderBG_Color = Color.white;
        }
        return this.pageHeaderBG_Color;
    }

    public Font getPageFooter_Font() {
        if (this.pageFooter_Font == null) {
            this.pageFooter_Font = new Font(this.standard_Font.getName(), 0, this.standard_Font.getSize() - 2);
        }
        return this.pageFooter_Font;
    }

    public Color getPageFooterFG_Color() {
        if (this.pageFooterFG_Color == null) {
            this.pageFooterFG_Color = MPrintColor.blackBlue;
        }
        return this.pageFooterFG_Color;
    }

    public Color getPageFooterBG_Color() {
        if (this.pageFooterBG_Color == null) {
            this.pageFooterBG_Color = Color.white;
        }
        return this.pageFooterBG_Color;
    }

    public Color getHLine_Color() {
        if (this.lineH_Color != null) {
            return this.lineH_Color;
        }
        int i2 = this.getLine_PrintColor_ID();
        if (i2 != 0) {
            this.lineH_Color = MPrintColor.get(this.getCtx(), i2).getColor();
        }
        if (this.lineH_Color == null) {
            this.lineH_Color = Color.lightGray;
        }
        return this.lineH_Color;
    }

    public Color getVLine_Color() {
        if (this.lineV_Color != null) {
            return this.lineV_Color;
        }
        int i2 = this.getLine_PrintColor_ID();
        if (i2 != 0) {
            this.lineV_Color = MPrintColor.get(this.getCtx(), i2).getColor();
        }
        if (this.lineV_Color == null) {
            this.lineV_Color = Color.lightGray;
        }
        return this.lineV_Color;
    }

    public Stroke getHLine_Stroke() {
        if (this.lineH_Stroke == null) {
            float width = this.getLineStroke().floatValue() / 2.0f;
            if (this.getHdrStrokeType() == null || "d".equals(this.getLineStrokeType())) {
                this.lineH_Stroke = new BasicStroke(width, 0, 2, 1.0f, this.getPatternDotted(width), 0.0f);
            } else if ("S".equals(this.getLineStrokeType())) {
                this.lineH_Stroke = new BasicStroke(width);
            } else if ("D".equals(this.getLineStrokeType())) {
                this.lineH_Stroke = new BasicStroke(width, 0, 2, 1.0f, this.getPatternDashed(width), 0.0f);
            } else if ("2".equals(this.getLineStrokeType())) {
                this.lineH_Stroke = new BasicStroke(width, 0, 2, 1.0f, this.getPatternDash_Dotted(width), 0.0f);
            }
            if (this.lineH_Stroke == null) {
                this.lineH_Stroke = new BasicStroke(width, 0, 2, 1.0f, this.getPatternDotted(width), 0.0f);
            }
        }
        return this.lineH_Stroke;
    }

    public Stroke getVLine_Stroke() {
        if (this.lineV_Stroke == null) {
            float width = this.getLineStroke().floatValue() / 2.0f;
            if (this.getHdrStrokeType() == null || "d".equals(this.getLineStrokeType())) {
                this.lineV_Stroke = new BasicStroke(width, 0, 2, 1.0f, this.getPatternDotted(width), 0.0f);
            } else if ("S".equals(this.getLineStrokeType())) {
                this.lineV_Stroke = new BasicStroke(width);
            } else if ("D".equals(this.getLineStrokeType())) {
                this.lineV_Stroke = new BasicStroke(width, 0, 2, 1.0f, this.getPatternDashed(width), 0.0f);
            } else if ("2".equals(this.getLineStrokeType())) {
                this.lineV_Stroke = new BasicStroke(width, 0, 2, 1.0f, this.getPatternDash_Dotted(width), 0.0f);
            }
            if (this.lineV_Stroke == null) {
                this.lineV_Stroke = new BasicStroke(width, 0, 2, 1.0f, this.getPatternDotted(width), 0.0f);
            }
        }
        return this.lineV_Stroke;
    }

    @Override
    public BigDecimal getLineStroke() {
        BigDecimal retValue = super.getLineStroke();
        if (retValue == null || Env.ZERO.compareTo(retValue) <= 0) {
            retValue = new BigDecimal(1.0);
        }
        return retValue;
    }

    public BigDecimal getVLineStroke() {
        BigDecimal retValue = super.getLineStroke();
        if (retValue == null || Env.ZERO.compareTo(retValue) <= 0) {
            retValue = new BigDecimal(1.0);
        }
        return retValue;
    }

    private float[] getPatternDotted(float width) {
        return new float[]{2.0f * width, 2.0f * width};
    }

    private float[] getPatternDashed(float width) {
        return new float[]{10.0f * width, 4.0f * width};
    }

    private float[] getPatternDash_Dotted(float width) {
        return new float[]{10.0f * width, 2.0f * width, 2.0f * width, 2.0f * width};
    }

    public static MPrintTableFormat get(Properties ctx, int AD_PrintTableFormat_ID, Font standard_font) {
        Integer ii = AD_PrintTableFormat_ID;
        MPrintTableFormat tf = s_cache.get(ii);
        if (tf == null) {
            tf = AD_PrintTableFormat_ID == 0 ? MPrintTableFormat.getDefault(ctx) : new MPrintTableFormat(ctx, AD_PrintTableFormat_ID, null);
            s_cache.put(ii, tf);
        }
        tf.setStandard_Font(standard_font);
        return tf;
    }

    public static MPrintTableFormat get(Properties ctx, int AD_PrintTableFormat_ID, int AD_PrintFont_ID) {
        return MPrintTableFormat.get(ctx, AD_PrintTableFormat_ID, MPrintFont.get(AD_PrintFont_ID).getFont());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MPrintTableFormat getDefault(Properties ctx) {
        ResultSet rs;
        CPreparedStatement pstmt;
        MPrintTableFormat tf;
        block4: {
            tf = null;
            String sql = "SELECT * FROM AD_PrintTableFormat WHERE AD_Client_ID IN (0,?) AND IsActive='Y' ORDER BY IsDefault DESC, AD_Client_ID DESC";
            int AD_Client_ID = Env.getAD_Client_ID(ctx);
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, AD_Client_ID);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block4;
                tf = new MPrintTableFormat(ctx, rs, null);
            }
            catch (Exception e) {
                try {
                    s_log.log(Level.SEVERE, sql, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return tf;
    }

    public Image getImage() {
        if (this.m_image != null) {
            return this.m_image;
        }
        if (this.isImageIsAttached()) {
            MAttachment attachment = MAttachment.get(this.getCtx(), Table_ID, this.get_ID());
            if (attachment == null) {
                this.log.log(Level.WARNING, "No Attachment - ID=" + this.get_ID());
                return null;
            }
            if (attachment.getEntryCount() != 1) {
                this.log.log(Level.WARNING, "Need just 1 Attachment Entry = " + attachment.getEntryCount());
                return null;
            }
            byte[] imageData = attachment.getEntryData(0);
            if (imageData != null) {
                this.m_image = Toolkit.getDefaultToolkit().createImage(imageData);
            }
            if (this.m_image != null) {
                this.log.fine(attachment.getEntryName(0) + " - Size=" + imageData.length);
            } else {
                this.log.log(Level.WARNING, attachment.getEntryName(0) + " - not loaded (must be gif or jpg) - ID=" + this.get_ID());
            }
        } else if (this.getImageURL() != null) {
            try {
                URL url = new URL(this.getImageURL());
                Toolkit tk = Toolkit.getDefaultToolkit();
                this.m_image = tk.getImage(url);
            }
            catch (MalformedURLException e) {
                this.log.log(Level.WARNING, "Malformed URL - " + this.getImageURL(), e);
            }
        }
        return this.m_image;
    }

    public Image getImageWaterMark() {
        if (this.m_image_water_mark != null) {
            return this.m_image_water_mark;
        }
        if (this.getAD_Image_ID() > 0) {
            this.m_image_water_mark = MImage.get(this.getCtx(), this.getAD_Image_ID()).getImage();
        }
        return this.m_image_water_mark;
    }
}

