/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Trx;

public class PO_LOB
implements Serializable {
    private static final long serialVersionUID = -325477490976139224L;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private String m_tableName;
    private String m_columnName;
    private String m_whereClause;
    private int m_displayType;
    private Object m_value;

    public PO_LOB(String tableName, String columnName, String whereClause, int displayType, Object value) {
        this.m_tableName = tableName;
        this.m_columnName = columnName;
        this.m_whereClause = whereClause;
        this.m_displayType = displayType;
        this.m_value = value;
    }

    public boolean save(String whereClause, String trxName) {
        this.m_whereClause = whereClause;
        return this.save(trxName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(String trxName) {
        boolean success;
        PreparedStatement pstmt;
        Connection con;
        Trx trx;
        block40: {
            if (this.m_value == null || !(this.m_value instanceof String) && !(this.m_value instanceof byte[]) || this.m_value instanceof String && this.m_value.toString().length() == 0 || this.m_value instanceof byte[] && ((byte[])this.m_value).length == 0) {
                StringBuffer sql = new StringBuffer("UPDATE ").append(this.m_tableName).append(" SET ").append(this.m_columnName).append("=null WHERE ").append(this.m_whereClause);
                int no = DB.executeUpdate(sql.toString(), trxName);
                this.log.fine("save [" + trxName + "] #" + no + " - no data - set to null - " + this.m_value);
                if (no == 0) {
                    this.log.warning("[" + trxName + "] - not updated - " + sql);
                }
                return true;
            }
            StringBuffer sql = new StringBuffer("UPDATE ").append(this.m_tableName).append(" SET ").append(this.m_columnName).append("=? WHERE ").append(this.m_whereClause);
            this.log.fine("[" + trxName + "] - Local - " + this.m_value);
            trx = null;
            if (trxName != null) {
                trx = Trx.get(trxName, false);
            }
            con = null;
            if (trx != null) {
                con = trx.getConnection();
            }
            if (con == null) {
                con = DB.createConnection(false, 2);
            }
            if (con == null) {
                this.log.log(Level.SEVERE, "Could not get Connection");
                return false;
            }
            pstmt = null;
            success = true;
            try {
                pstmt = con.prepareStatement(sql.toString());
                if (DisplayType.isText(this.m_displayType)) {
                    pstmt.setString(1, (String)this.m_value);
                } else {
                    pstmt.setBytes(1, (byte[])this.m_value);
                }
                int no = pstmt.executeUpdate();
                if (no == 1) break block40;
                this.log.warning("[" + trxName + "] - Not updated #" + no + " - " + sql);
                success = false;
            }
            catch (Throwable e) {
                try {
                    this.log.log(Level.SEVERE, "[" + trxName + "] - " + sql, e);
                    success = false;
                }
                catch (Throwable throwable) {
                    DB.close(pstmt);
                    pstmt = null;
                    throw throwable;
                }
                DB.close(pstmt);
                pstmt = null;
            }
        }
        DB.close(pstmt);
        pstmt = null;
        if (success) {
            if (trx != null) {
                trx = null;
                con = null;
            } else {
                try {
                    con.commit();
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "[" + trxName + "] - commit ", e);
                    success = false;
                }
                finally {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {}
                    con = null;
                }
            }
        }
        if (!success) {
            this.log.severe("[" + trxName + "] - rollback");
            if (trx != null) {
                trx.rollback();
                trx = null;
                con = null;
            } else {
                try {
                    con.rollback();
                }
                catch (Exception ee) {
                    this.log.log(Level.SEVERE, "[" + trxName + "] - rollback", ee);
                }
                finally {
                    try {
                        con.close();
                    }
                    catch (SQLException sQLException) {}
                    con = null;
                }
            }
        }
        return success;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PO_LOB[");
        sb.append(this.m_tableName).append(".").append(this.m_columnName).append(",DisplayType=").append(this.m_displayType).append("]");
        return sb.toString();
    }
}

