/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_AD_SysConfig;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MSysConfig
extends X_AD_SysConfig {
    private static final long serialVersionUID = -5271070197457739666L;
    private static CLogger s_log = CLogger.getCLogger(MSysConfig.class);
    private static CCache<String, String> s_cache = new CCache("AD_SysConfig", 40, 0);

    public MSysConfig(Properties ctx, int AD_SysConfig_ID, String trxName) {
        super(ctx, AD_SysConfig_ID, trxName);
        if (AD_SysConfig_ID == 0) {
            // empty if block
        }
    }

    public static MSysConfig get(Properties context, String name, String transactionName) {
        MSysConfig sysConfig = (MSysConfig)new Query(context, "AD_SysConfig", "Name=?", transactionName).setClient_ID().setParameters(name).first();
        return sysConfig;
    }

    public MSysConfig(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static void resetCache() {
        s_cache.reset();
    }

    public static String getValue(String Name2, String defaultValue) {
        return MSysConfig.getValue(Name2, defaultValue, 0, 0);
    }

    public static String getValue(String Name2) {
        return MSysConfig.getValue(Name2, null);
    }

    public static int getIntValue(String Name2, int defaultValue) {
        String s = MSysConfig.getValue(Name2);
        if (s == null) {
            return defaultValue;
        }
        if (s.length() == 0) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            s_log.log(Level.SEVERE, "getIntValue (" + Name2 + ") = " + s, e);
            return defaultValue;
        }
    }

    public static double getDoubleValue(String Name2, double defaultValue) {
        String s = MSysConfig.getValue(Name2);
        if (s == null || s.length() == 0) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            s_log.log(Level.SEVERE, "getDoubleValue (" + Name2 + ") = " + s, e);
            return defaultValue;
        }
    }

    public static boolean getBooleanValue(String Name2, boolean defaultValue) {
        String s = MSysConfig.getValue(Name2);
        if (s == null || s.length() == 0) {
            return defaultValue;
        }
        if ("Y".equalsIgnoreCase(s)) {
            return true;
        }
        if ("N".equalsIgnoreCase(s)) {
            return false;
        }
        return Boolean.valueOf(s);
    }

    public static String getValue(String Name2, String defaultValue, int AD_Client_ID) {
        return MSysConfig.getValue(Name2, defaultValue, AD_Client_ID, 0);
    }

    public static String getValue(String Name2, int AD_Client_ID) {
        return MSysConfig.getValue(Name2, null, AD_Client_ID);
    }

    public static int getIntValue(String Name2, int defaultValue, int AD_Client_ID) {
        String s = MSysConfig.getValue(Name2, AD_Client_ID);
        if (s == null) {
            return defaultValue;
        }
        if (s.length() == 0) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            s_log.log(Level.SEVERE, "getIntValue (" + Name2 + ") = " + s, e);
            return defaultValue;
        }
    }

    public static double getDoubleValue(String Name2, double defaultValue, int AD_Client_ID) {
        String s = MSysConfig.getValue(Name2, AD_Client_ID);
        if (s == null || s.length() == 0) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            s_log.log(Level.SEVERE, "getDoubleValue (" + Name2 + ") = " + s, e);
            return defaultValue;
        }
    }

    public static boolean getBooleanValue(String Name2, boolean defaultValue, int AD_Client_ID) {
        String s = MSysConfig.getValue(Name2, AD_Client_ID);
        if (s == null || s.length() == 0) {
            return defaultValue;
        }
        if ("Y".equalsIgnoreCase(s)) {
            return true;
        }
        if ("N".equalsIgnoreCase(s)) {
            return false;
        }
        return Boolean.valueOf(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getValue(String Name2, String defaultValue, int AD_Client_ID, int AD_Org_ID) {
        String key = AD_Client_ID + "_" + AD_Org_ID + "_" + Name2;
        String str = s_cache.get(key);
        if (str != null) {
            return str;
        }
        if (str == null && s_cache.containsKey(key)) {
            return defaultValue;
        }
        String sql = "SELECT Value FROM AD_SysConfig WHERE Name=? AND AD_Client_ID IN (0, ?) AND AD_Org_ID IN (0, ?) AND IsActive='Y' ORDER BY AD_Client_ID DESC, AD_Org_ID DESC";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, Name2);
            pstmt.setInt(2, AD_Client_ID);
            pstmt.setInt(3, AD_Org_ID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                str = rs.getString(1);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, "getValue", e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (str != null) {
            str = str.trim();
            s_cache.put(key, str);
            return str;
        }
        s_cache.put(key, null);
        return defaultValue;
    }

    public static String getValue(String Name2, int AD_Client_ID, int AD_Org_ID) {
        return MSysConfig.getValue(Name2, null, AD_Client_ID, AD_Org_ID);
    }

    public static int getIntValue(String Name2, int defaultValue, int AD_Client_ID, int AD_Org_ID) {
        String s = MSysConfig.getValue(Name2, AD_Client_ID, AD_Org_ID);
        if (s == null) {
            return defaultValue;
        }
        if (s.length() == 0) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            s_log.log(Level.SEVERE, "getIntValue (" + Name2 + ") = " + s, e);
            return defaultValue;
        }
    }

    public static double getDoubleValue(String Name2, double defaultValue, int AD_Client_ID, int AD_Org_ID) {
        String s = MSysConfig.getValue(Name2, AD_Client_ID, AD_Org_ID);
        if (s == null || s.length() == 0) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            s_log.log(Level.SEVERE, "getDoubleValue (" + Name2 + ") = " + s, e);
            return defaultValue;
        }
    }

    public static boolean getBooleanValue(String Name2, boolean defaultValue, int AD_Client_ID, int AD_Org_ID) {
        String s = MSysConfig.getValue(Name2, AD_Client_ID, AD_Org_ID);
        if (s == null || s.length() == 0) {
            return defaultValue;
        }
        if ("Y".equalsIgnoreCase(s)) {
            return true;
        }
        if ("N".equalsIgnoreCase(s)) {
            return false;
        }
        return Boolean.valueOf(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean beforeSave(boolean newRecord) {
        this.log.fine("New=" + newRecord);
        if (this.getAD_Client_ID() != 0 || this.getAD_Org_ID() != 0) {
            String configLevel = null;
            String sql = "SELECT ConfigurationLevel FROM AD_SysConfig WHERE Name=? AND AD_Client_ID = 0 AND AD_Org_ID = 0";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setString(1, this.getName());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    configLevel = rs.getString(1);
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            catch (SQLException e) {
                s_log.log(Level.SEVERE, "getValue", e);
            }
            finally {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            if (configLevel == null && this.getAD_Org_ID() != 0) {
                sql = "SELECT ConfigurationLevel FROM AD_SysConfig WHERE Name=? AND AD_Client_ID = ? AND AD_Org_ID = 0";
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setString(1, this.getName());
                    pstmt.setInt(2, this.getAD_Client_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        configLevel = rs.getString(1);
                    }
                }
                catch (SQLException e) {
                    s_log.log(Level.SEVERE, "getValue", e);
                }
                finally {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                }
            }
            if (configLevel != null) {
                this.setConfigurationLevel(configLevel);
                if (this.getAD_Org_ID() != 0 && (configLevel.equals("S") || configLevel.equals("C"))) {
                    this.log.saveError("Can't Save Org Level", "This is a system or client parameter, you can't save it as organization parameter");
                    return false;
                }
                if (this.getAD_Client_ID() != 0 && configLevel.equals("S")) {
                    this.log.saveError("Can't Save Client Level", "This is a system parameter, you can't save it as client parameter");
                    return false;
                }
            } else if (this.getAD_Org_ID() != 0) {
                this.setConfigurationLevel("O");
            } else if (this.getAD_Client_ID() != 0 && this.getConfigurationLevel().equals("S")) {
                this.setConfigurationLevel("C");
            }
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.get_ID() + ", " + this.getName() + "=" + this.getValue() + ", ConfigurationLevel=" + this.getConfigurationLevel() + ", Client|Org=" + this.getAD_Client_ID() + "|" + this.getAD_Org_ID() + ", EntityType=" + this.getEntityType() + "]";
    }
}

