/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_W_Store;
import org.compiere.db.CConnection;
import org.compiere.interfaces.Server;
import org.compiere.model.MClient;
import org.compiere.model.MMailMsg;
import org.compiere.model.MWarehouse;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;

public class MStore
extends X_W_Store {
    private static final long serialVersionUID = -5836212836465405633L;
    private static CCache<Integer, MStore> s_cache = new CCache("W_Store", 2);
    private static CLogger s_log = CLogger.getCLogger(MStore.class);
    private MMailMsg[] m_msgs = null;

    public static MStore get(Properties ctx, int W_Store_ID) {
        Integer key = W_Store_ID;
        MStore retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MStore(ctx, W_Store_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static MStore get(Properties ctx, String contextPath) {
        ResultSet rs;
        MStore wstore2 = null;
        for (MStore wstore2 : s_cache.values()) {
            if (!wstore2.getWebContext().equals(contextPath)) continue;
            return wstore2;
        }
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM W_Store WHERE WebContext=?";
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, contextPath);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                wstore2 = new MStore(ctx, rs, null);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (wstore2 == null) {
            sql = "SELECT * FROM W_Store WHERE AD_Client_ID=? AND IsActive='Y' ORDER BY W_Store_ID";
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, Env.getAD_Client_ID(ctx));
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    wstore2 = new MStore(ctx, rs, null);
                    s_log.warning("Context " + contextPath + " Not found - Found via AD_Client_ID=" + Env.getAD_Client_ID(ctx));
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                s_log.log(Level.SEVERE, sql, e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
        }
        if (wstore2 == null) {
            return null;
        }
        Integer key = wstore2.getW_Store_ID();
        s_cache.put(key, wstore2);
        return wstore2;
    }

    public static MStore[] getOfClient(MClient client) {
        ArrayList<MStore> list = new ArrayList<MStore>();
        String sql = "SELECT * FROM W_Store WHERE AD_Client_ID=? AND IsActive='Y'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, client.get_TrxName());
            pstmt.setInt(1, client.getAD_Client_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MStore(client.getCtx(), rs, client.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MStore[] retValue = new MStore[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MStore[] getActive() {
        s_log.info("");
        try {
            Collection<MStore> cc = s_cache.values();
            Object[] oo = cc.toArray();
            for (int i2 = 0; i2 < oo.length; ++i2) {
                s_log.info(i2 + ": " + oo[i2]);
            }
            MStore[] retValue = new MStore[oo.length];
            for (int i3 = 0; i3 < oo.length; ++i3) {
                retValue[i3] = (MStore)oo[i3];
            }
            return retValue;
        }
        catch (Exception e) {
            s_log.severe(e.toString());
            return new MStore[0];
        }
    }

    public MStore(Properties ctx, int W_Store_ID, String trxName) {
        super(ctx, W_Store_ID, trxName);
        if (W_Store_ID == 0) {
            this.setIsDefault(false);
            this.setIsMenuAssets(true);
            this.setIsMenuContact(true);
            this.setIsMenuInterests(true);
            this.setIsMenuInvoices(true);
            this.setIsMenuOrders(true);
            this.setIsMenuPayments(true);
            this.setIsMenuRegistrations(true);
            this.setIsMenuRequests(true);
            this.setIsMenuRfQs(true);
            this.setIsMenuShipments(true);
        }
    }

    public MStore(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getWebContext(boolean full) {
        if (!full) {
            return super.getURL();
        }
        Object url = super.getURL();
        if (url == null || ((String)url).length() == 0) {
            url = "http://localhost";
        }
        if (((String)url).endsWith("/")) {
            url = (String)url + ((String)url).substring(0, ((String)url).length() - 1);
        }
        return (String)url + this.getWebContext();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("WStore[");
        sb.append(this.getWebContext(true)).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        boolean urlOK;
        String url;
        if (!this.getWebContext().startsWith("/")) {
            this.setWebContext("/" + this.getWebContext());
        }
        if (newRecord || this.is_ValueChanged("M_Warehouse_ID") || this.getAD_Org_ID() == 0) {
            MWarehouse wh = new MWarehouse(this.getCtx(), this.getM_Warehouse_ID(), this.get_TrxName());
            this.setAD_Org_ID(wh.getAD_Org_ID());
        }
        if ((url = this.getURL()) == null) {
            url = "";
        }
        boolean bl = urlOK = url.startsWith("http://") || url.startsWith("https://");
        if (!urlOK) {
            this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "URL") + " - e.g. http://www.adempiere.org");
            return false;
        }
        return true;
    }

    public EMail createEMail(String to, String subject, String message) {
        String from;
        if (to == null || to.length() == 0) {
            this.log.warning("No To");
            return null;
        }
        EMail email = null;
        MClient client = MClient.get(this.getCtx(), this.getAD_Client_ID());
        if (client.isServerEMail() && Ini.isClient()) {
            try {
                Server server = CConnection.get().getServer();
                if (server != null) {
                    email = server.createEMail(Env.getRemoteCallCtx(this.getCtx()), this.getAD_Client_ID(), to, subject, message);
                } else {
                    this.log.log(Level.WARNING, "No AppsServer");
                }
            }
            catch (Exception ex) {
                this.log.log(Level.SEVERE, this.getName() + " - AppsServer error", ex);
            }
        }
        if ((from = this.getWStoreEMail()) == null || from.length() == 0) {
            from = client.getRequestEMail();
        }
        if (email == null) {
            email = new EMail(client, from, to, subject, message);
        }
        if (client.isSmtpAuthorization()) {
            if (this.getWStoreEMail() != null && this.getWStoreUser() != null && this.getWStoreUserPW() != null) {
                email.createAuthenticator(this.getWStoreUser(), this.getWStoreUserPW());
            } else {
                email.createAuthenticator(client.getRequestUser(), client.getRequestUserPW());
            }
        }
        email.addBcc(from);
        return email;
    }

    public boolean sendEMail(String to, String subject, String message) {
        EMail email;
        if (message == null || message.length() == 0) {
            this.log.warning("No Message");
            return false;
        }
        StringBuffer msgText = new StringBuffer();
        if (this.getEMailHeader() != null) {
            msgText.append(this.getEMailHeader());
        }
        msgText.append(message);
        if (this.getEMailFooter() != null) {
            msgText.append(this.getEMailFooter());
        }
        if ((email = this.createEMail(to, subject, msgText.toString())) == null) {
            return false;
        }
        try {
            String msg = email.send();
            if ("OK".equals(email.send())) {
                this.log.info("Sent EMail " + subject + " to " + to);
                return true;
            }
            this.log.warning("Could NOT Send Email: " + subject + " to " + to + ": " + msg + " (" + this.getName() + ")");
            return false;
        }
        catch (Exception ex) {
            this.log.severe(this.getName() + " - " + ex.getLocalizedMessage());
            return false;
        }
    }

    public String testEMail() {
        if (this.getWStoreEMail() == null || this.getWStoreEMail().length() == 0) {
            return "No Web Store EMail for " + this.getName();
        }
        EMail email = this.createEMail(this.getWStoreEMail(), "Adempiere WebStore EMail Test", "Adempiere WebStore EMail Test: " + this.toString());
        if (email == null) {
            return "Could not create Web Store EMail: " + this.getName();
        }
        try {
            String msg = email.send();
            if ("OK".equals(email.send())) {
                this.log.info("Sent Test EMail to " + this.getWStoreEMail());
                return "OK";
            }
            this.log.warning("Could NOT send Test Email to " + this.getWStoreEMail() + ": " + msg);
            return msg;
        }
        catch (Exception ex) {
            this.log.severe(this.getName() + " - " + ex.getLocalizedMessage());
            return ex.getLocalizedMessage();
        }
    }

    public MMailMsg[] getMailMsgs(boolean reload) {
        if (this.m_msgs != null && !reload) {
            return this.m_msgs;
        }
        ArrayList<MMailMsg> list = new ArrayList<MMailMsg>();
        String sql = "SELECT * FROM W_MailMsg WHERE W_Store_ID=? ORDER BY MailMsgType";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getW_Store_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MMailMsg(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_msgs = new MMailMsg[list.size()];
        list.toArray(this.m_msgs);
        return this.m_msgs;
    }

    public MMailMsg getMailMsg(String MailMsgType) {
        int i2;
        if (this.m_msgs == null) {
            this.getMailMsgs(false);
        }
        for (i2 = 0; i2 < this.m_msgs.length; ++i2) {
            if (!this.m_msgs[i2].getMailMsgType().equals(MailMsgType)) continue;
            return this.m_msgs[i2];
        }
        if (this.createMessages() == 0) {
            this.log.severe("Not created/found: " + MailMsgType);
            return null;
        }
        this.getMailMsgs(true);
        for (i2 = 0; i2 < this.m_msgs.length; ++i2) {
            if (!this.m_msgs[i2].getMailMsgType().equals(MailMsgType)) continue;
            return this.m_msgs[i2];
        }
        this.log.severe("Not found: " + MailMsgType);
        return null;
    }

    public int createMessages() {
        String[][] initMsgs = new String[][]{{"UV", "EMail Verification", "EMail Verification ", "Dear ", "\nYou requested the Verification Code: ", "\nPlease enter the verification code to get access."}, {"UP", "Password Request", "Password Request ", "Dear ", "\nWe received a 'Send Password' request from: ", "\nYour password is: "}, {"LS", "Subscription New", "New Subscription ", "Dear ", "\nYou requested to be added to the list: ", "\nThanks for your interest."}, {"LU", "Subscription Removed", "Remove Subscription ", "Dear ", "\nYou requested to be removed from the list: ", "\nSorry to see you go.  This is effictive immediately."}, {"OA", "Order Acknowledgement", "Adempiere Web - Order ", "Dear ", "\nThank you for your purchase: ", "\nYou can view your Orders, Invoices, Payments in the Web Store.\nFrom there, you also download your Assets (Documentation, etc.)"}, {"PA", "Payment Success", "Adempiere Web - Payment ", "Dear ", "\nThank you for your payment of ", "\nYou can view your Orders, Invoices, Payments in the Web Store.\nFrom there you also download your Assets (Documentation, etc.)"}, {"PE", "Payment Error", "Adempiere Web - Declined Payment ", "Dear ", "\nUnfortunately your payment was declined: ", "\nPlease check and try again. You can pay later by going to 'My Orders' or 'My Invoices' - or by directly creating a payment in 'My Payments'"}, {"WR", "Request", "Request ", "Dear ", "\nThank you for your request: \n---------.----------.----------.----------.----------.----------\n", "\n---------.----------.----------.----------.----------.----------\n\nPlease check back for updates."}, {"UA", "Welcome Message", "Welcome", "Welcome to our Web Store", "This is the Validation Code to access information:", ""}};
        if (this.m_msgs == null) {
            this.getMailMsgs(false);
        }
        if (this.m_msgs.length == initMsgs.length) {
            return 0;
        }
        int counter = 0;
        for (int i2 = 0; i2 < initMsgs.length; ++i2) {
            boolean found = false;
            for (int m = 0; m < this.m_msgs.length; ++m) {
                if (!initMsgs[i2][0].equals(this.m_msgs[m].getMailMsgType())) continue;
                found = true;
                break;
            }
            if (found) continue;
            MMailMsg msg = new MMailMsg(this, initMsgs[i2][0], initMsgs[i2][1], initMsgs[i2][2], initMsgs[i2][3], initMsgs[i2][4], initMsgs[i2][5]);
            if (msg.save()) {
                ++counter;
                continue;
            }
            this.log.severe("Not created MailMsgType=" + initMsgs[i2][0]);
        }
        this.log.info("#" + counter);
        this.m_msgs = null;
        return counter;
    }
}

