/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_PA_SLA_Criteria;
import org.compiere.model.MSLAGoal;
import org.compiere.sla.SLACriteria;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MSLACriteria
extends X_PA_SLA_Criteria {
    private static final long serialVersionUID = -3295590987540402184L;
    private static CCache<Integer, MSLACriteria> s_cache = new CCache("PA_SLA_Criteria", 20);

    public static MSLACriteria get(Properties ctx, int PA_SLA_Criteria_ID, String trxName) {
        Integer key = PA_SLA_Criteria_ID;
        MSLACriteria retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MSLACriteria(ctx, PA_SLA_Criteria_ID, trxName);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MSLACriteria(Properties ctx, int PA_SLA_Criteria_ID, String trxName) {
        super(ctx, PA_SLA_Criteria_ID, trxName);
    }

    public MSLACriteria(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MSLAGoal[] getGoals() {
        String sql = "SELECT * FROM PA_SLA_Goal WHERE PA_SLA_Criteria_ID=?";
        ArrayList<MSLAGoal> list = new ArrayList<MSLAGoal>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getPA_SLA_Criteria_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MSLAGoal(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MSLAGoal[] retValue = new MSLAGoal[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public SLACriteria newInstance() throws Exception {
        if (this.getClassname() == null || this.getClassname().length() == 0) {
            throw new AdempiereSystemError("No SLA Criteria Classname");
        }
        try {
            Class<?> clazz = Class.forName(this.getClassname());
            SLACriteria retValue = (SLACriteria)clazz.newInstance();
            return retValue;
        }
        catch (Exception e) {
            throw new AdempiereSystemError("Could not intsnciate SLA Criteria", e);
        }
    }
}

