/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.adempiere.core.domains.models.X_M_RequisitionTax;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MTax;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class MRequisitionTax
extends X_M_RequisitionTax {
    private MTax tax = null;
    private MRequisition parent = null;
    protected static CLogger log = CLogger.getCLogger(MRequisitionTax.class);

    public MRequisitionTax(Properties ctx, int M_RequisitionTax_ID, String trxName) {
        super(ctx, M_RequisitionTax_ID, trxName);
    }

    public MRequisitionTax(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected MTax getTax() {
        if (this.tax == null) {
            this.tax = MTax.get(this.getCtx(), this.getC_Tax_ID());
        }
        return this.tax;
    }

    public static MRequisitionTax get(MRequisitionLine line, int precision, boolean oldTax, String trxName) {
        boolean isOldTax;
        MRequisitionTax requisitionTax = null;
        if (line == null || line.getM_Requisition_ID() == 0) {
            log.fine("No Requisition");
            return null;
        }
        int taxId = line.getC_Tax_ID();
        boolean bl = isOldTax = oldTax && line.is_ValueChanged("C_Tax_ID");
        if (isOldTax) {
            Object old = line.get_ValueOld("C_Tax_ID");
            if (old == null) {
                log.fine("No Old Tax");
                return null;
            }
            taxId = (Integer)old;
        }
        if (taxId == 0) {
            log.fine("No Tax");
            return null;
        }
        requisitionTax = (MRequisitionTax)new Query(line.getCtx(), "M_RequisitionTax", "M_Requisition_ID = ? AND C_Tax_ID = ?", trxName).setClient_ID().setParameters(line.getM_Requisition_ID(), taxId).first();
        if (requisitionTax != null) {
            requisitionTax.set_TrxName(trxName);
            log.fine("(old=" + oldTax + ") " + requisitionTax);
            return requisitionTax;
        }
        if (isOldTax) {
            return null;
        }
        requisitionTax = new MRequisitionTax(line.getCtx(), 0, trxName);
        requisitionTax.set_TrxName(trxName);
        requisitionTax.setClientOrg(line);
        requisitionTax.setM_Requisition_ID(line.getM_Requisition_ID());
        requisitionTax.setC_Tax_ID(line.getC_Tax_ID());
        log.fine("(new) " + requisitionTax);
        return requisitionTax;
    }

    public boolean calculateTaxFromLines() {
        BigDecimal taxBaseAmt = Env.ZERO;
        BigDecimal taxAmt = Env.ZERO;
        boolean documentLevel = this.getTax().isDocumentLevel();
        for (MRequisitionLine requisitionLine : this.getParent().getLines()) {
            taxBaseAmt = taxBaseAmt.add(requisitionLine.getLineNetAmt());
            if (documentLevel) continue;
            taxAmt = taxAmt.add(this.tax.calculateTax(requisitionLine.getLineNetAmt(), this.isTaxIncluded(), this.parent.getPrecision()));
        }
        if (taxBaseAmt == null) {
            return false;
        }
        if (documentLevel) {
            taxAmt = this.tax.calculateTax(taxBaseAmt, this.isTaxIncluded(), this.parent.getPrecision());
        }
        this.setTaxAmt(taxAmt);
        if (this.isTaxIncluded()) {
            this.setTaxBaseAmt(taxBaseAmt.subtract(taxAmt));
        } else {
            this.setTaxBaseAmt(taxBaseAmt);
        }
        log.fine(this.toString());
        return true;
    }

    public MRequisition getParent() {
        if (this.parent != null) {
            return this.parent;
        }
        this.parent = new MRequisition(this.getCtx(), this.getM_Requisition_ID(), this.get_TrxName());
        return this.parent;
    }
}

