/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_C_ProjectPhase;
import org.compiere.model.MOrder;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.MProjectTask;
import org.compiere.model.MProjectTypePhase;
import org.compiere.model.MProjectTypeTask;
import org.compiere.model.MRequest;
import org.compiere.model.MStandardRequestType;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class MProjectPhase
extends X_C_ProjectPhase {
    private static final long serialVersionUID = 5824045445920353065L;

    public MProjectPhase(Properties ctx, int C_ProjectPhase_ID, String trxName) {
        super(ctx, C_ProjectPhase_ID, trxName);
        if (C_ProjectPhase_ID == 0) {
            this.setCommittedAmt(Env.ZERO);
            this.setIsCommitCeiling(false);
            this.setIsComplete(false);
            this.setSeqNo(0);
            this.setQty(Env.ZERO);
        }
    }

    public MProjectPhase(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProjectPhase(MProject project) {
        this(project.getCtx(), 0, project.get_TrxName());
        this.setClientOrg(project);
        this.setC_Project_ID(project.getC_Project_ID());
    }

    public MProjectPhase(MProject project, MProjectTypePhase phase) {
        this(project);
        this.setC_Phase_ID(phase.getC_Phase_ID());
        this.setName(phase.getName());
        this.setSeqNo(phase.getSeqNo());
        this.setDescription(phase.getDescription());
        this.setHelp(phase.getHelp());
        this.setPriorityRule(phase.getPriorityRule());
        this.setIsMilestone(phase.isMilestone());
        this.setDurationUnit(phase.getDurationUnit());
        this.setDurationEstimated(phase.getDurationEstimated());
        if (phase.getM_Product_ID() > 0) {
            this.setM_Product_ID(phase.getM_Product_ID());
        }
        if (phase.getPP_Product_BOM_ID() > 0) {
            this.setPP_Product_BOM_ID(phase.getPP_Product_BOM_ID());
        }
        if (phase.getAD_Workflow_ID() > 0) {
            this.setAD_Workflow_ID(phase.getAD_Workflow_ID());
        }
        if (project.getC_Campaign_ID() > 0) {
            this.setC_Campaign_ID(project.getC_Campaign_ID());
        }
        if (project.getC_Activity_ID() > 0) {
            this.setC_Activity_ID(project.getC_Activity_ID());
        }
        if (project.getC_SalesRegion_ID() > 0) {
            this.setC_SalesRegion_ID(project.getC_SalesRegion_ID());
        }
        if (project.getAD_OrgTrx_ID() > 0) {
            this.setAD_OrgTrx_ID(project.getAD_OrgTrx_ID());
        }
        if (project.getUser1_ID() > 0) {
            this.setUser1_ID(project.getUser1_ID());
        }
        if (project.getUser2_ID() > 0) {
            this.setUser2_ID(project.getUser2_ID());
        }
        if (project.getUser3_ID() > 0) {
            this.setUser3_ID(project.getUser3_ID());
        }
        if (project.getUser4_ID() > 0) {
            this.setUser4_ID(project.getUser4_ID());
        }
        this.setQty(phase.getStandardQty());
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        Timestamp projectStartDate;
        if (this.getDateDeadline() == null && (projectStartDate = this.getC_Project().getDateStart()) != null && this.getDurationUnit() != null) {
            Timestamp deadLine = TimeUtil.addDuration(projectStartDate, this.getDurationUnit(), this.getDurationEstimated());
            this.setDateDeadline(deadLine);
        }
        if (this.getDateFinishSchedule() == null && this.getDateDeadline() != null) {
            this.setDateFinishSchedule(this.getDateDeadline());
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord) {
            this.createRequest();
        }
        return true;
    }

    public void createRequest() {
        if (this.getC_Phase_ID() > 0 && this.getC_Phase().getR_StandardRequestType_ID() > 0) {
            MStandardRequestType standardRequestType = (MStandardRequestType)this.getC_Phase().getR_StandardRequestType();
            List<MRequest> requests = standardRequestType.createStandardRequest(this);
            requests.stream().forEach(request -> {
                request.setC_Project_ID(this.getC_Project_ID());
                request.setC_ProjectPhase_ID(this.getC_ProjectPhase_ID());
                request.setDateStartPlan(this.getDateStartSchedule());
                request.setDateCompletePlan(this.getDateFinishSchedule());
                request.saveEx();
            });
        }
    }

    public List<MProjectTask> getTasks() {
        return new Query(this.getCtx(), "C_ProjectTask", "C_ProjectPhase_ID=?", this.get_TrxName()).setClient_ID().setParameters(this.getC_ProjectPhase_ID()).setOrderBy("SeqNo").list();
    }

    public int copyLinesFrom(MProjectPhase fromPhase) {
        if (fromPhase == null) {
            return 0;
        }
        AtomicInteger count = new AtomicInteger(0);
        List<MProjectLine> fromProjectLines = fromPhase.getLines();
        fromProjectLines.stream().filter(fromProjectLine -> fromProjectLine.getC_ProjectTask_ID() <= 0).forEach(fromProjectLine -> {
            MProjectLine toProjectline = new MProjectLine(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(fromProjectLine, toProjectline, this.getAD_Client_ID(), this.getAD_Org_ID());
            toProjectline.setC_Project_ID(this.getC_Project_ID());
            toProjectline.setC_ProjectPhase_ID(this.getC_ProjectPhase_ID());
            toProjectline.saveEx();
            count.getAndUpdate(no -> no + 1);
        });
        if (fromProjectLines.size() != count.get()) {
            this.log.warning("Count difference - ProjectLine=" + fromProjectLines.size() + " <> Saved=" + count);
        }
        return count.get();
    }

    public int copyTasksFrom(MProjectPhase fromProjectPhase) {
        if (fromProjectPhase == null) {
            return 0;
        }
        AtomicInteger count = new AtomicInteger(0);
        AtomicInteger countLine = new AtomicInteger(0);
        List<MProjectTask> toProjectTasks = this.getTasks();
        List<MProjectTask> fromProjectTasks = fromProjectPhase.getTasks();
        fromProjectTasks.stream().forEach(fromProjectTask -> {
            Boolean exists = toProjectTasks.stream().anyMatch(taskTo -> taskTo.getC_Task_ID() == fromProjectTask.getC_Task_ID());
            if (exists.booleanValue()) {
                this.log.info("Task already exists here, ignored - " + fromProjectTask);
            } else {
                MProjectTask toProjectTask = new MProjectTask(this.getCtx(), 0, this.get_TrxName());
                PO.copyValues(fromProjectTask, toProjectTask, this.getAD_Client_ID(), this.getAD_Org_ID());
                toProjectTask.setC_ProjectPhase_ID(this.getC_ProjectPhase_ID());
                toProjectTask.setC_Task_ID(fromProjectTask.getC_Task_ID());
                toProjectTask.setProjInvoiceRule(this.getProjInvoiceRule());
                toProjectTask.saveEx();
                count.getAndUpdate(no -> no + 1);
                countLine.getAndUpdate(no -> no + toProjectTask.copyLinesFrom((MProjectTask)fromProjectTask));
            }
        });
        if (fromProjectTasks.size() != count.get()) {
            this.log.warning("Count difference - ProjectPhase=" + fromProjectTasks.size() + " <> Saved=" + count.get());
        }
        return count.get() + countLine.get();
    }

    public int copyTasksFrom(MProjectTypePhase fromProjectPhase) {
        if (fromProjectPhase == null) {
            return 0;
        }
        AtomicInteger count = new AtomicInteger(0);
        List<MProjectTypeTask> fromProjectTasks = fromProjectPhase.getTasks();
        fromProjectTasks.stream().forEach(fromProjectTask -> {
            MProjectTask toProjectTask = new MProjectTask(this, (MProjectTypeTask)fromProjectTask);
            toProjectTask.setC_ProjectPhase_ID(this.getC_ProjectPhase_ID());
            toProjectTask.setProjInvoiceRule(this.getProjInvoiceRule());
            toProjectTask.saveEx();
            count.getAndUpdate(no -> no + 1);
        });
        this.log.fine("#" + count.get() + " - " + fromProjectPhase);
        if (fromProjectTasks.size() != count.get()) {
            this.log.log(Level.SEVERE, "Count difference - TypePhase=" + fromProjectTasks.size() + " <> Saved=" + count.get());
        }
        return count.get();
    }

    public List<MProjectLine> getLines() {
        String whereClause = "C_Project_ID=? and C_ProjectPhase_ID=?";
        return new Query(this.getCtx(), "C_ProjectLine", "C_Project_ID=? and C_ProjectPhase_ID=?", this.get_TrxName()).setClient_ID().setParameters(this.getC_Project_ID(), this.getC_ProjectPhase_ID()).setOrderBy("Line").list();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MProjectPhase[");
        sb.append(this.get_ID()).append("-").append(this.getSeqNo()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    public List<MOrder> getOrders() {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("EXISTS (SELECT 1 FROM C_OrderLine ol WHERE ol.C_Order_ID = C_Order.C_Order_ID AND ol.C_ProjectPhase_ID=?)");
        return new Query(this.getCtx(), "C_Order", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(this.getC_ProjectPhase_ID()).list();
    }

    public Integer getBPartnerId() {
        return this.getC_Project().getC_BPartner_ID();
    }
}

