/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_C_PaymentTerm;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoicePaySchedule;
import org.compiere.model.MPaySchedule;
import org.compiere.model.Query;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MPaymentTerm
extends X_C_PaymentTerm {
    private static final long serialVersionUID = 2494915482340569386L;
    private static final BigDecimal HUNDRED = new BigDecimal(100);
    private MPaySchedule[] m_schedule;

    public static MPaymentTerm getPaymentTermByDefault(Properties ctx, String trxName) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("IsDefault").append("=?");
        return (MPaymentTerm)new Query(ctx, "C_PaymentTerm", whereClause.toString(), trxName).setClient_ID().setOnlyActiveRecords(true).setParameters(true).first();
    }

    public MPaymentTerm(Properties ctx, int C_PaymentTerm_ID, String trxName) {
        super(ctx, C_PaymentTerm_ID, trxName);
        if (C_PaymentTerm_ID == 0) {
            this.setAfterDelivery(false);
            this.setNetDays(0);
            this.setDiscount(Env.ZERO);
            this.setDiscount2(Env.ZERO);
            this.setDiscountDays(0);
            this.setDiscountDays2(0);
            this.setGraceDays(0);
            this.setIsDueFixed(false);
            this.setIsValid(false);
        }
    }

    public MPaymentTerm(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPaySchedule[] getSchedule(boolean requery) {
        if (this.m_schedule != null && !requery) {
            return this.m_schedule;
        }
        String sql = "SELECT * FROM C_PaySchedule WHERE C_PaymentTerm_ID=? AND IsActive='Y' ORDER BY NetDays";
        ArrayList<MPaySchedule> list = new ArrayList<MPaySchedule>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getC_PaymentTerm_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MPaySchedule ps = new MPaySchedule(this.getCtx(), rs, this.get_TrxName());
                ps.setParent(this);
                list.add(ps);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getSchedule", e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_schedule = new MPaySchedule[list.size()];
        list.toArray(this.m_schedule);
        return this.m_schedule;
    }

    public String validate() {
        boolean valid;
        String validMsg = Msg.parseTranslation(this.getCtx(), "@OK@");
        this.getSchedule(true);
        if (this.m_schedule.length == 0) {
            if (!this.isValid()) {
                this.setIsValid(true);
            }
            return validMsg;
        }
        if (this.m_schedule.length == 1 && this.isValid()) {
            this.setIsValid(false);
        }
        BigDecimal total = Env.ZERO;
        for (int i2 = 0; i2 < this.m_schedule.length; ++i2) {
            BigDecimal percent = this.m_schedule[i2].getPercentage();
            if (percent == null) continue;
            total = total.add(percent);
        }
        boolean bl = valid = total.compareTo(HUNDRED) == 0;
        if (this.isValid() != valid) {
            this.setIsValid(valid);
        }
        for (int i3 = 0; i3 < this.m_schedule.length; ++i3) {
            if (this.m_schedule[i3].isValid() == valid) continue;
            this.m_schedule[i3].setIsValid(valid);
            this.m_schedule[i3].saveEx();
        }
        if (valid) {
            return validMsg;
        }
        String msg = "@Total@ = " + total + " - @Difference@ = " + HUNDRED.subtract(total);
        return Msg.parseTranslation(this.getCtx(), msg);
    }

    public boolean apply(int C_Invoice_ID) {
        MInvoice invoice = new MInvoice(this.getCtx(), C_Invoice_ID, this.get_TrxName());
        if (invoice == null || invoice.get_ID() == 0) {
            this.log.log(Level.SEVERE, "apply - Not valid C_Invoice_ID=" + C_Invoice_ID);
            return false;
        }
        return this.apply(invoice);
    }

    public boolean apply(MInvoice invoice) {
        if (invoice == null || invoice.get_ID() == 0) {
            this.log.log(Level.SEVERE, "No valid invoice - " + invoice);
            return false;
        }
        if (!this.isValid()) {
            return this.applyNoSchedule(invoice);
        }
        this.getSchedule(true);
        if (this.m_schedule.length <= 1) {
            return this.applyNoSchedule(invoice);
        }
        return this.applySchedule(invoice);
    }

    private boolean applyNoSchedule(MInvoice invoice) {
        this.deleteInvoicePaySchedule(invoice.getC_Invoice_ID(), invoice.get_TrxName());
        if (invoice.getC_PaymentTerm_ID() != this.getC_PaymentTerm_ID()) {
            invoice.setC_PaymentTerm_ID(this.getC_PaymentTerm_ID());
        }
        if (invoice.isPayScheduleValid()) {
            invoice.setIsPayScheduleValid(false);
        }
        return false;
    }

    private boolean applySchedule(MInvoice invoice) {
        this.deleteInvoicePaySchedule(invoice.getC_Invoice_ID(), invoice.get_TrxName());
        MInvoicePaySchedule ips = null;
        BigDecimal remainder = invoice.getGrandTotal();
        for (int i2 = 0; i2 < this.m_schedule.length; ++i2) {
            ips = new MInvoicePaySchedule(invoice, this.m_schedule[i2]);
            ips.save(invoice.get_TrxName());
            this.log.fine(ips.toString());
            remainder = remainder.subtract(ips.getDueAmt());
        }
        if (remainder.compareTo(Env.ZERO) != 0 && ips != null) {
            ips.setDueAmt(ips.getDueAmt().add(remainder));
            ips.save(invoice.get_TrxName());
            this.log.fine("Remainder=" + remainder + " - " + ips);
        }
        if (invoice.getC_PaymentTerm_ID() != this.getC_PaymentTerm_ID()) {
            invoice.setC_PaymentTerm_ID(this.getC_PaymentTerm_ID());
        }
        return invoice.validatePaySchedule();
    }

    private void deleteInvoicePaySchedule(int C_Invoice_ID, String trxName) {
        String sql = "DELETE C_InvoicePaySchedule WHERE C_Invoice_ID=" + C_Invoice_ID;
        int no = DB.executeUpdate(sql, trxName);
        this.log.fine("C_Invoice_ID=" + C_Invoice_ID + " - #" + no);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MPaymentTerm[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(",Valid=").append(this.isValid()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.isDueFixed()) {
            int dd = this.getFixMonthDay();
            if (dd < 1 || dd > 31) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@Invalid@ @FixMonthDay@"));
                return false;
            }
            dd = this.getFixMonthCutoff();
            if (dd < 1 || dd > 31) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@Invalid@ @FixMonthCutoff@"));
                return false;
            }
        }
        if (Integer.signum(this.getNetDays()) < 0) {
            throw new AdempiereException(Msg.parseTranslation(this.getCtx(), "@NetDays@") + " " + Msg.parseTranslation(this.getCtx(), "@positive.number@"));
        }
        if (!newRecord || !this.isValid()) {
            this.validate();
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        for (MPaySchedule line : this.getSchedule(true)) {
            line.deleteEx(true);
        }
        return true;
    }
}

