/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_M_MovementConfirm;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MLocator;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MMovementLineConfirm;
import org.compiere.model.MPeriod;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MMovementConfirm
extends X_M_MovementConfirm
implements DocAction {
    private static final long serialVersionUID = -5210710606049843678L;
    public static String REVERSE_INDICATOR = "^";
    private MMovementLineConfirm[] movementLineConfirms = null;
    private MInventory inventoryFrom = null;
    private MInventory inventoryTo = null;
    private String inventoryInfo = null;
    private String processMesssage = null;
    private boolean justPrepared = false;

    public static MMovementConfirm create(MMovement move, boolean checkExisting) {
        MMovementConfirm[] confirmations;
        int i2;
        if (checkExisting && (i2 = 0) < (confirmations = move.getConfirmations(false)).length) {
            MMovementConfirm confirm = confirmations[i2];
            return confirm;
        }
        MMovementConfirm confirm = new MMovementConfirm(move);
        confirm.save(move.get_TrxName());
        MMovementLine[] moveLines = move.getLines(false);
        for (int i3 = 0; i3 < moveLines.length; ++i3) {
            MMovementLine mLine = moveLines[i3];
            MMovementLineConfirm cLine = new MMovementLineConfirm(confirm);
            cLine.setMovementLine(mLine);
            cLine.save(move.get_TrxName());
        }
        return confirm;
    }

    public MMovementConfirm(Properties ctx, int M_MovementConfirm_ID, String trxName) {
        super(ctx, M_MovementConfirm_ID, trxName);
        if (M_MovementConfirm_ID == 0) {
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setIsApproved(false);
            this.setProcessed(false);
        }
    }

    public MMovementConfirm(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MMovementConfirm(MMovement move) {
        this(move.getCtx(), 0, move.get_TrxName());
        this.setClientOrg(move);
        this.setM_Movement_ID(move.getM_Movement_ID());
    }

    public MMovementLineConfirm[] getLines(boolean requery) {
        if (this.movementLineConfirms != null && !requery) {
            MMovementConfirm.set_TrxName(this.movementLineConfirms, this.get_TrxName());
            return this.movementLineConfirms;
        }
        String sql = "SELECT * FROM M_MovementLineConfirm WHERE M_MovementConfirm_ID=?";
        ArrayList<MMovementLineConfirm> list = new ArrayList<MMovementLineConfirm>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getM_MovementConfirm_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MMovementLineConfirm(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.movementLineConfirms = new MMovementLineConfirm[list.size()];
        list.toArray(this.movementLineConfirms);
        return this.movementLineConfirms;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    @Override
    public void setIsApproved(boolean IsApproved) {
        if (IsApproved && !this.isApproved()) {
            int AD_User_ID = Env.getAD_User_ID(this.getCtx());
            MUser user = MUser.get(this.getCtx(), AD_User_ID);
            String info = user.getName() + ": " + Msg.translate(this.getCtx(), "IsApproved") + " - " + new Timestamp(System.currentTimeMillis());
            this.addDescription(info);
        }
        super.setIsApproved(IsApproved);
    }

    @Override
    public String getDocumentInfo() {
        return Msg.getElement(this.getCtx(), "M_MovementConfirm_ID") + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public boolean processIt(String processAction) {
        this.processMesssage = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.processMesssage = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.processMesssage != null) {
            return "IN";
        }
        if (!MPeriod.isOpen(this.getCtx(), this.getUpdated(), "MMM", this.getAD_Org_ID())) {
            this.processMesssage = "@PeriodClosed@";
            return "IN";
        }
        MMovementLineConfirm[] movementLineConfirms = this.getLines(true);
        if (movementLineConfirms.length == 0) {
            this.processMesssage = "@NoLines@";
            return "IN";
        }
        boolean difference = false;
        for (int i2 = 0; i2 < movementLineConfirms.length; ++i2) {
            if (movementLineConfirms[i2].isFullyConfirmed()) continue;
            difference = true;
            break;
        }
        this.processMesssage = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.processMesssage != null) {
            return "IN";
        }
        this.justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String valid;
        String status;
        if (!this.justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.processMesssage = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.processMesssage != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info("completeIt - " + this.toString());
        MMovement movement = new MMovement(this.getCtx(), this.getM_Movement_ID(), this.get_TrxName());
        MMovementLineConfirm[] movementLineConfirms = this.getLines(false);
        for (int i2 = 0; i2 < movementLineConfirms.length; ++i2) {
            MMovementLineConfirm movementLineConfirm = movementLineConfirms[i2];
            movementLineConfirm.set_TrxName(this.get_TrxName());
            if (!movementLineConfirm.processLine()) {
                this.processMesssage = "ShipLine not saved - " + movementLineConfirm;
                return "IN";
            }
            if (movementLineConfirm.isFullyConfirmed()) {
                movementLineConfirm.setProcessed(true);
                movementLineConfirm.save(this.get_TrxName());
                continue;
            }
            if (this.createDifferenceDoc(movement, movementLineConfirm)) {
                movementLineConfirm.setProcessed(true);
                movementLineConfirm.save(this.get_TrxName());
                continue;
            }
            this.log.log(Level.SEVERE, "completeIt - Scrapped=" + movementLineConfirm.getScrappedQty() + " - Difference=" + movementLineConfirm.getDifferenceQty());
            this.processMesssage = "Differnce Doc not created";
            return "IN";
        }
        if (this.inventoryInfo != null) {
            this.processMesssage = " @M_Inventory_ID@: " + this.inventoryInfo;
            this.addDescription(Msg.translate(this.getCtx(), "M_Inventory_ID") + ": " + this.inventoryInfo);
        }
        if ((valid = ModelValidationEngine.get().fireDocValidate(this, 9)) != null) {
            this.processMesssage = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private boolean createDifferenceDoc(MMovement move, MMovementLineConfirm confirm) {
        MInventoryLine inventoryLine;
        MWarehouse warehouse;
        MLocator locator;
        MMovementLine movementLine = confirm.getLine();
        if (Env.ZERO.compareTo(confirm.getDifferenceQty()) != 0) {
            locator = MLocator.get(this.getCtx(), movementLine.getM_Locator_ID());
            if (this.inventoryFrom != null && this.inventoryFrom.getM_Warehouse_ID() != locator.getM_Warehouse_ID()) {
                this.inventoryFrom = null;
            }
            if (this.inventoryFrom == null) {
                warehouse = MWarehouse.get(this.getCtx(), locator.getM_Warehouse_ID());
                this.inventoryFrom = new MInventory(warehouse);
                this.inventoryFrom.setDescription(Msg.translate(this.getCtx(), "M_MovementConfirm_ID") + " " + this.getDocumentNo());
                if (!this.inventoryFrom.save(this.get_TrxName())) {
                    this.processMesssage = this.processMesssage + "Inventory not created";
                    return false;
                }
                if (this.getM_Inventory_ID() == 0) {
                    this.setM_Inventory_ID(this.inventoryFrom.getM_Inventory_ID());
                    this.inventoryInfo = this.inventoryFrom.getDocumentNo();
                } else {
                    this.inventoryInfo = this.inventoryInfo + "," + this.inventoryFrom.getDocumentNo();
                }
            }
            this.log.info("createDifferenceDoc - Difference=" + confirm.getDifferenceQty());
            inventoryLine = new MInventoryLine(this.inventoryFrom, movementLine.getM_Locator_ID(), movementLine.getM_Product_ID(), movementLine.getM_AttributeSetInstance_ID(), confirm.getDifferenceQty(), Env.ZERO);
            inventoryLine.setDescription(Msg.translate(this.getCtx(), "DifferenceQty"));
            if (!inventoryLine.save(this.get_TrxName())) {
                this.processMesssage = this.processMesssage + "Inventory Line not created";
                return false;
            }
            confirm.setM_InventoryLine_ID(inventoryLine.getM_InventoryLine_ID());
        }
        if (Env.ZERO.compareTo(confirm.getScrappedQty()) != 0) {
            locator = MLocator.get(this.getCtx(), movementLine.getM_LocatorTo_ID());
            if (this.inventoryTo != null && this.inventoryTo.getM_Warehouse_ID() != locator.getM_Warehouse_ID()) {
                this.inventoryTo = null;
            }
            if (this.inventoryTo == null) {
                warehouse = MWarehouse.get(this.getCtx(), locator.getM_Warehouse_ID());
                this.inventoryTo = new MInventory(warehouse);
                this.inventoryTo.setDescription(Msg.translate(this.getCtx(), "M_MovementConfirm_ID") + " " + this.getDocumentNo());
                if (!this.inventoryTo.save(this.get_TrxName())) {
                    this.processMesssage = this.processMesssage + "Inventory not created";
                    return false;
                }
                if (this.getM_Inventory_ID() == 0) {
                    this.setM_Inventory_ID(this.inventoryTo.getM_Inventory_ID());
                    this.inventoryInfo = this.inventoryTo.getDocumentNo();
                } else {
                    this.inventoryInfo = this.inventoryInfo + "," + this.inventoryTo.getDocumentNo();
                }
            }
            this.log.info("createDifferenceDoc - Scrapped=" + confirm.getScrappedQty());
            inventoryLine = new MInventoryLine(this.inventoryTo, movementLine.getM_LocatorTo_ID(), movementLine.getM_Product_ID(), movementLine.getM_AttributeSetInstance_ID(), confirm.getScrappedQty(), Env.ZERO);
            inventoryLine.setDescription(Msg.translate(this.getCtx(), "ScrappedQty"));
            if (!inventoryLine.save(this.get_TrxName())) {
                this.processMesssage = this.processMesssage + "Inventory Line not created";
                return false;
            }
            confirm.setM_InventoryLine_ID(inventoryLine.getM_InventoryLine_ID());
        }
        return true;
    }

    @Override
    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        this.processMesssage = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.processMesssage != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.processMesssage = "Document Closed: " + this.getDocStatus();
            return false;
        }
        if (!("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus()))) {
            return this.reverseCorrectIt();
        }
        MMovementLineConfirm[] movementLineConfirms = this.getLines(false);
        Arrays.stream(movementLineConfirms).forEach(line -> {
            BigDecimal oldConfirmedQty = line.getConfirmedQty();
            if (oldConfirmedQty.compareTo(Env.ZERO) != 0) {
                line.setConfirmedQty(Env.ZERO);
                line.setDescription("Void (" + oldConfirmedQty + ")");
                line.saveEx();
            }
        });
        this.processMesssage = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.processMesssage != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.processMesssage = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.processMesssage != null) {
            return false;
        }
        this.setDocAction("--");
        this.processMesssage = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.processMesssage == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        this.processMesssage = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.processMesssage != null) {
            return false;
        }
        MMovementConfirm reversalMovementConfirm = new MMovementConfirm(this.getCtx(), 0, this.get_TrxName());
        MMovementConfirm.copyValues(this, reversalMovementConfirm, this.getAD_Client_ID(), this.getAD_Org_ID());
        reversalMovementConfirm.setReversal_ID(this.getM_MovementConfirm_ID());
        reversalMovementConfirm.setM_Movement_ID(this.getM_Movement_ID());
        reversalMovementConfirm.setDocStatus("DR");
        reversalMovementConfirm.setDocAction("CO");
        reversalMovementConfirm.setIsApproved(false);
        reversalMovementConfirm.setProcessed(false);
        reversalMovementConfirm.setDocumentNo(this.getDocumentNo() + REVERSE_INDICATOR);
        reversalMovementConfirm.addDescription("{->" + this.getDocumentNo() + ")");
        reversalMovementConfirm.setIsReversal(true);
        reversalMovementConfirm.saveEx();
        Arrays.stream(this.getLines(true)).forEach(movementLineConfirm -> {
            MMovementLineConfirm reverseMovementLineConfirm = new MMovementLineConfirm(this.getCtx(), 0, this.get_TrxName());
            MMovementConfirm.copyValues(movementLineConfirm, reverseMovementLineConfirm, movementLineConfirm.getAD_Client_ID(), movementLineConfirm.getAD_Org_ID());
            reverseMovementLineConfirm.setM_MovementConfirm_ID(reversalMovementConfirm.getM_MovementConfirm_ID());
            reverseMovementLineConfirm.setReversalLine_ID(movementLineConfirm.getM_MovementLineConfirm_ID());
            reverseMovementLineConfirm.setM_MovementLine_ID(movementLineConfirm.getM_MovementLine_ID());
            reverseMovementLineConfirm.setConfirmedQty(movementLineConfirm.getConfirmedQty().negate());
            reverseMovementLineConfirm.setTargetQty(movementLineConfirm.getTargetQty().negate());
            reverseMovementLineConfirm.setScrappedQty(movementLineConfirm.getScrappedQty().negate());
            reverseMovementLineConfirm.setProcessed(false);
            reverseMovementLineConfirm.saveEx();
        });
        if (!reversalMovementConfirm.processIt("CO")) {
            this.processMesssage = "Reversal ERROR: " + reversalMovementConfirm.getProcessMsg();
            return false;
        }
        reversalMovementConfirm.closeIt();
        reversalMovementConfirm.setDocStatus("RE");
        reversalMovementConfirm.setDocAction("--");
        reversalMovementConfirm.saveEx();
        this.processMesssage = reversalMovementConfirm.getDocumentNo();
        this.processMesssage = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.processMesssage != null) {
            return false;
        }
        this.setDescription("(" + reversalMovementConfirm.getDocumentNo() + "<-)");
        this.setIsReversal(true);
        this.setProcessed(true);
        this.setDocStatus("RE");
        this.setDocAction("--");
        this.saveEx();
        return true;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        this.processMesssage = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.processMesssage != null) {
            return false;
        }
        MMovementConfirm movementConfirm = new MMovementConfirm(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues(this, movementConfirm);
        this.processMesssage = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.processMesssage != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.processMesssage = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.processMesssage != null) {
            return false;
        }
        this.processMesssage = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.processMesssage != null) {
            return false;
        }
        return false;
    }

    @Override
    public String getSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDocumentNo());
        stringBuffer.append(": ").append(Msg.translate(this.getCtx(), "ApprovalAmt")).append("=").append(this.getApprovalAmt()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            stringBuffer.append(" - ").append(this.getDescription());
        }
        return stringBuffer.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.processMesssage;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getUpdatedBy();
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }
}

