/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_C_LandedCostAllocation;
import org.adempiere.engine.IDocumentLine;
import org.compiere.model.MConversionRate;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MLandedCostAllocation
extends X_C_LandedCostAllocation
implements IDocumentLine {
    private static final long serialVersionUID = -8645283018475474574L;
    private MInvoiceLine invoiceLine = null;
    private MInvoice invoice = null;
    private static CLogger s_log = CLogger.getCLogger(MLandedCostAllocation.class);

    public static MLandedCostAllocation[] getOfInvoiceLine(Properties ctx, int C_InvoiceLine_ID, String trxName) {
        ArrayList<MLandedCostAllocation> list = new ArrayList<MLandedCostAllocation>();
        String sql = "SELECT * FROM C_LandedCostAllocation WHERE C_InvoiceLine_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, C_InvoiceLine_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MLandedCostAllocation(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MLandedCostAllocation[] retValue = new MLandedCostAllocation[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static List<MLandedCostAllocation> getOfInOutline(MInOutLine ioLine, int costElementId) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("M_InOutLine_ID").append("=? AND ");
        whereClause.append("M_CostElement_ID").append("=? ");
        return new Query(ioLine.getCtx(), "C_LandedCostAllocation", whereClause.toString(), ioLine.get_TrxName()).setClient_ID().setParameters(ioLine.getM_InOutLine_ID(), costElementId).list();
    }

    public MLandedCostAllocation(Properties ctx, int C_LandedCostAllocation_ID, String trxName) {
        super(ctx, C_LandedCostAllocation_ID, trxName);
        if (C_LandedCostAllocation_ID == 0) {
            this.setAmt(Env.ZERO);
            this.setQty(Env.ZERO);
            this.setBase(Env.ZERO);
        }
    }

    public MLandedCostAllocation(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MLandedCostAllocation(MInvoiceLine parent, int M_CostElement_ID) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setC_InvoiceLine_ID(parent.getC_InvoiceLine_ID());
        this.setM_CostElement_ID(M_CostElement_ID);
    }

    public void setAmt(double Amt, int precision) {
        BigDecimal bd = new BigDecimal(Amt);
        if (bd.scale() > precision) {
            bd = bd.setScale(precision, RoundingMode.HALF_UP);
        }
        super.setAmt(bd);
    }

    @Override
    public void setQty(BigDecimal Qty) {
        super.setQty(Qty);
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public int getM_Locator_ID() {
        return 0;
    }

    @Override
    public BigDecimal getMovementQty() {
        return this.getQty();
    }

    @Override
    public BigDecimal getPriceActual() {
        MInvoiceLine invoiceLine = (MInvoiceLine)this.getC_InvoiceLine();
        BigDecimal amount = MConversionRate.convertBase(this.getCtx(), this.getAmt(), this.getC_Currency_ID(), this.getDateAcct(), this.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID()).divide(this.getQty(), invoiceLine.getParent().getM_PriceList().getPricePrecision(), RoundingMode.HALF_UP);
        if ("APC".equals(invoiceLine.getParent().getC_DocType().getDocBaseType())) {
            return amount.negate();
        }
        return amount;
    }

    @Override
    public int getReversalLine_ID() {
        return 0;
    }

    @Override
    public boolean isSOTrx() {
        return false;
    }

    @Override
    public void setM_Locator_ID(int M_Locator_ID) {
    }

    @Override
    public Timestamp getDateAcct() {
        return this.getInvoice().getDateAcct();
    }

    @Override
    public IDocumentLine getReversalDocumentLine() {
        return null;
    }

    @Override
    public int getM_AttributeSetInstanceTo_ID() {
        return -1;
    }

    @Override
    public int getM_LocatorTo_ID() {
        return -1;
    }

    @Override
    public int getC_DocType_ID() {
        return -1;
    }

    @Override
    public BigDecimal getPriceActualCurrency() {
        MInvoiceLine invoiceLine = this.getInvoiceLine();
        BigDecimal amount = this.getAmt().divide(this.getQty(), invoiceLine.getParent().getM_PriceList().getPricePrecision(), RoundingMode.HALF_UP);
        if ("APC".equals(invoiceLine.getParent().getC_DocType().getDocBaseType())) {
            amount = amount.negate();
        }
        return amount;
    }

    @Override
    public int getC_Currency_ID() {
        if (this.getInvoice() != null) {
            return this.getInvoice().getC_Currency_ID();
        }
        return 0;
    }

    @Override
    public int getC_ConversionType_ID() {
        if (this.getInvoice() != null) {
            return this.getInvoice().getC_ConversionType_ID();
        }
        return 0;
    }

    @Override
    public boolean isReversalParent() {
        return false;
    }

    public void setInvoiceLine(MInvoiceLine invoiceLine) {
        this.invoiceLine = invoiceLine;
    }

    public void setInvoice(MInvoice invoice) {
        this.invoice = invoice;
    }

    public MInvoiceLine getInvoiceLine() {
        this.setInvoiceLine(Optional.ofNullable(this.invoiceLine).orElse((MInvoiceLine)this.getC_InvoiceLine()));
        return this.invoiceLine;
    }

    public MInvoice getInvoice() {
        this.setInvoice(Optional.ofNullable(this.invoice).orElse(this.getInvoiceLine().getParent()));
        return this.invoice;
    }
}

