/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.adempiere.core.domains.models.X_C_InvoiceTax;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MTax;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MInvoiceTax
extends X_C_InvoiceTax {
    private static final long serialVersionUID = -5560880305482497098L;
    private static CLogger s_log = CLogger.getCLogger(MInvoiceTax.class);
    private MTax m_tax = null;
    private Integer m_precision = null;

    public static MInvoiceTax get(MInvoiceLine line, int precision, boolean oldTax, String trxName) {
        boolean isOldTax;
        MInvoiceTax retValue = null;
        if (line == null || line.getC_Invoice_ID() == 0 || line.isDescription()) {
            return null;
        }
        int C_Tax_ID = line.getC_Tax_ID();
        boolean bl = isOldTax = oldTax && line.is_ValueChanged("C_Tax_ID");
        if (isOldTax) {
            Object old = line.get_ValueOld("C_Tax_ID");
            if (old == null) {
                return null;
            }
            C_Tax_ID = (Integer)old;
        }
        if (C_Tax_ID == 0) {
            s_log.warning("C_Tax_ID=0");
            return null;
        }
        retValue = (MInvoiceTax)new Query(line.getCtx(), "C_InvoiceTax", "C_Invoice_ID=? AND C_Tax_ID=?", trxName).setParameters(line.getC_Invoice_ID(), C_Tax_ID).firstOnly();
        if (retValue != null) {
            retValue.set_TrxName(trxName);
            retValue.setPrecision(precision);
            s_log.fine("(old=" + oldTax + ") " + retValue);
            return retValue;
        }
        if (isOldTax) {
            return null;
        }
        retValue = new MInvoiceTax(line.getCtx(), 0, trxName);
        retValue.set_TrxName(trxName);
        retValue.setClientOrg(line);
        retValue.setC_Invoice_ID(line.getC_Invoice_ID());
        retValue.setC_Tax_ID(line.getC_Tax_ID());
        retValue.setPrecision(precision);
        retValue.setIsTaxIncluded(line.isTaxIncluded());
        s_log.fine("(new) " + retValue);
        return retValue;
    }

    public MInvoiceTax(Properties ctx, int ignored, String trxName) {
        super(ctx, 0, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
        this.setTaxAmt(Env.ZERO);
        this.setTaxBaseAmt(Env.ZERO);
        this.setIsTaxIncluded(false);
    }

    public MInvoiceTax(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    private int getPrecision() {
        if (this.m_precision == null) {
            return 2;
        }
        return this.m_precision;
    }

    protected void setPrecision(int precision) {
        this.m_precision = new Integer(precision);
    }

    protected MTax getTax() {
        if (this.m_tax == null) {
            this.m_tax = MTax.get(this.getCtx(), this.getC_Tax_ID());
        }
        return this.m_tax;
    }

    public boolean calculateTaxFromLines() {
        BigDecimal taxBaseAmt = Env.ZERO;
        BigDecimal taxAmt = Env.ZERO;
        boolean documentLevel = this.getTax().isDocumentLevel();
        MTax tax = this.getTax();
        String sql = "SELECT il.LineNetAmt, COALESCE(il.TaxAmt,0), i.IsSOTrx, il.PriceEntered, il.QtyEntered FROM C_InvoiceLine il INNER JOIN C_Invoice i ON (il.C_Invoice_ID=i.C_Invoice_ID) WHERE il.C_Invoice_ID=? AND il.C_Tax_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getC_Invoice_ID());
            pstmt.setInt(2, this.getC_Tax_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                BigDecimal baseAmt = rs.getBigDecimal(1);
                taxBaseAmt = taxBaseAmt.add(baseAmt);
                BigDecimal amt = rs.getBigDecimal(2);
                if (amt == null) {
                    amt = Env.ZERO;
                }
                boolean isSOTrx = "Y".equals(rs.getString(3));
                if (!documentLevel && amt.signum() != 0) {
                    if (this.isTaxIncluded()) {
                        BigDecimal priceEntered = rs.getBigDecimal(4);
                        BigDecimal qtyEntered = rs.getBigDecimal(5);
                        BigDecimal bd = priceEntered.multiply(qtyEntered);
                        amt = tax.calculateTax(bd, this.isTaxIncluded(), this.getPrecision());
                    }
                } else {
                    amt = documentLevel || baseAmt.signum() == 0 ? Env.ZERO : tax.calculateTax(baseAmt, this.isTaxIncluded(), this.getPrecision());
                }
                taxAmt = taxAmt.add(amt);
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (documentLevel || taxAmt.signum() == 0) {
            taxAmt = tax.calculateTax(taxBaseAmt, this.isTaxIncluded(), this.getPrecision());
        }
        this.setTaxAmt(taxAmt);
        this.setTaxBaseAmt(taxBaseAmt);
        return true;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MInvoiceTax[");
        sb.append("C_Invoice_ID=").append(this.getC_Invoice_ID()).append(",C_Tax_ID=").append(this.getC_Tax_ID()).append(", Base=").append(this.getTaxBaseAmt()).append(",Tax=").append(this.getTaxAmt()).append("]");
        return sb.toString();
    }
}

