/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_C_InvoiceBatch;
import org.compiere.model.MInvoiceBatchLine;
import org.compiere.model.PO;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MInvoiceBatch
extends X_C_InvoiceBatch {
    private static final long serialVersionUID = 3449653049236263604L;
    private MInvoiceBatchLine[] m_lines = null;

    public MInvoiceBatch(Properties ctx, int C_InvoiceBatch_ID, String trxName) {
        super(ctx, C_InvoiceBatch_ID, trxName);
        if (C_InvoiceBatch_ID == 0) {
            this.setControlAmt(Env.ZERO);
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
            this.setDocumentAmt(Env.ZERO);
            this.setIsSOTrx(false);
            this.setProcessed(false);
        }
    }

    public MInvoiceBatch(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInvoiceBatchLine[] getLines(boolean reload) {
        if (this.m_lines != null && !reload) {
            MInvoiceBatch.set_TrxName(this.m_lines, this.get_TrxName());
            return this.m_lines;
        }
        String sql = "SELECT * FROM C_InvoiceBatchLine WHERE C_InvoiceBatch_ID=? ORDER BY Line";
        ArrayList<MInvoiceBatchLine> list = new ArrayList<MInvoiceBatchLine>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getC_InvoiceBatch_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MInvoiceBatchLine(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_lines = new MInvoiceBatchLine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String set = "SET Processed='" + (processed ? "Y" : "N") + "' WHERE C_InvoiceBatch_ID=" + this.getC_InvoiceBatch_ID();
        int noLine = DB.executeUpdate("UPDATE C_InvoiceBatchLine " + set, this.get_TrxName());
        this.m_lines = null;
        this.log.fine(processed + " - Lines=" + noLine);
    }

    public int copyLinesFrom(MInvoiceBatch invoiceBatchFrom) {
        if (this.isProcessed()) {
            return 0;
        }
        List<MInvoiceBatchLine> fromInvoiceBatchLines = Arrays.asList(invoiceBatchFrom.getLines(true));
        AtomicInteger count = new AtomicInteger();
        fromInvoiceBatchLines.stream().forEach(invoiceBatchLineFrom -> {
            MInvoiceBatchLine invoiceBatchLineTo = new MInvoiceBatchLine(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(invoiceBatchLineFrom, invoiceBatchLineTo, invoiceBatchLineFrom.getAD_Client_ID(), invoiceBatchLineFrom.getAD_Org_ID());
            invoiceBatchLineTo.setC_InvoiceBatch_ID(this.getC_InvoiceBatch_ID());
            invoiceBatchLineTo.set_ValueNoCheck("C_InvoiceBatchLine_ID", I_ZERO);
            invoiceBatchLineTo.setProcessed(false);
            invoiceBatchLineTo.saveEx();
            count.updateAndGet(no -> no + 1);
        });
        if (fromInvoiceBatchLines.size() != count.get()) {
            this.log.log(Level.SEVERE, "Line difference - From=" + fromInvoiceBatchLines.size() + " <> Saved=" + count);
        }
        return count.get();
    }
}

