/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.X_C_DunningRun;
import org.compiere.model.MBPartner;
import org.compiere.model.MDunningLevel;
import org.compiere.model.MDunningRunEntry;
import org.compiere.model.Query;

public class MDunningRun
extends X_C_DunningRun {
    private static final long serialVersionUID = 6858939271415643483L;
    private List<MDunningRunEntry> runEntries = new ArrayList<MDunningRunEntry>();
    private List<MDunningLevel> levels = new ArrayList<MDunningLevel>();

    public MDunningRun(Properties ctx, int C_DunningRun_ID, String trxName) {
        super(ctx, C_DunningRun_ID, trxName);
        if (C_DunningRun_ID == 0) {
            this.setDunningDate(new Timestamp(System.currentTimeMillis()));
            this.setProcessed(false);
        }
    }

    public MDunningRun(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public List<MDunningLevel> getLevels() {
        if (this.levels != null && this.levels.size() > 0) {
            return this.levels;
        }
        this.levels = this.getC_DunningLevel_ID() > 0 ? new Query(this.getCtx(), "C_DunningLevel", "C_Dunning_ID=? AND C_DunningLevel_ID=?", this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.getC_Dunning_ID(), this.getC_DunningLevel_ID()).setOrderBy("DaysAfterDue DESC, C_DunningLevel_ID").list() : new Query(this.getCtx(), "C_DunningLevel", "C_Dunning_ID=?", this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.getC_Dunning_ID()).setOrderBy("DaysAfterDue DESC, C_DunningLevel_ID").list();
        return this.levels;
    }

    public List<MDunningRunEntry> getEntries(boolean requery) {
        return this.getEntries(requery, false);
    }

    public List<MDunningRunEntry> getEntries(boolean requery, boolean onlyInvoices) {
        if (this.runEntries != null && this.runEntries.size() > 0 && !requery) {
            return this.runEntries;
        }
        new Query(this.getCtx(), "C_DunningRunEntry", "C_DunningRun_ID=?", this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.getC_DunningRun_ID()).setOrderBy("C_DunningLevel_ID, C_DunningRunEntry_ID").list().stream().forEach(entry -> {
            if (!onlyInvoices || !entry.hasInvoices()) {
                this.runEntries.add((MDunningRunEntry)entry);
            }
        });
        return this.runEntries;
    }

    public static List<MDunningRun> getDunningRunList(Properties ctx, boolean onlyUnprocessed) {
        return new Query(ctx, "C_DunningRun", onlyUnprocessed ? "Processed = 'N'" : "", null).setOnlyActiveRecords(true).setClient_ID().setOrderBy("DunningDate").list();
    }

    public boolean deleteEntries(boolean force) {
        boolean ok;
        this.getEntries(true);
        for (MDunningRunEntry entry : this.runEntries) {
            entry.deleteEx(force);
        }
        boolean bl = ok = this.getEntries(true).size() == 0;
        if (ok) {
            this.runEntries = new ArrayList<MDunningRunEntry>();
        }
        return ok;
    }

    public MDunningRunEntry getEntry(int bPartnerId, int currencyId, int salesRepId, int dunningLevelId) {
        int bPartnerRelatedId = bPartnerId;
        this.getEntries(false);
        for (MDunningRunEntry entry : this.runEntries) {
            if (entry.getC_BPartner_ID() != bPartnerRelatedId || entry.getC_DunningLevel_ID() != dunningLevelId) continue;
            return entry;
        }
        MDunningRunEntry entry = new MDunningRunEntry(this);
        MBPartner bp = new MBPartner(this.getCtx(), bPartnerRelatedId, this.get_TrxName());
        entry.setBPartner(bp, true);
        if (entry.getSalesRep_ID() == 0) {
            entry.setSalesRep_ID(salesRepId);
        }
        entry.setC_Currency_ID(currencyId);
        entry.setC_DunningLevel_ID(dunningLevelId);
        this.runEntries = new ArrayList<MDunningRunEntry>();
        return entry;
    }
}

