/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.ResultSet;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.core.domains.models.X_M_DiscountSchema;
import org.adempiere.core.domains.models.X_M_DiscountSchemaBreak;
import org.compiere.model.MDiscountSchemaBreak;
import org.compiere.model.MDiscountSchemaLine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class MDiscountSchema
extends X_M_DiscountSchema {
    private static final long serialVersionUID = -3314884382853756019L;
    private static CCache<Integer, MDiscountSchema> s_cache = new CCache("M_DiscountSchema", 20);
    private List<MDiscountSchemaBreak> breaks = null;
    private List<MDiscountSchemaLine> lines = null;

    public static MDiscountSchema get(Properties ctx, int M_DiscountSchema_ID) {
        Integer key = M_DiscountSchema_ID;
        MDiscountSchema retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MDiscountSchema(ctx, M_DiscountSchema_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MDiscountSchema(Properties ctx, int M_DiscountSchema_ID, String trxName) {
        super(ctx, M_DiscountSchema_ID, trxName);
        if (M_DiscountSchema_ID == 0) {
            this.setDiscountType("F");
            this.setFlatDiscount(Env.ZERO);
            this.setIsBPartnerFlatDiscount(false);
            this.setIsQuantityBased(true);
            this.setCumulativeLevel("L");
        }
    }

    public MDiscountSchema(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public List<MDiscountSchemaBreak> getBreaksAsList(boolean reload) {
        if (this.breaks != null && !reload) {
            return this.breaks;
        }
        this.breaks = new Query(this.getCtx(), "M_DiscountSchemaBreak", "M_DiscountSchema_ID = ?", this.get_TrxName()).setParameters(this.getM_DiscountSchema_ID()).setOrderBy("SeqNo").list();
        return this.breaks;
    }

    public List<MDiscountSchemaLine> getLinesAsList(boolean reload) {
        if (this.lines != null && !reload) {
            return this.lines;
        }
        this.lines = new Query(this.getCtx(), "M_DiscountSchemaLine", "M_DiscountSchema_ID = ?", this.get_TrxName()).setParameters(this.getM_DiscountSchema_ID()).setOrderBy("SeqNo").list();
        return this.lines;
    }

    public MDiscountSchemaBreak[] getBreaks(boolean reload) {
        this.getBreaksAsList(reload);
        PO[] breaksAsArray = new MDiscountSchemaBreak[this.breaks.size()];
        this.breaks.toArray(breaksAsArray);
        MDiscountSchema.set_TrxName(breaksAsArray, this.get_TrxName());
        return breaksAsArray;
    }

    public MDiscountSchemaLine[] getLines(boolean reload) {
        this.getLinesAsList(reload);
        PO[] linesAsArray = new MDiscountSchemaLine[this.lines.size()];
        this.lines.toArray(linesAsArray);
        MDiscountSchema.set_TrxName(linesAsArray, this.get_TrxName());
        return linesAsArray;
    }

    public BigDecimal calculatePrice(BigDecimal Qty, BigDecimal Price, int M_Product_ID, int M_Product_Category_ID, BigDecimal BPartnerFlatDiscount) {
        this.log.fine("Price=" + Price + ",Qty=" + Qty + ",M_Product_ID=" + M_Product_ID + ",M_Product_Category_ID=" + M_Product_Category_ID + ",BPartnerFlatDiscount=" + BPartnerFlatDiscount.doubleValue());
        if (Price == null || Env.ZERO.compareTo(Price) == 0) {
            return Price;
        }
        BigDecimal discount = this.calculateDiscount(Qty, Price, M_Product_ID, M_Product_Category_ID, BPartnerFlatDiscount);
        this.log.fine("Discount=" + discount.doubleValue());
        if (discount == null || discount.signum() == 0) {
            return Price;
        }
        BigDecimal onehundred = new BigDecimal(100);
        BigDecimal multiplier = onehundred.subtract(discount);
        multiplier = multiplier.divide(onehundred, MathContext.DECIMAL128);
        BigDecimal newPrice = Price.multiply(multiplier);
        this.log.fine("=>" + newPrice);
        return newPrice;
    }

    public BigDecimal calculateDiscount(BigDecimal quantity, BigDecimal Price, int productId, int productCategoryId, BigDecimal BPartnerFlatDiscount) {
        if (BPartnerFlatDiscount == null) {
            BPartnerFlatDiscount = Env.ZERO;
        }
        if ("F".equals(this.getDiscountType())) {
            if (this.isBPartnerFlatDiscount()) {
                return BPartnerFlatDiscount;
            }
            return this.getFlatDiscount();
        }
        if ("S".equals(this.getDiscountType()) || "P".equals(this.getDiscountType())) {
            this.log.info("Not supported (yet) DiscountType=" + this.getDiscountType());
            return Env.ZERO;
        }
        this.getBreaksAsList(true);
        BigDecimal amount = Price.multiply(quantity);
        if (this.isQuantityBased()) {
            this.log.finer("Qty=" + quantity + ",M_Product_ID=" + productId + ",M_Product_Category_ID=" + productCategoryId);
        } else {
            this.log.finer("Amt=" + amount + ",M_Product_ID=" + productId + ",M_Product_Category_ID=" + productCategoryId);
        }
        Optional<MDiscountSchemaBreak> maybeDiscount = this.breaks.stream().filter(breakLine -> breakLine.isActive() && breakLine.getM_Product_ID() > 0).filter(breakLine -> breakLine.applies(this.isQuantityBased() ? quantity : amount, productId, productCategoryId)).sorted(Comparator.comparing(X_M_DiscountSchemaBreak::getSeqNo)).findFirst();
        if (!maybeDiscount.isPresent()) {
            maybeDiscount = this.breaks.stream().filter(breakLine -> breakLine.isActive() && breakLine.getM_Product_Category_ID() > 0).filter(breakLine -> breakLine.applies(this.isQuantityBased() ? quantity : amount, productId, productCategoryId)).sorted(Comparator.comparing(X_M_DiscountSchemaBreak::getSeqNo)).findFirst();
        }
        if (!maybeDiscount.isPresent()) {
            maybeDiscount = this.breaks.stream().filter(breakLine -> breakLine.isActive() && breakLine.getM_Product_Category_ID() == 0 && breakLine.getM_Product_ID() == 0).filter(breakLine -> breakLine.applies(this.isQuantityBased() ? quantity : amount, productId, productCategoryId)).sorted(Comparator.comparing(X_M_DiscountSchemaBreak::getSeqNo)).findFirst();
        }
        if (maybeDiscount.isPresent()) {
            BigDecimal discount = null;
            discount = maybeDiscount.get().isBPartnerFlatDiscount() ? BPartnerFlatDiscount : maybeDiscount.get().getBreakDiscount();
            this.log.fine("Discount=>" + discount);
            return discount;
        }
        return Env.ZERO;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getValidFrom() == null) {
            this.setValidFrom(TimeUtil.getDay(null));
        }
        return true;
    }

    public int reSeq() {
        int count = 0;
        MDiscountSchemaLine[] lines = this.getLines(true);
        for (int i2 = 0; i2 < lines.length; ++i2) {
            int line = (i2 + 1) * 10;
            if (line == lines[i2].getSeqNo()) continue;
            lines[i2].setSeqNo(line);
            if (!lines[i2].save()) continue;
            ++count;
        }
        lines = null;
        MDiscountSchemaBreak[] breaks = this.getBreaks(true);
        for (int i3 = 0; i3 < breaks.length; ++i3) {
            int line = (i3 + 1) * 10;
            if (line == breaks[i3].getSeqNo()) continue;
            breaks[i3].setSeqNo(line);
            if (!breaks[i3].save()) continue;
            ++count;
        }
        breaks = null;
        return count;
    }
}

