/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_C_Conversion_Rate;
import org.compiere.model.MClient;
import org.compiere.model.MConversionType;
import org.compiere.model.MCurrency;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;

public class MConversionRate
extends X_C_Conversion_Rate {
    private static final long serialVersionUID = -8171829790483133141L;
    private static CLogger s_log = CLogger.getCLogger(MConversionRate.class);
    private static CCache<Integer, MConversionRate> s_cache = new CCache("C_Conversion_Rate", 40, 5);

    public static BigDecimal convertBase(Properties ctx, BigDecimal Amt, int CurFrom_ID, Timestamp ConvDate, int C_ConversionType_ID, int AD_Client_ID, int AD_Org_ID) {
        int currencyID = 0;
        MClient client = new MClient(ctx, AD_Client_ID, null);
        if (client != null) {
            currencyID = client.getC_Currency_ID();
        }
        if (currencyID == 0) {
            currencyID = MClient.get(ctx).getC_Currency_ID();
        }
        return MConversionRate.convert(ctx, Amt, CurFrom_ID, currencyID, ConvDate, C_ConversionType_ID, AD_Client_ID, AD_Org_ID);
    }

    public static BigDecimal convertBaseDoc(Properties ctx, BigDecimal Amt, int CurFrom_ID, Timestamp ConvDate, int C_ConversionType_ID, int tableID, int recordID, int AD_Client_ID, int AD_Org_ID) {
        int currencyID = 0;
        MClient client = new MClient(ctx, AD_Client_ID, null);
        if (client != null) {
            currencyID = client.getC_Currency_ID();
        }
        if (currencyID == 0) {
            currencyID = MClient.get(ctx).getC_Currency_ID();
        }
        return MConversionRate.convertDoc(ctx, Amt, CurFrom_ID, currencyID, ConvDate, C_ConversionType_ID, tableID, recordID, AD_Client_ID, AD_Org_ID);
    }

    public static BigDecimal convert(Properties ctx, BigDecimal Amt, int CurFrom_ID, int CurTo_ID, int AD_Client_ID, int AD_Org_ID) {
        return MConversionRate.convert(ctx, Amt, CurFrom_ID, CurTo_ID, null, 0, AD_Client_ID, AD_Org_ID);
    }

    public static BigDecimal convert(Properties ctx, BigDecimal Amt, int CurFrom_ID, int CurTo_ID, Timestamp ConvDate, int C_ConversionType_ID, int AD_Client_ID, int AD_Org_ID) {
        if (Amt == null) {
            throw new IllegalArgumentException("Required parameter missing - Amt");
        }
        if (CurFrom_ID == CurTo_ID || Amt.compareTo(Env.ZERO) == 0) {
            return Amt;
        }
        BigDecimal retValue = MConversionRate.getRate(CurFrom_ID, CurTo_ID, ConvDate, C_ConversionType_ID, AD_Client_ID, AD_Org_ID);
        if (retValue == null) {
            return null;
        }
        retValue = retValue.multiply(Amt);
        int stdPrecision = MCurrency.getStdPrecision(ctx, CurTo_ID);
        if (retValue.scale() > stdPrecision) {
            retValue = retValue.setScale(stdPrecision, 4);
        }
        return retValue;
    }

    public static BigDecimal convertDoc(Properties ctx, BigDecimal Amt, int CurFrom_ID, int CurTo_ID, Timestamp ConvDate, int C_ConversionType_ID, int tableID, int recordID, int AD_Client_ID, int AD_Org_ID) {
        if (Amt == null) {
            throw new IllegalArgumentException("Required parameter missing - Amt");
        }
        if (CurFrom_ID == CurTo_ID || Amt.compareTo(Env.ZERO) == 0) {
            return Amt;
        }
        BigDecimal retValue = MConversionRate.getRateDoc(CurFrom_ID, CurTo_ID, ConvDate, C_ConversionType_ID, tableID, recordID, AD_Client_ID, AD_Org_ID);
        if (retValue == null) {
            return null;
        }
        retValue = retValue.multiply(Amt);
        int stdPrecision = MCurrency.getStdPrecision(ctx, CurTo_ID);
        if (retValue.scale() > stdPrecision) {
            retValue = retValue.setScale(stdPrecision, 4);
        }
        return retValue;
    }

    public static void setRate(String CurFrom_ISO, String CurTo_ISO, Date spotDate, BigDecimal MultiplyRate) throws Exception {
        String trxName = Trx.createTrxName();
        Trx trx = Trx.get(trxName, true);
        Properties ctx = Env.getCtx();
        MCurrency curFrom = MCurrency.get(ctx, CurFrom_ISO);
        if (curFrom == null) {
            throw new Exception("Invalid currency " + CurFrom_ISO);
        }
        MCurrency curTo = MCurrency.get(ctx, CurTo_ISO);
        if (curTo == null) {
            throw new Exception("Invalid currency " + CurTo_ISO);
        }
        if (spotDate == null) {
            spotDate = Calendar.getInstance().getTime();
        }
        Calendar spotCal = Calendar.getInstance();
        spotCal.setTime(spotDate);
        spotCal.set(11, 0);
        spotCal.set(12, 0);
        spotCal.set(13, 0);
        spotCal.set(14, 0);
        Timestamp startTs = new Timestamp(spotCal.getTimeInMillis());
        String whereClause = "C_Currency_ID=? and C_Currency_ID_To=? and ValidFrom>=? and ValidTo<=? and C_ConversionType_ID=?";
        MConversionRate updateRate = null;
        List rates = new Query(ctx, "C_Conversion_Rate", "C_Currency_ID=? and C_Currency_ID_To=? and ValidFrom>=? and ValidTo<=? and C_ConversionType_ID=?", trxName).setParameters(curFrom.get_ID(), curTo.get_ID(), startTs, startTs, 114).list();
        if (rates.size() > 0) {
            for (MConversionRate rate : rates) {
                if (!rate.getValidFrom().equals(rate.getValidTo())) {
                    rate.deleteEx(true, trxName);
                    continue;
                }
                updateRate = rate;
            }
        }
        if (updateRate == null) {
            updateRate = new MConversionRate(ctx, 0, trxName);
            updateRate.setAD_Client_ID(0);
            updateRate.setAD_Org_ID(0);
            updateRate.setC_Currency_ID(curFrom.get_ID());
            updateRate.setC_Currency_ID_To(curTo.get_ID());
            updateRate.setValidFrom(startTs);
            updateRate.setValidTo(startTs);
            updateRate.setC_ConversionType_ID(114);
        }
        updateRate.setMultiplyRate(MultiplyRate);
        updateRate.saveEx(trxName);
        trx.commit(true);
        trx.close();
    }

    public static BigDecimal getRate(int CurFrom_ID, int CurTo_ID, Timestamp ConvDate, int ConversionType_ID, int AD_Client_ID, int AD_Org_ID) {
        String sql;
        BigDecimal retValue;
        if (CurFrom_ID == CurTo_ID) {
            return Env.ONE;
        }
        int C_ConversionType_ID = ConversionType_ID;
        if (C_ConversionType_ID == 0) {
            C_ConversionType_ID = MConversionType.getDefault(AD_Client_ID);
        }
        if (ConvDate == null) {
            ConvDate = new Timestamp(System.currentTimeMillis());
        }
        if ((retValue = DB.getSQLValueBD(null, sql = "SELECT MultiplyRate FROM C_Conversion_Rate WHERE C_Currency_ID=? AND C_Currency_ID_To=? AND\tC_ConversionType_ID=? AND\t? BETWEEN ValidFrom AND ValidTo AND AD_Client_ID IN (0,?) AND AD_Org_ID IN (0,?) ORDER BY AD_Client_ID DESC, AD_Org_ID DESC, ValidFrom DESC", CurFrom_ID, CurTo_ID, C_ConversionType_ID, ConvDate, AD_Client_ID, AD_Org_ID)) == null) {
            s_log.info("getRate - not found - CurFrom=" + CurFrom_ID + ", CurTo=" + CurTo_ID + ", " + ConvDate + ", Type=" + ConversionType_ID + (String)(ConversionType_ID == C_ConversionType_ID ? "" : "->" + C_ConversionType_ID) + ", Client=" + AD_Client_ID + ", Org=" + AD_Org_ID);
        }
        return retValue;
    }

    public static BigDecimal getRateDoc(int CurFrom_ID, int CurTo_ID, Timestamp ConvDate, int ConversionType_ID, int tableID, int recordID, int AD_Client_ID, int AD_Org_ID) {
        String sql;
        BigDecimal retValue;
        if (CurFrom_ID == CurTo_ID) {
            return Env.ONE;
        }
        int C_ConversionType_ID = ConversionType_ID;
        if (C_ConversionType_ID == 0) {
            C_ConversionType_ID = MConversionType.getDefault(AD_Client_ID);
        }
        if (ConvDate == null) {
            ConvDate = new Timestamp(System.currentTimeMillis());
        }
        if ((retValue = DB.getSQLValueBD(null, sql = "SELECT MultiplyRate FROM C_Conversion_Rate WHERE C_Currency_ID=? AND C_Currency_ID_To=? AND\tC_ConversionType_ID=? AND\t? BETWEEN ValidFrom AND ValidTo AND AD_Client_ID IN (0,?) AND AD_Org_ID IN (0,?)  AND AD_Table_ID = ? AND Record_ID = ?ORDER BY AD_Client_ID DESC, AD_Org_ID DESC, ValidFrom DESC", CurFrom_ID, CurTo_ID, C_ConversionType_ID, ConvDate, AD_Client_ID, AD_Org_ID, tableID, recordID)) == null) {
            s_log.info("getRate - not found - CurFrom=" + CurFrom_ID + ", CurTo=" + CurTo_ID + ", " + ConvDate + ", Type=" + ConversionType_ID + (String)(ConversionType_ID == C_ConversionType_ID ? "" : "->" + C_ConversionType_ID) + ", Client=" + AD_Client_ID + ", Org=" + AD_Org_ID);
        }
        return retValue;
    }

    public static BigDecimal getDivideRate(int CurFrom_ID, int CurTo_ID, Timestamp ConvDate, int ConversionType_ID, int AD_Client_ID, int AD_Org_ID) {
        if (CurFrom_ID == CurTo_ID) {
            return Env.ONE;
        }
        int C_ConversionType_ID = ConversionType_ID;
        if (C_ConversionType_ID == 0) {
            C_ConversionType_ID = MConversionType.getDefault(AD_Client_ID);
        }
        if (ConvDate == null) {
            ConvDate = TimeUtil.trunc(new Timestamp(System.currentTimeMillis()), "D");
        }
        String sql = "SELECT DivideRate FROM C_Conversion_Rate WHERE C_Currency_ID=? AND C_Currency_ID_To=? AND\tC_ConversionType_ID=? AND\t? BETWEEN ValidFrom AND ValidTo AND AD_Client_ID IN (0,?) AND AD_Org_ID IN (0,?) ORDER BY AD_Client_ID DESC, AD_Org_ID DESC, ValidFrom DESC";
        BigDecimal retValue = null;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, CurFrom_ID);
            pstmt.setInt(2, CurTo_ID);
            pstmt.setInt(3, C_ConversionType_ID);
            pstmt.setTimestamp(4, ConvDate);
            pstmt.setInt(5, AD_Client_ID);
            pstmt.setInt(6, AD_Org_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getBigDecimal(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "getRate", e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (retValue == null) {
            s_log.info("getDivideRate - not found - CurFrom=" + CurFrom_ID + ", CurTo=" + CurTo_ID + ", " + ConvDate + ", Type=" + ConversionType_ID + (String)(ConversionType_ID == C_ConversionType_ID ? "" : "->" + C_ConversionType_ID) + ", Client=" + AD_Client_ID + ", Org=" + AD_Org_ID);
            retValue = Env.ZERO;
        }
        return retValue;
    }

    public static int getConversionRateId(int currencyFromId, int CurencyToId, Timestamp conversionDate, int conversionTypeId, int clientId, int orgId) {
        String sql;
        int conversionRateId;
        if (currencyFromId == CurencyToId) {
            return 0;
        }
        int internalConversionTypeId = conversionTypeId;
        if (internalConversionTypeId == 0) {
            internalConversionTypeId = MConversionType.getDefault(clientId);
        }
        if (conversionDate == null) {
            conversionDate = new Timestamp(System.currentTimeMillis());
        }
        if ((conversionRateId = DB.getSQLValue(null, sql = "SELECT C_Conversion_Rate_ID FROM C_Conversion_Rate WHERE C_Currency_ID=? AND C_Currency_ID_To=? AND\tC_ConversionType_ID=? AND\t? BETWEEN ValidFrom AND ValidTo AND AD_Client_ID IN (0,?) AND AD_Org_ID IN (0,?) ORDER BY AD_Client_ID DESC, AD_Org_ID DESC, ValidFrom DESC", currencyFromId, CurencyToId, internalConversionTypeId, conversionDate, clientId, orgId)) == -1) {
            s_log.info("getRate - not found - CurFrom=" + currencyFromId + ", CurTo=" + CurencyToId + ", " + conversionDate + ", Type=" + conversionTypeId + (String)(conversionTypeId == internalConversionTypeId ? "" : "->" + internalConversionTypeId) + ", Client=" + clientId + ", Org=" + orgId);
        }
        return conversionRateId;
    }

    public static BigDecimal getRate(Properties ctx, int C_Conversion_Rate_ID) {
        MConversionRate conversion = MConversionRate.get(ctx, C_Conversion_Rate_ID);
        if (conversion == null) {
            return null;
        }
        return conversion.getMultiplyRate();
    }

    public static MConversionRate get(Properties ctx, int C_Conversion_Rate_ID) {
        if (C_Conversion_Rate_ID <= 0) {
            return null;
        }
        Integer key = new Integer(C_Conversion_Rate_ID);
        MConversionRate retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MConversionRate(ctx, C_Conversion_Rate_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MConversionRate(Properties ctx, int C_Conversion_Rate_ID, String trxName) {
        super(ctx, C_Conversion_Rate_ID, trxName);
        if (C_Conversion_Rate_ID == 0) {
            super.setDivideRate(Env.ZERO);
            super.setMultiplyRate(Env.ZERO);
            this.setValidFrom(new Timestamp(System.currentTimeMillis()));
        }
    }

    public MConversionRate(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MConversionRate(PO po, int C_ConversionType_ID, int C_Currency_ID, int C_Currency_ID_To, BigDecimal MultiplyRate, Timestamp ValidFrom) {
        this(po.getCtx(), 0, po.get_TrxName());
        this.setClientOrg(po);
        this.setC_ConversionType_ID(C_ConversionType_ID);
        this.setC_Currency_ID(C_Currency_ID);
        this.setC_Currency_ID_To(C_Currency_ID_To);
        this.setMultiplyRate(MultiplyRate);
        this.setValidFrom(ValidFrom);
    }

    @Override
    public void setMultiplyRate(BigDecimal MultiplyRate) {
        if (MultiplyRate == null || MultiplyRate.compareTo(Env.ZERO) == 0 || MultiplyRate.compareTo(Env.ONE) == 0) {
            super.setDivideRate(Env.ONE);
            super.setMultiplyRate(Env.ONE);
        } else {
            super.setMultiplyRate(MultiplyRate);
            double dd = 1.0 / MultiplyRate.doubleValue();
            super.setDivideRate(new BigDecimal(dd));
        }
    }

    @Override
    public void setDivideRate(BigDecimal DivideRate) {
        if (DivideRate == null || DivideRate.compareTo(Env.ZERO) == 0 || DivideRate.compareTo(Env.ONE) == 0) {
            super.setDivideRate(Env.ONE);
            super.setMultiplyRate(Env.ONE);
        } else {
            super.setDivideRate(DivideRate);
            double dd = 1.0 / DivideRate.doubleValue();
            super.setMultiplyRate(new BigDecimal(dd));
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MConversionRate[");
        sb.append(this.get_ID()).append(",Currency=").append(this.getC_Currency_ID()).append(",To=").append(this.getC_Currency_ID_To()).append(", Multiply=").append(this.getMultiplyRate()).append(",Divide=").append(this.getDivideRate()).append(", ValidFrom=").append(this.getValidFrom());
        sb.append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        Timestamp to;
        if (this.getC_Currency_ID() == this.getC_Currency_ID_To()) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@C_Currency_ID@ = @C_Currency_ID@"));
            return false;
        }
        if (this.getMultiplyRate().compareTo(Env.ZERO) <= 0) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@MultiplyRate@ <= 0"));
            return false;
        }
        Timestamp from = this.getValidFrom();
        if (this.getValidTo() == null) {
            this.setValidTo(TimeUtil.getDay(2056, 1, 29));
        }
        if ((to = this.getValidTo()).before(from)) {
            SimpleDateFormat df = DisplayType.getDateFormat(15);
            this.log.saveError("Error", df.format(to) + " < " + df.format(from));
            return false;
        }
        return true;
    }

    public static String getErrorMessage(Properties ctx, String adMessage, int currencyFromID, int currencyToID, int convertionTypeId, Timestamp date, String trxName) {
        if (convertionTypeId == 0) {
            convertionTypeId = MConversionType.getDefault(Env.getAD_Client_ID(ctx));
        }
        String retValue = Msg.getMsg(ctx, adMessage, new Object[]{MCurrency.get(ctx, currencyFromID).getISO_Code(), MCurrency.get(ctx, currencyToID).getISO_Code(), new MConversionType(ctx, convertionTypeId, trxName).getName(), date});
        return retValue;
    }
}

