/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.core.domains.models.X_C_CashLine;
import org.compiere.model.MBankAccount;
import org.compiere.model.MCash;
import org.compiere.model.MCashBook;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MCashLine
extends X_C_CashLine {
    private static final long serialVersionUID = 2962077554051498950L;
    private MCash m_parent = null;
    private MCashBook m_cashBook = null;
    private MBankAccount m_bankAccount = null;
    private MInvoice m_invoice = null;

    public MCashLine(Properties ctx, int C_CashLine_ID, String trxName) {
        super(ctx, C_CashLine_ID, trxName);
        if (C_CashLine_ID == 0) {
            this.setAmount(Env.ZERO);
            this.setDiscountAmt(Env.ZERO);
            this.setWriteOffAmt(Env.ZERO);
            this.setIsGenerated(false);
        }
    }

    public MCashLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCashLine(MCash cash) {
        this(cash.getCtx(), 0, cash.get_TrxName());
        this.setClientOrg(cash);
        this.setC_Cash_ID(cash.getC_Cash_ID());
        this.m_parent = cash;
        this.m_cashBook = this.m_parent.getCashBook();
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public void setInvoice(MInvoice invoice) {
        this.setC_Invoice_ID(invoice.getC_Invoice_ID());
        this.setCashType("I");
        this.setC_Currency_ID(invoice.getC_Currency_ID());
        MDocType dt = MDocType.get(this.getCtx(), invoice.getC_DocType_ID());
        BigDecimal amt = invoice.getGrandTotal();
        if ("API".equals(dt.getDocBaseType()) || "ARC".equals(dt.getDocBaseType())) {
            amt = amt.negate();
        }
        this.setAmount(amt);
        this.setDiscountAmt(Env.ZERO);
        this.setWriteOffAmt(Env.ZERO);
        this.setIsGenerated(true);
        this.m_invoice = invoice;
    }

    public void setOrder(MOrder order, String trxName) {
        this.setCashType("I");
        this.setC_Currency_ID(order.getC_Currency_ID());
        BigDecimal amt = order.getGrandTotal();
        this.setAmount(amt);
        this.setDiscountAmt(Env.ZERO);
        this.setWriteOffAmt(Env.ZERO);
        this.setIsGenerated(true);
        if ("WP".equals(order.getDocStatus())) {
            this.saveEx(trxName);
            order.setC_CashLine_ID(this.getC_CashLine_ID());
            order.processIt("WC");
            order.saveEx(trxName);
            MInvoice[] invoices = order.getInvoices();
            int length = invoices.length;
            if (length > 0) {
                this.m_invoice = invoices[length - 1];
                this.setC_Invoice_ID(this.m_invoice.getC_Invoice_ID());
            }
        }
    }

    public Timestamp getStatementDate() {
        return this.getParent().getStatementDate();
    }

    public MCashLine createReversal() {
        MCash parent = this.getParent();
        if (!parent.isProcessed()) {
            this.setIsActive(false);
            return this;
        }
        parent = MCash.get(this.getCtx(), parent.getAD_Org_ID(), parent.getStatementDate(), parent.getC_Currency_ID(), this.get_TrxName());
        MCashLine reversal = new MCashLine(parent);
        reversal.setClientOrg(this);
        reversal.setC_BankAccount_ID(this.getC_BankAccount_ID());
        reversal.setC_Charge_ID(this.getC_Charge_ID());
        reversal.setC_Currency_ID(this.getC_Currency_ID());
        reversal.setC_Invoice_ID(this.getC_Invoice_ID());
        reversal.setCashType(this.getCashType());
        reversal.setDescription(this.getDescription());
        reversal.setIsGenerated(true);
        reversal.setAmount(this.getAmount().negate());
        if (this.getDiscountAmt() == null) {
            this.setDiscountAmt(Env.ZERO);
        } else {
            reversal.setDiscountAmt(this.getDiscountAmt().negate());
        }
        if (this.getWriteOffAmt() == null) {
            this.setWriteOffAmt(Env.ZERO);
        } else {
            reversal.setWriteOffAmt(this.getWriteOffAmt().negate());
        }
        reversal.addDescription("(" + this.getLine() + ")");
        return reversal;
    }

    public MCash getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MCash(this.getCtx(), this.getC_Cash_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public MCashBook getCashBook() {
        if (this.m_cashBook == null) {
            this.m_cashBook = MCashBook.get(this.getCtx(), this.getParent().getC_CashBook_ID());
        }
        return this.m_cashBook;
    }

    public MBankAccount getBankAccount() {
        if (this.m_bankAccount == null && this.getC_BankAccount_ID() != 0) {
            this.m_bankAccount = MBankAccount.get(this.getCtx(), this.getC_BankAccount_ID());
        }
        return this.m_bankAccount;
    }

    public MInvoice getInvoice() {
        if (this.m_invoice == null && this.getC_Invoice_ID() != 0) {
            this.m_invoice = MInvoice.get(this.getCtx(), this.getC_Invoice_ID());
        }
        return this.m_invoice;
    }

    @Override
    protected boolean beforeDelete() {
        Boolean generated = (Boolean)this.get_ValueOld("IsGenerated");
        if (generated != null && generated.booleanValue() && this.get_ValueOld("C_Invoice_ID") != null) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), "CannotDeleteCashGenInvoice"));
            return false;
        }
        return true;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        return this.updateHeader();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        boolean verify;
        Object generated;
        if (newRecord && this.getParent().isComplete()) {
            this.log.saveError("ParentComplete", Msg.translate(this.getCtx(), "C_CashLine"));
            return false;
        }
        if (this.is_ValueChanged("C_Invoice_ID") && (generated = this.get_ValueOld("IsGenerated")) != null && ((Boolean)generated).booleanValue()) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), "CannotChangeCashGenInvoice"));
            return false;
        }
        if ("I".equals(this.getCashType()) && this.getC_Invoice_ID() == 0) {
            this.setCashType("E");
        }
        if ("T".equals(this.getCashType()) && this.getC_BankAccount_ID() == 0) {
            this.setCashType("E");
        }
        if ("C".equals(this.getCashType()) && this.getC_Charge_ID() == 0) {
            this.setCashType("E");
        }
        boolean bl = verify = newRecord || this.is_ValueChanged("CashType") || this.is_ValueChanged("C_Invoice_ID") || this.is_ValueChanged("C_BankAccount_ID");
        if (verify) {
            if ("T".equals(this.getCashType())) {
                this.setC_Currency_ID(this.getBankAccount().getC_Currency_ID());
            } else if ("I".equals(this.getCashType())) {
                this.setC_Currency_ID(this.getInvoice().getC_Currency_ID());
            } else {
                this.setC_Currency_ID(this.getCashBook().getC_Currency_ID());
            }
            if ("T".equals(this.getCashType())) {
                this.setAD_Org_ID(this.getBankAccount().getAD_Org_ID());
            } else if ("I".equals(this.getCashType())) {
                this.setAD_Org_ID(this.getCashBook().getAD_Org_ID());
            }
            if (this.getAD_Org_ID() == 0) {
                this.setAD_Org_ID(this.getParent().getAD_Org_ID());
            }
        }
        if (!"T".equals(this.getCashType())) {
            this.setC_BankAccount_ID(I_ZERO);
        }
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 FROM C_CashLine WHERE C_Cash_ID=?";
            int ii = DB.getSQLValue(this.get_TrxName(), sql, this.getC_Cash_ID());
            this.setLine(ii);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        return this.updateHeader();
    }

    private boolean updateHeader() {
        String sql = "UPDATE C_Cash c SET StatementDifference=(SELECT COALESCE(SUM(currencyConvert(cl.Amount, cl.C_Currency_ID, cb.C_Currency_ID, c.DateAcct, 0, c.AD_Client_ID, c.AD_Org_ID)),0) FROM C_CashLine cl, C_CashBook cb WHERE cb.C_CashBook_ID=c.C_CashBook_ID AND cl.C_Cash_ID=c.C_Cash_ID AND cl.IsActive='Y') WHERE C_Cash_ID=" + this.getC_Cash_ID();
        int no = DB.executeUpdate(sql, this.get_TrxName());
        if (no != 1) {
            this.log.warning("Difference #" + no);
        }
        if ((no = DB.executeUpdate(sql = "UPDATE C_Cash SET EndingBalance = BeginningBalance + StatementDifference WHERE C_Cash_ID=" + this.getC_Cash_ID(), this.get_TrxName())) != 1) {
            this.log.warning("Balance #" + no);
        }
        return no == 1;
    }
}

