/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.X_M_BOM;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.Msg;

public class MBOM
extends X_M_BOM {
    private static final long serialVersionUID = -8885316310068284701L;
    private static CCache<Integer, MBOM> s_cache = new CCache("M_BOM", 20);
    private static CLogger s_log = CLogger.getCLogger(MBOM.class);

    public static MBOM get(Properties ctx, int M_BOM_ID) {
        Integer key = M_BOM_ID;
        MBOM retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MBOM(ctx, M_BOM_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static MBOM[] getOfProduct(Properties ctx, int M_Product_ID, String trxName, String whereClause) {
        Object where = "M_Product_ID=?";
        if (whereClause != null && whereClause.length() > 0) {
            where = (String)where + " AND " + whereClause;
        }
        List<MBOM> list = new Query(ctx, "M_BOM", (String)where, trxName).setParameters(M_Product_ID).list();
        MBOM[] retValue = new MBOM[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MBOM(Properties ctx, int M_BOM_ID, String trxName) {
        super(ctx, M_BOM_ID, trxName);
        if (M_BOM_ID == 0) {
            this.setBOMType("A");
            this.setBOMUse("A");
        }
    }

    public MBOM(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord || this.is_ValueChanged("BOMType")) {
            MBOM[] boms;
            if (this.getBOMType().equals("A")) {
                MBOM[] boms2 = MBOM.getOfProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName(), "BOMType='A' AND BOMUse='" + this.getBOMUse() + "' AND IsActive='Y'");
                if (boms2.length != 0 && (boms2.length != 1 || boms2[0].getM_BOM_ID() != this.getM_BOM_ID())) {
                    this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "Can only have one Current Active BOM for Product BOM Use (" + this.getBOMType() + ")"));
                    return false;
                }
            } else if (this.getBOMType().equals("O") && (boms = MBOM.getOfProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName(), "IsActive='Y'")).length != 0 && (boms.length != 1 || boms[0].getM_BOM_ID() != this.getM_BOM_ID())) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "Can only have single Make-to-Order BOM for Product"));
                return false;
            }
        }
        return true;
    }
}

