/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.adempiere.exceptions.DBException;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.DataStatusListener;
import org.compiere.model.GridField;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.M_Element;
import org.compiere.model.PO;
import org.compiere.model.PO_LOB;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.MSort;
import org.compiere.util.Msg;
import org.compiere.util.SecureEngine;
import org.compiere.util.Trx;
import org.compiere.util.ValueNamePair;

public class GridTable
extends AbstractTableModel
implements Serializable {
    private static final long serialVersionUID = 7799823493936826600L;
    public static final String DATA_REFRESH_MESSAGE = "Refreshed";
    public String m_trxName = null;
    private static CLogger log = CLogger.getCLogger(GridTable.class.getName());
    private Properties m_ctx;
    private int m_AD_Table_ID;
    private String m_tableName = "";
    private int m_WindowNo;
    private int m_TabNo;
    private boolean m_withAccessControl;
    private boolean m_readOnly = true;
    private boolean m_deleteable = true;
    private boolean m_virtual;
    public static final String CTX_KeyColumnName = "KeyColumnName";
    private int m_rowCount = 0;
    private boolean m_changed = false;
    private int m_rowChanged = -1;
    private boolean m_inserting = false;
    private int m_newRow = -1;
    private boolean m_open = false;
    private boolean m_compareDB = true;
    private volatile ArrayList<Object[]> m_buffer = new ArrayList(100);
    private volatile ArrayList<MSort> m_sort = new ArrayList(100);
    private volatile Map<Integer, Object[]> m_virtualBuffer = new HashMap<Integer, Object[]>(100);
    private Object[] m_rowData = null;
    private Object[] m_oldValue = null;
    private Loader m_loader = null;
    private ArrayList<GridField> m_fields = new ArrayList(30);
    private ArrayList<Object> m_parameterSELECT = new ArrayList(5);
    private ArrayList<Object> m_parameterWHERE = new ArrayList(5);
    private String m_SQL;
    private String m_SQL_Count;
    private String m_SQL_Select;
    private String m_whereClause = "";
    private boolean m_onlyCurrentRows = false;
    private int m_onlyCurrentDays = 1;
    private String m_orderClause = "";
    private int m_maxRows = 0;
    private int m_indexKeyColumn = -1;
    private int m_indexColorColumn = -1;
    private int m_indexProcessedColumn = -1;
    private int m_indexActiveColumn = -1;
    private int m_indexClientColumn = -1;
    private int m_indexOrgColumn = -1;
    private VetoableChangeSupport m_vetoableChangeSupport = new VetoableChangeSupport(this);
    private Thread m_loaderThread;
    public static final String PROPERTY = "MTable-RowSave";
    private static final Integer NEW_ROW_ID = -1;
    private static final int DEFAULT_FETCH_SIZE = 200;
    public ArrayList<Integer> rowChanged = new ArrayList();
    private HashMap<Integer, Object[]> rowChangedData = new HashMap();
    public static final char SAVE_OK = 'O';
    public static final char SAVE_ERROR = 'E';
    public static final char SAVE_ACCESS = 'A';
    public static final char SAVE_MANDATORY = 'M';
    public static final char SAVE_ABORT = 'U';
    private ArrayList<String> m_createSqlColumn = new ArrayList();
    private ArrayList<String> m_createSqlValue = new ArrayList();
    private ArrayList<PO_LOB> m_lobInfo = null;
    private int m_currentRow = -1;

    public String getTrxName() {
        return this.m_trxName;
    }

    public void setTrxName(String trxName) {
        this.m_trxName = trxName;
    }

    public GridTable(Properties ctx, int AD_Table_ID, String TableName, int WindowNo, int TabNo, boolean withAccessControl) {
        this(ctx, AD_Table_ID, TableName, WindowNo, TabNo, withAccessControl, false);
    }

    public GridTable(Properties ctx, int AD_Table_ID, String TableName, int WindowNo, int TabNo, boolean withAccessControl, boolean virtual) {
        log.info(TableName);
        this.m_ctx = ctx;
        this.m_AD_Table_ID = AD_Table_ID;
        this.setTableName(TableName);
        this.m_WindowNo = WindowNo;
        this.m_TabNo = TabNo;
        this.m_withAccessControl = withAccessControl;
        this.m_virtual = virtual;
    }

    public void setTableName(String newTableName) {
        if (this.m_open) {
            log.log(Level.SEVERE, "Table already open - ignored");
            return;
        }
        if (newTableName == null || newTableName.length() == 0) {
            return;
        }
        this.m_tableName = newTableName;
    }

    public String getTableName() {
        return this.m_tableName;
    }

    public boolean setSelectWhereClause(String newWhereClause, boolean onlyCurrentRows, int onlyCurrentDays) {
        if (this.m_open) {
            log.log(Level.SEVERE, "Table already open - ignored");
            return false;
        }
        this.m_whereClause = newWhereClause;
        this.m_onlyCurrentRows = onlyCurrentRows;
        this.m_onlyCurrentDays = onlyCurrentDays;
        if (this.m_whereClause == null) {
            this.m_whereClause = "";
        }
        return true;
    }

    public String getSelectWhereClause() {
        return this.m_whereClause;
    }

    public boolean isOnlyCurrentRowsDisplayed() {
        return !this.m_onlyCurrentRows;
    }

    public void setOrderClause(String newOrderClause) {
        this.m_orderClause = newOrderClause;
        if (this.m_orderClause == null) {
            this.m_orderClause = "";
        }
    }

    public String getOrderClause() {
        return this.m_orderClause;
    }

    private String createSelectSql() {
        if (this.m_fields.size() == 0 || this.m_tableName == null || this.m_tableName.equals("")) {
            return "";
        }
        StringBuffer select = new StringBuffer("SELECT ");
        for (int i = 0; i < this.m_fields.size(); ++i) {
            if (i > 0) {
                select.append(",");
            }
            GridField field = this.m_fields.get(i);
            select.append(field.getColumnSQL(true));
        }
        select.append(" FROM ").append(this.m_tableName);
        this.m_SQL_Select = select.toString();
        this.m_SQL_Count = "SELECT COUNT(*) FROM " + this.m_tableName;
        int parentTabNo = this.getParentTabNo();
        String parentKey = Env.getContext(this.m_ctx, this.m_WindowNo, parentTabNo, "_TabInfo_KeyColumnName", true);
        String valueKey = null;
        String currKey = null;
        if (parentKey != null && parentKey.length() > 0) {
            valueKey = Env.getContext(this.m_ctx, this.m_WindowNo, parentTabNo, parentKey, true);
            currKey = Env.getContext(this.m_ctx, this.m_WindowNo, parentKey);
            if (currKey == null) {
                currKey = new String("");
            }
            if (valueKey != null && valueKey.length() > 0 && parentKey != null && parentKey.length() > 0 && !currKey.equals(valueKey)) {
                Env.setContext(this.m_ctx, this.m_WindowNo, parentKey, valueKey);
            }
        }
        StringBuffer where = new StringBuffer("");
        if (this.m_whereClause.length() > 0) {
            where.append(" WHERE ");
            if (this.m_whereClause.indexOf(64) == -1) {
                where.append(this.m_whereClause);
            } else {
                String context = Env.parseContext(this.m_ctx, this.m_WindowNo, this.m_whereClause, false);
                if (context != null && context.trim().length() > 0) {
                    where.append(context);
                } else {
                    log.log(Level.WARNING, "Failed to parse where clause. whereClause=" + this.m_whereClause);
                    where.append(" 1 = 2 ");
                }
            }
        }
        if (this.m_onlyCurrentRows && this.m_TabNo == 0) {
            if (where.toString().indexOf(" WHERE ") == -1) {
                where.append(" WHERE ");
            } else {
                where.append(" AND ");
            }
            where.append("(Processed='N' OR Updated>");
            where.append("SysDate-1");
            where.append(")");
        }
        this.m_SQL = this.m_SQL_Select + where.toString();
        this.m_SQL_Count = this.m_SQL_Count + where.toString();
        if (this.m_withAccessControl) {
            boolean ro = false;
            this.m_SQL = MRole.getDefault(this.m_ctx, false).addAccessSQL(this.m_SQL, this.m_tableName, true, false);
            this.m_SQL_Count = MRole.getDefault(this.m_ctx, false).addAccessSQL(this.m_SQL_Count, this.m_tableName, true, false);
        }
        if (!this.m_orderClause.equals("")) {
            this.m_SQL = this.m_SQL + " ORDER BY " + this.m_orderClause;
        }
        log.fine(this.m_SQL_Count);
        Env.setContext(this.m_ctx, this.m_WindowNo, this.m_TabNo, "_TabInfo_SQL", this.m_SQL);
        return this.m_SQL;
    }

    public void addField(GridField field) {
        log.fine("(" + this.m_tableName + ") - " + field.getColumnName());
        if (this.m_open) {
            log.log(Level.SEVERE, "Table already open - ignored: " + field.getColumnName());
            return;
        }
        if (!MRole.getDefault(this.m_ctx, false).isColumnAccess(this.m_AD_Table_ID, field.getAD_Column_ID(), true)) {
            log.fine("No Column Access " + field.getColumnName());
            return;
        }
        if (field.isKey()) {
            this.m_indexKeyColumn = this.m_fields.size();
        }
        if (field.getColumnName().equals("IsActive")) {
            this.m_indexActiveColumn = this.m_fields.size();
        } else if (field.getColumnName().equals("Processed")) {
            this.m_indexProcessedColumn = this.m_fields.size();
        } else if (field.getColumnName().equals("AD_Client_ID")) {
            this.m_indexClientColumn = this.m_fields.size();
        } else if (field.getColumnName().equals("AD_Org_ID")) {
            this.m_indexOrgColumn = this.m_fields.size();
        }
        this.m_fields.add(field);
    }

    @Override
    public String getColumnName(int index) {
        if (index < 0 || index > this.m_fields.size()) {
            log.log(Level.SEVERE, "Invalid index=" + index);
            return "";
        }
        GridField field = this.m_fields.get(index);
        return field.getColumnName();
    }

    @Override
    public int findColumn(String columnName) {
        for (int i = 0; i < this.m_fields.size(); ++i) {
            GridField field = this.m_fields.get(i);
            if (!columnName.equals(field.getColumnName())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Class<?> getColumnClass(int index) {
        if (index < 0 || index >= this.m_fields.size()) {
            log.log(Level.SEVERE, "Invalid index=" + index);
            return null;
        }
        GridField field = this.m_fields.get(index);
        return DisplayType.getClass(field.getDisplayType(), false);
    }

    public void setParameterSELECT(int index, Object parameter) {
        if (index >= this.m_parameterSELECT.size()) {
            this.m_parameterSELECT.add(parameter);
        } else {
            this.m_parameterSELECT.set(index, parameter);
        }
    }

    public void setParameterWHERE(int index, Object parameter) {
        if (index >= this.m_parameterWHERE.size()) {
            this.m_parameterWHERE.add(parameter);
        } else {
            this.m_parameterWHERE.set(index, parameter);
        }
    }

    protected GridField getField(int index) {
        if (index < 0 || index >= this.m_fields.size()) {
            return null;
        }
        return this.m_fields.get(index);
    }

    protected GridField getField(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        int cols = this.m_fields.size();
        for (int i = 0; i < cols; ++i) {
            GridField field = this.m_fields.get(i);
            if (!identifier.equalsIgnoreCase(field.getColumnName())) continue;
            return field;
        }
        return null;
    }

    public GridField[] getFields() {
        GridField[] retValue = new GridField[this.m_fields.size()];
        this.m_fields.toArray(retValue);
        return retValue;
    }

    public boolean open(int maxRows) {
        log.info("MaxRows=" + maxRows);
        this.m_maxRows = maxRows;
        if (this.m_open) {
            log.fine("already open");
            this.dataRefreshAll();
            return true;
        }
        if (this.m_virtual) {
            this.verifyVirtual();
        }
        this.createSelectSql();
        if (this.m_SQL == null || this.m_SQL.equals("")) {
            log.log(Level.SEVERE, "No SQL");
            return false;
        }
        this.m_loader = new Loader();
        this.m_rowCount = this.m_loader.open(maxRows);
        if (this.m_virtual) {
            this.m_buffer = null;
            this.m_virtualBuffer = new HashMap<Integer, Object[]>(210);
        } else {
            this.m_buffer = new ArrayList(this.m_rowCount + 10);
        }
        this.m_sort = new ArrayList(this.m_rowCount + 10);
        if (this.m_rowCount > 0) {
            if (this.m_rowCount < 1000) {
                this.m_loader.run();
            } else {
                this.m_loaderThread = new Thread((Runnable)this.m_loader, "TLoader");
                this.m_loaderThread.start();
            }
        } else {
            this.m_loader.close();
        }
        this.m_open = true;
        this.m_changed = false;
        this.m_newRow = -1;
        this.m_rowChanged = -1;
        this.m_inserting = false;
        return true;
    }

    private void verifyVirtual() {
        if (this.m_indexKeyColumn == -1) {
            this.m_virtual = false;
            return;
        }
        GridField[] fields = this.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].isKey() || i == this.m_indexKeyColumn) continue;
            this.m_virtual = false;
            return;
        }
    }

    public void loadComplete() {
        if (this.m_loaderThread != null && this.m_loaderThread.isAlive()) {
            try {
                this.m_loaderThread.join();
            }
            catch (InterruptedException ie) {
                log.log(Level.SEVERE, "Join interrupted", ie);
            }
        }
        for (int i = 0; i < this.m_fields.size(); ++i) {
            GridField field = this.m_fields.get(i);
            field.lookupLoadComplete();
        }
    }

    public boolean isLoading() {
        return this.m_loaderThread != null && this.m_loaderThread.isAlive();
    }

    public boolean isOpen() {
        return this.m_open;
    }

    public void close(boolean finalCall) {
        if (!this.m_open) {
            return;
        }
        log.fine("final=" + finalCall);
        if (finalCall) {
            DataStatusListener[] evl = (DataStatusListener[])this.listenerList.getListeners(DataStatusListener.class);
            for (int i = 0; i < evl.length; ++i) {
                this.listenerList.remove(DataStatusListener.class, evl[i]);
            }
            TableModelListener[] ev2 = (TableModelListener[])this.listenerList.getListeners(TableModelListener.class);
            for (int i = 0; i < ev2.length; ++i) {
                this.listenerList.remove(TableModelListener.class, ev2[i]);
            }
            VetoableChangeListener[] vcl = this.m_vetoableChangeSupport.getVetoableChangeListeners();
            for (int i = 0; i < vcl.length; ++i) {
                this.m_vetoableChangeSupport.removeVetoableChangeListener(vcl[i]);
            }
        }
        while (this.m_loaderThread != null && this.m_loaderThread.isAlive()) {
            log.fine("Interrupting Loader ...");
            this.m_loaderThread.interrupt();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.m_inserting) {
            this.dataSave(false);
        }
        if (this.m_buffer != null) {
            this.m_buffer.clear();
            this.m_buffer = null;
        }
        if (this.m_sort != null) {
            this.m_sort.clear();
            this.m_sort = null;
        }
        if (this.m_virtualBuffer != null) {
            this.m_virtualBuffer.clear();
            this.m_virtualBuffer = null;
        }
        if (finalCall) {
            this.dispose();
        }
        log.fine("");
        this.m_open = false;
    }

    private void dispose() {
        for (int i = 0; i < this.m_fields.size(); ++i) {
            this.m_fields.get(i).dispose();
        }
        this.m_fields.clear();
        this.m_fields = null;
        this.m_vetoableChangeSupport = null;
        this.m_parameterSELECT.clear();
        this.m_parameterSELECT = null;
        this.m_parameterWHERE.clear();
        this.m_parameterWHERE = null;
        this.m_buffer = null;
        this.m_virtualBuffer = null;
        this.m_sort = null;
        this.m_rowData = null;
        this.m_oldValue = null;
        this.m_loader = null;
        this.m_loaderThread = null;
    }

    @Override
    public int getColumnCount() {
        return this.m_fields.size();
    }

    public int getFieldCount() {
        return this.m_fields.size();
    }

    @Override
    public int getRowCount() {
        return this.m_rowCount;
    }

    public void setColorColumn(String columnName) {
        this.m_indexColorColumn = this.findColumn(columnName);
    }

    public int getColorCode(int row) {
        if (this.m_indexColorColumn == -1) {
            return 0;
        }
        Object data = this.getValueAt(row, this.m_indexColorColumn);
        if (data == null || !(data instanceof BigDecimal)) {
            return 0;
        }
        BigDecimal bd = (BigDecimal)data;
        return bd.signum();
    }

    public void sort(int col, boolean ascending) {
        MSort currentRow;
        log.info("#" + col + " " + ascending);
        if (col < 0) {
            return;
        }
        if (this.getRowCount() == 0) {
            return;
        }
        Object[] changedRow = this.m_rowChanged >= 0 ? this.getDataAtRow(this.m_rowChanged) : null;
        GridField field = this.getField(col);
        MSort mSort = currentRow = this.m_currentRow >= 0 && this.m_currentRow < this.m_sort.size() ? this.m_sort.get(this.m_currentRow) : null;
        if (field.getDisplayType() == 26) {
            return;
        }
        boolean isLookup = DisplayType.isLookup(field.getDisplayType());
        boolean isASI = 35 == field.getDisplayType();
        for (int i = 0; i < this.m_sort.size(); ++i) {
            MSort sort = this.m_sort.get(i);
            Object[] rowData = this.getDataAtRow(i);
            sort.data = rowData[col] == null ? null : (isLookup || isASI ? field.getLookup().getDisplay(rowData[col]) : rowData[col]);
        }
        log.info(field.toString() + " #" + this.m_sort.size());
        MSort sort = new MSort(0, null);
        sort.setSortAsc(ascending);
        Collections.sort(this.m_sort, sort);
        if (this.m_virtual) {
            Object[] newRow = this.m_virtualBuffer.get(NEW_ROW_ID);
            this.m_virtualBuffer.clear();
            if (newRow != null && newRow.length > 0) {
                this.m_virtualBuffer.put(NEW_ROW_ID, newRow);
            }
            if (changedRow != null && changedRow.length > 0 && changedRow[this.m_indexKeyColumn] != null && (Integer)changedRow[this.m_indexKeyColumn] > 0) {
                this.m_virtualBuffer.put((Integer)changedRow[this.m_indexKeyColumn], changedRow);
                for (int i = 0; i < this.m_sort.size(); ++i) {
                    if (this.m_sort.get((int)i).index != (Integer)changedRow[this.m_indexKeyColumn]) continue;
                    this.m_rowChanged = i;
                    break;
                }
            }
            for (int i = 0; i < this.m_sort.size(); ++i) {
                this.m_sort.get((int)i).data = null;
                if (currentRow == null || this.m_sort.get(i) != currentRow) continue;
                this.m_currentRow = i;
            }
        }
        this.fireDataStatusIEvent("Sorted", "#" + this.m_sort.size());
        this.fireTableDataChanged();
    }

    public int getKeyID(int row) {
        if (this.m_indexKeyColumn != -1) {
            try {
                Integer ii = (Integer)this.getValueAt(row, this.m_indexKeyColumn);
                if (ii == null) {
                    return -1;
                }
                return ii;
            }
            catch (Exception e) {
                return -1;
            }
        }
        return -1;
    }

    public String getUUID(int row) {
        return DB.getSQLValueString(null, "SELECT UUID FROM " + this.getTableName() + " WHERE " + this.getKeyColumnName() + " = " + this.getKeyID(row), new Object[0]);
    }

    public String getKeyColumnName() {
        if (this.m_indexKeyColumn != -1) {
            return this.getColumnName(this.m_indexKeyColumn);
        }
        return "";
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (!this.m_open || row < 0 || col < 0 || row >= this.m_rowCount) {
            return null;
        }
        for (int loops = 0; row >= this.m_sort.size() && this.m_loaderThread != null && this.m_loaderThread.isAlive() && loops < 15; ++loops) {
            log.fine("Waiting for loader row=" + row + ", size=" + this.m_sort.size());
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (row >= this.m_sort.size()) {
            return null;
        }
        Object[] rowData = this.getDataAtRow(row);
        if (rowData == null || col > rowData.length) {
            return null;
        }
        return rowData[col];
    }

    private Object[] getDataAtRow(int row) {
        return this.getDataAtRow(row, true);
    }

    private Object[] getDataAtRow(int row, boolean fetchIfNotFound) {
        MSort sort = this.m_sort.get(row);
        Object[] rowData = null;
        if (this.m_virtual) {
            if (sort.index != NEW_ROW_ID && !this.m_virtualBuffer.containsKey(sort.index) && fetchIfNotFound) {
                this.fillBuffer(row, 200);
            }
            rowData = this.m_virtualBuffer.get(sort.index);
        } else {
            rowData = this.m_buffer.get(sort.index);
        }
        return rowData;
    }

    private void setDataAtRow(int row, Object[] rowData) {
        MSort sort = this.m_sort.get(row);
        if (this.m_virtual) {
            if (sort.index != NEW_ROW_ID && !this.m_virtualBuffer.containsKey(sort.index)) {
                this.fillBuffer(row, 200);
            }
            this.m_virtualBuffer.put(sort.index, rowData);
        } else {
            this.m_buffer.set(sort.index, rowData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillBuffer(int start, int fetchSize) {
        ResultSet rs;
        CPreparedStatement stmt;
        block12: {
            if (start > 0 && start + fetchSize >= this.m_sort.size() && (start -= fetchSize - (this.m_sort.size() - start)) < 0) {
                start = 0;
            }
            StringBuffer sql = new StringBuffer();
            sql.append(this.m_SQL_Select).append(" WHERE ").append(this.getKeyColumnName()).append(" IN (");
            LinkedHashMap<Integer, Integer> rowmap = new LinkedHashMap<Integer, Integer>(200);
            for (int i = start; i < start + fetchSize && i < this.m_sort.size(); ++i) {
                if (i > start) {
                    sql.append(",");
                }
                sql.append(this.m_sort.get((int)i).index);
                rowmap.put(this.m_sort.get((int)i).index, i);
            }
            sql.append(")");
            Object[] newRow = this.m_virtualBuffer.get(NEW_ROW_ID);
            Object[] changedRow = this.m_rowChanged >= 0 ? this.getDataAtRow(this.m_rowChanged, false) : null;
            this.m_virtualBuffer = new HashMap<Integer, Object[]>(210);
            if (newRow != null && newRow.length > 0) {
                this.m_virtualBuffer.put(NEW_ROW_ID, newRow);
            }
            if (changedRow != null && changedRow.length > 0 && changedRow[this.m_indexKeyColumn] != null && (Integer)changedRow[this.m_indexKeyColumn] > 0) {
                this.m_virtualBuffer.put((Integer)changedRow[this.m_indexKeyColumn], changedRow);
            }
            stmt = null;
            rs = null;
            try {
                stmt = DB.prepareStatement(sql.toString(), null);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    Object[] data = this.readData(rs);
                    rowmap.remove(data[this.m_indexKeyColumn]);
                    this.m_virtualBuffer.put((Integer)data[this.m_indexKeyColumn], data);
                }
                if (rowmap.isEmpty()) break block12;
                ArrayList<Integer> toremove = new ArrayList<Integer>();
                for (Map.Entry entry : rowmap.entrySet()) {
                    toremove.add((Integer)entry.getValue());
                }
                Collections.reverse(toremove);
                for (Integer row : toremove) {
                    this.m_sort.remove(row);
                }
            }
            catch (SQLException e) {
                try {
                    log.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, stmt);
                    throw throwable;
                }
                DB.close(rs, stmt);
            }
        }
        DB.close(rs, stmt);
    }

    public void setChanged(boolean changed) {
        if (!this.m_open || this.m_readOnly) {
            return;
        }
        this.m_changed = changed;
        if (!changed) {
            this.m_rowChanged = -1;
        }
    }

    @Override
    public final void setValueAt(Object value, int row, int col) {
        this.setValueAt(value, row, col, false);
    }

    public final void setValueAt(Object value, int row, int col, boolean force) {
        if (!this.m_open || this.m_readOnly || row < 0 || col < 0 || this.m_rowCount == 0 || row >= this.m_rowCount) {
            log.finest("r=" + row + " c=" + col + " - R/O=" + this.m_readOnly + ", Rows=" + this.m_rowCount + " - Ignored");
            return;
        }
        if (!this.rowChanged.contains(row)) {
            this.rowChanged.add(row);
        }
        if (!this.m_fields.get(0).getGridTab().isIncluded()) {
            this.dataSave(row, false);
        }
        Object oldValue = this.getValueAt(row, col);
        if (!force && !this.isValueChanged(oldValue, value)) {
            log.finest("r=" + row + " c=" + col + " - New=" + value + "==Old=" + oldValue + " - Ignored");
            return;
        }
        log.fine("r=" + row + " c=" + col + " = " + value + " (" + oldValue + ")");
        this.m_oldValue = new Object[3];
        this.m_oldValue[0] = row;
        this.m_oldValue[1] = col;
        this.m_oldValue[2] = oldValue;
        Object[] rowData = this.getDataAtRow(row);
        this.m_rowChanged = row;
        if (this.m_rowData == null) {
            int size = this.m_fields.size();
            this.m_rowData = new Object[size];
            for (int i = 0; i < size; ++i) {
                this.m_rowData[i] = rowData[i];
            }
        }
        if (this.rowChangedData.containsKey(row)) {
            this.rowChangedData.get((Object)Integer.valueOf((int)row))[col] = oldValue;
        } else {
            Object[] o = new Object[rowData.length];
            System.arraycopy(rowData, 0, o, 0, rowData.length);
            this.rowChangedData.put(row, o);
        }
        rowData[col] = value;
        this.setDataAtRow(row, rowData);
        if (!this.m_fields.get(0).getGridTab().isIncluded() && 17 != this.m_fields.get(col).getDisplayType()) {
            this.fireTableCellUpdated(row, col);
        }
        GridField field = this.getField(col);
        field.setValue(value, this.m_inserting);
        DataStatusEvent evt = this.createDSE();
        evt.setChangedColumn(col, field.getColumnName());
        this.fireDataStatusChanged(evt);
    }

    public Object getOldValue(int row, int col) {
        if (this.m_oldValue == null) {
            return null;
        }
        if ((Integer)this.m_oldValue[0] == row && (Integer)this.m_oldValue[1] == col) {
            return this.m_oldValue[2];
        }
        return null;
    }

    public boolean needSave(boolean onlyRealChange) {
        return this.needSave(this.m_rowChanged, onlyRealChange);
    }

    public boolean needSave() {
        return this.needSave(this.m_rowChanged, false);
    }

    public boolean needSave(int newRow) {
        return this.needSave(newRow, false);
    }

    public boolean needSave(int newRow, boolean onlyRealChange) {
        log.fine("Row=" + newRow + ", Changed=" + this.m_rowChanged + "/" + this.m_changed);
        if (!this.m_changed && this.m_rowChanged == -1) {
            return false;
        }
        if (this.m_changed && this.m_rowChanged == -1 && onlyRealChange) {
            return false;
        }
        return newRow != this.m_rowChanged;
    }

    public boolean dataSave(int newRow, boolean manualCmd) {
        log.fine("Row=" + newRow + ", Changed=" + this.m_rowChanged + "/" + this.m_changed);
        if (!this.m_changed && this.m_rowChanged == -1) {
            return true;
        }
        if (newRow == this.m_rowChanged) {
            return true;
        }
        return this.dataSave(manualCmd) == 'O';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char dataSave(boolean manualCmd) {
        ResultSet rs;
        CPreparedStatement pstmt;
        block152: {
            boolean manualUpdate;
            Object[] rowDataDB;
            StringBuffer multiRowWHERE;
            StringBuffer singleRowWHERE;
            StringBuffer select;
            block151: {
                int col;
                String is;
                boolean error;
                Object[] rowData;
                block150: {
                    String missingColumns;
                    String tablename;
                    if (!this.m_open) {
                        log.warning("Error - Open=" + this.m_open);
                        return 'E';
                    }
                    if (this.m_rowChanged == -1) {
                        log.config("NoNeed - Changed=" + this.m_changed + ", Row=" + this.m_rowChanged);
                        if (!manualCmd) {
                            return 'O';
                        }
                    }
                    if (this.m_rowData == null) {
                        this.m_rowChanged = -1;
                        log.fine("No Changes");
                        return 'E';
                    }
                    if (this.m_readOnly) {
                        log.warning("IsReadOnly - ignored");
                        this.dataIgnore();
                        return 'A';
                    }
                    if (this.m_rowChanged == -1) {
                        if (this.m_newRow != -1) {
                            this.m_rowChanged = this.m_newRow;
                        } else {
                            this.fireDataStatusEEvent("SaveErrorNoChange", "", true);
                            return 'E';
                        }
                    }
                    int[] co = this.getClientOrg(this.m_rowChanged);
                    int AD_Client_ID = co[0];
                    int AD_Org_ID = co[1];
                    if (!MRole.getDefault(this.m_ctx, false).canUpdate(AD_Client_ID, AD_Org_ID, this.m_AD_Table_ID, 0, true)) {
                        this.fireDataStatusEEvent(CLogger.retrieveError());
                        this.dataIgnore();
                        return 'A';
                    }
                    log.info("Row=" + this.m_rowChanged);
                    try {
                        if (!manualCmd) {
                            this.m_vetoableChangeSupport.fireVetoableChange(PROPERTY, -1, this.m_rowChanged);
                        }
                    }
                    catch (PropertyVetoException pve) {
                        log.warning(pve.getMessage());
                        return 'U';
                    }
                    rowData = this.getDataAtRow(this.m_rowChanged);
                    boolean specialZeroUpdate = false;
                    if (!this.m_inserting && manualCmd && (Env.getAD_User_ID(this.m_ctx) == 0 || Env.getAD_User_ID(this.m_ctx) == 100) && this.getKeyID(this.m_rowChanged) == 0 && ((tablename = this.getTableName()).equals("AD_Org") || tablename.equals("AD_ReportView") || tablename.equals("AD_Role") || tablename.equals("AD_System") || tablename.equals("AD_User") || tablename.equals("C_DocType") || tablename.equals("GL_Category") || tablename.equals("M_AttributeSet") || tablename.equals("M_AttributeSetInstance"))) {
                        specialZeroUpdate = true;
                    }
                    if ((missingColumns = this.getMandatory(rowData)).length() != 0) {
                        this.fireDataStatusEEvent("FillMandatory", missingColumns + "\n", true);
                        return 'M';
                    }
                    int Record_ID = 0;
                    if (!this.m_inserting) {
                        Record_ID = this.getKeyID(this.m_rowChanged);
                    }
                    try {
                        if (!specialZeroUpdate) {
                            return this.dataSavePO(Record_ID);
                        }
                    }
                    catch (Throwable e) {
                        this.fireDataStatusEEvent("SaveErrorNoChange", e.getLocalizedMessage(), true);
                        if (e instanceof ClassNotFoundException) {
                            log.warning(this.m_tableName + " - " + e.getLocalizedMessage());
                        }
                        log.log(Level.SEVERE, "Persistency Issue - " + this.m_tableName + ": " + e.getLocalizedMessage(), e);
                        return 'E';
                    }
                    log.info("NonPO");
                    error = false;
                    this.lobReset();
                    is = null;
                    String ERROR = "ERROR: ";
                    String INFO = "Info: ";
                    select = new StringBuffer("SELECT ");
                    int addedColumns = 0;
                    for (int i = 0; i < this.m_fields.size(); ++i) {
                        GridField field = this.m_fields.get(i);
                        if (this.m_inserting && field.isVirtualColumn()) continue;
                        if (addedColumns++ > 0) {
                            select.append(",");
                        }
                        select.append(field.getColumnSQL(true));
                    }
                    select.append(" FROM ").append(this.m_tableName);
                    singleRowWHERE = new StringBuffer();
                    multiRowWHERE = new StringBuffer();
                    if (this.m_inserting) {
                        select.append(" WHERE 1=2");
                    } else {
                        select.append(" WHERE ").append(this.getWhereClause(rowData));
                    }
                    pstmt = null;
                    rs = null;
                    pstmt = DB.prepareStatement(select.toString(), 1005, 1008, null);
                    rs = pstmt.executeQuery();
                    if (this.m_inserting || rs.next()) break block150;
                    this.fireDataStatusEEvent("SaveErrorRowNotFound", "", true);
                    this.dataRefresh(this.m_rowChanged);
                    char c = 'E';
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    return c;
                }
                rowDataDB = null;
                boolean bl = manualUpdate = 1007 == rs.getConcurrency();
                if (!manualUpdate && Ini.isPropertyBool("LogMigrationScript")) {
                    manualUpdate = true;
                }
                if (manualUpdate) {
                    this.createUpdateSqlReset();
                }
                if (this.m_inserting) {
                    if (manualUpdate) {
                        log.fine("Prepare inserting ... manual");
                    } else {
                        log.fine("Prepare inserting ... RowSet");
                        rs.moveToInsertRow();
                    }
                } else {
                    log.fine("Prepare updating ... manual=" + manualUpdate);
                    rowDataDB = this.readData(rs);
                }
                Timestamp now = new Timestamp(System.currentTimeMillis());
                int user = Env.getContextAsInt(this.m_ctx, "#AD_User_ID");
                int size = this.m_fields.size();
                int colRs = 1;
                for (col = 0; col < size; ++col) {
                    GridField field = this.m_fields.get(col);
                    if (field.isVirtualColumn()) {
                        if (this.m_inserting) continue;
                        ++colRs;
                        continue;
                    }
                    String columnName = field.getColumnName();
                    if (field.getDisplayType() != 26 && !field.isVirtualColumn()) {
                        if (field.isKey() && this.m_inserting) {
                            if (columnName.endsWith("_ID") || columnName.toUpperCase().endsWith("_ID")) {
                                int insertID = DB.getNextID(this.m_ctx, this.m_tableName, null);
                                if (manualUpdate) {
                                    this.createUpdateSql(columnName, String.valueOf(insertID));
                                } else {
                                    rs.updateInt(colRs, insertID);
                                }
                                singleRowWHERE.append(columnName).append("=").append(insertID);
                                is = "Info: " + columnName + " -> " + insertID + " (Key)";
                            } else {
                                String str = rowData[col].toString();
                                if (manualUpdate) {
                                    this.createUpdateSql(columnName, DB.TO_STRING(str));
                                } else {
                                    rs.updateString(colRs, str);
                                }
                                singleRowWHERE = new StringBuffer();
                                singleRowWHERE.append(columnName).append("=").append(DB.TO_STRING(str));
                                is = "Info: " + columnName + " -> " + str + " (StringKey)";
                            }
                            log.fine(is);
                        } else if (columnName.equals("DocumentNo")) {
                            boolean newDocNo = false;
                            String docNo = (String)rowData[col];
                            if (docNo == null || docNo.length() == 0) {
                                newDocNo = true;
                            } else if (docNo.startsWith("<") && docNo.endsWith(">")) {
                                newDocNo = true;
                            }
                            if (newDocNo || this.m_inserting) {
                                String insertDoc = null;
                                if (this.m_inserting) {
                                    insertDoc = DB.getDocumentNo(this.m_ctx, this.m_WindowNo, this.m_tableName, true, null);
                                }
                                log.fine("DocumentNo entered=" + docNo + ", DocTypeInsert=" + insertDoc + ", newDocNo=" + newDocNo);
                                if (insertDoc == null || insertDoc.length() == 0) {
                                    insertDoc = !newDocNo && docNo != null && docNo.length() > 0 ? docNo : DB.getDocumentNo(this.m_ctx, this.m_WindowNo, this.m_tableName, false, null);
                                }
                                if (insertDoc == null || insertDoc.length() == 0) {
                                    if (docNo != null && docNo.length() != 0) {
                                        insertDoc = (String)rowData[col];
                                    } else {
                                        error = true;
                                        is = "ERROR: " + field.getColumnName() + "= " + rowData[col] + " NO DocumentNo";
                                        log.fine(is);
                                        break;
                                    }
                                }
                                if (manualUpdate) {
                                    this.createUpdateSql(columnName, DB.TO_STRING(insertDoc));
                                } else {
                                    rs.updateString(colRs, insertDoc);
                                }
                                is = "Info: " + columnName + " -> " + insertDoc + " (DocNo)";
                                log.fine(is);
                            }
                        } else if (columnName.equals("Value") && this.m_inserting) {
                            String value = (String)rowData[col];
                            if (!(value != null && value.length() != 0 || (value = DB.getDocumentNo(this.m_ctx, this.m_WindowNo, this.m_tableName, false, null)) != null && value.length() != 0)) {
                                error = true;
                                is = "ERROR: " + field.getColumnName() + "= " + rowData[col] + " No Value";
                                log.fine(is);
                                break;
                            }
                            if (manualUpdate) {
                                this.createUpdateSql(columnName, DB.TO_STRING(value));
                            } else {
                                rs.updateString(colRs, value);
                            }
                            is = "Info: " + columnName + " -> " + value + " (Value)";
                            log.fine(is);
                        } else if (columnName.equals("Updated")) {
                            if (this.m_compareDB && !this.m_inserting && !this.m_rowData[col].equals(rowDataDB[col])) {
                                error = true;
                                is = "ERROR: " + field.getColumnName() + "= " + this.m_rowData[col] + " != DB: " + rowDataDB[col];
                                log.fine(is);
                                break;
                            }
                            if (manualUpdate) {
                                this.createUpdateSql(columnName, DB.TO_DATE(now, false));
                            } else {
                                rs.updateTimestamp(colRs, now);
                            }
                            is = "Info: Updated/By -> " + now + " - " + user;
                            log.fine(is);
                        } else if (columnName.equals("UpdatedBy")) {
                            if (manualUpdate) {
                                this.createUpdateSql(columnName, String.valueOf(user));
                            } else {
                                rs.updateInt(colRs, user);
                            }
                        } else if (this.m_inserting && columnName.equals("Created")) {
                            if (manualUpdate) {
                                this.createUpdateSql(columnName, DB.TO_DATE(now, false));
                            } else {
                                rs.updateTimestamp(colRs, now);
                            }
                        } else if (this.m_inserting && columnName.equals("CreatedBy")) {
                            if (manualUpdate) {
                                this.createUpdateSql(columnName, String.valueOf(user));
                            } else {
                                rs.updateInt(colRs, user);
                            }
                        } else if (this.m_rowData[col] == null && rowData[col] == null) {
                            if (this.m_inserting) {
                                if (manualUpdate) {
                                    this.createUpdateSql(columnName, "NULL");
                                } else {
                                    rs.updateNull(colRs);
                                }
                                is = "Info: " + columnName + "= NULL";
                                log.fine(is);
                            }
                        } else if (this.m_inserting || this.m_rowData[col] == null && rowData[col] != null || this.m_rowData[col] != null && rowData[col] == null || !this.m_rowData[col].equals(rowData[col])) {
                            if (this.m_inserting || !this.m_compareDB || this.m_rowData[col] == null && rowDataDB[col] == null || this.m_rowData[col] != null && this.m_rowData[col].equals(rowDataDB[col])) {
                                if (CLogMgt.isLevelFinest()) {
                                    log.fine(columnName + "=" + rowData[col] + " " + (rowData[col] == null ? "" : rowData[col].getClass().getName()));
                                }
                                boolean encrypted = field.isEncryptedColumn();
                                String type = "String";
                                if (rowData[col] == null) {
                                    if (manualUpdate) {
                                        this.createUpdateSql(columnName, "NULL");
                                    } else {
                                        rs.updateNull(colRs);
                                    }
                                } else if (DisplayType.isID(field.getDisplayType()) || field.getDisplayType() == 11) {
                                    try {
                                        Object dd = rowData[col];
                                        Integer iii = null;
                                        iii = dd instanceof Integer ? (Integer)dd : Integer.valueOf(dd.toString());
                                        if (encrypted) {
                                            iii = (Integer)this.encrypt(iii);
                                        }
                                        if (manualUpdate) {
                                            this.createUpdateSql(columnName, String.valueOf(iii));
                                        } else {
                                            rs.updateInt(colRs, (int)iii);
                                        }
                                    }
                                    catch (Exception e) {
                                        if (manualUpdate) {
                                            this.createUpdateSql(columnName, DB.TO_STRING(rowData[col].toString()));
                                        }
                                        rs.updateString(colRs, rowData[col].toString());
                                    }
                                    type = "Int";
                                } else if (DisplayType.isNumeric(field.getDisplayType())) {
                                    BigDecimal bd = (BigDecimal)rowData[col];
                                    if (encrypted) {
                                        bd = (BigDecimal)this.encrypt(bd);
                                    }
                                    if (manualUpdate) {
                                        this.createUpdateSql(columnName, bd.toString());
                                    } else {
                                        rs.updateBigDecimal(colRs, bd);
                                    }
                                    type = "Number";
                                } else if (DisplayType.isDate(field.getDisplayType())) {
                                    Timestamp ts = (Timestamp)rowData[col];
                                    if (encrypted) {
                                        ts = (Timestamp)this.encrypt(ts);
                                    }
                                    if (manualUpdate) {
                                        this.createUpdateSql(columnName, DB.TO_DATE(ts, false));
                                    } else {
                                        rs.updateTimestamp(colRs, ts);
                                    }
                                    type = "Date";
                                } else if (field.getDisplayType() == 36) {
                                    PO_LOB lob = new PO_LOB(this.getTableName(), columnName, null, field.getDisplayType(), rowData[col]);
                                    this.lobAdd(lob);
                                    type = "CLOB";
                                } else if (field.getDisplayType() == 20) {
                                    String yn = null;
                                    if (rowData[col] instanceof Boolean) {
                                        Boolean bb = (Boolean)rowData[col];
                                        yn = bb != false ? "Y" : "N";
                                    } else {
                                        String string = yn = "Y".equals(rowData[col]) ? "Y" : "N";
                                    }
                                    if (encrypted) {
                                        // empty if block
                                    }
                                    if (manualUpdate) {
                                        this.createUpdateSql(columnName, DB.TO_STRING(yn));
                                    } else {
                                        rs.updateString(colRs, yn);
                                    }
                                } else {
                                    String str = rowData[col].toString();
                                    if (encrypted) {
                                        str = (String)this.encrypt(str);
                                    }
                                    if (manualUpdate) {
                                        this.createUpdateSql(columnName, DB.TO_STRING(str));
                                    } else {
                                        rs.updateString(colRs, str);
                                    }
                                }
                                is = "Info: " + columnName + "= " + this.m_rowData[col] + " -> " + rowData[col] + " (" + type + ")";
                                if (encrypted) {
                                    is = is + " encrypted";
                                }
                                log.fine(is);
                            } else {
                                error = true;
                                is = "ERROR: " + field.getColumnName() + "= " + this.m_rowData[col] + " != DB: " + rowDataDB[col] + " -> " + rowData[col];
                                log.fine(is);
                            }
                        }
                    }
                    if (field.isKey() && !this.m_inserting) {
                        if (rowData[col] == null) {
                            throw new RuntimeException("Key is NULL - " + columnName);
                        }
                        if (columnName.endsWith("_ID")) {
                            singleRowWHERE.append(columnName).append("=").append(rowData[col]);
                        } else {
                            singleRowWHERE = new StringBuffer();
                            singleRowWHERE.append(columnName).append("=").append(DB.TO_STRING(rowData[col].toString()));
                        }
                    }
                    if (field.isParentColumn()) {
                        if (rowData[col] == null) {
                            throw new RuntimeException("MultiKey Parent is NULL - " + columnName);
                        }
                        if (multiRowWHERE.length() != 0) {
                            multiRowWHERE.append(" AND ");
                        }
                        if (columnName.endsWith("_ID")) {
                            multiRowWHERE.append(columnName).append("=").append(rowData[col]);
                        } else {
                            multiRowWHERE.append(columnName).append("=").append(DB.TO_STRING(rowData[col].toString()));
                        }
                    }
                    ++colRs;
                }
                if (!error) break block151;
                if (manualUpdate) {
                    this.createUpdateSqlReset();
                } else {
                    rs.cancelRowUpdates();
                }
                this.fireDataStatusEEvent("SaveErrorDataChanged", "", true);
                this.dataRefresh(this.m_rowChanged);
                col = 69;
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return (char)col;
            }
            try {
                String sql;
                String whereClause = singleRowWHERE.toString();
                if (whereClause.length() == 0) {
                    whereClause = multiRowWHERE.toString();
                }
                if (this.m_inserting) {
                    log.fine("Inserting ...");
                    if (manualUpdate) {
                        sql = this.createUpdateSql(true, null);
                        int no = DB.executeUpdateEx(sql, null);
                        if (no != 1) {
                            log.log(Level.SEVERE, "Insert #=" + no + " - " + sql);
                        }
                    } else {
                        rs.insertRow();
                    }
                } else {
                    log.fine("Updating ... " + whereClause);
                    if (manualUpdate) {
                        sql = this.createUpdateSql(false, whereClause);
                        int no = DB.executeUpdateEx(sql, null);
                        if (no != 1) {
                            log.log(Level.SEVERE, "Update #=" + no + " - " + sql);
                        }
                    } else {
                        rs.updateRow();
                    }
                }
                log.fine("Committing ...");
                DB.commit(true, null);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                this.lobSave(whereClause);
                log.fine("Reading ... " + whereClause);
                StringBuffer refreshSQL = new StringBuffer(this.m_SQL_Select).append(" WHERE ").append(whereClause);
                pstmt = DB.prepareStatement(refreshSQL.toString(), null);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    rowDataDB = this.readData(rs);
                    this.setDataAtRow(this.m_rowChanged, rowDataDB);
                    if (this.m_virtual) {
                        MSort sort = this.m_sort.get(this.m_rowChanged);
                        int oldId = sort.index;
                        int newId = this.getKeyID(this.m_rowChanged);
                        if (newId != oldId) {
                            sort.index = newId;
                            Object[] data = this.m_virtualBuffer.remove(oldId);
                            this.m_virtualBuffer.put(newId, data);
                        }
                    }
                    this.fireTableRowsUpdated(this.m_rowChanged, this.m_rowChanged);
                    break block152;
                }
                log.log(Level.SEVERE, "Inserted row not found");
            }
            catch (Exception e) {
                char c;
                try {
                    String msg = "SaveError";
                    if (DBException.isUniqueContraintError(e)) {
                        log.log(Level.SEVERE, "Key Not Unique", e);
                        msg = "SaveErrorNotUnique";
                    } else {
                        log.log(Level.SEVERE, select.toString(), e);
                    }
                    this.fireDataStatusEEvent(msg, e.getLocalizedMessage(), true);
                    c = 'E';
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return c;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        this.m_rowData = null;
        this.m_changed = false;
        this.m_compareDB = true;
        this.m_rowChanged = -1;
        this.m_newRow = -1;
        this.m_inserting = false;
        this.fireDataStatusIEvent("Saved", "");
        log.info("fini");
        return 'O';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char dataSavePO(int Record_ID) throws Exception {
        String info;
        log.fine("ID=" + Record_ID);
        Object[] rowData = this.getDataAtRow(this.m_rowChanged);
        MTable table2 = MTable.get(this.m_ctx, this.m_AD_Table_ID);
        PO po = null;
        po = Record_ID != -1 ? table2.getPO(Record_ID, null) : table2.getPO(this.getWhereClause(rowData), null);
        if (po == null) {
            throw new ClassNotFoundException("No Persistent Object");
        }
        int size = this.m_fields.size();
        for (int col = 0; col < size; ++col) {
            GridField field = this.m_fields.get(col);
            if (field.isVirtualColumn()) continue;
            String columnName = field.getColumnName();
            Object value = rowData[col];
            Object oldValue = this.m_rowData[col];
            if (field.getDisplayType() == 26 || oldValue == null && value == null || !this.m_inserting && !this.isValueChanged(oldValue, value)) continue;
            int poIndex = po.get_ColumnIndex(columnName);
            if (poIndex < 0) {
                po.set_CustomColumn(columnName, value);
                continue;
            }
            Object dbValue = po.get_Value(poIndex);
            if (this.m_inserting || !this.m_compareDB || oldValue == null && dbValue == null || oldValue != null && oldValue.equals(dbValue) || oldValue instanceof Boolean && (Boolean)oldValue == false && dbValue == null || value == null && dbValue == null || value != null && value.equals(dbValue) || value instanceof Boolean && (Boolean)value == false && dbValue == null || oldValue != null && dbValue != null && oldValue.getClass().equals(byte[].class) && dbValue.getClass().equals(byte[].class) && Arrays.equals((byte[])oldValue, (byte[])dbValue) || value != null && dbValue != null && oldValue != null && value.getClass().equals(byte[].class) && dbValue.getClass().equals(byte[].class) && Arrays.equals((byte[])oldValue, (byte[])dbValue)) {
                if (po.set_ValueNoCheck(columnName, value)) continue;
                ValueNamePair error = CLogger.retrieveError();
                if (error != null) {
                    this.fireDataStatusEEvent(error.getValue() != null ? error.getValue() : "", field.getHeader() + " - " + (error.getName() != null ? error.getName() : ""), true);
                } else {
                    this.fireDataStatusEEvent(Msg.parseTranslation(po.getCtx(), "@Value@ @NotValid@ "), field.getHeader(), true);
                }
                return 'E';
            }
            String msg = columnName + "= " + oldValue + (String)(oldValue == null ? "" : "(" + oldValue.getClass().getName() + ")") + " != DB: " + dbValue + (String)(dbValue == null ? "" : "(" + dbValue.getClass().getName() + ")") + " -> New: " + value + (String)(value == null ? "" : "(" + value.getClass().getName() + ")");
            this.fireDataStatusEEvent("SaveErrorDataChanged", msg, true);
            this.dataRefresh(this.m_rowChanged);
            return 'E';
        }
        if (!po.save()) {
            String msg = "SaveError";
            String info2 = "";
            ValueNamePair ppE = CLogger.retrieveError();
            if (ppE != null) {
                msg = ppE.getValue();
                info2 = ppE.getName();
                if (DBException.isUniqueContraintError(CLogger.retrieveException())) {
                    msg = "SaveErrorNotUnique";
                }
            }
            this.fireDataStatusEEvent(msg, info2, true);
            return 'E';
        }
        if (this.m_virtual && po.get_ID() > 0) {
            MSort sort = this.m_sort.get(this.m_rowChanged);
            int oldid = sort.index;
            if (oldid != po.get_ID()) {
                sort.index = po.get_ID();
                Object[] data = this.m_virtualBuffer.remove(oldid);
                data[this.m_indexKeyColumn] = sort.index;
                this.m_virtualBuffer.put(sort.index, data);
            }
        }
        String whereClause = po.get_WhereClause(true);
        log.fine("Reading ... " + whereClause);
        StringBuffer refreshSQL = new StringBuffer(this.m_SQL_Select).append(" WHERE ").append(whereClause);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(refreshSQL.toString(), null);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                Object[] rowDataDB = this.readData(rs);
                this.setDataAtRow(this.m_rowChanged, rowDataDB);
                this.fireTableRowsUpdated(this.m_rowChanged, this.m_rowChanged);
            }
        }
        catch (SQLException e) {
            char dbValue;
            try {
                String msg = "SaveError";
                log.log(Level.SEVERE, refreshSQL.toString(), e);
                this.fireDataStatusEEvent(msg, e.getLocalizedMessage(), true);
                dbValue = 'E';
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return dbValue;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        this.m_rowData = null;
        this.m_changed = false;
        this.m_compareDB = true;
        this.m_rowChanged = -1;
        this.m_newRow = -1;
        this.m_inserting = false;
        ValueNamePair pp = CLogger.retrieveWarning();
        if (pp != null) {
            String msg = pp.getValue();
            info = pp.getName();
            this.fireDataStatusEEvent(msg, info, false);
        } else {
            pp = CLogger.retrieveInfo();
            String msg = "Saved";
            info = "";
            if (pp != null) {
                msg = pp.getValue();
                info = pp.getName();
            }
            this.fireDataStatusIEvent(msg, info);
        }
        log.config("fini");
        return 'O';
    }

    private String getWhereClause(Object[] rowData) {
        int size = this.m_fields.size();
        StringBuffer singleRowWHERE = null;
        StringBuffer multiRowWHERE = null;
        for (int col = 0; col < size; ++col) {
            Object value;
            String columnName;
            GridField field = this.m_fields.get(col);
            if (field.isKey()) {
                columnName = field.getColumnName();
                value = rowData[col];
                if (value == null) {
                    log.log(Level.WARNING, "PK data is null - " + columnName);
                    return null;
                }
                if (columnName.endsWith("_ID")) {
                    singleRowWHERE = new StringBuffer(columnName).append("=").append(value);
                    continue;
                }
                singleRowWHERE = new StringBuffer(columnName).append("=").append(DB.TO_STRING(value.toString()));
                continue;
            }
            if (!field.isParentColumn()) continue;
            columnName = field.getColumnName();
            value = rowData[col];
            if (value == null) {
                log.log(Level.INFO, "FK data is null - " + columnName);
                continue;
            }
            if (multiRowWHERE == null) {
                multiRowWHERE = new StringBuffer();
            } else {
                multiRowWHERE.append(" AND ");
            }
            if (columnName.endsWith("_ID")) {
                multiRowWHERE.append(columnName).append("=").append(value);
                continue;
            }
            multiRowWHERE.append(columnName).append("=").append(DB.TO_STRING(value.toString()));
        }
        if (singleRowWHERE != null) {
            return singleRowWHERE.toString();
        }
        if (multiRowWHERE != null) {
            return multiRowWHERE.toString();
        }
        log.log(Level.WARNING, "No key Found");
        return null;
    }

    private void createUpdateSql(String columnName, String value) {
        this.m_createSqlColumn.add(columnName);
        this.m_createSqlValue.add(value);
        log.finest("#" + this.m_createSqlColumn.size() + " - " + columnName + "=" + value);
    }

    private String createUpdateSql(boolean insert, String whereClause) {
        StringBuffer sb = new StringBuffer();
        if (insert) {
            int i;
            sb.append("INSERT INTO ").append(this.m_tableName).append(" (");
            for (i = 0; i < this.m_createSqlColumn.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(this.m_createSqlColumn.get(i));
            }
            sb.append(") VALUES ( ");
            for (i = 0; i < this.m_createSqlValue.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(this.m_createSqlValue.get(i));
            }
            sb.append(")");
        } else {
            sb.append("UPDATE ").append(this.m_tableName).append(" SET ");
            for (int i = 0; i < this.m_createSqlColumn.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(this.m_createSqlColumn.get(i)).append("=").append(this.m_createSqlValue.get(i));
            }
            sb.append(" WHERE ").append(whereClause);
        }
        log.fine(sb.toString());
        this.createUpdateSqlReset();
        return sb.toString();
    }

    private void createUpdateSqlReset() {
        this.m_createSqlColumn = new ArrayList();
        this.m_createSqlValue = new ArrayList();
    }

    private String getMandatory(Object[] rowData) {
        StringBuffer sb = new StringBuffer();
        int size = this.m_fields.size();
        for (int i = 0; i < size; ++i) {
            GridField field = this.m_fields.get(i);
            if (!field.isMandatory(true)) continue;
            if (rowData[i] == null || rowData[i].toString().length() == 0) {
                field.setInserting(true);
                field.setError(true);
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(field.getHeader());
                continue;
            }
            field.setError(false);
        }
        if (sb.length() == 0) {
            return "";
        }
        return sb.toString();
    }

    private void lobReset() {
        this.m_lobInfo = null;
    }

    private void lobAdd(PO_LOB lob) {
        log.fine("LOB=" + lob);
        if (this.m_lobInfo == null) {
            this.m_lobInfo = new ArrayList();
        }
        this.m_lobInfo.add(lob);
    }

    private void lobSave(String whereClause) {
        if (this.m_lobInfo == null) {
            return;
        }
        for (int i = 0; i < this.m_lobInfo.size(); ++i) {
            PO_LOB lob = this.m_lobInfo.get(i);
            lob.save(whereClause, null);
        }
        this.lobReset();
    }

    public boolean dataNew(int currentRow, boolean copyCurrent) {
        MSort newSort;
        log.info("Current=" + currentRow + ", Copy=" + copyCurrent);
        if (this.m_readOnly) {
            this.fireDataStatusEEvent("AccessCannotInsert", "", true);
            return false;
        }
        this.dataSave(-2, false);
        this.m_inserting = true;
        int size = this.m_fields.size();
        this.m_rowData = new Object[size];
        Object[] rowData = new Object[size];
        this.m_changed = true;
        this.m_compareDB = true;
        this.m_newRow = currentRow + 1;
        if (this.m_sort.size() < this.m_newRow) {
            this.m_newRow = this.m_sort.size();
        }
        MSort mSort = newSort = this.m_virtual ? new MSort(NEW_ROW_ID, null) : new MSort(this.m_sort.size(), null);
        if (this.m_virtual) {
            this.m_virtualBuffer.put(NEW_ROW_ID, rowData);
        } else {
            this.m_buffer.add(rowData);
        }
        this.m_sort.add(this.m_newRow, newSort);
        ++this.m_rowCount;
        if (copyCurrent) {
            Object[] origData = this.getDataAtRow(currentRow);
            for (int i = 0; i < size; ++i) {
                GridField field = this.m_fields.get(i);
                String columnName = field.getColumnName();
                if (field.isVirtualColumn()) continue;
                if (field.isKey() || M_Element.isReservedColumnName(columnName) || field.isReadOnly() || !field.IsAllowCopy()) {
                    rowData[i] = field.getDefault();
                    field.setValue(rowData[i], this.m_inserting);
                    continue;
                }
                rowData[i] = origData[i];
            }
        } else {
            for (int i = 0; i < size; ++i) {
                GridField field = this.m_fields.get(i);
                rowData[i] = field.getDefault();
                field.setValue(rowData[i], this.m_inserting);
            }
        }
        Object[] o = new Object[rowData.length];
        System.arraycopy(rowData, 0, o, 0, rowData.length);
        this.rowChangedData.put(this.m_newRow, o);
        if (!this.rowChanged.contains(this.m_newRow)) {
            this.rowChanged.add(this.m_newRow);
        }
        this.m_rowChanged = -1;
        log.fine("Current=" + currentRow + ", New=" + this.m_newRow);
        this.fireTableRowsInserted(this.m_newRow, this.m_newRow);
        this.fireDataStatusIEvent(copyCurrent ? "UpdateCopied" : "Inserted", "");
        log.fine("Current=" + currentRow + ", New=" + this.m_newRow + " - complete");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dataDelete(int row) {
        int i;
        MSort sort;
        block23: {
            Object[] rowData;
            block22: {
                Boolean processed;
                log.info("Row=" + row);
                if (row < 0) {
                    return false;
                }
                if (this.m_readOnly) {
                    this.fireDataStatusEEvent("AccessCannotDelete", "", true);
                    return false;
                }
                if (!this.m_deleteable) {
                    this.fireDataStatusEEvent("AccessNotDeleteable", "", true);
                    return false;
                }
                if (this.m_indexProcessedColumn > 0 && !this.m_tableName.startsWith("I_") && (processed = (Boolean)this.getValueAt(row, this.m_indexProcessedColumn)) != null && processed.booleanValue()) {
                    this.fireDataStatusEEvent("CannotDeleteTrx", "", true);
                    return false;
                }
                sort = this.m_sort.get(row);
                rowData = this.getDataAtRow(row);
                MTable table2 = MTable.get(this.m_ctx, this.m_AD_Table_ID);
                PO po = null;
                int Record_ID = this.getKeyID(this.m_rowChanged);
                po = Record_ID != -1 ? table2.getPO(Record_ID, null) : table2.getPO(this.getWhereClause(rowData), null);
                if (po == null) break block22;
                boolean ok = false;
                try {
                    ok = po.delete(false);
                }
                catch (Throwable t) {
                    log.log(Level.SEVERE, "Delete", t);
                }
                if (!ok) {
                    ValueNamePair vp = CLogger.retrieveError();
                    if (vp != null) {
                        this.fireDataStatusEEvent(vp);
                    } else {
                        this.fireDataStatusEEvent("DeleteError", "", true);
                    }
                    return false;
                }
                break block23;
            }
            StringBuffer sql = new StringBuffer("DELETE ");
            sql.append(this.m_tableName).append(" WHERE ").append(this.getWhereClause(rowData));
            int no = 0;
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql.toString(), 1005, 1008, null);
                no = pstmt.executeUpdate();
            }
            catch (SQLException e) {
                boolean bl;
                try {
                    log.log(Level.SEVERE, sql.toString(), e);
                    String msg = "DeleteError";
                    if (DBException.isChildRecordFoundError(e)) {
                        msg = "DeleteErrorDependent";
                    }
                    this.fireDataStatusEEvent(msg, e.getLocalizedMessage(), true);
                    bl = false;
                }
                catch (Throwable throwable) {
                    DB.close(pstmt);
                    pstmt = null;
                    throw throwable;
                }
                DB.close(pstmt);
                pstmt = null;
                return bl;
            }
            DB.close(pstmt);
            pstmt = null;
            if (no != 1) {
                log.log(Level.SEVERE, "Number of deleted rows = " + no);
                return false;
            }
        }
        if (this.m_virtual) {
            this.m_virtualBuffer.remove(sort.index);
        } else {
            this.m_buffer.remove(sort.index);
        }
        --this.m_rowCount;
        this.m_sort.remove(row);
        if (!this.m_virtual) {
            for (i = 0; i < this.m_sort.size(); ++i) {
                MSort ptr = this.m_sort.get(i);
                if (ptr.index <= sort.index) continue;
                --ptr.index;
            }
        }
        if (this.rowChanged.contains(row)) {
            this.rowChangedData.remove(row);
            i = 0;
            for (int changed : this.rowChanged) {
                if (changed == row) {
                    this.rowChanged.remove(i);
                    break;
                }
                ++i;
            }
        }
        this.m_changed = false;
        this.m_rowChanged = -1;
        this.fireTableRowsDeleted(row, row);
        this.fireDataStatusIEvent("Deleted", "");
        log.fine("Row=" + row + " complete");
        return true;
    }

    public void dataIgnore() {
        if (!this.m_inserting && !this.m_changed && this.m_rowChanged < 0) {
            log.fine("Nothing to ignore");
            return;
        }
        log.info("Inserting=" + this.m_inserting);
        if (this.m_inserting) {
            MSort sort = this.m_sort.get(this.m_newRow);
            if (this.m_virtual) {
                this.m_virtualBuffer.remove(NEW_ROW_ID);
            } else {
                this.m_buffer.remove(sort.index);
            }
            --this.m_rowCount;
            this.m_sort.remove(this.m_newRow);
            this.m_changed = false;
            this.m_rowData = null;
            if (!this.m_inserting && this.rowChanged.size() > 0) {
                for (int i = 0; i < this.rowChanged.size(); ++i) {
                    this.setDataAtRow(this.rowChanged.get(i), this.rowChangedData.get(this.rowChanged.get(i)));
                }
            }
            this.rowChangedData.clear();
            this.rowChanged.clear();
            this.m_rowChanged = -1;
            this.m_inserting = false;
            this.fireTableRowsDeleted(this.m_newRow, this.m_newRow);
        } else {
            if (this.m_rowData != null) {
                this.setDataAtRow(this.m_rowChanged, this.m_rowData);
            }
            this.m_changed = false;
            this.m_rowData = null;
            this.m_rowChanged = -1;
            this.m_inserting = false;
        }
        this.m_newRow = -1;
        this.fireDataStatusIEvent("Ignored", "");
    }

    public void dataRefresh(int row) {
        this.dataRefresh(row, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataRefresh(int row, boolean fireStatusEvent) {
        log.info("Row=" + row);
        if (row < 0 || this.m_sort.size() == 0 || this.m_inserting) {
            return;
        }
        MSort sort = this.m_sort.get(row);
        Object[] rowData = this.getDataAtRow(row);
        this.dataIgnore();
        String where = this.getWhereClause(rowData);
        if (where == null || where.length() == 0) {
            where = "1=2";
        }
        String sql = this.m_SQL_Select + " WHERE " + where;
        sort = this.m_sort.get(row);
        Object[] rowDataDB = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                rowDataDB = this.readData(rs);
            }
        }
        catch (SQLException e) {
            try {
                log.log(Level.SEVERE, sql, e);
                this.fireTableRowsUpdated(row, row);
                this.fireDataStatusEEvent("RefreshError", sql, true);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        this.setDataAtRow(row, rowDataDB);
        this.m_rowData = null;
        this.m_changed = false;
        this.m_rowChanged = -1;
        this.m_inserting = false;
        this.fireTableRowsUpdated(row, row);
        if (fireStatusEvent) {
            this.fireDataStatusIEvent(DATA_REFRESH_MESSAGE, "");
        }
    }

    public void dataRefreshAll() {
        this.dataRefreshAll(true, -1);
    }

    public void dataRefreshAll(boolean fireStatusEvent, int rowToRetained) {
        log.info("");
        this.m_inserting = false;
        this.dataIgnore();
        String retainedWhere = null;
        if (rowToRetained >= 0) {
            retainedWhere = this.getWhereClause(rowToRetained);
        }
        this.close(false);
        if (retainedWhere != null) {
            if (this.m_whereClause != null && this.m_whereClause.trim().length() > 0) {
                this.m_whereClause = "((" + this.m_whereClause + ") OR (" + retainedWhere + ")) ";
            }
            this.open(this.m_maxRows);
        } else {
            this.open(this.m_maxRows);
        }
        this.m_rowData = null;
        this.m_changed = false;
        this.m_rowChanged = -1;
        this.m_inserting = false;
        this.fireTableDataChanged();
        if (fireStatusEvent) {
            this.fireDataStatusIEvent(DATA_REFRESH_MESSAGE, "");
        }
    }

    public boolean dataRequery(String whereClause, boolean onlyCurrentRows, int onlyCurrentDays) {
        log.info(whereClause + "; OnlyCurrent=" + onlyCurrentRows);
        this.close(false);
        this.m_onlyCurrentDays = onlyCurrentDays;
        this.setSelectWhereClause(whereClause, onlyCurrentRows, this.m_onlyCurrentDays);
        this.open(this.m_maxRows);
        this.m_rowData = null;
        this.m_changed = false;
        this.m_rowChanged = -1;
        this.m_inserting = false;
        this.fireTableDataChanged();
        this.fireDataStatusIEvent(DATA_REFRESH_MESSAGE, "");
        return true;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.m_readOnly) {
            return false;
        }
        if (col == this.m_indexKeyColumn) {
            return false;
        }
        if (col < 0 && col >= this.m_fields.size()) {
            return false;
        }
        if (col == this.m_indexActiveColumn && this.m_indexProcessedColumn == -1) {
            return true;
        }
        if (!this.isRowEditable(row)) {
            return false;
        }
        return this.m_fields.get(col).isEditable(false);
    }

    public boolean isRowEditable(int row) {
        Object processed;
        Object value;
        if (this.m_readOnly || row < 0) {
            return false;
        }
        if (this.m_indexActiveColumn > 0 && ((value = this.getValueAt(row, this.m_indexActiveColumn)) instanceof Boolean ? (Boolean)value == false : "N".equals(value))) {
            return false;
        }
        if (this.m_indexProcessedColumn > 0 && ((processed = this.getValueAt(row, this.m_indexProcessedColumn)) instanceof Boolean ? (Boolean)processed != false : "Y".equals(processed))) {
            return false;
        }
        int[] co = this.getClientOrg(row);
        int AD_Client_ID = co[0];
        int AD_Org_ID = co[1];
        int Record_ID = this.getKeyID(row);
        return MRole.getDefault(this.m_ctx, false).canUpdate(AD_Client_ID, AD_Org_ID, this.m_AD_Table_ID, Record_ID, false);
    }

    private int[] getClientOrg(int row) {
        Integer ii;
        Integer ii2;
        int AD_Client_ID = -1;
        if (this.m_indexClientColumn != -1 && (ii2 = (Integer)this.getValueAt(row, this.m_indexClientColumn)) != null) {
            AD_Client_ID = ii2;
        }
        int AD_Org_ID = 0;
        if (this.m_indexOrgColumn != -1 && (ii = (Integer)this.getValueAt(row, this.m_indexOrgColumn)) != null) {
            AD_Org_ID = ii;
        }
        return new int[]{AD_Client_ID, AD_Org_ID};
    }

    public void setReadOnly(boolean value) {
        log.fine("ReadOnly=" + value);
        this.m_readOnly = value;
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public boolean isInserting() {
        return this.m_inserting;
    }

    public void setCompareDB(boolean compareDB) {
        this.m_compareDB = compareDB;
    }

    public boolean getCompareDB() {
        return this.m_compareDB;
    }

    public void setDeleteable(boolean value) {
        log.fine("Deleteable=" + value);
        this.m_deleteable = value;
    }

    private Object[] readData(ResultSet rs) {
        int size = this.m_fields.size();
        Object[] rowData = new Object[size];
        String columnName = null;
        int displayType = 0;
        try {
            for (int j = 0; j < size; ++j) {
                GridField field = this.m_fields.get(j);
                columnName = field.getColumnName();
                displayType = field.getDisplayType();
                if (displayType == 11 || DisplayType.isID(displayType) && (columnName.endsWith("_ID") || columnName.endsWith("_Acct") || columnName.equals("AD_Key") || columnName.equals("AD_Display")) || columnName.endsWith("atedBy")) {
                    rowData[j] = rs.getInt(j + 1);
                    if (rs.wasNull()) {
                        rowData[j] = null;
                    }
                } else if (DisplayType.isNumeric(displayType)) {
                    rowData[j] = rs.getBigDecimal(j + 1);
                } else if (DisplayType.isDate(displayType)) {
                    rowData[j] = rs.getTimestamp(j + 1);
                } else if (displayType == 26) {
                    rowData[j] = null;
                } else if (displayType == 20) {
                    String str = rs.getString(j + 1);
                    if (field.isEncryptedColumn()) {
                        str = (String)this.decrypt(str);
                    }
                    rowData[j] = "Y".equals(str);
                } else if (DisplayType.isLOB(displayType)) {
                    long length;
                    Object lob;
                    Object value = rs.getObject(j + 1);
                    if (rs.wasNull()) {
                        rowData[j] = null;
                    } else if (value instanceof Clob) {
                        lob = (Clob)value;
                        length = lob.length();
                        rowData[j] = lob.getSubString(1L, (int)length);
                    } else if (value instanceof Blob) {
                        lob = (Blob)value;
                        length = lob.length();
                        rowData[j] = lob.getBytes(1L, (int)length);
                    } else if (value instanceof String) {
                        rowData[j] = value;
                    } else if (value instanceof byte[]) {
                        rowData[j] = value;
                    }
                } else {
                    rowData[j] = rs.getString(j + 1);
                }
                if (!field.isEncryptedColumn() || displayType == 20) continue;
                rowData[j] = this.decrypt(rowData[j]);
            }
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, columnName + ", DT=" + displayType, e);
        }
        return rowData;
    }

    private Object encrypt(Object xx) {
        if (xx == null) {
            return null;
        }
        return SecureEngine.encrypt(xx);
    }

    private Object decrypt(Object yy) {
        if (yy == null) {
            return null;
        }
        return SecureEngine.decrypt(yy);
    }

    public synchronized void removeDataStatusListener(DataStatusListener l) {
        this.listenerList.remove(DataStatusListener.class, l);
    }

    public synchronized void addDataStatusListener(DataStatusListener l) {
        this.listenerList.add(DataStatusListener.class, l);
    }

    private void fireDataStatusChanged(DataStatusEvent e) {
        DataStatusListener[] listeners = (DataStatusListener[])this.listenerList.getListeners(DataStatusListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].dataStatusChanged(e);
        }
    }

    private DataStatusEvent createDSE() {
        boolean changed = this.m_changed;
        if (this.m_rowChanged != -1) {
            changed = true;
        }
        DataStatusEvent dse = new DataStatusEvent(this, this.m_rowCount, changed, Env.isAutoCommit(this.m_ctx, this.m_WindowNo), this.m_inserting);
        dse.AD_Table_ID = this.m_AD_Table_ID;
        dse.Record_ID = null;
        return dse;
    }

    protected void fireDataStatusIEvent(String AD_Message, String info) {
        DataStatusEvent e = this.createDSE();
        e.setInfo(AD_Message, info, false, false);
        if (AD_Message.equals("Sorted")) {
            e.setCurrentRow(this.m_currentRow);
        }
        this.fireDataStatusChanged(e);
    }

    protected void fireDataStatusEEvent(String AD_Message, String info, boolean isError) {
        DataStatusEvent e = this.createDSE();
        e.setInfo(AD_Message, info, isError, !isError);
        if (isError) {
            log.saveWarning(AD_Message, info);
        }
        this.fireDataStatusChanged(e);
    }

    protected void fireDataStatusEEvent(ValueNamePair errorLog) {
        if (errorLog != null) {
            this.fireDataStatusEEvent(errorLog.getValue(), errorLog.getName(), true);
        }
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener l) {
        this.m_vetoableChangeSupport.removeVetoableChangeListener(l);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener l) {
        this.m_vetoableChangeSupport.addVetoableChangeListener(l);
    }

    protected void fireVetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        this.m_vetoableChangeSupport.fireVetoableChange(e);
    }

    public String toString() {
        return new StringBuffer("MTable[").append(this.m_tableName).append(",WindowNo=").append(this.m_WindowNo).append(",Tab=").append(this.m_TabNo).append("]").toString();
    }

    public int getNewRow() {
        return this.m_newRow;
    }

    protected void setFieldVFormat(String identifier, String strNewFormat) {
        int cols = this.m_fields.size();
        for (int i = 0; i < cols; ++i) {
            GridField field = this.m_fields.get(i);
            if (!identifier.equalsIgnoreCase(field.getColumnName())) continue;
            field.setVFormat(strNewFormat);
            this.m_fields.set(i, field);
            break;
        }
    }

    public boolean hasChanged(int row) {
        block22: {
            ResultSet rs;
            CPreparedStatement pstmt;
            String dbProcessedS;
            Timestamp dbUpdated;
            boolean hasProcessed;
            boolean hasUpdated;
            int colProcessed;
            int colUpdated;
            block21: {
                if (this.getKeyID(row) <= 0) break block22;
                colUpdated = this.findColumn("Updated");
                colProcessed = this.findColumn("Processed");
                hasUpdated = colUpdated > 0;
                hasProcessed = colProcessed > 0;
                String columns = null;
                if (hasUpdated && hasProcessed) {
                    columns = new String("Updated, Processed");
                } else if (hasUpdated) {
                    columns = new String("Updated");
                } else if (hasProcessed) {
                    columns = new String("Processed");
                } else {
                    return false;
                }
                if (this.findColumn(this.m_tableName + "_ID") == -1) {
                    return false;
                }
                dbUpdated = null;
                dbProcessedS = null;
                pstmt = null;
                rs = null;
                String sql = "SELECT " + columns + " FROM " + this.m_tableName + " WHERE " + this.m_tableName + "_ID=?";
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, this.getKeyID(row));
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        int idx = 1;
                        if (hasUpdated) {
                            dbUpdated = rs.getTimestamp(idx++);
                        }
                        if (hasProcessed) {
                            dbProcessedS = rs.getString(idx++);
                        }
                        break block21;
                    }
                    log.info("No Value " + sql);
                }
                catch (SQLException e) {
                    try {
                        throw new DBException(e, sql);
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        throw throwable;
                    }
                }
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            if (hasUpdated) {
                Timestamp memUpdated = null;
                memUpdated = (Timestamp)this.getOldValue(row, colUpdated);
                if (memUpdated == null) {
                    memUpdated = (Timestamp)this.getValueAt(row, colUpdated);
                }
                if (memUpdated != null && !memUpdated.equals(dbUpdated)) {
                    return true;
                }
            }
            if (hasProcessed) {
                Boolean memProcessed = null;
                memProcessed = (Boolean)this.getOldValue(row, colProcessed);
                if (memProcessed == null) {
                    memProcessed = (Boolean)this.getValueAt(row, colProcessed);
                }
                Boolean dbProcessed = Boolean.TRUE;
                if (dbProcessedS == null || dbProcessedS.isEmpty() || !dbProcessedS.equals("Y")) {
                    dbProcessed = Boolean.FALSE;
                }
                if (memProcessed != null && !memProcessed.equals(dbProcessed)) {
                    return true;
                }
            }
        }
        return false;
    }

    private int getParentTabNo() {
        int tabNo = this.m_TabNo;
        int currentLevel = Env.getContextAsInt(this.m_ctx, this.m_WindowNo, tabNo, "_TabInfo_TabLevel");
        int parentLevel = currentLevel - 1;
        if (parentLevel < 0) {
            return tabNo;
        }
        while (parentLevel < currentLevel && tabNo > 0) {
            currentLevel = Env.getContextAsInt(this.m_ctx, this.m_WindowNo, --tabNo, "_TabInfo_TabLevel");
        }
        return tabNo;
    }

    private boolean isNotNullAndIsEmpty(Object value) {
        return value != null && value instanceof String && value.toString().equals("");
    }

    private boolean isValueChanged(Object oldValue, Object value) {
        boolean bChanged;
        if (this.isNotNullAndIsEmpty(oldValue)) {
            oldValue = null;
        }
        if (this.isNotNullAndIsEmpty(value)) {
            value = null;
        }
        boolean bl = bChanged = oldValue == null && value != null || oldValue != null && value == null;
        if (!bChanged && oldValue != null) {
            if (oldValue.getClass().equals(value.getClass())) {
                bChanged = oldValue instanceof Comparable ? ((Comparable)oldValue).compareTo(value) != 0 : !oldValue.equals(value);
            } else if (value != null) {
                bChanged = !oldValue.toString().equals(value.toString());
            }
        }
        return bChanged;
    }

    public String getWhereClause(int row) {
        if (row < 0 || this.m_sort.size() == 0 || this.m_inserting) {
            return null;
        }
        Object[] rowData = this.getDataAtRow(row);
        if (rowData == null) {
            return null;
        }
        String where = this.getWhereClause(rowData);
        return where;
    }

    public ArrayList<Integer> getRowChanged() {
        return this.rowChanged;
    }

    public boolean checkField(int m_row) {
        Object[] rowData;
        String missingColumns;
        if (m_row != -1 && (missingColumns = this.getMandatory(rowData = this.getDataAtRow(m_row))).length() != 0) {
            this.fireDataStatusEEvent("FillMandatory", missingColumns + "\n", true);
            return false;
        }
        return true;
    }

    protected void setCurrentRow(int m_currentRow) {
        this.m_currentRow = m_currentRow;
    }

    class Loader
    implements Serializable,
    Runnable {
        private static final long serialVersionUID = -8735217685095696892L;
        private PreparedStatement m_pstmt = null;
        private ResultSet m_rs = null;
        private Trx trx = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int open(int maxRows) {
            int rows = 0;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement(GridTable.this.m_SQL_Count, null);
                this.setParameter(pstmt, true);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    rows = rs.getInt(1);
                }
            }
            catch (SQLException e0) {
                int n;
                try {
                    if (DBException.isInvalidIdentifierError(e0)) {
                        log.warning("Count - " + e0.getLocalizedMessage() + "\nSQL=" + GridTable.this.m_SQL_Count);
                    } else {
                        log.log(Level.SEVERE, "Count SQL=" + GridTable.this.m_SQL_Count, e0);
                    }
                    n = 0;
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
                DB.close(rs, pstmt);
                return n;
            }
            DB.close(rs, pstmt);
            StringBuffer info = new StringBuffer("Rows=");
            info.append(rows);
            if (rows == 0) {
                info.append(" - ").append(GridTable.this.m_SQL_Count);
            }
            String trxName = GridTable.this.m_virtual ? Trx.createTrxName("Loader") : null;
            this.trx = trxName != null ? Trx.get(trxName, true) : null;
            try {
                this.m_pstmt = DB.prepareStatement(GridTable.this.m_SQL, trxName);
                if (maxRows > 0 && rows > maxRows) {
                    this.m_pstmt.setMaxRows(maxRows);
                    info.append(" - MaxRows=").append(maxRows);
                    rows = maxRows;
                }
                if (GridTable.this.m_virtual) {
                    this.m_pstmt.setFetchSize(100);
                }
                this.setParameter(this.m_pstmt, false);
                this.m_rs = this.m_pstmt.executeQuery();
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, GridTable.this.m_SQL, e);
                return 0;
            }
            log.fine(info.toString());
            return rows;
        }

        private void close() {
            DB.close(this.m_rs, this.m_pstmt);
            this.m_rs = null;
            this.m_pstmt = null;
            if (this.trx != null) {
                this.trx.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            log.info("");
            if (this.m_rs == null) {
                return;
            }
            try {
                while (this.m_rs.next()) {
                    MSort sort;
                    if (Thread.interrupted()) {
                        log.fine("Interrupted");
                        this.close();
                        return;
                    }
                    int recordId = 0;
                    Object[] rowData = null;
                    if (GridTable.this.m_virtual) {
                        recordId = this.m_rs.getInt(GridTable.this.getKeyColumnName());
                    } else {
                        rowData = GridTable.this.readData(this.m_rs);
                    }
                    MSort mSort = sort = GridTable.this.m_virtual ? new MSort(recordId, null) : new MSort(GridTable.this.m_buffer.size(), null);
                    if (!GridTable.this.m_virtual) {
                        GridTable.this.m_buffer.add(rowData);
                    }
                    GridTable.this.m_sort.add(sort);
                    if (GridTable.this.m_sort.size() % 1000 != 0) continue;
                    try {
                        Thread.yield();
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ie) {
                        log.fine("Interrupted while sleeping");
                        this.close();
                        this.close();
                        return;
                    }
                    DataStatusEvent evt = GridTable.this.createDSE();
                    evt.setLoading(GridTable.this.m_sort.size());
                    GridTable.this.fireDataStatusChanged(evt);
                }
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, "run", e);
            }
            finally {
                this.close();
            }
            GridTable.this.fireDataStatusIEvent("", "");
        }

        private void setParameter(PreparedStatement pstmt, boolean countSQL) {
            if (GridTable.this.m_parameterSELECT.size() == 0 && GridTable.this.m_parameterWHERE.size() == 0) {
                return;
            }
            try {
                Integer ii;
                Object para;
                int i;
                int pos = 1;
                for (i = 0; !countSQL && i < GridTable.this.m_parameterSELECT.size(); ++i) {
                    para = GridTable.this.m_parameterSELECT.get(i);
                    if (para != null) {
                        log.fine("Select " + i + "=" + para);
                    }
                    if (para == null) continue;
                    if (para instanceof Integer) {
                        ii = (Integer)para;
                        pstmt.setInt(pos++, ii);
                        continue;
                    }
                    if (para instanceof BigDecimal) {
                        pstmt.setBigDecimal(pos++, (BigDecimal)para);
                        continue;
                    }
                    pstmt.setString(pos++, para.toString());
                }
                for (i = 0; i < GridTable.this.m_parameterWHERE.size(); ++i) {
                    para = GridTable.this.m_parameterWHERE.get(i);
                    if (para != null) {
                        log.fine("Where " + i + "=" + para);
                    }
                    if (para == null) continue;
                    if (para instanceof Integer) {
                        ii = (Integer)para;
                        pstmt.setInt(pos++, ii);
                        continue;
                    }
                    if (para instanceof BigDecimal) {
                        pstmt.setBigDecimal(pos++, (BigDecimal)para);
                        continue;
                    }
                    pstmt.setString(pos++, para.toString());
                }
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, "parameter", e);
            }
        }
    }
}

