/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.Callout;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class CalloutEngine
implements Callout {
    public static final String NO_ERROR = "";
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private GridTab m_mTab;
    private GridField m_mField;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String start(Properties ctx, String methodName, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        Method method;
        if (methodName == null || methodName.length() == 0) {
            throw new IllegalArgumentException("No Method Name");
        }
        this.m_mTab = mTab;
        this.m_mField = mField;
        String retValue = NO_ERROR;
        StringBuffer msg = new StringBuffer(methodName).append(" - ").append(mField.getColumnName()).append("=").append(value).append(" (old=").append(oldValue).append(") {active=").append(this.isCalloutActive()).append("}");
        if (!this.isCalloutActive()) {
            this.log.info(msg.toString());
        }
        if ((method = this.getMethod(methodName)) == null) {
            throw new IllegalArgumentException("Method not found: " + methodName);
        }
        int argLength = method.getParameterTypes().length;
        if (argLength != 5 && argLength != 6) {
            throw new IllegalArgumentException("Method " + methodName + " has invalid no of arguments: " + argLength);
        }
        try {
            Object[] args = null;
            args = argLength == 6 ? new Object[]{ctx, WindowNo, mTab, mField, value, oldValue} : new Object[]{ctx, WindowNo, mTab, mField, value};
            retValue = (String)method.invoke((Object)this, args);
        }
        catch (Exception e) {
            Throwable ex = e.getCause();
            if (ex == null) {
                ex = e;
            }
            this.log.log(Level.SEVERE, "start: " + methodName, ex);
            retValue = ex.getLocalizedMessage();
            if (retValue == null) {
                retValue = ex.toString();
            }
        }
        finally {
            this.m_mTab = null;
            this.m_mField = null;
        }
        return retValue;
    }

    @Override
    public String convert(String methodName, String value) {
        if (methodName == null || methodName.length() == 0) {
            throw new IllegalArgumentException("No Method Name");
        }
        String retValue = null;
        StringBuffer msg = new StringBuffer(methodName).append(" - ").append(value);
        this.log.info(msg.toString());
        Method method = this.getMethod(methodName);
        if (method == null) {
            throw new IllegalArgumentException("Method not found: " + methodName);
        }
        int argLength = method.getParameterTypes().length;
        if (argLength != 1) {
            throw new IllegalArgumentException("Method " + methodName + " has invalid no of arguments: " + argLength);
        }
        try {
            Object[] args = new Object[]{value};
            retValue = (String)method.invoke((Object)this, args);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "convert: " + methodName, e);
            e.printStackTrace(System.err);
        }
        return retValue;
    }

    private Method getMethod(String methodName) {
        Method[] allMethods = this.getClass().getMethods();
        for (int i = 0; i < allMethods.length; ++i) {
            if (!methodName.equals(allMethods[i].getName())) continue;
            return allMethods[i];
        }
        return null;
    }

    protected boolean isCalloutActive() {
        return this.m_mTab != null ? this.m_mTab.getActiveCallouts().length > 1 : false;
    }

    protected static void setCalloutActive(boolean active) {
    }

    public String dateAcct(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive()) {
            return NO_ERROR;
        }
        if (value == null || !(value instanceof Timestamp)) {
            return NO_ERROR;
        }
        mTab.setValue("DateAcct", value);
        return NO_ERROR;
    }

    public String rate(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return NO_ERROR;
        }
        BigDecimal rate1 = (BigDecimal)value;
        BigDecimal rate2 = Env.ZERO;
        BigDecimal one = new BigDecimal(1.0);
        if (rate1.doubleValue() != 0.0) {
            rate2 = one.divide(rate1, MathContext.DECIMAL128);
        }
        if (mField.getColumnName().equals("MultiplyRate")) {
            mTab.setValue("DivideRate", (Object)rate2);
        } else {
            mTab.setValue("MultiplyRate", (Object)rate2);
        }
        this.log.info(mField.getColumnName() + "=" + rate1 + " => " + rate2);
        return NO_ERROR;
    }

    public GridTab getGridTab() {
        return this.m_mTab;
    }

    public GridField getGridField() {
        return this.m_mField;
    }
}

