/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.jr.report;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import oracle.jdbc.driver.OracleDriver;
import org.compiere.db.CConnection;
import org.compiere.jr.report.JasperReportViewer;
import org.postgresql.Driver;

public class JasperViewer
extends JFrame {
    private static final long serialVersionUID = 1192807883081180999L;
    private String m_title;
    private JPanel pnlMain;

    protected JasperViewer(JasperPrint jasperPrint, String frameTitle) throws JRException {
        this.m_title = frameTitle;
        this.initComponents();
        JasperReportViewer viewer = new JasperReportViewer(this, jasperPrint);
        this.pnlMain.add((Component)((Object)viewer), "Center");
    }

    private void initComponents() {
        this.pnlMain = new JPanel();
        this.setTitle(this.m_title);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                JasperViewer.this.exitForm();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 27) {
                    JasperViewer.this.exitForm();
                }
            }

            @Override
            public void keyTyped(KeyEvent event) {
                super.keyTyped(event);
            }
        });
        this.pnlMain.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.pnlMain, "Center");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(new Dimension(750, 550));
        this.setLocation((screenSize.width - 750) / 2, (screenSize.height - 550) / 2);
    }

    private void exitForm() {
        this.setVisible(false);
        this.dispose();
    }

    public static void viewReport(JasperPrint jasperPrint) throws JRException {
        JasperViewer jasperViewer = new JasperViewer(jasperPrint, "JasperReport");
        jasperViewer.setVisible(true);
    }

    public static void viewReport(JasperPrint jasperPrint, String frameTitle) throws JRException {
        JasperViewer jasperViewer = new JasperViewer(jasperPrint, frameTitle);
        jasperViewer.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            JasperReport myjasperReport = JasperCompileManager.compileReport((String)args[0]);
            JasperPrint myjasperPrint = JasperFillManager.fillReport((JasperReport)myjasperReport, new HashMap(), (Connection)JasperViewer.getConnection());
            JasperViewer.viewReport(myjasperPrint);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Connection getConnection(String[] args) {
        CConnection compiereConnection = CConnection.get();
        try {
            if (compiereConnection.isOracle()) {
                DriverManager.registerDriver((java.sql.Driver)new OracleDriver());
            }
            if (compiereConnection.isPostgreSQL()) {
                DriverManager.registerDriver((java.sql.Driver)new Driver());
            }
            return DriverManager.getConnection(args[1], args[2], args[3]);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Connection getConnection() {
        try {
            DriverManager.registerDriver((java.sql.Driver)new OracleDriver());
            return DriverManager.getConnection("jdbc:oracle:thin:@abalone.lesmuids.com:1521:abalone", "adempiere", "adempiere");
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

