/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import org.compiere.apps.ADialog;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.install.Translation;
import org.compiere.install.TranslationController;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

public class VTranslationDialog
extends TranslationController
implements FormPanel,
ActionListener {
    private static final long serialVersionUID = -5072470836657762574L;
    private CPanel panel = new CPanel();
    private FormFrame m_frame;
    private static CLogger log = CLogger.getCLogger(VTranslationDialog.class);
    private GridBagLayout mainLayout = new GridBagLayout();
    private JComboBox cbLanguage = new JComboBox();
    private JLabel lLanguage = new JLabel();
    private JLabel lTable = new JLabel();
    private JComboBox cbTable = new JComboBox();
    private JButton bExport = new JButton();
    private JButton bImport = new JButton();
    private StatusBar statusBar = new StatusBar();
    private JLabel lClient = new JLabel();
    private JComboBox cbClient = new JComboBox();

    private void jbInit() throws Exception {
        this.panel.setLayout(this.mainLayout);
        this.lClient.setText(Msg.translate(Env.getCtx(), "AD_Client_ID"));
        this.lLanguage.setText(Msg.translate(Env.getCtx(), "AD_Language"));
        this.lLanguage.setToolTipText(Msg.translate(Env.getCtx(), "IsSystemLanguage"));
        this.lTable.setText(Msg.translate(Env.getCtx(), "AD_Table_ID"));
        this.bExport.setText(Msg.getMsg(Env.getCtx(), "Export"));
        this.bExport.addActionListener(this);
        this.bImport.setText(Msg.getMsg(Env.getCtx(), "Import"));
        this.bImport.addActionListener(this);
        this.panel.add((Component)this.cbLanguage, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.panel.add((Component)this.lLanguage, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.panel.add((Component)this.lTable, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.panel.add((Component)this.cbTable, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.panel.add((Component)this.bExport, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.panel.add((Component)this.bImport, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.panel.add((Component)this.lClient, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.panel.add((Component)this.cbClient, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void dynInit() {
        ArrayList<KeyNamePair> clients = this.getClientList();
        for (KeyNamePair keyNamePair : clients) {
            this.cbClient.addItem(keyNamePair);
        }
        ArrayList<ValueNamePair> languages = this.getLanguageList();
        for (ValueNamePair language : languages) {
            this.cbLanguage.addItem(language);
        }
        ArrayList<ValueNamePair> arrayList = this.getTableList();
        for (ValueNamePair table2 : arrayList) {
            this.cbTable.addItem(table2);
        }
        this.setStatusBar(this.statusBar);
    }

    @Override
    public void init(int WindowNo, FormFrame frame) {
        log.info("");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        Env.setContext(Env.getCtx(), this.m_WindowNo, "IsSOTrx", "Y");
        try {
            this.jbInit();
            this.dynInit();
            frame.getContentPane().add((Component)this.panel, "Center");
            frame.getContentPane().add((Component)this.statusBar, "South");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", ex);
        }
    }

    @Override
    public void dispose() {
        this.m_frame.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int returnVal;
        ValueNamePair AD_Language = (ValueNamePair)this.cbLanguage.getSelectedItem();
        if (AD_Language == null) {
            this.statusBar.setStatusLine(Msg.getMsg(Env.getCtx(), "LanguageSetupError"), true);
            return;
        }
        ValueNamePair AD_Table = (ValueNamePair)this.cbTable.getSelectedItem();
        if (AD_Table == null) {
            return;
        }
        boolean imp = e.getSource() == this.bImport;
        KeyNamePair AD_Client = (KeyNamePair)this.cbClient.getSelectedItem();
        int AD_Client_ID = -1;
        if (AD_Client != null) {
            AD_Client_ID = AD_Client.getKey();
        }
        String startDir = Ini.getAdempiereHome() + File.separator + "data";
        JFileChooser chooser = new JFileChooser(startDir);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(1);
        int n = returnVal = imp ? chooser.showOpenDialog(this.panel) : chooser.showSaveDialog(this.panel);
        if (returnVal != 0) {
            return;
        }
        String directory = chooser.getSelectedFile().getAbsolutePath();
        this.statusBar.setStatusLine(directory);
        this.panel.setCursor(Cursor.getPredefinedCursor(3));
        Translation t = new Translation(Env.getCtx());
        Object msg = t.validateLanguage(AD_Language.getValue());
        if (((String)msg).length() > 0) {
            ADialog.error(this.m_WindowNo, this.panel, "LanguageSetupError", (String)msg);
            return;
        }
        if (AD_Table.getValue().equals("")) {
            msg = null;
            for (int i = 1; i < this.cbTable.getItemCount(); ++i) {
                AD_Table = (ValueNamePair)this.cbTable.getItemAt(i);
                msg = imp ? t.importTrl(directory, AD_Client_ID, AD_Language.getValue(), AD_Table.getValue()) : t.exportTrl(directory, AD_Client_ID, AD_Language.getValue(), AD_Table.getValue());
            }
            if (msg == null || ((String)msg).length() == 0) {
                msg = (imp ? "Import" : "Export") + " Successful. [" + directory + "]";
            }
            this.statusBar.setStatusLine(directory);
        } else {
            msg = null;
            Object object = msg = imp ? t.importTrl(directory, AD_Client_ID, AD_Language.getValue(), AD_Table.getValue()) : t.exportTrl(directory, AD_Client_ID, AD_Language.getValue(), AD_Table.getValue());
            if (msg == null || ((String)msg).length() == 0) {
                msg = (imp ? "Import" : "Export") + " Successful. [" + directory + "]";
            }
            this.statusBar.setStatusLine((String)msg);
        }
        this.panel.setCursor(Cursor.getDefaultCursor());
    }
}

